/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.maketorrent;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.core.tag.Tag;
import com.aelitis.azureus.core.tag.TagManager;
import com.aelitis.azureus.core.tag.TagManagerFactory;
import com.aelitis.azureus.core.tag.TagType;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerInitialisationAdapter;
import org.gudy.azureus2.core3.internat.LocaleTorrentUtil;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.TOTorrentFactory;
import org.gudy.azureus2.core3.torrent.TOTorrentProgressListener;
import org.gudy.azureus2.core3.tracker.host.TRHostException;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.core3.util.TrackersUtil;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.maketorrent.NewTorrentWizard;
import org.gudy.azureus2.ui.swt.shells.CoreWaiterSWT;
import org.gudy.azureus2.ui.swt.views.utils.ManagerUtils;
import org.gudy.azureus2.ui.swt.wizard.AbstractWizardPanel;
import org.gudy.azureus2.ui.swt.wizard.IWizardPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProgressPanel
extends AbstractWizardPanel<NewTorrentWizard>
implements TOTorrentProgressListener {
    Text tasks;
    ProgressBar progress;
    Display display;
    Button show_torrent_file;

    public ProgressPanel(NewTorrentWizard wizard, IWizardPanel<NewTorrentWizard> _previousPanel) {
        super(wizard, _previousPanel);
    }

    @Override
    public void show() {
        this.display = ((NewTorrentWizard)this.wizard).getDisplay();
        ((NewTorrentWizard)this.wizard).setTitle(MessageText.getString("wizard.progresstitle"));
        ((NewTorrentWizard)this.wizard).setCurrentInfo("");
        ((NewTorrentWizard)this.wizard).setPreviousEnabled(false);
        Composite rootPanel = ((NewTorrentWizard)this.wizard).getPanel();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        rootPanel.setLayout((Layout)layout);
        Composite panel = new Composite(rootPanel, 0);
        GridData gridData = new GridData(772);
        panel.setLayoutData((Object)gridData);
        layout = new GridLayout();
        layout.numColumns = 2;
        panel.setLayout((Layout)layout);
        this.tasks = new Text(panel, 2058);
        this.tasks.setBackground(this.display.getSystemColor(1));
        gridData = new GridData(1808);
        gridData.heightHint = 120;
        gridData.horizontalSpan = 2;
        this.tasks.setLayoutData((Object)gridData);
        this.progress = new ProgressBar(panel, 0);
        this.progress.setMinimum(0);
        this.progress.setMaximum(0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.progress.setLayoutData((Object)gridData);
        Label label = new Label(panel, 0);
        gridData = new GridData(768);
        label.setLayoutData((Object)gridData);
        Composite Browsepanel = new Composite(panel, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        Browsepanel.setLayout((Layout)layout);
        label = new Label(Browsepanel, 0);
        Messages.setLanguageText((Widget)label, "wizard.newtorrent.showtorrent");
        this.show_torrent_file = new Button(Browsepanel, 8);
        Messages.setLanguageText((Widget)this.show_torrent_file, "MyTorrentsView.menu.explore");
        this.show_torrent_file.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ManagerUtils.open(new File(((NewTorrentWizard)((ProgressPanel)ProgressPanel.this).wizard).savePath));
            }
        });
        this.show_torrent_file.setEnabled(false);
    }

    @Override
    public void finish() {
        AEThread t = new AEThread("Torrent Maker"){

            public void runSupport() {
                ProgressPanel.this.makeTorrent();
            }
        };
        t.setPriority(1);
        t.setDaemon(true);
        t.start();
    }

    public void makeTorrent() {
        int tracker_type = ((NewTorrentWizard)this.wizard).getTrackerType();
        if (tracker_type == 2) {
            TrackersUtil.getInstance().addTracker(((NewTorrentWizard)this.wizard).trackerURL);
        }
        File f = ((NewTorrentWizard)this.wizard).create_mode == 2 ? new File(((NewTorrentWizard)this.wizard).directoryPath) : (((NewTorrentWizard)this.wizard).create_mode == 1 ? new File(((NewTorrentWizard)this.wizard).singlePath) : ((NewTorrentWizard)this.wizard).byo_desc_file);
        try {
            File save_dir;
            TOTorrent torrent;
            URL url = new URL(((NewTorrentWizard)this.wizard).trackerURL);
            if (((NewTorrentWizard)this.wizard).getPieceSizeComputed()) {
                ((NewTorrentWizard)this.wizard).creator = TOTorrentFactory.createFromFileOrDirWithComputedPieceLength(f, url, ((NewTorrentWizard)this.wizard).getAddOtherHashes());
                ((NewTorrentWizard)this.wizard).creator.addListener(this);
                ((NewTorrentWizard)this.wizard).creator.setFileIsLayoutDescriptor(((NewTorrentWizard)this.wizard).create_mode == 3);
                torrent = ((NewTorrentWizard)this.wizard).creator.create();
            } else {
                ((NewTorrentWizard)this.wizard).creator = TOTorrentFactory.createFromFileOrDirWithFixedPieceLength(f, url, ((NewTorrentWizard)this.wizard).getAddOtherHashes(), ((NewTorrentWizard)this.wizard).getPieceSizeManual());
                ((NewTorrentWizard)this.wizard).creator.addListener(this);
                ((NewTorrentWizard)this.wizard).creator.setFileIsLayoutDescriptor(((NewTorrentWizard)this.wizard).create_mode == 3);
                torrent = ((NewTorrentWizard)this.wizard).creator.create();
            }
            if (tracker_type == 3) {
                TorrentUtils.setDecentralised(torrent);
            }
            torrent.setComment(((NewTorrentWizard)this.wizard).getComment());
            TorrentUtils.setDHTBackupEnabled(torrent, ((NewTorrentWizard)this.wizard).permitDHT);
            TorrentUtils.setPrivate(torrent, ((NewTorrentWizard)this.wizard).privateTorrent);
            LocaleTorrentUtil.setDefaultTorrentEncoding(torrent);
            if (((NewTorrentWizard)this.wizard).create_mode == 2) {
                save_dir = f;
            } else if (((NewTorrentWizard)this.wizard).create_mode == 1) {
                save_dir = f.getParentFile();
            } else {
                String save_path = COConfigurationManager.getStringParameter("Default save path");
                File f_save_path = new File(save_path);
                if (!f_save_path.canWrite()) {
                    throw new Exception("Default save path is not configured: See Tools->Options->File");
                }
                save_dir = f_save_path;
            }
            if (((NewTorrentWizard)this.wizard).useMultiTracker) {
                this.reportCurrentTask(MessageText.getString("wizard.addingmt"));
                TorrentUtils.listToAnnounceGroups(((NewTorrentWizard)this.wizard).trackers, torrent);
            }
            if (((NewTorrentWizard)this.wizard).useWebSeed && ((NewTorrentWizard)this.wizard).webseeds.size() > 0) {
                List webseed;
                this.reportCurrentTask(MessageText.getString("wizard.webseed.adding"));
                Map ws = ((NewTorrentWizard)this.wizard).webseeds;
                List getright = (List)ws.get("getright");
                if (getright.size() > 0) {
                    for (int i = 0; i < getright.size(); ++i) {
                        this.reportCurrentTask("    GetRight: " + getright.get(i));
                    }
                    torrent.setAdditionalListProperty("url-list", new ArrayList(getright));
                }
                if ((webseed = (List)ws.get("webseed")).size() > 0) {
                    for (int i = 0; i < webseed.size(); ++i) {
                        this.reportCurrentTask("    WebSeed: " + webseed.get(i));
                    }
                    torrent.setAdditionalListProperty("httpseeds", new ArrayList(webseed));
                }
            }
            this.reportCurrentTask(MessageText.getString("wizard.savingfile"));
            final File torrent_file = new File(((NewTorrentWizard)this.wizard).savePath);
            torrent.serialiseToBEncodedFile(torrent_file);
            this.reportCurrentTask(MessageText.getString("wizard.filesaved"));
            ((NewTorrentWizard)this.wizard).switchToClose(new Runnable(){

                public void run() {
                    ProgressPanel.this.show_torrent_file.setEnabled(true);
                }
            });
            if (((NewTorrentWizard)this.wizard).autoOpen) {
                CoreWaiterSWT.waitForCore(CoreWaiterSWT.TriggerInThread.NEW_THREAD, new AzureusCoreRunningListener(){

                    public void azureusCoreRunning(AzureusCore core) {
                        String initialTags;
                        boolean start_stopped = COConfigurationManager.getBooleanParameter("Default Start Torrents Stopped");
                        byte[] hash = null;
                        try {
                            hash = torrent.getHash();
                        }
                        catch (TOTorrentException e1) {
                            // empty catch block
                        }
                        if (((NewTorrentWizard)((ProgressPanel)ProgressPanel.this).wizard).forceStart || ((NewTorrentWizard)((ProgressPanel)ProgressPanel.this).wizard).superseed) {
                            start_stopped = false;
                        }
                        DownloadManagerInitialisationAdapter dmia = (initialTags = ((NewTorrentWizard)ProgressPanel.this.wizard).getInitialTags(true)).length() > 0 ? new DownloadManagerInitialisationAdapter(){

                            public int getActions() {
                                return 1;
                            }

                            public void initialised(DownloadManager dm, boolean for_seeding) {
                                String[] bits;
                                TagManager tm = TagManagerFactory.getTagManager();
                                TagType tag_type = tm.getTagType(3);
                                for (String tag : bits = initialTags.replace(';', ',').split(",")) {
                                    if ((tag = tag.trim()).length() <= 0) continue;
                                    try {
                                        Tag t = tag_type.getTag(tag, true);
                                        if (t == null) {
                                            t = tag_type.createTag(tag, true);
                                        }
                                        t.addTaggable(dm);
                                    }
                                    catch (Throwable e) {
                                        Debug.out(e);
                                    }
                                }
                            }
                        } : null;
                        final DownloadManager dm = core.getGlobalManager().addDownloadManager(torrent_file.toString(), hash, save_dir.toString(), start_stopped ? 70 : 75, true, true, dmia);
                        if (!start_stopped && dm != null) {
                            dm.getGlobalManager().moveTop(new DownloadManager[]{dm});
                        }
                        if (((NewTorrentWizard)((ProgressPanel)ProgressPanel.this).wizard).autoHost && ((NewTorrentWizard)ProgressPanel.this.wizard).getTrackerType() != 2) {
                            try {
                                core.getTrackerHost().hostTorrent(torrent, true, false);
                            }
                            catch (TRHostException e) {
                                Logger.log(new LogAlert(true, "Host operation fails", e));
                            }
                        }
                        if (dm != null) {
                            if (((NewTorrentWizard)((ProgressPanel)ProgressPanel.this).wizard).forceStart) {
                                dm.setForceStart(true);
                            }
                            if (((NewTorrentWizard)((ProgressPanel)ProgressPanel.this).wizard).superseed) {
                                new AEThread2("startwait"){

                                    public void run() {
                                        int state;
                                        long elapsed;
                                        long start = SystemTime.getMonotonousTime();
                                        while (!dm.isDestroyed() && ((elapsed = SystemTime.getMonotonousTime() - start) <= 60000L || (state = dm.getState()) != 100 && state != 70) && elapsed <= 300000L) {
                                            PEPeerManager pm = dm.getPeerManager();
                                            if (pm != null) {
                                                pm.setSuperSeedMode(true);
                                                break;
                                            }
                                            try {
                                                Thread.sleep(1000L);
                                            }
                                            catch (Throwable e) {
                                                break;
                                            }
                                        }
                                    }
                                }.start();
                            }
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            if (e instanceof TOTorrentException) {
                TOTorrentException te = (TOTorrentException)e;
                if (te.getReason() != 9) {
                    this.reportCurrentTask(MessageText.getString("wizard.operationfailed"));
                    this.reportCurrentTask(TorrentUtils.exceptionToText(te));
                }
            } else {
                Debug.printStackTrace(e);
                this.reportCurrentTask(MessageText.getString("wizard.operationfailed"));
                this.reportCurrentTask(Debug.getStackTrace(e));
            }
            ((NewTorrentWizard)this.wizard).switchToClose();
        }
    }

    @Override
    public void reportCurrentTask(final String task_description) {
        if (this.display != null && !this.display.isDisposed()) {
            this.display.asyncExec((Runnable)new AERunnable(){

                public void runSupport() {
                    if (ProgressPanel.this.tasks != null && !ProgressPanel.this.tasks.isDisposed()) {
                        ProgressPanel.this.tasks.append(task_description + Text.DELIMITER);
                    }
                }
            });
        }
    }

    @Override
    public void reportProgress(final int percent_complete) {
        if (this.display != null && !this.display.isDisposed()) {
            this.display.asyncExec((Runnable)new AERunnable(){

                public void runSupport() {
                    if (ProgressPanel.this.progress != null && !ProgressPanel.this.progress.isDisposed()) {
                        ProgressPanel.this.progress.setSelection(percent_complete);
                    }
                }
            });
        }
    }
}

