/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.maketorrent;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.TrackersUtil;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.maketorrent.NewTorrentWizard;
import org.gudy.azureus2.ui.swt.maketorrent.WebSeedsEditor;
import org.gudy.azureus2.ui.swt.maketorrent.WebSeedsEditorListener;
import org.gudy.azureus2.ui.swt.wizard.AbstractWizardPanel;
import org.gudy.azureus2.ui.swt.wizard.IWizardPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebSeedPanel
extends AbstractWizardPanel<NewTorrentWizard>
implements WebSeedsEditorListener {
    private Combo configList;
    private Tree configDetails;
    private Button btnNew;
    private Button btnEdit;
    private Button btnDelete;

    public WebSeedPanel(NewTorrentWizard wizard, AbstractWizardPanel<NewTorrentWizard> previous) {
        super(wizard, previous);
    }

    @Override
    public void show() {
        ((NewTorrentWizard)this.wizard).setTitle(MessageText.getString("wizard.webseed.title"));
        ((NewTorrentWizard)this.wizard).setCurrentInfo("");
        Composite rootPanel = ((NewTorrentWizard)this.wizard).getPanel();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        rootPanel.setLayout((Layout)layout);
        Composite panel = new Composite(rootPanel, 0);
        GridData gridData = new GridData(772);
        panel.setLayoutData((Object)gridData);
        layout = new GridLayout();
        layout.numColumns = 3;
        panel.setLayout((Layout)layout);
        Label labelTitle = new Label(panel, 0);
        Messages.setLanguageText((Widget)labelTitle, "wizard.webseed.configuration");
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        labelTitle.setLayoutData((Object)gridData);
        this.configList = new Combo(panel, 8);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        this.configList.setLayoutData((Object)gridData);
        this.configList.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                WebSeedPanel.this.updateWebSeeds();
                WebSeedPanel.this.refreshDetails();
            }
        });
        this.btnNew = new Button(panel, 8);
        Messages.setLanguageText((Widget)this.btnNew, "wizard.multitracker.new");
        gridData = new GridData();
        gridData.widthHint = 100;
        this.btnNew.setLayoutData((Object)gridData);
        this.btnNew.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                HashMap webseeds = new HashMap();
                webseeds.put("getright", new ArrayList());
                webseeds.put("webseed", new ArrayList());
                new WebSeedsEditor(null, webseeds, WebSeedPanel.this);
            }
        });
        this.btnEdit = new Button(panel, 8);
        Messages.setLanguageText((Widget)this.btnEdit, "wizard.multitracker.edit");
        gridData = new GridData();
        gridData.widthHint = 100;
        this.btnEdit.setLayoutData((Object)gridData);
        this.btnEdit.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                int selection = WebSeedPanel.this.configList.getSelectionIndex();
                String selected = WebSeedPanel.this.configList.getItem(selection);
                Map<String, Map> webseeds = TrackersUtil.getInstance().getWebSeeds();
                new WebSeedsEditor(selected, webseeds.get(selected), WebSeedPanel.this);
            }
        });
        this.btnDelete = new Button(panel, 8);
        Messages.setLanguageText((Widget)this.btnDelete, "wizard.multitracker.delete");
        gridData = new GridData(128);
        gridData.widthHint = 100;
        this.btnDelete.setLayoutData((Object)gridData);
        this.btnDelete.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                int selection = WebSeedPanel.this.configList.getSelectionIndex();
                String selected = WebSeedPanel.this.configList.getItem(selection);
                TrackersUtil.getInstance().removeWebSeed(selected);
                WebSeedPanel.this.refreshList("");
                WebSeedPanel.this.refreshDetails();
                WebSeedPanel.this.setEditDeleteEnable();
            }
        });
        Label labelSeparator = new Label(panel, 258);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        labelSeparator.setLayoutData((Object)gridData);
        this.configDetails = new Tree(panel, 2048);
        gridData = new GridData(768);
        gridData.heightHint = 150;
        gridData.horizontalSpan = 3;
        this.configDetails.setLayoutData((Object)gridData);
        this.refreshList(((NewTorrentWizard)this.wizard).webSeedConfig);
        this.refreshDetails();
        this.setEditDeleteEnable();
    }

    @Override
    public IWizardPanel<NewTorrentWizard> getNextPanel() {
        return ((NewTorrentWizard)this.wizard).getNextPanelForMode(this);
    }

    @Override
    public boolean isNextEnabled() {
        return true;
    }

    void refreshDetails() {
        this.configDetails.removeAll();
        Map webseeds = ((NewTorrentWizard)this.wizard).webseeds;
        for (Map.Entry entry : webseeds.entrySet()) {
            TreeItem itemRoot = new TreeItem(this.configDetails, 0);
            itemRoot.setText((String)entry.getKey());
            for (String url : (List)entry.getValue()) {
                new TreeItem(itemRoot, 0).setText(url);
            }
            itemRoot.setExpanded(true);
        }
    }

    void setEditDeleteEnable() {
        if (this.configList.getItemCount() > 0) {
            this.btnEdit.setEnabled(true);
            this.btnDelete.setEnabled(true);
        } else {
            this.btnEdit.setEnabled(false);
            this.btnDelete.setEnabled(false);
        }
    }

    @Override
    public void webSeedsChanged(String oldName, String newName, Map ws) {
        TrackersUtil util = TrackersUtil.getInstance();
        if (oldName != null && !oldName.equals(newName)) {
            util.removeWebSeed(oldName);
        }
        util.addWebSeed(newName, ws);
        this.refreshList(newName);
        this.refreshDetails();
        this.setEditDeleteEnable();
    }

    private void refreshList(String toBeSelected) {
        Map<String, Map> webseeds = TrackersUtil.getInstance().getWebSeeds();
        this.configList.removeAll();
        Iterator<String> iter = webseeds.keySet().iterator();
        while (iter.hasNext()) {
            this.configList.add(iter.next());
        }
        int selection = this.configList.indexOf(toBeSelected);
        if (selection != -1) {
            this.configList.select(selection);
        } else if (this.configList.getItemCount() > 0) {
            this.configList.select(0);
        }
        this.updateWebSeeds();
    }

    private void updateWebSeeds() {
        String selected;
        int selection = this.configList.getSelectionIndex();
        if (selection == -1) {
            ((NewTorrentWizard)this.wizard).webSeedConfig = "";
            ((NewTorrentWizard)this.wizard).webseeds = new HashMap();
            this.setNext();
            return;
        }
        ((NewTorrentWizard)this.wizard).webSeedConfig = selected = this.configList.getItem(selection);
        Map<String, Map> webseeds = TrackersUtil.getInstance().getWebSeeds();
        ((NewTorrentWizard)this.wizard).webseeds = webseeds.get(selected);
        this.setNext();
    }

    private void setNext() {
        ((NewTorrentWizard)this.wizard).setNextEnabled(true);
        ((NewTorrentWizard)this.wizard).setErrorMessage("");
    }
}

