/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.nat;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdmin;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminProgressListener;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminProtocol;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.ipchecker.natchecker.NatChecker;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.shell.ShellFactory;
import org.gudy.azureus2.ui.swt.shells.CoreWaiterSWT;

public class NatTestWindow {
    Display display;
    Button bTestTCP;
    Button bTestUDP;
    Button bApply;
    Button bCancel;
    StyledText textResults;
    int serverTCPListenPort = COConfigurationManager.getIntParameter("TCP.Listen.Port");
    int serverUDPListenPort = COConfigurationManager.getIntParameter("UDP.Listen.Port");

    public NatTestWindow() {
        final Shell shell = ShellFactory.createMainShell(2144);
        shell.setText(MessageText.getString("configureWizard.nat.title"));
        Utils.setShellIcon(shell);
        this.display = shell.getDisplay();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        shell.setLayout((Layout)layout);
        Composite panel = new Composite((Composite)shell, 0);
        GridData gridData = new GridData(772);
        panel.setLayoutData((Object)gridData);
        layout = new GridLayout();
        layout.numColumns = 3;
        panel.setLayout((Layout)layout);
        Label label = new Label(panel, 64);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.widthHint = 400;
        label.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)label, "configureWizard.nat.message");
        label = new Label(panel, 0);
        label = new Label(panel, 0);
        label = new Label(panel, 0);
        label = new Label(panel, 0);
        Messages.setLanguageText((Widget)label, "configureWizard.nat.server.tcp_listen_port");
        final Text textServerTCPListen = new Text(panel, 2048);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        textServerTCPListen.setLayoutData((Object)gridData);
        textServerTCPListen.setText("" + this.serverTCPListenPort);
        textServerTCPListen.addListener(25, new Listener(){

            public void handleEvent(Event e) {
                String text = e.text;
                char[] chars = new char[text.length()];
                text.getChars(0, chars.length, chars, 0);
                for (int i = 0; i < chars.length; ++i) {
                    if ('0' <= chars[i] && chars[i] <= '9') continue;
                    e.doit = false;
                    return;
                }
            }
        });
        textServerTCPListen.addListener(24, new Listener(){

            public void handleEvent(Event e) {
                try {
                    int TCPListenPort;
                    NatTestWindow.this.serverTCPListenPort = TCPListenPort = Integer.parseInt(textServerTCPListen.getText());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        this.bTestTCP = new Button(panel, 8);
        Messages.setLanguageText((Widget)this.bTestTCP, "configureWizard.nat.test");
        gridData = new GridData();
        gridData.widthHint = 70;
        this.bTestTCP.setLayoutData((Object)gridData);
        label = new Label(panel, 0);
        Messages.setLanguageText((Widget)label, "configureWizard.nat.server.udp_listen_port");
        final Text textServerUDPListen = new Text(panel, 2048);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        textServerUDPListen.setLayoutData((Object)gridData);
        textServerUDPListen.setText("" + this.serverUDPListenPort);
        textServerUDPListen.addListener(25, new Listener(){

            public void handleEvent(Event e) {
                String text = e.text;
                char[] chars = new char[text.length()];
                text.getChars(0, chars.length, chars, 0);
                for (int i = 0; i < chars.length; ++i) {
                    if ('0' <= chars[i] && chars[i] <= '9') continue;
                    e.doit = false;
                    return;
                }
            }
        });
        textServerUDPListen.addListener(24, new Listener(){

            public void handleEvent(Event e) {
                try {
                    int UDPListenPort;
                    NatTestWindow.this.serverUDPListenPort = UDPListenPort = Integer.parseInt(textServerUDPListen.getText());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        this.bTestUDP = new Button(panel, 8);
        Messages.setLanguageText((Widget)this.bTestUDP, "configureWizard.nat.test");
        gridData = new GridData();
        gridData.widthHint = 70;
        this.bTestUDP.setLayoutData((Object)gridData);
        this.textResults = new StyledText(panel, 2626);
        gridData = new GridData();
        gridData.widthHint = 400;
        gridData.heightHint = 100;
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.horizontalSpan = 3;
        this.textResults.setLayoutData((Object)gridData);
        this.textResults.setBackground(panel.getDisplay().getSystemColor(1));
        this.bTestTCP.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                NatTestWindow.this.bTestUDP.setEnabled(false);
                NatTestWindow.this.bTestTCP.setEnabled(false);
                NatTestWindow.this.bApply.setEnabled(false);
                NatTestWindow.this.textResults.setText("");
                CoreWaiterSWT.waitForCore(CoreWaiterSWT.TriggerInThread.ANY_THREAD, new AzureusCoreRunningListener(){

                    public void azureusCoreRunning(AzureusCore core) {
                        CheckerTCP checker = new CheckerTCP(NatTestWindow.this.serverTCPListenPort);
                        checker.start();
                    }
                });
            }
        });
        this.bTestUDP.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                NatTestWindow.this.bTestUDP.setEnabled(false);
                NatTestWindow.this.bTestTCP.setEnabled(false);
                NatTestWindow.this.bApply.setEnabled(false);
                NatTestWindow.this.textResults.setText("");
                CoreWaiterSWT.waitForCore(CoreWaiterSWT.TriggerInThread.ANY_THREAD, new AzureusCoreRunningListener(){

                    public void azureusCoreRunning(AzureusCore core) {
                        CheckerUDP checker = new CheckerUDP(core, NatTestWindow.this.serverUDPListenPort);
                        checker.start();
                    }
                });
            }
        });
        this.bApply = new Button(panel, 8);
        this.bApply.setText(MessageText.getString("Button.apply"));
        gridData = new GridData();
        gridData.widthHint = 70;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 131072;
        gridData.horizontalSpan = 2;
        this.bApply.setLayoutData((Object)gridData);
        this.bApply.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                int old_tcp = COConfigurationManager.getIntParameter("TCP.Listen.Port");
                int old_udp = COConfigurationManager.getIntParameter("UDP.Listen.Port");
                int old_udp2 = COConfigurationManager.getIntParameter("UDP.NonData.Listen.Port");
                if (old_tcp != NatTestWindow.this.serverTCPListenPort) {
                    COConfigurationManager.setParameter("TCP.Listen.Port", NatTestWindow.this.serverTCPListenPort);
                }
                if (old_udp != NatTestWindow.this.serverUDPListenPort) {
                    COConfigurationManager.setParameter("UDP.Listen.Port", NatTestWindow.this.serverUDPListenPort);
                    if (old_udp == old_udp2) {
                        COConfigurationManager.setParameter("UDP.NonData.Listen.Port", NatTestWindow.this.serverUDPListenPort);
                    }
                }
                COConfigurationManager.save();
                shell.close();
            }
        });
        this.bCancel = new Button(panel, 8);
        this.bCancel.setText(MessageText.getString("Button.cancel"));
        gridData = new GridData();
        gridData.widthHint = 70;
        this.bCancel.setLayoutData((Object)gridData);
        this.bCancel.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                shell.close();
            }
        });
        shell.setDefaultButton(this.bApply);
        shell.addListener(31, new Listener(){

            public void handleEvent(Event e) {
                if (e.character == '\u001b') {
                    shell.close();
                }
            }
        });
        shell.pack();
        Utils.centreWindow(shell);
        shell.open();
    }

    public void printMessage(final String message) {
        if (this.display == null || this.display.isDisposed()) {
            return;
        }
        this.display.asyncExec((Runnable)new AERunnable(){

            public void runSupport() {
                if (NatTestWindow.this.textResults == null || NatTestWindow.this.textResults.isDisposed()) {
                    return;
                }
                NatTestWindow.this.textResults.append(message);
            }
        });
    }

    public class CheckerTCP
    extends AEThread {
        private int TCPListenPort;

        public CheckerTCP(int tcp_listen_port) {
            super("NAT Checker TCP");
            this.TCPListenPort = tcp_listen_port;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runSupport() {
            try {
                NatTestWindow.this.printMessage(MessageText.getString("configureWizard.nat.testing") + " TCP " + this.TCPListenPort + " ... ");
                NatChecker checker = new NatChecker(AzureusCoreFactory.getSingleton(), NetworkAdmin.getSingleton().getMultiHomedServiceBindAddresses(true)[0], this.TCPListenPort, false);
                switch (checker.getResult()) {
                    case 1: {
                        NatTestWindow.this.printMessage("\n" + MessageText.getString("configureWizard.nat.ok") + "\n" + checker.getAdditionalInfo());
                        break;
                    }
                    case 2: {
                        NatTestWindow.this.printMessage("\n" + MessageText.getString("configureWizard.nat.ko") + " - " + checker.getAdditionalInfo() + ".\n");
                        break;
                    }
                    default: {
                        NatTestWindow.this.printMessage("\n" + MessageText.getString("configureWizard.nat.unable") + ". \n(" + checker.getAdditionalInfo() + ").\n");
                    }
                }
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                if (NatTestWindow.this.display.isDisposed()) {
                    return;
                }
                NatTestWindow.this.display.asyncExec((Runnable)new AERunnable(){

                    public void runSupport() {
                        if (NatTestWindow.this.bTestTCP != null && !NatTestWindow.this.bTestTCP.isDisposed()) {
                            NatTestWindow.this.bTestTCP.setEnabled(true);
                        }
                        if (NatTestWindow.this.bTestUDP != null && !NatTestWindow.this.bTestUDP.isDisposed()) {
                            NatTestWindow.this.bTestUDP.setEnabled(true);
                        }
                        if (NatTestWindow.this.bApply != null && !NatTestWindow.this.bApply.isDisposed()) {
                            NatTestWindow.this.bApply.setEnabled(true);
                        }
                    }
                });
                throw throwable;
            }
            if (NatTestWindow.this.display.isDisposed()) {
                return;
            }
            NatTestWindow.this.display.asyncExec((Runnable)new /* invalid duplicate definition of identical inner class */);
        }
    }

    public class CheckerUDP
    extends AEThread {
        private AzureusCore core;
        private int udp_port;

        public CheckerUDP(AzureusCore _core, int _udp_port) {
            super("NAT Checker UDP");
            this.core = _core;
            this.udp_port = _udp_port;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runSupport() {
            try {
                NetworkAdmin admin = NetworkAdmin.getSingleton();
                NetworkAdminProtocol[] inbound_protocols = admin.getInboundProtocols(this.core);
                NetworkAdminProtocol selected = null;
                for (NetworkAdminProtocol p : inbound_protocols) {
                    if (p.getType() != 3 || p.getPort() != this.udp_port) continue;
                    selected = p;
                    break;
                }
                if (selected == null) {
                    selected = admin.createInboundProtocol(this.core, 3, this.udp_port);
                }
                if (selected == null) {
                    NatTestWindow.this.printMessage("\n" + MessageText.getString("configureWizard.nat.ko") + ". \n( No UDP protocols enabled ).\n");
                } else {
                    NatTestWindow.this.printMessage(MessageText.getString("configureWizard.nat.testing") + " UDP " + this.udp_port + " ... ");
                    try {
                        selected.test(null, true, new NetworkAdminProgressListener(){

                            public void reportProgress(String task2) {
                                NatTestWindow.this.printMessage("\n    " + task2);
                            }
                        });
                        NatTestWindow.this.printMessage("\n" + MessageText.getString("configureWizard.nat.ok"));
                    }
                    catch (Throwable e) {
                        NatTestWindow.this.printMessage("\n" + MessageText.getString("configureWizard.nat.ko") + ". " + Debug.getNestedExceptionMessage(e) + ".\n");
                    }
                }
                Object var9_9 = null;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                if (NatTestWindow.this.display.isDisposed()) {
                    return;
                }
                NatTestWindow.this.display.asyncExec((Runnable)new AERunnable(){

                    public void runSupport() {
                        if (NatTestWindow.this.bTestTCP != null && !NatTestWindow.this.bTestTCP.isDisposed()) {
                            NatTestWindow.this.bTestTCP.setEnabled(true);
                        }
                        if (NatTestWindow.this.bTestUDP != null && !NatTestWindow.this.bTestUDP.isDisposed()) {
                            NatTestWindow.this.bTestUDP.setEnabled(true);
                        }
                        if (NatTestWindow.this.bApply != null && !NatTestWindow.this.bApply.isDisposed()) {
                            NatTestWindow.this.bApply.setEnabled(true);
                        }
                    }
                });
                throw throwable;
            }
            if (NatTestWindow.this.display.isDisposed()) {
                return;
            }
            NatTestWindow.this.display.asyncExec((Runnable)new /* invalid duplicate definition of identical inner class */);
        }
    }
}

