/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.pluginsimpl;

import com.aelitis.azureus.ui.common.ToolBarEnabler;
import com.aelitis.azureus.ui.common.ToolBarItem;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import com.aelitis.azureus.util.MapUtils;
import java.awt.Frame;
import java.awt.Panel;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.ui.UIPluginViewToolBarListener;
import org.gudy.azureus2.plugins.ui.UIRuntimeException;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.debug.ObfusticateImage;
import org.gudy.azureus2.ui.swt.plugins.PluginUISWTSkinObject;
import org.gudy.azureus2.ui.swt.plugins.UISWTView;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEventListener;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewCore;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewCoreEventListener;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewEventCancelledException;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewEventImpl;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewEventListenerHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UISWTViewImpl
implements UISWTViewCore,
AEDiagnosticsEvidenceGenerator {
    public static final String CFG_PREFIX = "Views.plugins.";
    private PluginUISWTSkinObject skinObject;
    private final Object initialDatasource;
    private UISWTView parentView;
    private Object dataSource = null;
    private boolean useCoreDataSource = false;
    private final UISWTViewEventListener eventListener;
    private Composite composite;
    private final String sViewID;
    private int iControlType = 0;
    private boolean bFirstGetCompositeCall = true;
    private String sTitle = null;
    private String lastFullTitleKey = null;
    private String lastFullTitle = "";
    public Object relatedPluginView = null;
    private UIPluginViewToolBarListener toolbarListener;
    private volatile Map<Object, Object> user_data;

    public UISWTViewImpl(String sParentID, String sViewID, UISWTViewEventListener eventListener, Object _initialDatasource) throws Exception {
        this.sViewID = sViewID;
        this.initialDatasource = _initialDatasource;
        this.eventListener = eventListener;
        if (eventListener instanceof UISWTViewCoreEventListener) {
            this.useCoreDataSource = true;
        }
        AEDiagnostics.addEvidenceGenerator(this);
        if (this.initialDatasource != null) {
            this.triggerEvent(1, this.initialDatasource);
        }
        if (!eventListener.eventOccurred(new UISWTViewEventImpl(sParentID, this, 0, this))) {
            throw new UISWTViewEventCancelledException();
        }
    }

    @Override
    public UISWTViewEventListener getEventListener() {
        return this.eventListener;
    }

    @Override
    public Object getInitialDataSource() {
        return this.initialDatasource;
    }

    @Override
    public Object getDataSource() {
        return this.dataSource;
    }

    public void setParentView(UISWTView p) {
        this.parentView = p;
    }

    @Override
    public UISWTView getParentView() {
        return this.parentView;
    }

    @Override
    public String getViewID() {
        return this.sViewID;
    }

    @Override
    public void closeView() {
        try {
            Composite c;
            UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
            if (uiFunctions != null) {
                uiFunctions.closePluginView(this);
            }
            if ((c = this.getComposite()) != null && !c.isDisposed()) {
                Composite parent = c.getParent();
                this.triggerEvent(7, null);
                if (parent instanceof CTabFolder) {
                    for (CTabItem item : ((CTabFolder)parent).getItems()) {
                        if (item.getControl() != c) continue;
                        item.dispose();
                    }
                }
            }
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    @Override
    public void setControlType(int iControlType) {
        if (iControlType == 1 || iControlType == 0 || iControlType == 257) {
            this.iControlType = iControlType;
        }
    }

    @Override
    public int getControlType() {
        return this.iControlType;
    }

    @Override
    public void triggerEvent(int eventType, Object data) {
        Composite c;
        if (eventType == 1) {
            Object newDataSource = PluginCoreUtils.convert(data, this.useCoreDataSource);
            if (this.dataSource == newDataSource) {
                return;
            }
            data = this.dataSource = newDataSource;
        } else if (eventType == 6) {
            this.lastFullTitle = "";
            Messages.updateLanguageForControl((Widget)this.getComposite());
        } else if (eventType == 9 && this.eventListener instanceof ObfusticateImage && data instanceof Map) {
            ((ObfusticateImage)((Object)this.eventListener)).obfusticatedImage((Image)MapUtils.getMapObject((Map)data, "image", null, Image.class));
        }
        try {
            this.eventListener.eventOccurred(new UISWTViewEventImpl(null, this, eventType, data));
        }
        catch (Throwable t) {
            Debug.out("ViewID=" + this.sViewID + "; EventID=" + eventType + "; data=" + data, t);
        }
        if (eventType == 7 && (c = this.getComposite()) != null && !c.isDisposed()) {
            Composite parent = c.getParent();
            Utils.disposeComposite(c);
            Utils.relayout((Control)parent);
        }
    }

    protected boolean triggerEventRaw(int eventType, Object data) {
        try {
            return this.eventListener.eventOccurred(new UISWTViewEventImpl(null, this, eventType, data));
        }
        catch (Throwable t) {
            throw new UIRuntimeException("UISWTView.triggerEvent:: ViewID=" + this.sViewID + "; EventID=" + eventType + "; data=" + data, t);
        }
    }

    @Override
    public void setTitle(String title) {
        if (title.contains(".") && MessageText.keyExists(title)) {
            title = MessageText.getString(title);
        }
        this.sTitle = title;
    }

    @Override
    public PluginInterface getPluginInterface() {
        if (this.eventListener instanceof UISWTViewEventListenerHolder) {
            return ((UISWTViewEventListenerHolder)this.eventListener).getPluginInterface();
        }
        return null;
    }

    @Override
    public Composite getComposite() {
        if (this.bFirstGetCompositeCall) {
            this.bFirstGetCompositeCall = false;
        }
        return this.composite;
    }

    @Override
    public String getTitleID() {
        if (this.sTitle == null) {
            if (MessageText.keyExists(this.sViewID)) {
                return this.sViewID;
            }
            String id = CFG_PREFIX + this.sViewID + ".title";
            if (MessageText.keyExists(id)) {
                return id;
            }
            return "!" + this.sViewID + "!";
        }
        return "!" + this.sTitle + "!";
    }

    @Override
    public String getFullTitle() {
        if (this.sTitle != null) {
            return this.sTitle;
        }
        String key = this.getTitleID();
        if (key == null) {
            return "";
        }
        if (this.lastFullTitle.length() > 0 && key.equals(this.lastFullTitleKey)) {
            return this.lastFullTitle;
        }
        this.lastFullTitleKey = key;
        this.lastFullTitle = MessageText.keyExists(key) || key.startsWith("!") && key.endsWith("!") ? MessageText.getString(key) : key.replace('.', ' ');
        return this.lastFullTitle;
    }

    @Override
    public void initialize(Composite parent) {
        if (this.iControlType == 0) {
            GridData gridData;
            Layout parentLayout = parent.getLayout();
            if (parentLayout instanceof FormLayout) {
                this.composite = parent;
            } else {
                this.composite = new Composite(parent, 0);
                GridLayout layout = new GridLayout(1, false);
                layout.marginHeight = 0;
                layout.marginWidth = 0;
                this.composite.setLayout((Layout)layout);
                gridData = new GridData(1808);
                this.composite.setLayoutData((Object)gridData);
            }
            this.triggerEvent(2, this.composite);
            if (this.composite.getLayout() instanceof GridLayout) {
                Control[] children = this.composite.getChildren();
                for (int i = 0; i < children.length; ++i) {
                    Control control = children[i];
                    Object layoutData = control.getLayoutData();
                    if (layoutData != null && layoutData instanceof GridData) continue;
                    if (layoutData != null) {
                        Logger.log(new LogEvent(LogIDs.PLUGIN, 1, "Plugin View '" + this.sViewID + "' tried to setLayoutData of " + control + " to a " + layoutData.getClass().getName()));
                    }
                    gridData = children.length == 1 ? new GridData(4, 4, true, true) : new GridData();
                    control.setLayoutData((Object)gridData);
                }
            }
        } else if (this.iControlType == 1) {
            this.composite = new Composite(parent, 0x1000000);
            FillLayout layout = new FillLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            this.composite.setLayout((Layout)layout);
            GridData gridData = new GridData(1808);
            this.composite.setLayoutData((Object)gridData);
            Frame f = SWT_AWT.new_Frame((Composite)this.composite);
            Panel pan = new Panel();
            f.add(pan);
            this.triggerEvent(2, pan);
        } else if (this.iControlType == 257) {
            this.triggerEvent(2, this.getSkinObject());
        }
    }

    public boolean requestClose() {
        return this.triggerEventRaw(8, null);
    }

    @Override
    public boolean useCoreDataSource() {
        return this.useCoreDataSource;
    }

    @Override
    public void setUseCoreDataSource(boolean useCoreDataSource) {
        if (this.useCoreDataSource == useCoreDataSource) {
            return;
        }
        this.useCoreDataSource = useCoreDataSource;
        this.triggerEvent(1, this.dataSource);
    }

    @Override
    public PluginUISWTSkinObject getSkinObject() {
        return this.skinObject;
    }

    @Override
    public void setSkinObject(PluginUISWTSkinObject skinObject, Composite c) {
        this.skinObject = skinObject;
        this.composite = c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(IndentWriter writer) {
        if (this.eventListener instanceof AEDiagnosticsEvidenceGenerator) {
            writer.println("View: " + this.sViewID + ": " + this.sTitle);
            try {
                try {
                    writer.indent();
                    ((AEDiagnosticsEvidenceGenerator)((Object)this.eventListener)).generate(writer);
                }
                catch (Exception exception) {
                    Object var4_3 = null;
                    writer.exdent();
                }
                Object var4_2 = null;
                writer.exdent();
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                writer.exdent();
                throw throwable;
            }
        } else {
            writer.println("View (no generator): " + this.sViewID + ": " + this.sTitle);
        }
    }

    public boolean toolBarItemActivated(ToolBarItem item, long activationType, Object datasource) {
        if (this.toolbarListener != null) {
            return this.toolbarListener.toolBarItemActivated(item, activationType, datasource);
        }
        if (this.eventListener instanceof UIPluginViewToolBarListener) {
            return ((UIPluginViewToolBarListener)((Object)this.eventListener)).toolBarItemActivated(item, activationType, datasource);
        }
        if (this.eventListener instanceof ToolBarEnabler) {
            return ((ToolBarEnabler)((Object)this.eventListener)).toolBarItemActivated(item.getID());
        }
        return false;
    }

    public void refreshToolBarItems(Map<String, Long> list) {
        if (this.eventListener instanceof UIPluginViewToolBarListener) {
            ((UIPluginViewToolBarListener)((Object)this.eventListener)).refreshToolBarItems(list);
        } else if (this.eventListener instanceof ToolBarEnabler) {
            String id;
            HashMap<String, Boolean> states = new HashMap<String, Boolean>();
            for (Map.Entry<String, Long> entry : list.entrySet()) {
                id = entry.getKey();
                states.put(id, (entry.getValue() & 1L) > 0L);
            }
            ((ToolBarEnabler)((Object)this.eventListener)).refreshToolBar(states);
            for (Map.Entry<String, Long> entry : states.entrySet()) {
                id = entry.getKey();
                Boolean visible = (Boolean)((Object)entry.getValue());
                list.put(id, visible != false ? 1L : 0L);
            }
        }
    }

    @Override
    public void setToolBarListener(UIPluginViewToolBarListener l) {
        this.toolbarListener = l;
    }

    @Override
    public UIPluginViewToolBarListener getToolBarListener() {
        return this.toolbarListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUserData(Object key, Object data) {
        UISWTViewImpl uISWTViewImpl = this;
        synchronized (uISWTViewImpl) {
            if (this.user_data == null) {
                if (data == null) {
                    return;
                }
                this.user_data = new HashMap<Object, Object>();
            }
            if (data == null) {
                this.user_data.remove(key);
                if (this.user_data.isEmpty()) {
                    this.user_data = null;
                }
            } else {
                this.user_data.put(key, data);
            }
        }
    }

    @Override
    public Object getUserData(Object key) {
        Map<Object, Object> temp = this.user_data;
        if (temp == null) {
            return null;
        }
        return temp.get(key);
    }
}

