/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.shells;

import java.util.Iterator;
import java.util.LinkedHashMap;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.shells.GCStringPrinter;

public class SpeedScaleShell {
    private static final boolean MOUSE_ONLY_UP_EXITS = true;
    private static final int OPTION_HEIGHT = 15;
    private static final int TEXT_HEIGHT = 32;
    private static final int SCALER_HEIGHT = 20;
    private int HEIGHT = 52;
    private static final int WIDTH = 120;
    private static final int PADDING_X0 = 10;
    private static final int PADDING_X1 = 10;
    private static final int WIDTH_NO_PADDING = 100;
    private static final int TYPED_TEXT_ALPHA = 80;
    private static final long CLOSE_DELAY = 600L;
    private int value;
    private boolean cancelled = true;
    private int minValue = 0;
    private int maxValue = -1;
    private int maxTextValue = -1;
    private int pageIncrement = 10;
    private int bigPageIncrement = 100;
    private Shell shell;
    private LinkedHashMap mapOptions = new LinkedHashMap();
    private String sValue = "";
    private Composite composite;
    private boolean menuChosen = false;
    protected boolean lastMoveHadMouseDown;
    private boolean assumeInitiallyDown;
    private TimerEventPerformer cursorBlinkPerformer = null;
    private TimerEvent cursorBlinkEvent = null;

    public boolean open(final int startValue, boolean _assumeInitiallyDown) {
        this.value = startValue;
        this.assumeInitiallyDown = _assumeInitiallyDown;
        if (this.assumeInitiallyDown) {
            this.lastMoveHadMouseDown = true;
        }
        this.cancelled = true;
        this.shell = new Shell(Utils.findAnyShell(), 0x20004000);
        this.shell.setLayout((Layout)new FillLayout());
        final Display display = this.shell.getDisplay();
        this.composite = new Composite((Composite)this.shell, 0x20000000);
        final Point firstMousePos = display.getCursorLocation();
        this.composite.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2) {
                    SpeedScaleShell.this.setCancelled(true);
                    SpeedScaleShell.this.shell.dispose();
                } else if (e.detail == 64) {
                    SpeedScaleShell.this.setValue(SpeedScaleShell.this.value + 1);
                } else if (e.detail == 32) {
                    SpeedScaleShell.this.setValue(SpeedScaleShell.this.value - 1);
                } else if (e.detail == 512) {
                    SpeedScaleShell.this.setValue(SpeedScaleShell.this.value + SpeedScaleShell.this.bigPageIncrement);
                } else if (e.detail == 256) {
                    SpeedScaleShell.this.setValue(SpeedScaleShell.this.value - SpeedScaleShell.this.bigPageIncrement);
                } else if (e.detail == 4) {
                    SpeedScaleShell.this.setCancelled(false);
                    SpeedScaleShell.this.shell.dispose();
                }
            }
        });
        this.composite.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000006 && e.stateMask == 0) {
                    SpeedScaleShell.this.setValue(SpeedScaleShell.this.value + SpeedScaleShell.this.pageIncrement);
                } else if (e.keyCode == 0x1000005 && e.stateMask == 0) {
                    SpeedScaleShell.this.setValue(SpeedScaleShell.this.value - SpeedScaleShell.this.pageIncrement);
                } else if (e.keyCode == 0x1000007) {
                    SpeedScaleShell.this.setValue(SpeedScaleShell.this.minValue);
                } else if (e.keyCode == 0x1000008 && SpeedScaleShell.this.maxValue != -1) {
                    SpeedScaleShell.this.setValue(SpeedScaleShell.this.maxValue);
                }
            }
        });
        this.composite.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                boolean hasButtonDown;
                SpeedScaleShell.this.lastMoveHadMouseDown = false;
                boolean bl = hasButtonDown = (e.stateMask & SWT.BUTTON_MASK) > 0 || SpeedScaleShell.this.assumeInitiallyDown;
                if (hasButtonDown) {
                    if (e.y > SpeedScaleShell.this.HEIGHT - 20) {
                        SpeedScaleShell.this.lastMoveHadMouseDown = true;
                        SpeedScaleShell.this.setValue(SpeedScaleShell.this.getValueFromMousePos(e.x));
                    }
                    SpeedScaleShell.this.composite.redraw();
                } else {
                    SpeedScaleShell.this.composite.redraw();
                }
            }
        });
        this.composite.addMouseTrackListener(new MouseTrackListener(){
            boolean mouseIsOut = false;
            private boolean exitCancelled = false;

            public void mouseHover(MouseEvent e) {
            }

            public void mouseExit(MouseEvent e) {
                this.mouseIsOut = true;
                SimpleTimer.addEvent("close scaler", SystemTime.getOffsetTime(600L), new TimerEventPerformer(){

                    public void perform(TimerEvent event2) {
                        Utils.execSWTThread(new AERunnable(){

                            public void runSupport() {
                                if (!exitCancelled) {
                                    SpeedScaleShell.this.shell.dispose();
                                } else {
                                    exitCancelled = false;
                                }
                            }
                        });
                    }
                });
            }

            public void mouseEnter(MouseEvent e) {
                if (this.mouseIsOut) {
                    this.exitCancelled = true;
                }
                this.mouseIsOut = false;
            }
        });
        this.composite.addMouseListener(new MouseListener(){
            boolean bMouseDown = false;

            public void mouseUp(MouseEvent e) {
                Point mousePos;
                if (SpeedScaleShell.this.assumeInitiallyDown) {
                    SpeedScaleShell.this.assumeInitiallyDown = false;
                }
                if (SpeedScaleShell.this.lastMoveHadMouseDown && (mousePos = display.getCursorLocation()).equals((Object)firstMousePos)) {
                    SpeedScaleShell.this.lastMoveHadMouseDown = false;
                    return;
                }
                this.bMouseDown = true;
                if (this.bMouseDown) {
                    if (e.y > SpeedScaleShell.this.HEIGHT - 20) {
                        SpeedScaleShell.this.setValue(SpeedScaleShell.this.getValueFromMousePos(e.x));
                        SpeedScaleShell.this.setCancelled(false);
                        if (SpeedScaleShell.this.lastMoveHadMouseDown) {
                            SpeedScaleShell.this.shell.dispose();
                        }
                    } else if (e.y > 32) {
                        int newValue;
                        int idx = (e.y - 32) / 15;
                        Iterator iterator = SpeedScaleShell.this.mapOptions.keySet().iterator();
                        do {
                            newValue = (Integer)iterator.next();
                        } while (--idx >= 0);
                        SpeedScaleShell.this.value = newValue;
                        SpeedScaleShell.this.setCancelled(false);
                        SpeedScaleShell.this.setMenuChosen(true);
                        SpeedScaleShell.this.shell.dispose();
                    }
                }
            }

            public void mouseDown(MouseEvent e) {
                if (e.count > 1) {
                    SpeedScaleShell.this.lastMoveHadMouseDown = true;
                    return;
                }
                Point mousePos = display.getCursorLocation();
                if (e.y > SpeedScaleShell.this.HEIGHT - 20) {
                    this.bMouseDown = true;
                    SpeedScaleShell.this.setValue(SpeedScaleShell.this.getValueFromMousePos(e.x));
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.composite.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                int x = 100 * SpeedScaleShell.this.value / SpeedScaleShell.this.maxValue;
                if (x < 0) {
                    x = 0;
                } else if (x > 100) {
                    x = 100;
                }
                int startX = 100 * startValue / SpeedScaleShell.this.maxValue;
                if (startX < 0) {
                    startX = 0;
                } else if (startX > 100) {
                    startX = 100;
                }
                int baseLinePos = SpeedScaleShell.this.getBaselinePos();
                try {
                    e.gc.setAdvanced(true);
                    e.gc.setAntialias(1);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                e.gc.setForeground(display.getSystemColor(18));
                e.gc.drawLine(10, baseLinePos - 6, 10, baseLinePos + 6);
                e.gc.drawLine(110, baseLinePos - 6, 110, baseLinePos + 6);
                e.gc.drawLine(10, baseLinePos, 110, baseLinePos);
                e.gc.setForeground(display.getSystemColor(21));
                e.gc.setBackground(display.getSystemColor(21));
                e.gc.drawLine(10 + startX, baseLinePos - 5, 10 + startX, baseLinePos + 5);
                e.gc.fillRoundRectangle(10 + x - 2, baseLinePos - 5, 5, 10, 10, 10);
                e.gc.setForeground(display.getSystemColor(28));
                e.gc.setBackground(display.getSystemColor(29));
                e.gc.fillRectangle(0, 0, 120, 32);
                GCStringPrinter.printString(e.gc, SpeedScaleShell.this._getStringValue(), new Rectangle(0, 0, 120, SpeedScaleShell.this.HEIGHT), true, false, 0x10000C0);
                e.gc.drawLine(0, 31, 120, 31);
                int y = 32;
                Point mousePos = SpeedScaleShell.this.composite.toControl(display.getCursorLocation());
                for (Integer value : SpeedScaleShell.this.mapOptions.keySet()) {
                    Color saveColor;
                    Color bg;
                    String text = (String)SpeedScaleShell.this.mapOptions.get(value);
                    Rectangle area = new Rectangle(0, y, 120, 15);
                    if (area.contains(mousePos)) {
                        bg = display.getSystemColor(26);
                        e.gc.setBackground(bg);
                        e.gc.setForeground(display.getSystemColor(27));
                        e.gc.fillRectangle(area);
                    } else {
                        bg = display.getSystemColor(25);
                        e.gc.setBackground(bg);
                        e.gc.setForeground(display.getSystemColor(24));
                    }
                    int ovalSize = 9;
                    if (SpeedScaleShell.this.getValue() == value.intValue()) {
                        saveColor = e.gc.getBackground();
                        e.gc.setBackground(e.gc.getForeground());
                        e.gc.fillOval(4, y + 5, ovalSize - 3, ovalSize - 3);
                        e.gc.setBackground(saveColor);
                    }
                    if (Constants.isLinux) {
                        saveColor = e.gc.getForeground();
                        e.gc.setForeground(bg);
                        e.gc.drawPoint(2, y + 3);
                        e.gc.setForeground(saveColor);
                    }
                    e.gc.drawOval(2, y + 3, ovalSize, ovalSize);
                    GCStringPrinter.printString(e.gc, text, new Rectangle(15, y, 105, 15), true, false, 16384);
                    y += 15;
                }
                if (SpeedScaleShell.this.sValue.length() > 0) {
                    Point extent = e.gc.textExtent(SpeedScaleShell.this.sValue);
                    if (extent.x > 110) {
                        extent.x = 110;
                    }
                    Rectangle rect = new Rectangle(112 - extent.x, 14, extent.x + 5, extent.y + 4 + 14 > 32 ? 17 : extent.y + 4);
                    e.gc.setBackground(display.getSystemColor(29));
                    e.gc.fillRectangle(rect);
                    try {
                        e.gc.setAlpha(80);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    e.gc.setBackground(display.getSystemColor(25));
                    e.gc.setForeground(display.getSystemColor(24));
                    GCStringPrinter.printString(e.gc, SpeedScaleShell.this.sValue, new Rectangle(rect.x + 2, rect.y + 2, 115, 15), true, false, 17408);
                }
            }
        });
        final AERunnable cursorBlinkRunnable = new AERunnable(){
            boolean on = false;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void runSupport() {
                if (SpeedScaleShell.this.composite.isDisposed()) {
                    return;
                }
                this.on = !this.on;
                GC gc = new GC((Drawable)SpeedScaleShell.this.composite);
                try {
                    gc.setLineWidth(2);
                    if (!this.on) {
                        gc.setForeground(display.getSystemColor(29));
                    } else {
                        try {
                            gc.setAlpha(80);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    int y = 15;
                    gc.drawLine(115, y + 1, 115, y + 15);
                    Object var4_4 = null;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    gc.dispose();
                    throw throwable;
                }
                gc.dispose();
                if (SpeedScaleShell.this.cursorBlinkPerformer != null) {
                    SpeedScaleShell.this.cursorBlinkEvent = SimpleTimer.addEvent("BlinkingCursor", SystemTime.getOffsetTime(500L), SpeedScaleShell.this.cursorBlinkPerformer);
                }
            }
        };
        this.cursorBlinkPerformer = new TimerEventPerformer(){

            public void perform(TimerEvent event2) {
                Utils.execSWTThread(cursorBlinkRunnable);
            }
        };
        this.cursorBlinkEvent = SimpleTimer.addEvent("BlinkingCursor", SystemTime.getOffsetTime(500L), this.cursorBlinkPerformer);
        this.composite.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (Character.isDigit(e.character)) {
                    SpeedScaleShell.this.sValue = SpeedScaleShell.this.sValue + e.character;
                } else if (e.keyCode == 8 && SpeedScaleShell.this.sValue.length() > 0) {
                    SpeedScaleShell.this.sValue = SpeedScaleShell.this.sValue.substring(0, SpeedScaleShell.this.sValue.length() - 1);
                } else {
                    return;
                }
                try {
                    int newValue = Integer.parseInt(SpeedScaleShell.this.sValue);
                    if (SpeedScaleShell.this.maxTextValue == -1) {
                        SpeedScaleShell.this.setValue(newValue);
                    } else {
                        if (SpeedScaleShell.this.minValue > 0 && newValue < SpeedScaleShell.this.minValue) {
                            newValue = SpeedScaleShell.this.minValue;
                        }
                        if (newValue > SpeedScaleShell.this.maxTextValue) {
                            newValue = SpeedScaleShell.this.maxTextValue;
                        }
                        SpeedScaleShell.this.value = newValue;
                        SpeedScaleShell.this.composite.redraw();
                    }
                }
                catch (Exception ex) {
                    SpeedScaleShell.this.setValue(startValue);
                }
            }
        });
        Point location = display.getCursorLocation();
        location.y -= this.getBaselinePos();
        int x = (int)(100.0 * (this.value > this.maxValue ? 1.0 : (double)this.value / (double)this.maxValue));
        location.x -= 10 + x;
        Rectangle bounds = new Rectangle(location.x, location.y, 120, this.HEIGHT);
        Monitor mouseMonitor = this.shell.getMonitor();
        Monitor[] monitors = display.getMonitors();
        for (int i = 0; i < monitors.length; ++i) {
            Monitor monitor = monitors[i];
            if (!monitor.getBounds().contains(location)) continue;
            mouseMonitor = monitor;
            break;
        }
        Rectangle monitorBounds = mouseMonitor.getBounds();
        Rectangle intersection = monitorBounds.intersection(bounds);
        if (intersection.width != bounds.width) {
            bounds.x = monitorBounds.x + monitorBounds.width - 120;
            bounds.width = 120;
        }
        if (intersection.height != bounds.height) {
            bounds.y = monitorBounds.y + monitorBounds.height - this.HEIGHT;
            bounds.height = this.HEIGHT;
        }
        this.shell.setBounds(bounds);
        if (!bounds.contains(firstMousePos)) {
            this.shell.setLocation(firstMousePos.x - bounds.width / 2, firstMousePos.y - bounds.height + 2);
        }
        this.shell.open();
        this.composite.setFocus();
        try {
            while (!this.shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
        catch (Throwable t) {
            Debug.out(t);
        }
        if (this.cursorBlinkEvent != null) {
            this.cursorBlinkEvent.cancel();
            this.cursorBlinkEvent = null;
        }
        return !this.cancelled;
    }

    protected int getValueFromMousePos(int x) {
        int x0 = x + 1;
        if (x < 10) {
            x0 = 10;
        } else if (x > 110) {
            x0 = 110;
        }
        return (x0 - 10) * this.maxValue / 100;
    }

    public int getValue() {
        return this.value;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    public int getMinValue() {
        return this.minValue;
    }

    public void setMinValue(int minValue) {
        this.minValue = minValue;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(int maxValue) {
        this.maxValue = maxValue;
    }

    public void setValue(int value) {
        if (value > this.maxValue) {
            value = this.maxValue;
        } else if (value < this.minValue) {
            value = this.minValue;
        }
        this.value = value;
        if (this.composite != null && !this.composite.isDisposed()) {
            this.composite.redraw();
        }
    }

    public String _getStringValue() {
        String name = (String)this.mapOptions.get(new Integer(this.value));
        return this.getStringValue(this.value, name);
    }

    public String getStringValue(int value, String sValue) {
        if (sValue != null) {
            return sValue;
        }
        return "" + value;
    }

    private int getBaselinePos() {
        return this.HEIGHT - 10;
    }

    public void addOption(String id, int value) {
        this.mapOptions.put(new Integer(value), id);
        this.HEIGHT += 15;
    }

    public int getMaxTextValue() {
        return this.maxTextValue;
    }

    public void setMaxTextValue(int maxTextValue) {
        this.maxTextValue = maxTextValue;
    }

    public boolean wasMenuChosen() {
        return this.menuChosen;
    }

    public void setMenuChosen(boolean menuChosen) {
        this.menuChosen = menuChosen;
    }
}

