/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.update;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.plugins.update.Update;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderException;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderListener;

public class UpdateAutoDownloader
implements ResourceDownloaderListener {
    private final Update[] updates;
    private ArrayList downloaders;
    private Iterator iterDownloaders;
    private final cbCompletion completionCallback;

    public UpdateAutoDownloader(Update[] updates, cbCompletion completionCallback) {
        this.updates = updates;
        this.completionCallback = completionCallback;
        this.downloaders = new ArrayList();
        this.start();
    }

    private void start() {
        for (int i = 0; i < this.updates.length; ++i) {
            Update update = this.updates[i];
            ResourceDownloader[] rds = update.getDownloaders();
            for (int j = 0; j < rds.length; ++j) {
                ResourceDownloader rd = rds[j];
                this.downloaders.add(rd);
            }
        }
        this.iterDownloaders = this.downloaders.iterator();
        this.nextUpdate();
    }

    private boolean nextUpdate() {
        if (this.iterDownloaders.hasNext()) {
            ResourceDownloader downloader = (ResourceDownloader)this.iterDownloaders.next();
            downloader.addListener(this);
            downloader.asyncDownload();
            return true;
        }
        return false;
    }

    private void allDownloadsComplete() {
        boolean bRequiresRestart = false;
        boolean bHadMandatoryUpdates = false;
        for (int i = 0; i < this.updates.length; ++i) {
            Update update = this.updates[i];
            if (update.getDownloaders().length <= 0) continue;
            if (update.getRestartRequired() != 1) {
                bRequiresRestart = true;
            }
            if (!update.isMandatory()) continue;
            bHadMandatoryUpdates = true;
        }
        this.completionCallback.allUpdatesComplete(bRequiresRestart, bHadMandatoryUpdates);
    }

    public boolean completed(ResourceDownloader downloader, InputStream data) {
        downloader.removeListener(this);
        if (!this.nextUpdate()) {
            AEThread thread = new AEThread("AllDownloadsComplete", true){

                public void runSupport() {
                    UpdateAutoDownloader.this.allDownloadsComplete();
                }
            };
            thread.start();
        }
        return true;
    }

    public void failed(ResourceDownloader downloader, ResourceDownloaderException e) {
        downloader.removeListener(this);
        this.iterDownloaders.remove();
        this.nextUpdate();
    }

    public void reportActivity(ResourceDownloader downloader, String activity) {
    }

    public void reportAmountComplete(ResourceDownloader downloader, long amount) {
    }

    public void reportPercentComplete(ResourceDownloader downloader, int percentage) {
    }

    public static interface cbCompletion {
        public void allUpdatesComplete(boolean var1, boolean var2);
    }
}

