/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views;

import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.shell.ShellFactory;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewImpl;
import org.gudy.azureus2.ui.swt.views.ConfigView;

public class ConfigShell {
    private static ConfigShell instance;
    private Shell shell;
    private ConfigView configView;
    private UISWTViewImpl swtView;

    public static ConfigShell getInstance() {
        if (null == instance) {
            instance = new ConfigShell();
        }
        return instance;
    }

    private ConfigShell() {
    }

    public void open(String section) {
        if (null != this.shell && !this.shell.isDisposed()) {
            this.configView.selectSection(section, true);
            if (this.shell.getMinimized()) {
                this.shell.setMinimized(false);
            }
            this.shell.forceActive();
            this.shell.forceFocus();
        } else {
            this.shell = ShellFactory.createMainShell(1136);
            this.shell.setLayout((Layout)new GridLayout());
            this.shell.setText(MessageText.getString(MessageText.resolveLocalizationKey("ConfigView.title.full")));
            Utils.setShellIcon(this.shell);
            this.configView = new ConfigView();
            try {
                this.swtView = new UISWTViewImpl(null, "ConfigView", this.configView, section);
            }
            catch (Exception e1) {
                Debug.out(e1);
            }
            this.swtView.initialize((Composite)this.shell);
            this.configView.selectSection(section, true);
            if (null == COConfigurationManager.getStringParameter("options.rectangle", null)) {
                Rectangle shellBounds = this.shell.getMonitor().getBounds();
                Point size = new Point(shellBounds.width * 10 / 11, shellBounds.height * 10 / 11);
                if (size.x > 1400) {
                    size.x = 1400;
                }
                if (size.y > 700) {
                    size.y = 700;
                }
                this.shell.setSize(size);
                Utils.centerWindowRelativeTo(this.shell, (Control)this.getMainShell());
            }
            Utils.linkShellMetricsToConfig(this.shell, "options");
            this.shell.addListener(21, new Listener(){

                public void handleEvent(Event event2) {
                    ConfigShell.this.configView.save();
                    event2.doit = true;
                }
            });
            this.shell.addTraverseListener(new TraverseListener(){

                public void keyTraversed(TraverseEvent e) {
                    if (e.detail == 2) {
                        ConfigShell.this.shell.dispose();
                    }
                }
            });
            this.shell.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent arg0) {
                    ConfigShell.this.close();
                }
            });
            this.shell.open();
        }
    }

    private void close() {
        if (this.swtView != null) {
            this.swtView.triggerEvent(7, null);
            this.swtView = null;
        }
        this.shell = null;
        this.configView = null;
    }

    private Shell getMainShell() {
        UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
        if (null != uiFunctions) {
            return uiFunctions.getMainShell();
        }
        throw new IllegalStateException("No instance of UIFunctionsSWT found; the UIFunctionsManager might not have been initialized properly");
    }
}

