/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views;

import com.aelitis.azureus.ui.common.ToolBarItem;
import com.aelitis.azureus.ui.selectedcontent.SelectedContent;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentManager;
import com.aelitis.azureus.util.MapUtils;
import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.util.Map;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerStats;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.ui.UIPluginViewToolBarListener;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.TorrentUtil;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.BufferedLabel;
import org.gudy.azureus2.ui.swt.debug.UIDebugGenerator;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.plugins.UISWTView;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEvent;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewCoreEventListener;
import org.gudy.azureus2.ui.swt.views.ViewUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneralView
implements ParameterListener,
UISWTViewCoreEventListener,
UIPluginViewToolBarListener {
    public static final String MSGID_PREFIX = "GeneralView";
    protected AEMonitor this_mon = new AEMonitor("GeneralView");
    private Display display;
    private DownloadManager manager = null;
    boolean[] pieces;
    int loopFactor;
    Composite genComposite;
    Composite gFile;
    Canvas piecesImage;
    Image pImage;
    BufferedLabel piecesPercent;
    Canvas availabilityImage;
    Image aImage;
    BufferedLabel availabilityPercent;
    Group gTransfer;
    BufferedLabel timeElapsed;
    BufferedLabel timeRemaining;
    BufferedLabel download;
    BufferedLabel downloadSpeed;
    BufferedLabel upload;
    BufferedLabel uploadSpeed;
    BufferedLabel totalSpeed;
    BufferedLabel ave_completion;
    BufferedLabel distributedCopies;
    BufferedLabel seeds;
    BufferedLabel peers;
    BufferedLabel completedLbl;
    Group gInfo;
    BufferedLabel fileName;
    BufferedLabel torrentStatus;
    BufferedLabel fileSize;
    BufferedLabel saveIn;
    BufferedLabel hash;
    BufferedLabel pieceNumber;
    BufferedLabel pieceSize;
    Control lblComment;
    BufferedLabel creation_date;
    BufferedLabel privateStatus;
    Control user_comment;
    BufferedLabel hashFails;
    BufferedLabel shareRatio;
    private int graphicsUpdate = COConfigurationManager.getIntParameter("Graphics Update");
    private Composite parent;
    private ScrolledComposite scrolled_comp;
    private UISWTView swtView;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void dataSourceChanged(Object newDataSource) {
        DownloadManager old_manager = this.manager;
        if (newDataSource == null) {
            this.manager = null;
        } else if (newDataSource instanceof Object[]) {
            Object temp = ((Object[])newDataSource)[0];
            if (temp instanceof DownloadManager) {
                this.manager = (DownloadManager)temp;
            } else {
                if (!(temp instanceof DiskManagerFileInfo)) return;
                this.manager = ((DiskManagerFileInfo)temp).getDownloadManager();
            }
        } else if (newDataSource instanceof DownloadManager) {
            this.manager = (DownloadManager)newDataSource;
        } else {
            if (!(newDataSource instanceof DiskManagerFileInfo)) return;
            this.manager = ((DiskManagerFileInfo)newDataSource).getDownloadManager();
        }
        if (old_manager == this.manager) {
            return;
        }
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                GeneralView.this.swt_refreshInfo();
            }
        });
    }

    public void initialize(Composite composite) {
        this.parent = composite;
        this.scrolled_comp = new ScrolledComposite(composite, 512);
        this.scrolled_comp.setExpandHorizontal(true);
        this.scrolled_comp.setExpandVertical(true);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.scrolled_comp.setLayout((Layout)layout);
        GridData gridData = new GridData(4, 4, true, true, 2, 1);
        this.scrolled_comp.setLayoutData((Object)gridData);
        this.genComposite = new Canvas((Composite)this.scrolled_comp, 0);
        GridLayout genLayout = new GridLayout();
        genLayout.marginHeight = 0;
        try {
            genLayout.marginTop = 5;
        }
        catch (NoSuchFieldError e) {
            // empty catch block
        }
        genLayout.marginWidth = 2;
        genLayout.numColumns = 1;
        this.genComposite.setLayout((Layout)genLayout);
        this.scrolled_comp.setContent((Control)this.genComposite);
        this.scrolled_comp.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle r = GeneralView.this.scrolled_comp.getClientArea();
                GeneralView.this.scrolled_comp.setMinSize(GeneralView.this.genComposite.computeSize(r.width, -1));
            }
        });
        Utils.execSWTThreadLater(0, new AERunnable(){

            public void runSupport() {
                GeneralView.this.swt_refreshInfo();
            }
        });
        COConfigurationManager.addParameterListener("Graphics Update", (ParameterListener)this);
    }

    private void swt_refreshInfo() {
        if (this.manager == null || this.parent == null) {
            if (this.genComposite != null && !this.genComposite.isDisposed()) {
                Utils.disposeComposite(this.genComposite, false);
                Label lab = new Label(this.genComposite, 0);
                GridData gridData = new GridData(768);
                lab.setLayoutData((Object)gridData);
                Messages.setLanguageText((Widget)lab, "label.no.download.selected");
                this.genComposite.layout();
            }
            return;
        }
        Utils.disposeComposite(this.genComposite, false);
        this.pieces = new boolean[this.manager.getNbPieces()];
        this.display = this.parent.getDisplay();
        this.gFile = new Composite(this.genComposite, 8);
        GridData gridData = new GridData(768);
        this.gFile.setLayoutData((Object)gridData);
        GridLayout fileLayout = new GridLayout();
        fileLayout.marginHeight = 0;
        fileLayout.marginWidth = 10;
        fileLayout.numColumns = 3;
        this.gFile.setLayout((Layout)fileLayout);
        Label piecesInfo = new Label(this.gFile, 16384);
        Messages.setLanguageText((Widget)piecesInfo, "GeneralView.section.downloaded");
        gridData = new GridData(32);
        piecesInfo.setLayoutData((Object)gridData);
        this.piecesImage = new Canvas(this.gFile, 0);
        gridData = new GridData(768);
        gridData.widthHint = 150;
        gridData.heightHint = 25;
        this.piecesImage.setLayoutData((Object)gridData);
        this.piecesPercent = new BufferedLabel(this.gFile, 0x20020000);
        gridData = new GridData(128);
        gridData.widthHint = 50;
        this.piecesPercent.setLayoutData(gridData);
        Label availabilityInfo = new Label(this.gFile, 16384);
        Messages.setLanguageText((Widget)availabilityInfo, "GeneralView.section.availability");
        gridData = new GridData(32);
        availabilityInfo.setLayoutData((Object)gridData);
        this.availabilityImage = new Canvas(this.gFile, 0);
        gridData = new GridData(768);
        gridData.widthHint = 150;
        gridData.heightHint = 25;
        this.availabilityImage.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)this.availabilityImage, "GeneralView.label.status.pieces_available.tooltip");
        this.availabilityPercent = new BufferedLabel(this.gFile, 0x20020000);
        gridData = new GridData(128);
        gridData.widthHint = 50;
        this.availabilityPercent.setLayoutData(gridData);
        Messages.setLanguageText(this.availabilityPercent.getWidget(), "GeneralView.label.status.pieces_available.tooltip");
        this.gTransfer = new Group(this.genComposite, 8);
        Messages.setLanguageText((Widget)this.gTransfer, "GeneralView.section.transfer");
        gridData = new GridData(768);
        this.gTransfer.setLayoutData((Object)gridData);
        GridLayout layoutTransfer = new GridLayout();
        layoutTransfer.numColumns = 6;
        this.gTransfer.setLayout((Layout)layoutTransfer);
        Label label = new Label((Composite)this.gTransfer, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.timeelapsed");
        this.timeElapsed = new BufferedLabel((Composite)this.gTransfer, 0x20004000);
        gridData = new GridData(768);
        this.timeElapsed.setLayoutData(gridData);
        label = new Label((Composite)this.gTransfer, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.remaining");
        this.timeRemaining = new BufferedLabel((Composite)this.gTransfer, 0x20004000);
        gridData = new GridData(768);
        this.timeRemaining.setLayoutData(gridData);
        label = new Label((Composite)this.gTransfer, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.shareRatio");
        this.shareRatio = new BufferedLabel((Composite)this.gTransfer, 0x20004000);
        gridData = new GridData(768);
        this.shareRatio.setLayoutData(gridData);
        label = new Label((Composite)this.gTransfer, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.downloaded");
        this.download = new BufferedLabel((Composite)this.gTransfer, 0x20004000);
        gridData = new GridData(768);
        this.download.setLayoutData(gridData);
        label = new Label((Composite)this.gTransfer, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.downloadspeed");
        this.downloadSpeed = new BufferedLabel((Composite)this.gTransfer, 0x20004000);
        gridData = new GridData(768);
        this.downloadSpeed.setLayoutData(gridData);
        label = new Label((Composite)this.gTransfer, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.hashfails");
        this.hashFails = new BufferedLabel((Composite)this.gTransfer, 16384);
        gridData = new GridData(768);
        this.hashFails.setLayoutData(gridData);
        label = new Label((Composite)this.gTransfer, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.uploaded");
        this.upload = new BufferedLabel((Composite)this.gTransfer, 0x20004000);
        gridData = new GridData(768);
        this.upload.setLayoutData(gridData);
        label = new Label((Composite)this.gTransfer, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.uploadspeed");
        this.uploadSpeed = new BufferedLabel((Composite)this.gTransfer, 0x20004000);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        this.uploadSpeed.setLayoutData(gridData);
        label = new Label((Composite)this.gTransfer, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.seeds");
        this.seeds = new BufferedLabel((Composite)this.gTransfer, 16384);
        gridData = new GridData(768);
        this.seeds.setLayoutData(gridData);
        label = new Label((Composite)this.gTransfer, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.peers");
        this.peers = new BufferedLabel((Composite)this.gTransfer, 16384);
        gridData = new GridData(768);
        this.peers.setLayoutData(gridData);
        label = new Label((Composite)this.gTransfer, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.completed");
        this.completedLbl = new BufferedLabel((Composite)this.gTransfer, 16384);
        gridData = new GridData(768);
        this.completedLbl.setLayoutData(gridData);
        label = new Label((Composite)this.gTransfer, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.totalspeed");
        this.totalSpeed = new BufferedLabel((Composite)this.gTransfer, 0x20004000);
        gridData = new GridData(768);
        this.totalSpeed.setLayoutData(gridData);
        label = new Label((Composite)this.gTransfer, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.swarm_average_completion");
        this.ave_completion = new BufferedLabel((Composite)this.gTransfer, 0x20004000);
        gridData = new GridData(768);
        this.ave_completion.setLayoutData(gridData);
        label = new Label((Composite)this.gTransfer, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.distributedCopies");
        this.distributedCopies = new BufferedLabel((Composite)this.gTransfer, 0x20004000);
        gridData = new GridData(768);
        this.distributedCopies.setLayoutData(gridData);
        this.gInfo = new Group(this.genComposite, 8);
        Messages.setLanguageText((Widget)this.gInfo, "GeneralView.section.info");
        gridData = new GridData(1808);
        this.gInfo.setLayoutData((Object)gridData);
        GridLayout layoutInfo = new GridLayout();
        layoutInfo.numColumns = 4;
        this.gInfo.setLayout((Layout)layoutInfo);
        label = new Label((Composite)this.gInfo, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.filename");
        this.fileName = new BufferedLabel((Composite)this.gInfo, 16384);
        gridData = new GridData(768);
        this.fileName.setLayoutData(gridData);
        label = new Label((Composite)this.gInfo, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.status");
        this.torrentStatus = new BufferedLabel((Composite)this.gInfo, 16384);
        gridData = new GridData(768);
        this.torrentStatus.setLayoutData(gridData);
        label = new Label((Composite)this.gInfo, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.savein");
        this.saveIn = new BufferedLabel((Composite)this.gInfo, 16384);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        this.saveIn.setLayoutData(gridData);
        label = new Label((Composite)this.gInfo, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.totalsize");
        this.fileSize = new BufferedLabel((Composite)this.gInfo, 16384);
        gridData = new GridData(768);
        this.fileSize.setLayoutData(gridData);
        label = new Label((Composite)this.gInfo, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.numberofpieces");
        this.pieceNumber = new BufferedLabel((Composite)this.gInfo, 16384);
        gridData = new GridData(768);
        this.pieceNumber.setLayoutData(gridData);
        label = new Label((Composite)this.gInfo, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.hash");
        this.hash = new BufferedLabel((Composite)this.gInfo, 16384);
        Messages.setLanguageText(this.hash.getWidget(), "GeneralView.label.hash.tooltip", true);
        gridData = new GridData(768);
        this.hash.setLayoutData(gridData);
        this.hash.setCursor(this.display.getSystemCursor(21));
        this.hash.setForeground(Colors.blue);
        label.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent arg0) {
                String hash_str = GeneralView.this.hash.getText();
                if (hash_str != null && hash_str.length() != 0) {
                    new Clipboard(GeneralView.this.display).setContents(new Object[]{hash_str.replaceAll(" ", "")}, new Transfer[]{TextTransfer.getInstance()});
                }
            }

            public void mouseDown(MouseEvent arg0) {
                String hash_str = GeneralView.this.hash.getText();
                if (hash_str != null && hash_str.length() != 0) {
                    new Clipboard(GeneralView.this.display).setContents(new Object[]{hash_str.replaceAll(" ", "")}, new Transfer[]{TextTransfer.getInstance()});
                }
            }
        });
        this.hash.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent arg0) {
                String hash_str = GeneralView.this.hash.getText();
                if (hash_str != null && hash_str.length() != 0) {
                    new Clipboard(GeneralView.this.display).setContents(new Object[]{hash_str.replaceAll(" ", "")}, new Transfer[]{TextTransfer.getInstance()});
                }
            }

            public void mouseDown(MouseEvent arg0) {
                String hash_str = GeneralView.this.hash.getText();
                if (hash_str != null && hash_str.length() != 0) {
                    new Clipboard(GeneralView.this.display).setContents(new Object[]{hash_str.replaceAll(" ", "")}, new Transfer[]{TextTransfer.getInstance()});
                }
            }
        });
        label = new Label((Composite)this.gInfo, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.size");
        this.pieceSize = new BufferedLabel((Composite)this.gInfo, 16384);
        gridData = new GridData(768);
        this.pieceSize.setLayoutData(gridData);
        label = new Label((Composite)this.gInfo, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.creationdate");
        this.creation_date = new BufferedLabel((Composite)this.gInfo, 16384);
        gridData = new GridData(768);
        this.creation_date.setLayoutData(gridData);
        label = new Label((Composite)this.gInfo, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.private");
        this.privateStatus = new BufferedLabel((Composite)this.gInfo, 16384);
        gridData = new GridData(768);
        this.privateStatus.setLayoutData(gridData);
        label = new Label((Composite)this.gInfo, 16384);
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        label.setLayoutData((Object)gridData);
        label = new Label((Composite)this.gInfo, 16384);
        label.setCursor(this.display.getSystemCursor(21));
        label.setForeground(Colors.blue);
        Messages.setLanguageText((Widget)label, "GeneralView.label.user_comment");
        try {
            this.user_comment = new Link((Composite)this.gInfo, 16448);
            ((Link)this.user_comment).addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Utils.launch(e.text);
                }
            });
        }
        catch (Throwable e) {
            this.user_comment = new Label((Composite)this.gInfo, 16448);
        }
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        this.user_comment.setLayoutData((Object)gridData);
        label.addMouseListener((MouseListener)new MouseAdapter(){

            private void editComment() {
                TorrentUtil.promptUserForComment(new DownloadManager[]{GeneralView.this.manager});
            }

            public void mouseDoubleClick(MouseEvent arg0) {
                this.editComment();
            }

            public void mouseDown(MouseEvent arg0) {
                this.editComment();
            }
        });
        label = new Label((Composite)this.gInfo, 16384);
        gridData = new GridData(2);
        label.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)label, "GeneralView.label.comment");
        try {
            this.lblComment = new Link((Composite)this.gInfo, 16448);
            ((Link)this.lblComment).addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Utils.launch(e.text);
                }
            });
        }
        catch (Throwable e) {
            this.lblComment = new Label((Composite)this.gInfo, 16448);
        }
        gridData = new GridData(1808);
        gridData.horizontalSpan = 3;
        this.lblComment.setLayoutData((Object)gridData);
        this.piecesImage.addListener(9, new Listener(){

            public void handleEvent(Event e) {
                if (e.count == 0 && e.width > 0 && e.height > 0) {
                    GeneralView.this.updatePiecesInfo(true);
                }
            }
        });
        this.availabilityImage.addListener(9, new Listener(){

            public void handleEvent(Event e) {
                if (e.count == 0 && e.width > 0 && e.height > 0) {
                    GeneralView.this.updateAvailability();
                }
            }
        });
        this.genComposite.layout();
        Rectangle r = this.scrolled_comp.getClientArea();
        this.scrolled_comp.setMinSize(this.genComposite.computeSize(r.width, -1));
    }

    public Composite getComposite() {
        return this.genComposite;
    }

    public void refresh() {
        byte[] created_by;
        String completed;
        String remaining;
        if (this.gFile == null || this.gFile.isDisposed() || this.manager == null) {
            return;
        }
        ++this.loopFactor;
        if (this.loopFactor % this.graphicsUpdate == 0) {
            this.updateAvailability();
            this.updatePiecesInfo(false);
        }
        DiskManager dm = this.manager.getDiskManager();
        String eta = DisplayFormatters.formatETA(this.manager.getStats().getSmoothedETA());
        if (dm != null) {
            long rem = dm.getRemainingExcludingDND();
            String data_rem = DisplayFormatters.formatByteCountToKiBEtc(rem);
            remaining = rem > 0L ? eta + (eta.length() == 0 ? "" : " ") + data_rem : (eta.length() == 0 ? data_rem : eta);
        } else {
            remaining = eta;
        }
        this.setTime(this.manager.getStats().getElapsedTime(), remaining);
        TRTrackerScraperResponse hd = this.manager.getTrackerScrapeResponse();
        String seeds_str = this.manager.getNbSeeds() + " " + MessageText.getString("GeneralView.label.connected");
        String peers_str = this.manager.getNbPeers() + " " + MessageText.getString("GeneralView.label.connected");
        if (hd != null && hd.isValid()) {
            seeds_str = seeds_str + " ( " + hd.getSeeds() + " " + MessageText.getString("GeneralView.label.in_swarm") + " )";
            peers_str = peers_str + " ( " + hd.getPeers() + " " + MessageText.getString("GeneralView.label.in_swarm") + " )";
            completed = hd.getCompleted() > -1 ? Integer.toString(hd.getCompleted()) : "?";
        } else {
            completed = "?";
        }
        String _shareRatio = "";
        int sr = this.manager.getStats().getShareRatio();
        if (sr == -1) {
            _shareRatio = "\u221e";
        }
        if (sr > 0) {
            String partial = "" + sr % 1000;
            while (partial.length() < 3) {
                partial = "0" + partial;
            }
            _shareRatio = sr / 1000 + "." + partial;
        }
        DownloadManagerStats stats2 = this.manager.getStats();
        String swarm_speed = DisplayFormatters.formatByteCountToKiBEtcPerSec(stats2.getTotalAverage()) + " ( " + DisplayFormatters.formatByteCountToKiBEtcPerSec(stats2.getTotalAveragePerPeer()) + " " + MessageText.getString("GeneralView.label.averagespeed") + " )";
        String swarm_completion = "";
        String distributedCopies = "0.000";
        String piecesDoneAndSum = "" + this.manager.getNbPieces();
        PEPeerManager pm = this.manager.getPeerManager();
        if (pm != null) {
            int comp2 = pm.getAverageCompletionInThousandNotation();
            if (comp2 >= 0) {
                swarm_completion = DisplayFormatters.formatPercentFromThousands(comp2);
            }
            piecesDoneAndSum = pm.getPiecePicker().getNbPiecesDone() + "/" + piecesDoneAndSum;
            distributedCopies = new DecimalFormat("0.000").format(pm.getPiecePicker().getMinAvailability() - (float)pm.getNbSeeds() - (float)(pm.isSeeding() && stats2.getDownloadCompleted(false) == 1000 ? 1 : 0));
        }
        this.setStats(DisplayFormatters.formatDownloaded(stats2), DisplayFormatters.formatByteCountToKiBEtc(stats2.getTotalDataBytesSent()), DisplayFormatters.formatByteCountToKiBEtcPerSec(stats2.getDataReceiveRate()), DisplayFormatters.formatByteCountToKiBEtcPerSec(stats2.getDataSendRate()), swarm_speed, "" + this.manager.getStats().getDownloadRateLimitBytesPerSecond() / 1024, "" + this.manager.getStats().getUploadRateLimitBytesPerSecond() / 1024, seeds_str, peers_str, completed, DisplayFormatters.formatHashFails(this.manager), _shareRatio, swarm_completion, distributedCopies);
        TOTorrent torrent = this.manager.getTorrent();
        String creation_date = DisplayFormatters.formatDate(this.manager.getTorrentCreationDate() * 1000L);
        byte[] byArray = created_by = torrent == null ? null : torrent.getCreatedBy();
        if (created_by != null) {
            try {
                creation_date = MessageText.getString("GeneralView.torrent_created_on_and_by", new String[]{creation_date, new String(created_by, "UTF8")});
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
        this.setInfos(this.manager.getDisplayName(), DisplayFormatters.formatByteCountToKiBEtc(this.manager.getSize()), DisplayFormatters.formatDownloadStatus(this.manager), this.manager.getSaveLocation().toString(), TorrentUtils.nicePrintTorrentHash(torrent), piecesDoneAndSum, this.manager.getPieceLength(), this.manager.getTorrentComment(), creation_date, this.manager.getDownloadState().getUserComment(), MessageText.getString("GeneralView." + (torrent != null && torrent.getPrivate() ? "yes" : "no")));
        if (this.loopFactor == 2) {
            this.getComposite().layout(true);
        }
    }

    public void delete() {
        if (this.aImage != null) {
            this.aImage.dispose();
        }
        this.aImage = null;
        if (this.pImage != null) {
            this.pImage.dispose();
        }
        this.pImage = null;
        Utils.disposeComposite(this.genComposite);
        COConfigurationManager.removeParameterListener("Graphics Update", this);
    }

    private String getFullTitle() {
        return MessageText.getString("GeneralView.title.full");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAvailability() {
        String sTotal;
        int allMin;
        GC gcImage;
        GC gc;
        int yMax;
        int xMax;
        Rectangle bounds;
        int[] available;
        block44: {
            block43: {
                if (this.manager == null) {
                    return;
                }
                try {
                    block48: {
                        block47: {
                            this.this_mon.enter();
                            PEPeerManager pm = this.manager.getPeerManager();
                            if (this.manager.getPeerManager() == null) {
                                if (this.availabilityPercent.getText().length() > 0) {
                                    this.availabilityPercent.setText("");
                                }
                                available = new int[this.manager.getNbPieces()];
                            } else {
                                available = pm.getAvailability();
                            }
                            if (this.display == null) break block47;
                            if (!this.display.isDisposed()) break block48;
                        }
                        Object var26_3 = null;
                        this.this_mon.exit();
                        return;
                    }
                    if (this.availabilityImage == null) break block43;
                    if (!this.availabilityImage.isDisposed()) break block49;
                }
                catch (Throwable throwable) {
                    Object var26_8 = null;
                    this.this_mon.exit();
                    throw throwable;
                }
            }
            Object var26_4 = null;
            this.this_mon.exit();
            {
                block49: {
                    return;
                }
                bounds = this.availabilityImage.getClientArea();
                xMax = bounds.width - 2;
                yMax = bounds.height - 2;
                if (xMax < 10) break block44;
                if (yMax >= 5) break block50;
            }
        }
        Object var26_5 = null;
        this.this_mon.exit();
        {
            block50: {
                return;
            }
            if (this.aImage != null && !this.aImage.isDisposed()) {
                this.aImage.dispose();
            }
            this.aImage = new Image((Device)this.display, bounds.width, bounds.height);
            gc = new GC((Drawable)this.availabilityImage);
            gcImage = new GC((Drawable)this.aImage);
            gcImage.setForeground(Colors.grey);
            gcImage.drawRectangle(0, 0, bounds.width - 1, bounds.height - 1);
            allMin = 0;
            int allMax = 0;
            int total = 0;
            sTotal = "000";
            if (available != null) {
                allMin = available.length == 0 ? 0 : available[0];
                allMax = available.length == 0 ? 0 : available[0];
                int nbPieces = available.length;
                for (int i = 0; i < nbPieces; ++i) {
                    if (available[i] < allMin) {
                        allMin = available[i];
                    }
                    if (available[i] <= allMax) continue;
                    allMax = available[i];
                }
                int maxAboveMin = allMax - allMin;
                if (maxAboveMin == 0) {
                    gcImage.setBackground(Colors.blues[allMin == 0 ? 0 : 9]);
                    gcImage.fillRectangle(1, 1, xMax, yMax);
                } else {
                    int i;
                    for (i = 0; i < nbPieces; ++i) {
                        if (available[i] <= allMin) continue;
                        ++total;
                    }
                    total = total * 1000 / nbPieces;
                    sTotal = "" + total;
                    if (total < 10) {
                        sTotal = "0" + sTotal;
                    }
                    if (total < 100) {
                        sTotal = "0" + sTotal;
                    }
                    for (i = 0; i < xMax; ++i) {
                        int index;
                        int a1 = (i + 1) * nbPieces / xMax;
                        int a0 = i * nbPieces / xMax;
                        if (a1 == a0) {
                            ++a1;
                        }
                        if (a1 > nbPieces) {
                            a1 = nbPieces;
                        }
                        int max = 0;
                        int min = available[a0];
                        int Pi = 1000;
                        for (int j = a0; j < a1; ++j) {
                            if (available[j] > max) {
                                max = available[j];
                            }
                            if (available[j] < min) {
                                min = available[j];
                            }
                            Pi *= available[j];
                            Pi /= available[j] + 1;
                        }
                        int pond = Pi;
                        if (max == 0) {
                            pond = 0;
                        } else {
                            int PiM = 1000;
                            for (int j = a0; j < a1; ++j) {
                                PiM *= max + 1;
                                PiM /= max;
                            }
                            pond *= PiM;
                            pond /= 1000;
                            pond *= max - min;
                            pond /= 1000;
                            pond += min;
                        }
                        if (pond <= 0 || allMax == 0) {
                            index = 0;
                        } else {
                            index = (pond - allMin) * 8 / maxAboveMin + 1;
                            if (index > 9) {
                                index = 9;
                            }
                        }
                        gcImage.setBackground(Colors.blues[index]);
                        gcImage.fillRectangle(i + 1, 1, 1, yMax);
                    }
                }
            }
            if (this.availabilityPercent != null) {
                if (!this.availabilityPercent.isDisposed()) break block45;
            }
            Object var24_29 = null;
            gcImage.dispose();
            gc.dispose();
        }
        Object var26_6 = null;
        this.this_mon.exit();
        {
            block45: {
                return;
            }
            try {
                this.availabilityPercent.setText(allMin + "." + sTotal);
                gc.drawImage(this.aImage, bounds.x, bounds.y);
                Object var24_30 = null;
            }
            catch (Throwable throwable) {
                Object var24_31 = null;
                gcImage.dispose();
                gc.dispose();
                throw throwable;
            }
            gcImage.dispose();
            gc.dispose();
            {
            }
        }
        Object var26_7 = null;
        this.this_mon.exit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePiecesInfo(boolean bForce) {
        block32: {
            Rectangle bounds;
            block34: {
                int yMax;
                int xMax;
                block33: {
                    block31: {
                        if (this.manager == null) {
                            return;
                        }
                        try {
                            block36: {
                                block35: {
                                    this.this_mon.enter();
                                    if (this.display == null) break block35;
                                    if (!this.display.isDisposed()) break block36;
                                }
                                Object var20_2 = null;
                                this.this_mon.exit();
                                return;
                            }
                            if (this.piecesImage == null) break block31;
                            if (!this.piecesImage.isDisposed()) break block37;
                        }
                        catch (Throwable throwable) {
                            Object var20_7 = null;
                            this.this_mon.exit();
                            throw throwable;
                        }
                    }
                    Object var20_3 = null;
                    this.this_mon.exit();
                    {
                        block37: {
                            return;
                        }
                        DiskManager dm = this.manager.getDiskManager();
                        boolean valid = !bForce;
                        boolean[] new_pieces = new boolean[this.manager.getNbPieces()];
                        if (dm != null) {
                            DiskManagerPiece[] dm_pieces = dm.getPieces();
                            for (int i = 0; i < this.pieces.length; ++i) {
                                new_pieces[i] = dm_pieces[i].isDone();
                            }
                        }
                        if (this.pieces == null) {
                            valid = false;
                        } else {
                            for (int i = 0; i < this.pieces.length; ++i) {
                                if (this.pieces[i] == new_pieces[i]) continue;
                                valid = false;
                                break;
                            }
                        }
                        this.pieces = new_pieces;
                        if (valid) break block32;
                        bounds = this.piecesImage.getClientArea();
                        xMax = bounds.width - 2;
                        yMax = bounds.height - 2 - 6;
                        if (xMax < 10) break block33;
                        if (yMax >= 5) break block38;
                    }
                }
                Object var20_4 = null;
                this.this_mon.exit();
                {
                    block38: {
                        return;
                    }
                    int total = this.manager.getStats().getDownloadCompleted(true);
                    if (this.pImage != null && !this.pImage.isDisposed()) {
                        this.pImage.dispose();
                    }
                    this.pImage = new Image((Device)this.display, bounds.width, bounds.height);
                    GC gcImage = new GC((Drawable)this.pImage);
                    try {
                        gcImage.setForeground(Colors.grey);
                        gcImage.drawRectangle(0, 0, bounds.width - 1, bounds.height - 1);
                        gcImage.drawLine(1, 6, xMax, 6);
                        if (this.pieces != null && this.pieces.length != 0) {
                            int nbPieces = this.pieces.length;
                            for (int i = 0; i < xMax; ++i) {
                                int a1 = (i + 1) * nbPieces / xMax;
                                int a0 = i * nbPieces / xMax;
                                if (a1 == a0) {
                                    ++a1;
                                }
                                if (a1 > nbPieces) {
                                    a1 = nbPieces;
                                }
                                int nbAvailable = 0;
                                for (int j = a0; j < a1; ++j) {
                                    if (this.pieces[j]) {
                                        ++nbAvailable;
                                    }
                                    int index = nbAvailable * 9 / (a1 - a0);
                                    gcImage.setBackground(Colors.blues[index]);
                                    gcImage.fillRectangle(i + 1, 7, 1, yMax);
                                }
                            }
                        }
                        int limit = xMax * total / 1000;
                        gcImage.setBackground(Colors.colorProgressBar);
                        gcImage.fillRectangle(1, 1, limit, 5);
                        if (limit < xMax) {
                            gcImage.setBackground(Colors.blues[0]);
                            gcImage.fillRectangle(limit + 1, 1, xMax - limit, 5);
                        }
                        Object var18_25 = null;
                    }
                    catch (Throwable throwable) {
                        Object var18_26 = null;
                        gcImage.dispose();
                        throw throwable;
                    }
                    gcImage.dispose();
                    if (this.piecesPercent != null && !this.piecesPercent.isDisposed()) {
                        this.piecesPercent.setText(DisplayFormatters.formatPercentFromThousands(total));
                    }
                    if (this.pImage == null) break block34;
                    if (!this.pImage.isDisposed()) break block39;
                }
            }
            Object var20_5 = null;
            this.this_mon.exit();
            {
                block39: {
                    return;
                }
                GC gc = new GC((Drawable)this.piecesImage);
                gc.drawImage(this.pImage, bounds.x, bounds.y);
                gc.dispose();
            }
        }
        Object var20_6 = null;
        this.this_mon.exit();
    }

    private void setTime(String elapsed, String remaining) {
        this.timeElapsed.setText(elapsed);
        this.timeRemaining.setText(remaining);
    }

    private void setStats(String dl, String ul, String dls, String uls, String ts, String dl_speed, String ul_speed, String s, String p, String completed, String hash_fails, String share_ratio, String ave_comp, String distr_copies) {
        if (this.display == null || this.display.isDisposed()) {
            return;
        }
        this.download.setText(dl);
        this.downloadSpeed.setText(dls);
        this.upload.setText(ul);
        this.uploadSpeed.setText(uls);
        this.totalSpeed.setText(ts);
        this.ave_completion.setText(ave_comp);
        this.distributedCopies.setText(distr_copies);
        this.seeds.setText(s);
        this.peers.setText(p);
        this.completedLbl.setText(completed);
        this.hashFails.setText(hash_fails);
        this.shareRatio.setText(share_ratio);
    }

    private void setInfos(final String _fileName, final String _fileSize, final String _torrentStatus, final String _path, final String _hash, final String _pieceData, final String _pieceLength, final String _comment, final String _creation_date, final String _user_comment, final String isPrivate) {
        if (this.display == null || this.display.isDisposed()) {
            return;
        }
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                GeneralView.this.fileName.setText(_fileName);
                GeneralView.this.fileSize.setText(_fileSize);
                GeneralView.this.torrentStatus.setText(_torrentStatus);
                int pos = _torrentStatus.indexOf("http://");
                if (pos > 0) {
                    GeneralView.this.torrentStatus.setLink(UrlUtils.getURL(_torrentStatus));
                } else {
                    GeneralView.this.torrentStatus.setLink(null);
                }
                GeneralView.this.saveIn.setText(_path);
                GeneralView.this.hash.setText(_hash);
                GeneralView.this.pieceNumber.setText(_pieceData);
                GeneralView.this.pieceSize.setText(_pieceLength);
                GeneralView.this.creation_date.setText(_creation_date);
                GeneralView.this.privateStatus.setText(isPrivate);
                boolean do_relayout = false;
                do_relayout = GeneralView.setCommentAndFormatLinks(GeneralView.this.lblComment, _comment.length() > 5000 && Constants.isWindowsXP ? _comment.substring(0, 5000) : _comment) | do_relayout;
                do_relayout = GeneralView.setCommentAndFormatLinks(GeneralView.this.user_comment, _user_comment) | do_relayout;
                if (do_relayout) {
                    GeneralView.this.gInfo.layout();
                }
            }
        });
    }

    private static boolean setCommentAndFormatLinks(Control c, String new_comment) {
        String old_comment = (String)c.getData("comment");
        if (new_comment == null) {
            new_comment = "";
        }
        if (new_comment.equals(old_comment)) {
            return false;
        }
        c.setData("comment", (Object)new_comment);
        if (c instanceof Label) {
            ((Label)c).setText(new_comment);
        } else if (c instanceof Link) {
            String sNewComment = new_comment.replaceAll("([^=\">][\\s]+|^)(http://[\\S]+)", "$1<A HREF=\"$2\">$2</A>");
            sNewComment = sNewComment.replaceAll("(href=)(htt[^\\s>]+)", "$1\"$2\"");
            ((Link)c).setText(sNewComment);
        }
        return true;
    }

    @Override
    public void parameterChanged(String parameterName) {
        this.graphicsUpdate = COConfigurationManager.getIntParameter("Graphics Update");
    }

    private Image obfusticatedImage(Image image) {
        UIDebugGenerator.obfusticateArea(image, (Control)this.fileName.getWidget(), this.manager.toString());
        UIDebugGenerator.obfusticateArea(image, (Control)this.saveIn.getWidget(), Debug.secretFileName(this.saveIn.getText()));
        return image;
    }

    @Override
    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 0: {
                this.swtView = event2.getView();
                this.swtView.setTitle(this.getFullTitle());
                this.swtView.setToolBarListener(this);
                break;
            }
            case 7: {
                this.delete();
                break;
            }
            case 2: {
                this.initialize((Composite)event2.getData());
                break;
            }
            case 6: {
                Messages.updateLanguageForControl((Widget)this.getComposite());
                this.swtView.setTitle(this.getFullTitle());
                break;
            }
            case 1: {
                this.dataSourceChanged(event2.getData());
                break;
            }
            case 3: {
                String id = "DMDetails_General";
                if (this.manager != null) {
                    id = this.manager.getTorrent() != null ? id + "." + this.manager.getInternalName() : id + ":" + this.manager.getSize();
                }
                SelectedContentManager.changeCurrentlySelectedContent(id, new SelectedContent[]{new SelectedContent(this.manager)});
                break;
            }
            case 5: {
                this.refresh();
                break;
            }
            case 9: {
                Object data = event2.getData();
                if (!(data instanceof Map)) break;
                this.obfusticatedImage((Image)MapUtils.getMapObject((Map)data, "image", null, Image.class));
                ((Map)data).put("obfuscateSideBar", true);
            }
        }
        return true;
    }

    @Override
    public boolean toolBarItemActivated(ToolBarItem item, long activationType, Object datasource) {
        return ViewUtils.toolBarItemActivated(this.manager, item, activationType, datasource);
    }

    @Override
    public void refreshToolBarItems(Map<String, Long> list) {
        ViewUtils.refreshToolBarItems(this.manager, list);
    }
}

