/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views;

import com.aelitis.azureus.core.networkmanager.admin.NetworkAdmin;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.common.ToolBarItem;
import com.aelitis.azureus.ui.mdi.MdiEntry;
import com.aelitis.azureus.ui.selectedcontent.SelectedContent;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentManager;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerPeerListener;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.peer.PEPeerStats;
import org.gudy.azureus2.core3.peer.impl.PEPeerTransport;
import org.gudy.azureus2.core3.peer.util.PeerUtils;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.plugins.ui.UIPluginViewToolBarListener;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.components.graphics.PieUtils;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.plugins.UISWTView;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEvent;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEventListener;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewCore;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewCoreEventListener;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewEventListenerHolder;
import org.gudy.azureus2.ui.swt.views.PeersView;
import org.gudy.azureus2.ui.swt.views.ViewUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PeersGraphicView
implements DownloadManagerPeerListener,
UISWTViewCoreEventListener,
UIPluginViewToolBarListener {
    public static String MSGID_PREFIX = "PeersGraphicView";
    private DownloadManager manager = null;
    private static final int NB_ANGLES = 1000;
    private double[] angles;
    private double perimeter;
    private double[] rs;
    private double[] deltaXXs;
    private double[] deltaXYs;
    private double[] deltaYXs;
    private double[] deltaYYs;
    private Point oldSize;
    private List<PEPeer> peers;
    private AEMonitor peers_mon = new AEMonitor("PeersGraphicView:peers");
    private PeerComparator peerComparator;
    private Map<PEPeer, int[]> peer_hit_map = new HashMap<PEPeer, int[]>();
    private int me_hit_x;
    private int me_hit_y;
    private Image my_flag;
    private Display display;
    private Composite panel;
    private UISWTView swtView;
    private static final int PEER_SIZE = 18;
    private static final int OWN_SIZE_DEFAULT = 75;
    private static final int OWN_SIZE_MIN = 30;
    private static final int OWN_SIZE_MAX = 75;
    private static int OWN_SIZE = 75;
    private boolean comp_focused;
    private Object focus_pending_ds;

    public PeersGraphicView() {
        this.angles = new double[1000];
        this.rs = new double[1000];
        this.deltaXXs = new double[1000];
        this.deltaXYs = new double[1000];
        this.deltaYXs = new double[1000];
        this.deltaYYs = new double[1000];
        for (int i = 0; i < 1000; ++i) {
            this.angles[i] = (double)(2 * i) * Math.PI / 1000.0 - Math.PI;
            this.deltaXXs[i] = Math.cos(this.angles[i]);
            this.deltaXYs[i] = Math.sin(this.angles[i]);
            this.deltaYXs[i] = Math.cos(this.angles[i] + 1.5707963267948966);
            this.deltaYYs[i] = Math.sin(this.angles[i] + 1.5707963267948966);
        }
        this.peers = new ArrayList<PEPeer>();
        this.peerComparator = new PeerComparator();
    }

    private void setFocused(boolean foc) {
        if (foc) {
            this.comp_focused = true;
            this.dataSourceChanged(this.focus_pending_ds);
        } else {
            this.focus_pending_ds = this.manager;
            this.dataSourceChanged(null);
            this.comp_focused = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void dataSourceChanged(Object newDataSource) {
        InetAddress ia;
        if (!this.comp_focused) {
            this.focus_pending_ds = newDataSource;
            return;
        }
        if (this.my_flag == null && (ia = NetworkAdmin.getSingleton().getDefaultPublicAddress()) != null) {
            this.my_flag = ImageRepository.getCountryFlag(ia, false);
        }
        DownloadManager old_manager = this.manager;
        if (newDataSource == null) {
            this.manager = null;
        } else if (newDataSource instanceof Object[]) {
            Object temp = ((Object[])newDataSource)[0];
            if (temp instanceof DownloadManager) {
                this.manager = (DownloadManager)temp;
            } else {
                if (!(temp instanceof DiskManagerFileInfo)) return;
                this.manager = ((DiskManagerFileInfo)temp).getDownloadManager();
            }
        } else if (newDataSource instanceof DownloadManager) {
            this.manager = (DownloadManager)newDataSource;
        } else {
            if (!(newDataSource instanceof DiskManagerFileInfo)) return;
            this.manager = ((DiskManagerFileInfo)newDataSource).getDownloadManager();
        }
        if (old_manager == this.manager) {
            return;
        }
        if (old_manager != null) {
            old_manager.removePeerListener(this);
        }
        try {
            this.peers_mon.enter();
            this.peers.clear();
            Object var5_4 = null;
            this.peers_mon.exit();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.peers_mon.exit();
            throw throwable;
        }
        if (this.manager == null) return;
        this.manager.addPeerListener(this);
    }

    private void delete() {
        if (this.manager != null) {
            this.manager.removePeerListener(this);
        }
        this.peer_hit_map.clear();
    }

    private Composite getComposite() {
        return this.panel;
    }

    private String getData() {
        return "PeersGraphicView.title.full";
    }

    private void initialize(Composite composite) {
        this.display = composite.getDisplay();
        this.panel = new Canvas(composite, 262144);
        this.panel.addListener(32, new Listener(){

            public void handleEvent(Event event2) {
                String tt;
                if (PeersGraphicView.this.manager == null) {
                    return;
                }
                int x = event2.x;
                int y = event2.y;
                if (x >= PeersGraphicView.this.me_hit_x && x <= PeersGraphicView.this.me_hit_x + OWN_SIZE && y >= PeersGraphicView.this.me_hit_y && y <= PeersGraphicView.this.me_hit_y + OWN_SIZE) {
                    tt = DisplayFormatters.formatDownloadStatus(PeersGraphicView.this.manager) + ", " + DisplayFormatters.formatPercentFromThousands(PeersGraphicView.this.manager.getStats().getCompleted());
                } else {
                    PEPeer target = null;
                    for (Map.Entry entry : PeersGraphicView.this.peer_hit_map.entrySet()) {
                        int[] loc = (int[])entry.getValue();
                        int loc_x = loc[0];
                        int loc_y = loc[1];
                        if (x < loc_x || x > loc_x + 18 || y < loc_y || y > loc_y + 18) continue;
                        target = (PEPeer)entry.getKey();
                        break;
                    }
                    if (target == null) {
                        tt = null;
                    } else {
                        PEPeerStats stats2 = target.getStats();
                        String[] details = PeerUtils.getCountryDetails(target);
                        String dstr = details == null || details.length < 2 ? "" : " - " + details[0] + "/" + details[1];
                        tt = target.getIp() + dstr + ", " + DisplayFormatters.formatPercentFromThousands(target.getPercentDoneInThousandNotation()) + "\r\n" + "Up=" + DisplayFormatters.formatByteCountToKiBEtcPerSec(stats2.getDataSendRate() + stats2.getProtocolSendRate()) + ", " + "Down=" + DisplayFormatters.formatByteCountToKiBEtcPerSec(stats2.getDataReceiveRate() + stats2.getProtocolReceiveRate());
                    }
                }
                PeersGraphicView.this.panel.setToolTipText(tt);
            }
        });
        this.panel.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event2) {
                int x = event2.x;
                int y = event2.y;
                for (Map.Entry entry : PeersGraphicView.this.peer_hit_map.entrySet()) {
                    int[] loc = (int[])entry.getValue();
                    int loc_x = loc[0];
                    int loc_y = loc[1];
                    if (x < loc_x || x > loc_x + 18 || y < loc_y || y > loc_y + 18) continue;
                    PEPeer target = (PEPeer)entry.getKey();
                    try {
                        String dm_id = "DMDetails_" + Base32.encode(PeersGraphicView.this.manager.getTorrent().getHash());
                        MdiEntry mdi_entry = UIFunctionsManager.getUIFunctions().getMDI().getEntry(dm_id);
                        if (mdi_entry != null) {
                            mdi_entry.setDatasource(new Object[]{PeersGraphicView.this.manager, target});
                        }
                        for (Composite comp2 = PeersGraphicView.this.panel.getParent(); comp2 != null; comp2 = comp2.getParent()) {
                            CTabItem[] items;
                            if (!(comp2 instanceof CTabFolder)) continue;
                            CTabFolder tf = (CTabFolder)comp2;
                            for (CTabItem item : items = tf.getItems()) {
                                UISWTViewCore view = (UISWTViewCore)item.getData("IView");
                                UISWTViewEventListener listener = view.getEventListener();
                                if (listener instanceof UISWTViewEventListenerHolder) {
                                    listener = ((UISWTViewEventListenerHolder)listener).getDelegatedEventListener(view);
                                }
                                if (!(listener instanceof PeersView)) continue;
                                tf.setSelection(item);
                                Event ev = new Event();
                                ev.item = item;
                                tf.notifyListeners(13, ev);
                                ((PeersView)listener).selectPeer(target);
                                return;
                            }
                        }
                        break;
                    }
                    catch (Throwable e) {
                        break;
                    }
                }
            }
        });
    }

    private void refresh() {
        this.doRefresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRefresh() {
        PEPeer[] sortedPeers;
        try {
            this.peers_mon.enter();
            ArrayList<PEPeerTransport> connectedPeers = new ArrayList<PEPeerTransport>();
            for (PEPeer peer : this.peers) {
                PEPeerTransport peerTransport;
                if (!(peer instanceof PEPeerTransport) || (peerTransport = (PEPeerTransport)peer).getConnectionState() != 4) continue;
                connectedPeers.add(peerTransport);
            }
            sortedPeers = connectedPeers.toArray(new PEPeer[connectedPeers.size()]);
            Object var7_8 = null;
            this.peers_mon.exit();
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.peers_mon.exit();
            throw throwable;
        }
        if (sortedPeers == null) {
            return;
        }
        for (int i = 0; i < 3; ++i) {
            try {
                Arrays.sort(sortedPeers, this.peerComparator);
                break;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                continue;
            }
        }
        this.render(sortedPeers);
    }

    private void render(PEPeer[] sortedPeers) {
        this.peer_hit_map.clear();
        if (this.panel == null || this.panel.isDisposed()) {
            return;
        }
        if (this.manager == null) {
            GC gcPanel = new GC((Drawable)this.panel);
            gcPanel.fillRectangle(this.panel.getBounds());
            gcPanel.dispose();
            return;
        }
        Point panelSize = this.panel.getSize();
        int min_dim = Math.min(panelSize.x, panelSize.y);
        if (min_dim <= 100) {
            OWN_SIZE = 30;
        } else if (min_dim >= 400) {
            OWN_SIZE = 75;
        } else {
            int s_diff = 45;
            float rat = ((float)min_dim - 100.0f) / 300.0f;
            OWN_SIZE = 30 + (int)((float)s_diff * rat);
        }
        int x0 = panelSize.x / 2;
        int y0 = panelSize.y / 2;
        int a = x0 - 20;
        int b = y0 - 20;
        if (a < 10 || b < 10) {
            return;
        }
        if (this.oldSize == null || !this.oldSize.equals((Object)panelSize)) {
            this.oldSize = panelSize;
            this.perimeter = 0.0;
            for (int i = 0; i < 1000; ++i) {
                this.rs[i] = Math.sqrt(1.0 / (this.deltaYXs[i] * this.deltaYXs[i] / (double)(a * a) + this.deltaYYs[i] * this.deltaYYs[i] / (double)(b * b)));
                this.perimeter += this.rs[i];
            }
        }
        Image buffer = new Image((Device)this.display, panelSize.x, panelSize.y);
        GC gcBuffer = new GC((Drawable)buffer);
        gcBuffer.setBackground(Colors.white);
        gcBuffer.setForeground(Colors.blue);
        gcBuffer.fillRectangle(0, 0, panelSize.x, panelSize.y);
        try {
            gcBuffer.setTextAntialias(1);
            gcBuffer.setAntialias(1);
        }
        catch (Exception e) {
            // empty catch block
        }
        gcBuffer.setBackground(Colors.blues[2]);
        int nbPeers = sortedPeers.length;
        int iAngle = 0;
        double currentPerimeter = 0.0;
        for (int i = 0; i < nbPeers; ++i) {
            int y1;
            int x1;
            double r;
            PEPeer peer = sortedPeers[i];
            do {
                r = this.rs[iAngle];
                currentPerimeter += r;
                if (iAngle + 1 >= 1000) continue;
                ++iAngle;
            } while (currentPerimeter < (double)i * this.perimeter / (double)nbPeers);
            int[] triangle = new int[6];
            int percent_received = peer.getPercentDoneOfCurrentIncomingRequest();
            int percent_sent = peer.getPercentDoneOfCurrentOutgoingRequest();
            boolean drawLine = false;
            if (!peer.isChokingMe() || percent_received >= 0) {
                gcBuffer.setForeground(Colors.blues[1]);
                drawLine = true;
            }
            if (!peer.isChokedByMe() || percent_sent >= 0) {
                gcBuffer.setForeground(Colors.blues[3]);
                drawLine = true;
            }
            if (!peer.isChokingMe() && peer.isUnchokeOverride() && peer.isInteresting()) {
                gcBuffer.setForeground(Colors.green);
                drawLine = true;
            }
            if (peer.isChokedByMe() && percent_sent >= 0) {
                gcBuffer.setForeground(Colors.green);
                drawLine = true;
            }
            if (drawLine) {
                x1 = x0 + (int)(r * this.deltaYXs[iAngle]);
                y1 = y0 + (int)(r * this.deltaYYs[iAngle]);
                gcBuffer.drawLine(x0, y0, x1, y1);
            }
            if (percent_received >= 0) {
                gcBuffer.setBackground(Colors.blues[7]);
                double r1 = r - r * (double)percent_received / 100.0;
                triangle[0] = (int)((double)x0 + (r1 - 10.0) * this.deltaYXs[iAngle] + 0.5);
                triangle[1] = (int)((double)y0 + (r1 - 10.0) * this.deltaYYs[iAngle] + 0.5);
                triangle[2] = (int)((double)x0 + this.deltaXXs[iAngle] * 4.0 + r1 * this.deltaYXs[iAngle] + 0.5);
                triangle[3] = (int)((double)y0 + this.deltaXYs[iAngle] * 4.0 + r1 * this.deltaYYs[iAngle] + 0.5);
                triangle[4] = (int)((double)x0 - this.deltaXXs[iAngle] * 4.0 + r1 * this.deltaYXs[iAngle] + 0.5);
                triangle[5] = (int)((double)y0 - this.deltaXYs[iAngle] * 4.0 + r1 * this.deltaYYs[iAngle] + 0.5);
                gcBuffer.fillPolygon(triangle);
            }
            if (percent_sent >= 0) {
                gcBuffer.setBackground(Colors.blues[2]);
                double r1 = r * (double)percent_sent / 100.0;
                triangle[0] = (int)((double)x0 + r1 * this.deltaYXs[iAngle] + 0.5);
                triangle[1] = (int)((double)y0 + r1 * this.deltaYYs[iAngle] + 0.5);
                triangle[2] = (int)((double)x0 + this.deltaXXs[iAngle] * 4.0 + (r1 - 10.0) * this.deltaYXs[iAngle] + 0.5);
                triangle[3] = (int)((double)y0 + this.deltaXYs[iAngle] * 4.0 + (r1 - 10.0) * this.deltaYYs[iAngle] + 0.5);
                triangle[4] = (int)((double)x0 - this.deltaXXs[iAngle] * 4.0 + (r1 - 10.0) * this.deltaYXs[iAngle] + 0.5);
                triangle[5] = (int)((double)y0 - this.deltaXYs[iAngle] * 4.0 + (r1 - 10.0) * this.deltaYYs[iAngle] + 0.5);
                gcBuffer.fillPolygon(triangle);
            }
            x1 = x0 + (int)(r * this.deltaYXs[iAngle]);
            y1 = y0 + (int)(r * this.deltaYYs[iAngle]);
            gcBuffer.setBackground(Colors.blues[7]);
            if (peer.isSnubbed()) {
                gcBuffer.setBackground(Colors.grey);
            }
            int peer_x = x1 - 9;
            int peer_y = y1 - 9;
            this.peer_hit_map.put(peer, new int[]{peer_x, peer_y});
            Image flag = ImageRepository.getCountryFlag(peer, false);
            if (flag != null) {
                PieUtils.drawPie(gcBuffer, flag, peer_x, peer_y, 18, 18, peer.getPercentDoneInThousandNotation() / 10, true);
                continue;
            }
            PieUtils.drawPie(gcBuffer, peer_x, peer_y, 18, 18, peer.getPercentDoneInThousandNotation() / 10);
        }
        gcBuffer.setBackground(Colors.blues[7]);
        this.me_hit_x = x0 - OWN_SIZE / 2;
        this.me_hit_y = y0 - OWN_SIZE / 2;
        PieUtils.drawPie(gcBuffer, this.me_hit_x, this.me_hit_y, OWN_SIZE, OWN_SIZE, this.manager.getStats().getCompleted() / 10);
        if (this.my_flag != null) {
            PieUtils.drawPie(gcBuffer, this.my_flag, this.me_hit_x, this.me_hit_y, OWN_SIZE, OWN_SIZE, this.manager.getStats().getCompleted() / 10, false);
        }
        gcBuffer.dispose();
        GC gcPanel = new GC((Drawable)this.panel);
        gcPanel.drawImage(buffer, 0, 0);
        gcPanel.dispose();
        buffer.dispose();
    }

    @Override
    public void peerManagerWillBeAdded(PEPeerManager peer_manager) {
    }

    @Override
    public void peerManagerAdded(PEPeerManager manager) {
    }

    @Override
    public void peerManagerRemoved(PEPeerManager manager) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void peerAdded(PEPeer peer) {
        try {
            this.peers_mon.enter();
            this.peers.add(peer);
            Object var3_2 = null;
            this.peers_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.peers_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void peerRemoved(PEPeer peer) {
        try {
            this.peers_mon.enter();
            this.peers.remove(peer);
            Object var3_2 = null;
            this.peers_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.peers_mon.exit();
            throw throwable;
        }
    }

    @Override
    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 0: {
                this.swtView = event2.getView();
                this.swtView.setTitle(MessageText.getString(this.getData()));
                this.swtView.setToolBarListener(this);
                break;
            }
            case 7: {
                this.delete();
                break;
            }
            case 2: {
                this.initialize((Composite)event2.getData());
                break;
            }
            case 6: {
                Messages.updateLanguageForControl((Widget)this.getComposite());
                this.swtView.setTitle(MessageText.getString(this.getData()));
                break;
            }
            case 1: {
                this.dataSourceChanged(event2.getData());
                break;
            }
            case 3: {
                String id = "DMDetails_Swarm";
                this.setFocused(true);
                if (this.manager != null) {
                    id = this.manager.getTorrent() != null ? id + "." + this.manager.getInternalName() : id + ":" + this.manager.getSize();
                }
                SelectedContentManager.changeCurrentlySelectedContent(id, new SelectedContent[]{new SelectedContent(this.manager)});
                break;
            }
            case 4: {
                this.setFocused(false);
                break;
            }
            case 5: {
                this.refresh();
            }
        }
        return true;
    }

    @Override
    public boolean toolBarItemActivated(ToolBarItem item, long activationType, Object datasource) {
        return ViewUtils.toolBarItemActivated(this.manager, item, activationType, datasource);
    }

    @Override
    public void refreshToolBarItems(Map<String, Long> list) {
        ViewUtils.refreshToolBarItems(this.manager, list);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class PeerComparator
    implements Comparator<PEPeer> {
        PeerComparator() {
        }

        @Override
        public int compare(PEPeer peer0, PEPeer peer1) {
            int percent1;
            int percent0 = peer0.getPercentDoneInThousandNotation();
            int result = percent0 - (percent1 = peer1.getPercentDoneInThousandNotation());
            if (result == 0) {
                long l = peer0.getTimeSinceConnectionEstablished() - peer1.getTimeSinceConnectionEstablished();
                if (l < 0L) {
                    result = -1;
                } else if (l > 0L) {
                    result = 1;
                }
            }
            return result;
        }
    }
}

