/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.common.table.TableLifeCycleListener;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerPeerListener;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerListener;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.plugins.peers.Peer;
import org.gudy.azureus2.ui.swt.plugins.UISWTInstance;
import org.gudy.azureus2.ui.swt.views.LoggerView;
import org.gudy.azureus2.ui.swt.views.PeersView;
import org.gudy.azureus2.ui.swt.views.peer.PeerInfoView;
import org.gudy.azureus2.ui.swt.views.peer.RemotePieceDistributionView;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWT;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWTMenuFillListener;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewFactory;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewTab;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.DownloadNameItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PeersSuperView
extends TableViewTab<PEPeer>
implements GlobalManagerListener,
DownloadManagerPeerListener,
TableLifeCycleListener,
TableViewSWTMenuFillListener {
    public static final String VIEW_ID = "AllPeersView";
    private TableViewSWT<PEPeer> tv;
    private Shell shell;
    private boolean active_listener = true;
    protected static boolean registeredCoreSubViews = false;

    public PeersSuperView() {
        super(VIEW_ID);
    }

    @Override
    public TableViewSWT<PEPeer> initYourTableView() {
        UISWTInstance pluginUI;
        TableColumnCore[] items = PeersView.getBasicColumnItems("AllPeers");
        TableColumnCore[] basicItems = new TableColumnCore[items.length + 1];
        System.arraycopy(items, 0, basicItems, 0, items.length);
        basicItems[items.length] = new DownloadNameItem("AllPeers");
        this.tv = TableViewFactory.createTableViewSWT(Peer.class, "AllPeers", this.getPropertiesPrefix(), basicItems, "connected_time", 0x10010002);
        this.tv.setRowDefaultHeight(16);
        this.tv.setEnableTabViews(true, true, null);
        UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
        if (uiFunctions != null && (pluginUI = uiFunctions.getUISWTInstance()) != null && !registeredCoreSubViews) {
            pluginUI.addView("AllPeers", "PeerInfoView", PeerInfoView.class, null);
            pluginUI.addView("AllPeers", "RemotePieceDistributionView", RemotePieceDistributionView.class, null);
            pluginUI.addView("AllPeers", "LoggerView", LoggerView.class, true);
            registeredCoreSubViews = true;
        }
        this.tv.addLifeCycleListener(this);
        this.tv.addMenuFillListener(this);
        return this.tv;
    }

    @Override
    public void tableViewInitialized() {
        this.shell = this.tv.getComposite().getShell();
        AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

            public void azureusCoreRunning(AzureusCore core) {
                PeersSuperView.this.registerGlobalManagerListener(core);
            }
        });
    }

    @Override
    public void tableViewDestroyed() {
        this.unregisterListeners();
    }

    @Override
    public void fillMenu(String sColumnName, Menu menu) {
        PeersView.fillMenu(menu, this.tv, this.shell, null);
    }

    @Override
    public void peerAdded(PEPeer created) {
        this.tv.addDataSource(created);
    }

    @Override
    public void peerRemoved(PEPeer removed) {
        this.tv.removeDataSource(removed);
    }

    private void addExistingDatasources(AzureusCore core) {
        if (this.tv.isDisposed()) {
            return;
        }
        ArrayList<PEPeer> sources = new ArrayList<PEPeer>();
        Iterator<DownloadManager> itr = core.getGlobalManager().getDownloadManagers().iterator();
        while (itr.hasNext()) {
            PEPeer[] peers = itr.next().getCurrentPeers();
            if (peers == null) continue;
            sources.addAll(Arrays.asList(peers));
        }
        if (sources.isEmpty()) {
            return;
        }
        this.tv.addDataSources((PEPeer[])sources.toArray(new PEPeer[sources.size()]));
        this.tv.processDataSourceQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerGlobalManagerListener(AzureusCore core) {
        this.active_listener = false;
        try {
            core.getGlobalManager().addListener(this);
            Object var3_2 = null;
            this.active_listener = true;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.active_listener = true;
            throw throwable;
        }
        this.addExistingDatasources(core);
    }

    private void unregisterListeners() {
        try {
            GlobalManager gm = AzureusCoreFactory.getSingleton().getGlobalManager();
            gm.removeListener(this);
            for (DownloadManager dm : gm.getDownloadManagers()) {
                this.downloadManagerRemoved(dm);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void downloadManagerAdded(DownloadManager dm) {
        dm.addPeerListener(this, !this.active_listener);
    }

    @Override
    public void downloadManagerRemoved(DownloadManager dm) {
        dm.removePeerListener(this);
    }

    @Override
    public void destroyInitiated() {
    }

    @Override
    public void destroyed() {
    }

    @Override
    public void seedingStatusChanged(boolean seeding_only_mode, boolean b) {
    }

    @Override
    public void addThisColumnSubMenu(String columnName, Menu menuThisColumn) {
    }

    @Override
    public void peerManagerAdded(PEPeerManager manager) {
    }

    @Override
    public void peerManagerRemoved(PEPeerManager manager) {
    }

    @Override
    public void peerManagerWillBeAdded(PEPeerManager manager) {
    }
}

