/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.util.IdentityHashSet;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.common.ToolBarItem;
import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.common.table.TableDataSourceChangedListener;
import com.aelitis.azureus.ui.common.table.TableLifeCycleListener;
import com.aelitis.azureus.ui.common.table.TableRowCore;
import com.aelitis.azureus.ui.common.table.TableView;
import com.aelitis.azureus.ui.common.table.impl.TableColumnManager;
import com.aelitis.azureus.ui.selectedcontent.SelectedContent;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentManager;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerPeerListener;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.ipfilter.IpFilterManagerFactory;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.plugins.peers.Peer;
import org.gudy.azureus2.plugins.ui.UIInputReceiver;
import org.gudy.azureus2.plugins.ui.UIInputReceiverListener;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.SimpleTextEntryWindow;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.plugins.UISWTInstance;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEvent;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewEventImpl;
import org.gudy.azureus2.ui.swt.views.LoggerView;
import org.gudy.azureus2.ui.swt.views.ViewUtils;
import org.gudy.azureus2.ui.swt.views.peer.PeerFilesView;
import org.gudy.azureus2.ui.swt.views.peer.PeerInfoView;
import org.gudy.azureus2.ui.swt.views.peer.RemotePieceDistributionView;
import org.gudy.azureus2.ui.swt.views.table.TableSelectedRowsListener;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWT;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWTMenuFillListener;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewFactory;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewTab;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.ASItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.ChokedItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.ChokingItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.ClientIdentificationItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.ClientItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.ConnectedTimeItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.DLedFromOthersItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.DiscardedItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.DownItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.DownSpeedItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.DownSpeedLimitItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.EncryptionItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.GainItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.HandshakeReservedBytesItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.HostNameItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.IncomingRequestCountItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.IndexItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.InterestedItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.InterestingItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.IpItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.LANItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.MessagingItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.NoUploadItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.OptimisticUnchokeItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.OutgoingRequestCountItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.PeerByteIDItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.PeerIDItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.PeerSourceItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.PercentItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.PieceItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.PiecesItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.PortItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.ProtocolItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.SnubbedItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.StatUpItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.StateItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.TimeToSendPieceItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.TimeUntilCompleteItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.TotalDownSpeedItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.TypeItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.UniquePieceItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.UpDownRatioItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.UpItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.UpRatioItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.UpSpeedItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.UpSpeedLimitItem;
import shu.utils.ShuUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PeersView
extends TableViewTab<PEPeer>
implements DownloadManagerPeerListener,
TableDataSourceChangedListener,
TableLifeCycleListener,
TableViewSWTMenuFillListener {
    private static final TableColumnCore[] basicItems = PeersView.getBasicColumnItems("Peers");
    public static final String MSGID_PREFIX = "PeersView";
    private DownloadManager manager;
    private TableViewSWT<PEPeer> tv;
    private Shell shell;
    private boolean enable_tabs = true;
    private static boolean registeredCoreSubViews;
    private boolean comp_focused;
    private Object focus_pending_ds;
    private PEPeer select_peer_pending;

    static TableColumnCore[] getBasicColumnItems(String table_id) {
        return new TableColumnCore[]{new IpItem(table_id), new ClientItem(table_id), new TypeItem(table_id), new MessagingItem(table_id), new EncryptionItem(table_id), new ProtocolItem(table_id), new PiecesItem(table_id), new PercentItem(table_id), new DownSpeedItem(table_id), new UpSpeedItem(table_id), new PeerSourceItem(table_id), new HostNameItem(table_id), new PortItem(table_id), new InterestedItem(table_id), new ChokedItem(table_id), new DownItem(table_id), new InterestingItem(table_id), new ChokingItem(table_id), new OptimisticUnchokeItem(table_id), new UpItem(table_id), new UpDownRatioItem(table_id), new GainItem(table_id), new StatUpItem(table_id), new SnubbedItem(table_id), new NoUploadItem(table_id), new TotalDownSpeedItem(table_id), new TimeUntilCompleteItem(table_id), new DiscardedItem(table_id), new UniquePieceItem(table_id), new TimeToSendPieceItem(table_id), new DLedFromOthersItem(table_id), new UpRatioItem(table_id), new StateItem(table_id), new ConnectedTimeItem(table_id), new PieceItem(table_id), new IncomingRequestCountItem(table_id), new OutgoingRequestCountItem(table_id), new UpSpeedLimitItem(table_id), new DownSpeedLimitItem(table_id), new LANItem(table_id), new PeerIDItem(table_id), new PeerByteIDItem(table_id), new HandshakeReservedBytesItem(table_id), new ClientIdentificationItem(table_id), new ASItem(table_id), new IndexItem(table_id)};
    }

    public PeersView() {
        super(MSGID_PREFIX);
    }

    @Override
    public TableViewSWT<PEPeer> initYourTableView() {
        UISWTInstance pluginUI;
        this.tv = TableViewFactory.createTableViewSWT(Peer.class, "Peers", this.getPropertiesPrefix(), basicItems, "pieces", 0x10010002);
        this.tv.setRowDefaultHeight(16);
        this.tv.setEnableTabViews(this.enable_tabs, true, null);
        UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
        if (uiFunctions != null && (pluginUI = uiFunctions.getUISWTInstance()) != null && !registeredCoreSubViews) {
            pluginUI.addView("Peers", "PeerInfoView", PeerInfoView.class, null);
            pluginUI.addView("Peers", "RemotePieceDistributionView", RemotePieceDistributionView.class, null);
            pluginUI.addView("Peers", "PeerFilesView", PeerFilesView.class, null);
            pluginUI.addView("Peers", "LoggerView", LoggerView.class, true);
            registeredCoreSubViews = true;
        }
        this.tv.addTableDataSourceChangedListener(this, true);
        this.tv.addLifeCycleListener(this);
        this.tv.addMenuFillListener(this);
        return this.tv;
    }

    private void setFocused(boolean foc) {
        if (foc) {
            this.comp_focused = true;
            this.dataSourceChanged(this.focus_pending_ds);
        } else {
            this.focus_pending_ds = this.manager;
            this.dataSourceChanged(null);
            this.comp_focused = false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void tableDataSourceChanged(Object newDataSource) {
        if (!this.comp_focused) {
            this.focus_pending_ds = newDataSource;
            return;
        }
        DownloadManager old_manager = this.manager;
        if (newDataSource == null) {
            this.manager = null;
        } else if (newDataSource instanceof Object[]) {
            Object temp = ((Object[])newDataSource)[0];
            if (temp instanceof DownloadManager) {
                this.manager = (DownloadManager)temp;
            } else {
                if (!(temp instanceof DiskManagerFileInfo)) return;
                this.manager = ((DiskManagerFileInfo)temp).getDownloadManager();
            }
        } else if (newDataSource instanceof DownloadManager) {
            this.manager = (DownloadManager)newDataSource;
        } else {
            if (!(newDataSource instanceof DiskManagerFileInfo)) return;
            this.manager = ((DiskManagerFileInfo)newDataSource).getDownloadManager();
        }
        if (old_manager == this.manager) {
            return;
        }
        if (old_manager != null) {
            old_manager.removePeerListener(this);
        }
        if (this.tv.isDisposed()) return;
        this.tv.removeAllTableRows();
        if (this.manager == null) return;
        this.manager.addPeerListener(this, false);
        this.addExistingDatasources();
    }

    @Override
    public void tableViewInitialized() {
        this.shell = this.tv.getComposite().getShell();
        if (this.manager != null) {
            this.manager.removePeerListener(this);
            this.manager.addPeerListener(this, false);
        }
        this.addExistingDatasources();
    }

    @Override
    public void tableViewDestroyed() {
        if (this.manager != null) {
            this.manager.removePeerListener(this);
        }
        this.select_peer_pending = null;
    }

    @Override
    public void fillMenu(String sColumnName, Menu menu) {
        PeersView.fillMenu(menu, this.tv, this.shell, this.manager);
    }

    public static void fillMenu(Menu menu, final TableView<?> tv, Shell shell, DownloadManager download_specific) {
        Object[] peers = tv.getSelectedDataSources().toArray();
        boolean hasSelection = peers.length > 0;
        boolean downSpeedDisabled = false;
        boolean downSpeedUnlimited = false;
        long totalDownSpeed = 0L;
        long downSpeedSetMax = 0L;
        long maxDown = 0L;
        boolean upSpeedDisabled = false;
        boolean upSpeedUnlimited = false;
        long totalUpSpeed = 0L;
        long upSpeedSetMax = 0L;
        long maxUp = 0L;
        GlobalManager gm = AzureusCoreFactory.getSingleton().getGlobalManager();
        final IdentityHashSet<DownloadManager> download_managers = new IdentityHashSet<DownloadManager>();
        if (hasSelection) {
            for (int i = 0; i < peers.length; ++i) {
                DownloadManager dm;
                PEPeer peer = (PEPeer)peers[i];
                PEPeerManager m = peer.getManager();
                if (m != null && gm != null && (dm = gm.getDownloadManager(new HashWrapper(m.getHash()))) != null) {
                    download_managers.add(dm);
                }
                try {
                    int maxul = peer.getStats().getUploadRateLimitBytesPerSecond();
                    maxUp += (long)(maxul * 4);
                    if (maxul == 0) {
                        upSpeedUnlimited = true;
                    } else if ((long)maxul > upSpeedSetMax) {
                        upSpeedSetMax = maxul;
                    }
                    if (maxul == -1) {
                        maxul = 0;
                        upSpeedDisabled = true;
                    }
                    totalUpSpeed += (long)maxul;
                    int maxdl = peer.getStats().getDownloadRateLimitBytesPerSecond();
                    maxDown += (long)(maxdl * 4);
                    if (maxdl == 0) {
                        downSpeedUnlimited = true;
                    } else if ((long)maxdl > downSpeedSetMax) {
                        downSpeedSetMax = maxdl;
                    }
                    if (maxdl == -1) {
                        maxdl = 0;
                        downSpeedDisabled = true;
                    }
                    totalDownSpeed += (long)maxdl;
                    continue;
                }
                catch (Exception ex) {
                    Debug.printStackTrace(ex);
                }
            }
        }
        if (download_specific != null) {
            final MenuItem noUpload_item = new MenuItem(menu, 32);
            noUpload_item.setEnabled(ShuUtils.auth);
            Messages.setLanguageText((Widget)noUpload_item, "PeersView.menu.noupload");
            noUpload_item.addListener(13, (Listener)new TableSelectedRowsListener(tv){

                public void run(TableRowCore row) {
                    PEPeer peer = (PEPeer)row.getDataSource(true);
                    if (peer == null) {
                        noUpload_item.setSelection(false);
                        noUpload_item.setEnabled(false);
                        return;
                    }
                    noUpload_item.setEnabled(ShuUtils.auth);
                    ((PEPeer)row.getDataSource(true)).setNoUploadUserSet(noUpload_item.getSelection());
                    noUpload_item.setSelection(peer.isNoUpload() || peer.isNoUploadUserSet());
                }
            });
            MenuItem block_item = new MenuItem(menu, 32);
            PEPeer peer = (PEPeer)tv.getFirstSelectedDataSource();
            if (peer == null || peer.getManager().getDiskManager().getRemainingExcludingDND() > 0L) {
                block_item.setSelection(false);
                block_item.setEnabled(false);
            } else {
                block_item.setEnabled(true);
                block_item.setSelection(peer.isSnubbed());
            }
            if (peer != null) {
                final boolean newSnubbedValue = !peer.isSnubbed();
                Messages.setLanguageText((Widget)block_item, "PeersView.menu.blockupload");
                block_item.addListener(13, (Listener)new TableSelectedRowsListener((TableView)tv){

                    public void run(TableRowCore row) {
                        PEPeer peer = (PEPeer)row.getDataSource(true);
                        peer.setSnubbed(newSnubbedValue);
                    }
                });
            }
        } else if (download_managers.size() > 0) {
            MenuItem itemDetails = new MenuItem(menu, 8);
            Messages.setLanguageText((Widget)itemDetails, "PeersView.menu.showdownload");
            Utils.setMenuItemImage(itemDetails, "details");
            itemDetails.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                    if (uiFunctions != null) {
                        for (DownloadManager dm : download_managers) {
                            uiFunctions.openView(5, dm);
                        }
                    }
                }
            });
            new MenuItem(menu, 2);
        }
        MenuItem ban_item = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)ban_item, "PeersView.menu.kickandban");
        ban_item.addListener(13, (Listener)new TableSelectedRowsListener((TableView)tv){

            public void run(TableRowCore row) {
                PEPeer peer = (PEPeer)row.getDataSource(true);
                String msg = MessageText.getString("PeersView.menu.kickandban.reason");
                IpFilterManagerFactory.getSingleton().getIPFilter().ban(peer.getIp(), msg, true);
                peer.getManager().removePeer(peer);
            }
        });
        MenuItem itemAdvanced = new MenuItem(menu, 64);
        Messages.setLanguageText((Widget)itemAdvanced, "MyTorrentsView.menu.advancedmenu");
        itemAdvanced.setEnabled(hasSelection);
        Menu menuAdvanced = new Menu((Decorations)shell, 4);
        itemAdvanced.setMenu(menuAdvanced);
        HashMap<String, Object> menu_properties = new HashMap<String, Object>();
        menu_properties.put("enable_upload_disable", true);
        menu_properties.put("enable_download_disable", true);
        ViewUtils.addSpeedMenu(shell, menuAdvanced, true, true, false, hasSelection, downSpeedDisabled, downSpeedUnlimited, totalDownSpeed, downSpeedSetMax, maxDown, upSpeedDisabled, upSpeedUnlimited, totalUpSpeed, upSpeedSetMax, maxUp, peers.length, menu_properties, new ViewUtils.SpeedAdapter(){

            public void setDownSpeed(int speed) {
                PeersView.setSelectedPeersDownSpeed(speed, tv);
            }

            public void setUpSpeed(int speed) {
                PeersView.setSelectedPeersUpSpeed(speed, tv);
            }
        });
        PeersView.addPeersMenu(download_specific, menu);
        new MenuItem(menu, 2);
    }

    @Override
    public void addThisColumnSubMenu(String columnName, Menu menuThisColumn) {
        if (PeersView.addPeersMenu(this.manager, menuThisColumn)) {
            new MenuItem(menuThisColumn, 2);
        }
    }

    private static boolean addPeersMenu(final DownloadManager man, Menu menu) {
        if (man == null) {
            return false;
        }
        PEPeerManager pm = man.getPeerManager();
        if (pm == null) {
            return false;
        }
        if (TorrentUtils.isReallyPrivate(man.getTorrent())) {
            return false;
        }
        new MenuItem(menu, 2);
        MenuItem add_peers_item = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)add_peers_item, "menu.add.peers");
        add_peers_item.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                SimpleTextEntryWindow entryWindow = new SimpleTextEntryWindow("dialog.add.peers.title", "dialog.add.peers.msg");
                String def = COConfigurationManager.getStringParameter("add.peers.default", "");
                entryWindow.setPreenteredText(String.valueOf(def), false);
                entryWindow.prompt(new UIInputReceiverListener(){

                    public void UIInputReceiverClosed(UIInputReceiver entryWindow) {
                        String[] bits;
                        if (!entryWindow.hasSubmittedInput()) {
                            return;
                        }
                        String sReturn = entryWindow.getSubmittedInput();
                        if (sReturn == null) {
                            return;
                        }
                        COConfigurationManager.setParameter("add.peers.default", sReturn);
                        PEPeerManager pm = man.getPeerManager();
                        if (pm == null) {
                            return;
                        }
                        for (String bit : bits = sReturn.split(",")) {
                            int pos = (bit = bit.trim()).lastIndexOf(58);
                            if (pos != -1) {
                                String host = bit.substring(0, pos).trim();
                                String port = bit.substring(pos + 1).trim();
                                try {
                                    int i_port = Integer.parseInt(port);
                                    pm.addPeer(host, i_port, 0, NetworkManager.getCryptoRequired(0), null);
                                }
                                catch (Throwable e) {}
                                continue;
                            }
                            pm.addPeer(bit, 6881, 0, NetworkManager.getCryptoRequired(0), null);
                        }
                    }
                });
            }
        });
        return true;
    }

    private static void setSelectedPeersUpSpeed(int speed, TableView<?> tv) {
        Object[] peers = tv.getSelectedDataSources().toArray();
        if (peers.length > 0) {
            for (int i = 0; i < peers.length; ++i) {
                try {
                    PEPeer peer = (PEPeer)peers[i];
                    peer.getStats().setUploadRateLimitBytesPerSecond(speed);
                    continue;
                }
                catch (Exception e) {
                    Debug.printStackTrace(e);
                }
            }
        }
    }

    private static void setSelectedPeersDownSpeed(int speed, TableView<?> tv) {
        Object[] peers = tv.getSelectedDataSources().toArray();
        if (peers.length > 0) {
            for (int i = 0; i < peers.length; ++i) {
                try {
                    PEPeer peer = (PEPeer)peers[i];
                    peer.getStats().setDownloadRateLimitBytesPerSecond(speed);
                    continue;
                }
                catch (Exception e) {
                    Debug.printStackTrace(e);
                }
            }
        }
    }

    @Override
    public void peerAdded(PEPeer created) {
        this.tv.addDataSource(created);
    }

    @Override
    public void peerRemoved(PEPeer removed) {
        this.tv.removeDataSource(removed);
    }

    public void selectPeer(PEPeer peer) {
        this.showPeer(peer, 0);
    }

    private void showPeer(final PEPeer peer, final int attempt) {
        if (attempt > 10) {
            return;
        }
        Utils.execSWTThreadLater(attempt == 0 ? 1 : 10, new Runnable(){

            public void run() {
                TableRowCore row = PeersView.this.tv.getRow(peer);
                if (row == null) {
                    if (attempt == 0) {
                        PeersView.this.select_peer_pending = peer;
                        return;
                    }
                } else {
                    PeersView.this.tv.setSelectedRows(new TableRowCore[]{row});
                    PeersView.this.tv.showRow(row);
                    if (row.isVisible()) {
                        return;
                    }
                }
                PeersView.this.showPeer(peer, attempt + 1);
            }
        });
    }

    @Override
    public void peerManagerWillBeAdded(PEPeerManager peer_manager) {
    }

    @Override
    public void peerManagerAdded(PEPeerManager manager) {
    }

    @Override
    public void peerManagerRemoved(PEPeerManager manager) {
        this.tv.removeAllTableRows();
    }

    private void addExistingDatasources() {
        if (this.manager == null || this.tv.isDisposed()) {
            return;
        }
        PEPeer[] dataSources = this.manager.getCurrentPeers();
        if (dataSources != null && dataSources.length > 0) {
            this.tv.addDataSources((PEPeer[])dataSources);
            this.tv.processDataSourceQueue();
        }
        if (this.select_peer_pending != null) {
            this.showPeer(this.select_peer_pending, 1);
            this.select_peer_pending = null;
        }
    }

    @Override
    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 0: {
                if (!(event2 instanceof UISWTViewEventImpl)) break;
                String parent = ((UISWTViewEventImpl)event2).getParentID();
                this.enable_tabs = parent != null && parent.equals("TorrentDetailsView");
                break;
            }
            case 3: {
                String id = "DMDetails_Peers";
                this.setFocused(true);
                if (this.manager != null) {
                    id = this.manager.getTorrent() != null ? id + "." + this.manager.getInternalName() : id + ":" + this.manager.getSize();
                }
                SelectedContentManager.changeCurrentlySelectedContent(id, new SelectedContent[]{new SelectedContent(this.manager)});
                break;
            }
            case 4: {
                this.setFocused(false);
            }
        }
        return super.eventOccurred(event2);
    }

    @Override
    public boolean toolBarItemActivated(ToolBarItem item, long activationType, Object datasource) {
        if (ViewUtils.toolBarItemActivated(this.manager, item, activationType, datasource)) {
            return true;
        }
        return super.toolBarItemActivated(item, activationType, datasource);
    }

    @Override
    public void refreshToolBarItems(Map<String, Long> list) {
        ViewUtils.refreshToolBarItems(this.manager, list);
        super.refreshToolBarItems(list);
    }

    static {
        TableColumnManager tcManager = TableColumnManager.getInstance();
        tcManager.setDefaultColumnNames("Peers", basicItems);
        registeredCoreSubViews = false;
    }
}

