/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views;

import java.net.URL;
import java.util.List;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncer;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimeFormatter;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.BufferedLabel;
import org.gudy.azureus2.ui.swt.components.BufferedTruncatedLabel;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.maketorrent.MultiTrackerEditor;
import org.gudy.azureus2.ui.swt.maketorrent.TrackerEditorListener;
import org.gudy.azureus2.ui.swt.plugins.UISWTView;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEvent;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewCoreEventListener;

public class ScrapeInfoView
implements UISWTViewCoreEventListener {
    private DownloadManager manager;
    private Composite cParent;
    private Composite cScrapeInfoView;
    private BufferedTruncatedLabel tracker_status;
    private Button updateButton;
    private BufferedLabel trackerUpdateIn;
    private Menu menuTracker;
    private MenuItem itemSelect;
    private BufferedTruncatedLabel trackerUrlValue;
    private long lastRefreshSecs;
    private UISWTView swtView;

    private String getFullTitle() {
        return MessageText.getString("ScrapeInfoView.title");
    }

    private void initialize(Composite parent) {
        this.cParent = parent;
        final Display display = parent.getDisplay();
        if (this.cScrapeInfoView == null || this.cScrapeInfoView.isDisposed()) {
            this.cScrapeInfoView = new Composite(parent, 0);
        }
        GridData gridData = new GridData(1808);
        this.cScrapeInfoView.setLayoutData((Object)gridData);
        GridLayout layoutInfo = new GridLayout();
        layoutInfo.numColumns = 4;
        this.cScrapeInfoView.setLayout((Layout)layoutInfo);
        Label label = new Label(this.cScrapeInfoView, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.trackerurl");
        label.setCursor(display.getSystemCursor(21));
        label.setForeground(Colors.blue);
        label.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent arg0) {
                String announce = ScrapeInfoView.this.trackerUrlValue.getText();
                if (announce != null && announce.length() != 0) {
                    new Clipboard(display).setContents(new Object[]{announce}, new Transfer[]{TextTransfer.getInstance()});
                }
            }

            public void mouseDown(MouseEvent arg0) {
                String announce = ScrapeInfoView.this.trackerUrlValue.getText();
                if (announce != null && announce.length() != 0) {
                    new Clipboard(display).setContents(new Object[]{announce}, new Transfer[]{TextTransfer.getInstance()});
                }
            }
        });
        this.menuTracker = new Menu((Decorations)parent.getShell(), 8);
        this.itemSelect = new MenuItem(this.menuTracker, 64);
        Messages.setLanguageText((Widget)this.itemSelect, "GeneralView.menu.selectTracker");
        MenuItem itemEdit = new MenuItem(this.menuTracker, 0);
        Messages.setLanguageText((Widget)itemEdit, "MyTorrentsView.menu.editTracker");
        this.cScrapeInfoView.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ScrapeInfoView.this.menuTracker.dispose();
            }
        });
        itemEdit.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                final TOTorrent torrent = ScrapeInfoView.this.manager.getTorrent();
                if (torrent == null) {
                    return;
                }
                List<List<String>> group = TorrentUtils.announceGroupsToList(torrent);
                new MultiTrackerEditor(null, null, group, new TrackerEditorListener(){

                    @Override
                    public void trackersChanged(String str, String str2, List<List<String>> _group) {
                        TorrentUtils.listToAnnounceGroups(_group, torrent);
                        try {
                            TorrentUtils.writeToFile(torrent);
                        }
                        catch (Throwable e2) {
                            Debug.printStackTrace(e2);
                        }
                        TRTrackerAnnouncer tc = ScrapeInfoView.this.manager.getTrackerClient();
                        if (tc != null) {
                            tc.resetTrackerUrl(true);
                        }
                    }
                }, true, true);
            }
        });
        TOTorrent torrent = this.manager == null ? null : this.manager.getTorrent();
        itemEdit.setEnabled(torrent != null && !TorrentUtils.isReallyPrivate(torrent));
        final Listener menuListener = new Listener(){

            public void handleEvent(Event e) {
                if (e.widget instanceof MenuItem) {
                    String text = ((MenuItem)e.widget).getText();
                    TOTorrent torrent = ScrapeInfoView.this.manager.getTorrent();
                    TorrentUtils.announceGroupsSetFirst(torrent, text);
                    try {
                        TorrentUtils.writeToFile(torrent);
                    }
                    catch (TOTorrentException f) {
                        Debug.printStackTrace(f);
                    }
                    TRTrackerAnnouncer tc = ScrapeInfoView.this.manager.getTrackerClient();
                    if (tc != null) {
                        tc.resetTrackerUrl(false);
                    }
                }
            }
        };
        this.menuTracker.addListener(22, new Listener(){

            public void handleEvent(Event e) {
                Menu menuSelect = ScrapeInfoView.this.itemSelect.getMenu();
                if (menuSelect != null && !menuSelect.isDisposed()) {
                    menuSelect.dispose();
                }
                if (ScrapeInfoView.this.manager == null || ScrapeInfoView.this.cScrapeInfoView == null || ScrapeInfoView.this.cScrapeInfoView.isDisposed()) {
                    return;
                }
                List<List<String>> groups = TorrentUtils.announceGroupsToList(ScrapeInfoView.this.manager.getTorrent());
                menuSelect = new Menu((Decorations)ScrapeInfoView.this.cScrapeInfoView.getShell(), 4);
                ScrapeInfoView.this.itemSelect.setMenu(menuSelect);
                for (List<String> trackers : groups) {
                    MenuItem menuItem = new MenuItem(menuSelect, 64);
                    Messages.setLanguageText((Widget)menuItem, "wizard.multitracker.group");
                    Menu menu = new Menu((Decorations)ScrapeInfoView.this.cScrapeInfoView.getShell(), 4);
                    menuItem.setMenu(menu);
                    for (String url : trackers) {
                        MenuItem menuItemTracker = new MenuItem(menu, 64);
                        menuItemTracker.setText(url);
                        menuItemTracker.addListener(13, menuListener);
                    }
                }
            }
        });
        this.trackerUrlValue = new BufferedTruncatedLabel(this.cScrapeInfoView, 16384, 70);
        this.trackerUrlValue.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent event2) {
                String url;
                if (event2.button == 3 || event2.button == 1 && event2.stateMask == 262144) {
                    ScrapeInfoView.this.menuTracker.setVisible(true);
                } else if (event2.button == 1 && ((url = ScrapeInfoView.this.trackerUrlValue.getText()).startsWith("http://") || url.startsWith("https://"))) {
                    int pos = -1;
                    pos = url.indexOf("/announce");
                    if (pos != -1) {
                        url = url.substring(0, pos + 1);
                    }
                    Utils.launch(url);
                }
            }
        });
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        this.trackerUrlValue.setLayoutData(gridData);
        label = new Label(this.cScrapeInfoView, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.tracker");
        this.tracker_status = new BufferedTruncatedLabel(this.cScrapeInfoView, 16384, 150);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        this.tracker_status.setLayoutData(gridData);
        label = new Label(this.cScrapeInfoView, 16384);
        Messages.setLanguageText((Widget)label, "GeneralView.label.updatein");
        this.trackerUpdateIn = new BufferedLabel(this.cScrapeInfoView, 16384);
        gridData = new GridData(260);
        this.trackerUpdateIn.setLayoutData(gridData);
        this.updateButton = new Button(this.cScrapeInfoView, 8);
        Messages.setLanguageText((Widget)this.updateButton, "GeneralView.label.trackerurlupdate");
        this.updateButton.setLayoutData((Object)new GridData());
        this.updateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event2) {
                new AEThread2("SIV:async"){

                    public void run() {
                        boolean force = false;
                        boolean enableUpdate = COConfigurationManager.getBooleanParameter("Enable Update");
                        if (enableUpdate) {
                            force = true;
                        }
                        if (!enableUpdate && ScrapeInfoView.this.manager.getTrackerClient() != null) {
                            ScrapeInfoView.this.manager.requestTrackerAnnounce(false);
                        } else {
                            ScrapeInfoView.this.manager.requestTrackerScrape(true);
                        }
                    }
                }.start();
            }
        });
        this.cScrapeInfoView.layout(true);
    }

    private void refresh() {
        if (this.manager == null) {
            return;
        }
        long thisRefreshSecs = SystemTime.getCurrentTime() / 1000L;
        if (this.lastRefreshSecs != thisRefreshSecs) {
            this.lastRefreshSecs = thisRefreshSecs;
            this.setTracker();
        }
    }

    private Composite getComposite() {
        return this.cScrapeInfoView;
    }

    private void setTracker() {
        boolean enableUpdate;
        TOTorrent torrent;
        URL temp;
        if (this.cScrapeInfoView == null || this.cScrapeInfoView.isDisposed()) {
            return;
        }
        Display display = this.cScrapeInfoView.getDisplay();
        String status = this.manager.getTrackerStatus();
        int time = this.manager.getTrackerTime();
        TRTrackerAnnouncer trackerClient = this.manager.getTrackerClient();
        if (trackerClient != null) {
            this.tracker_status.setText(trackerClient.getStatusString());
            time = trackerClient.getTimeUntilNextUpdate();
        } else {
            this.tracker_status.setText(status);
        }
        if (time < 0) {
            this.trackerUpdateIn.setText(MessageText.getString("GeneralView.label.updatein.querying"));
        } else {
            this.trackerUpdateIn.setText(TimeFormatter.formatColon(time));
        }
        String trackerURL = null;
        if (trackerClient != null && (temp = trackerClient.getTrackerURL()) != null) {
            trackerURL = temp.toString();
        }
        if (trackerURL == null && (torrent = this.manager.getTorrent()) != null) {
            trackerURL = torrent.getAnnounceURL().toString();
        }
        if (trackerURL != null) {
            this.trackerUrlValue.setText(trackerURL);
            if (trackerURL.startsWith("http://") || trackerURL.startsWith("https://")) {
                this.trackerUrlValue.setForeground(Colors.blue);
                this.trackerUrlValue.setCursor(display.getSystemCursor(21));
                Messages.setLanguageText(this.trackerUrlValue.getWidget(), "GeneralView.label.trackerurlopen.tooltip", true);
            } else {
                this.trackerUrlValue.setForeground(null);
                this.trackerUrlValue.setCursor(null);
                Messages.setLanguageText(this.trackerUrlValue.getWidget(), null);
                this.trackerUrlValue.setToolTipText(null);
            }
        }
        if (!(enableUpdate = COConfigurationManager.getBooleanParameter("Enable Update"))) {
            boolean update_state;
            if (trackerClient != null) {
                update_state = SystemTime.getCurrentTime() / 1000L - (long)trackerClient.getLastUpdateTime() >= 60L;
            } else {
                TRTrackerScraperResponse sr = this.manager.getTrackerScrapeResponse();
                if (sr == null) {
                    update_state = true;
                } else {
                    boolean bl = update_state = SystemTime.getCurrentTime() - sr.getScrapeStartTime() >= 120000L;
                }
            }
            if (this.updateButton.getEnabled() != update_state) {
                this.updateButton.setEnabled(update_state);
            }
        }
        this.cScrapeInfoView.layout();
    }

    private void setDownlaodManager(DownloadManager dm) {
        this.manager = dm;
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (ScrapeInfoView.this.cScrapeInfoView != null) {
                    Utils.disposeComposite(ScrapeInfoView.this.cScrapeInfoView, false);
                }
                if (ScrapeInfoView.this.cParent != null) {
                    ScrapeInfoView.this.initialize(ScrapeInfoView.this.cParent);
                }
            }
        });
    }

    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 0: {
                this.swtView = (UISWTView)event2.getData();
                this.swtView.setTitle(this.getFullTitle());
                break;
            }
            case 7: {
                break;
            }
            case 2: {
                this.initialize((Composite)event2.getData());
                break;
            }
            case 6: {
                Messages.updateLanguageForControl((Widget)this.getComposite());
                this.swtView.setTitle(this.getFullTitle());
                break;
            }
            case 1: {
                Object ds = event2.getData();
                if (!(ds instanceof DownloadManager)) break;
                DownloadManager dm = (DownloadManager)ds;
                this.setDownlaodManager(dm);
                break;
            }
            case 3: {
                break;
            }
            case 5: {
                this.refresh();
            }
        }
        return true;
    }
}

