/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.columnsetup;

import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.common.table.TableCountChangeListener;
import com.aelitis.azureus.ui.common.table.TableLifeCycleListener;
import com.aelitis.azureus.ui.common.table.TableRowCore;
import com.aelitis.azureus.ui.common.table.TableSelectionAdapter;
import com.aelitis.azureus.ui.common.table.TableStructureModificationListener;
import com.aelitis.azureus.ui.common.table.TableView;
import com.aelitis.azureus.ui.common.table.impl.TableColumnManager;
import com.aelitis.azureus.ui.common.updater.UIUpdatable;
import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import com.aelitis.azureus.ui.swt.uiupdater.UIUpdaterSWT;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.plugins.ui.tables.TableRow;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.shell.ShellFactory;
import org.gudy.azureus2.ui.swt.shells.GCStringPrinter;
import org.gudy.azureus2.ui.swt.views.table.TableRowSWT;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWT;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableColumnSetupWindow
implements UIUpdatable {
    private static final String TABLEID_AVAIL = "ColumnSetupAvail";
    private static final String TABLEID_CHOSEN = "ColumnSetupChosen";
    private static final boolean CAT_BUTTONS = true;
    private Shell shell;
    private TableViewSWT tvAvail;
    private final String forTableID;
    private final Class<?> forDataSourceType;
    private Composite cTableAvail;
    private Composite cCategories;
    private TableViewSWT tvChosen;
    private Composite cTableChosen;
    private TableColumnCore[] columnsChosen;
    private final TableRow sampleRow;
    private DragSourceListener dragSourceListener;
    private final TableStructureModificationListener<?> listener;
    private TableColumnCore[] columnsOriginalOrder;
    protected boolean apply = false;
    private Button[] radProficiency = new Button[3];
    private Map<TableColumnCore, Boolean> mapNewVisibility = new HashMap<TableColumnCore, Boolean>();
    private ArrayList<TableColumnCore> listColumnsNoCat;
    private ArrayList<String> listCats;
    private Combo comboFilter;
    private Group cPickArea;
    protected boolean doReset;

    public TableColumnSetupWindow(Class<?> forDataSourceType, String _tableID, TableRow sampleRow, TableStructureModificationListener<?> _listener) {
        this.sampleRow = sampleRow;
        this.listener = _listener;
        this.forDataSourceType = forDataSourceType;
        this.forTableID = _tableID;
        this.dragSourceListener = new DragSourceListener(){
            private TableColumnCore tableColumn;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void dragStart(DragSourceEvent event2) {
                event2.doit = true;
                if (!(event2.widget instanceof DragSource)) {
                    event2.doit = false;
                    return;
                }
                TableView tv = (TableView)((DragSource)event2.widget).getData("tv");
                TableRowCore row = tv.getFocusedRow();
                if (row == null) {
                    event2.doit = false;
                    return;
                }
                this.tableColumn = (TableColumnCore)row.getDataSource();
                if (event2.image != null && !Constants.isLinux) {
                    try {
                        GC gc = new GC((Drawable)event2.image);
                        try {
                            Rectangle bounds = event2.image.getBounds();
                            gc.fillRectangle(bounds);
                            String title = MessageText.getString(this.tableColumn.getTitleLanguageKey(), this.tableColumn.getName());
                            String s = title + " Column will be placed at the location you drop it, shifting other columns down";
                            GCStringPrinter sp = new GCStringPrinter(gc, s, bounds, false, false, 0x1000040);
                            sp.calculateMetrics();
                            if (sp.isCutoff()) {
                                GCStringPrinter.printString(gc, title, bounds, false, false, 0x1000040);
                            } else {
                                sp.printString();
                            }
                            Object var10_10 = null;
                        }
                        catch (Throwable throwable) {
                            Object var10_11 = null;
                            gc.dispose();
                            throw throwable;
                        }
                        gc.dispose();
                        {
                        }
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
            }

            public void dragSetData(DragSourceEvent event2) {
                if (!(event2.widget instanceof DragSource)) {
                    return;
                }
                TableView tv = (TableView)((DragSource)event2.widget).getData("tv");
                event2.data = "" + (tv == TableColumnSetupWindow.this.tvChosen ? "c" : "a");
            }

            public void dragFinished(DragSourceEvent event2) {
            }
        };
        String tableName = MessageText.getString(_tableID + "View.header", (String)null);
        if (tableName == null && (tableName = MessageText.getString(_tableID + "View.title.full", (String)null)) == null) {
            tableName = _tableID;
        }
        this.shell = ShellFactory.createShell(Utils.findAnyShell(), 1264);
        Utils.setShellIcon(this.shell);
        FormLayout formLayout = new FormLayout();
        this.shell.setText(MessageText.getString("ColumnSetup.title", new String[]{tableName}));
        this.shell.setLayout((Layout)formLayout);
        this.shell.setSize(780, 550);
        this.shell.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2) {
                    TableColumnSetupWindow.this.shell.dispose();
                }
            }
        });
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TableColumnSetupWindow.this.close();
            }
        });
        Label topInfo = new Label((Composite)this.shell, 64);
        Messages.setLanguageText((Widget)topInfo, "ColumnSetup.explain");
        FormData fd = Utils.getFilledFormData();
        fd.left.offset = 5;
        fd.top.offset = 5;
        fd.bottom = null;
        topInfo.setLayoutData((Object)fd);
        Button btnOk = new Button((Composite)this.shell, 8);
        Messages.setLanguageText((Widget)btnOk, "Button.ok");
        btnOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableColumnSetupWindow.this.apply = true;
                TableColumnSetupWindow.this.shell.dispose();
            }
        });
        this.cPickArea = new Group((Composite)this.shell, 0);
        this.cPickArea.setLayout((Layout)new FormLayout());
        final ExpandBar expandFilters = new ExpandBar((Composite)this.cPickArea, 0);
        expandFilters.setSpacing(1);
        final Composite cFilterArea = new Composite((Composite)expandFilters, 0);
        cFilterArea.setLayout((Layout)new FormLayout());
        final TableColumnManager tcm = TableColumnManager.getInstance();
        Group cResultArea = new Group((Composite)this.shell, 0);
        Messages.setLanguageText((Widget)cResultArea, "ColumnSetup.chosencolumns");
        cResultArea.setLayout((Layout)new FormLayout());
        Composite cResultButtonArea = new Composite((Composite)cResultArea, 0);
        cResultButtonArea.setLayout((Layout)new FormLayout());
        this.tvAvail = this.createTVAvail();
        this.cTableAvail = new Composite((Composite)this.cPickArea, 524288);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.cTableAvail.setLayout((Layout)gridLayout);
        this.tvAvail.initialize(this.cTableAvail);
        TableColumnCore[] datasources = tcm.getAllTableColumnCoreAsArray(forDataSourceType, this.forTableID);
        this.listColumnsNoCat = new ArrayList<TableColumnCore>(Arrays.asList(datasources));
        this.listCats = new ArrayList();
        for (int i = 0; i < datasources.length; ++i) {
            String[] categories;
            TableColumnCore column = datasources[i];
            TableColumnInfo info = tcm.getColumnInfo(forDataSourceType, this.forTableID, column.getName());
            if (info == null || (categories = info.getCategories()) == null || categories.length <= 0) continue;
            for (int j = 0; j < categories.length; ++j) {
                String cat = categories[j];
                if (this.listCats.contains(cat)) continue;
                this.listCats.add(cat);
            }
            this.listColumnsNoCat.remove(column);
        }
        Listener radListener = new Listener(){

            public void handleEvent(Event event2) {
                TableColumnSetupWindow.this.fillAvail();
            }
        };
        Composite cProficiency = new Composite(cFilterArea, 0);
        cProficiency.setBackgroundMode(2);
        cProficiency.setLayout((Layout)new FormLayout());
        Label lblProficiency = new Label(cProficiency, 0);
        Messages.setLanguageText((Widget)lblProficiency, "ColumnSetup.proficiency");
        this.radProficiency[0] = new Button(cProficiency, 16);
        Messages.setLanguageText((Widget)this.radProficiency[0], "ConfigView.section.mode.beginner");
        fd = new FormData();
        fd.left = new FormAttachment((Control)lblProficiency, 5);
        this.radProficiency[0].setLayoutData((Object)fd);
        this.radProficiency[0].addListener(13, radListener);
        this.radProficiency[1] = new Button(cProficiency, 16);
        Messages.setLanguageText((Widget)this.radProficiency[1], "ConfigView.section.mode.intermediate");
        fd = new FormData();
        fd.left = new FormAttachment((Control)this.radProficiency[0], 5);
        this.radProficiency[1].setLayoutData((Object)fd);
        this.radProficiency[1].addListener(13, radListener);
        this.radProficiency[2] = new Button(cProficiency, 16);
        Messages.setLanguageText((Widget)this.radProficiency[2], "ConfigView.section.mode.advanced");
        fd = new FormData();
        fd.left = new FormAttachment((Control)this.radProficiency[1], 5);
        this.radProficiency[2].setLayoutData((Object)fd);
        this.radProficiency[2].addListener(13, radListener);
        int userMode = COConfigurationManager.getIntParameter("User Mode");
        if (userMode < 0) {
            userMode = 0;
        } else if (userMode >= this.radProficiency.length) {
            userMode = this.radProficiency.length - 1;
        }
        this.radProficiency[userMode].setSelection(true);
        Listener buttonListener = new Listener(){

            public void handleEvent(Event event2) {
                Control[] children = TableColumnSetupWindow.this.cCategories.getChildren();
                for (int i = 0; i < children.length; ++i) {
                    Control child = children[i];
                    if (child == event2.widget || !(child instanceof Button)) continue;
                    Button btn = (Button)child;
                    btn.setSelection(false);
                }
                TableColumnSetupWindow.this.fillAvail();
            }
        };
        Label lblCat = new Label(cFilterArea, 0);
        Messages.setLanguageText((Widget)lblCat, "ColumnSetup.categories");
        this.cCategories = new Composite(cFilterArea, 0);
        this.cCategories.setLayout((Layout)new RowLayout());
        Button button = new Button(this.cCategories, 2);
        Messages.setLanguageText((Widget)button, "Categories.all");
        button.addListener(13, buttonListener);
        button.setSelection(true);
        for (String cat : this.listCats) {
            button = new Button(this.cCategories, 2);
            button.setData("cat", (Object)cat);
            if (MessageText.keyExists("ColumnCategory." + cat)) {
                button.setText(MessageText.getString("ColumnCategory." + cat));
            } else {
                button.setText(cat);
            }
            button.addListener(13, buttonListener);
        }
        if (this.listColumnsNoCat.size() > 0) {
            button = new Button(this.cCategories, 2);
            if (MessageText.keyExists("ColumnCategory.uncat")) {
                button.setText(MessageText.getString("ColumnCategory.uncat"));
            } else {
                button.setText("?");
            }
            button.setText("?");
            button.setData("cat", (Object)"uncat");
            button.addListener(13, buttonListener);
        }
        final ExpandItem expandItemFilters = new ExpandItem(expandFilters, 0);
        expandItemFilters.setText(MessageText.getString("ColumnSetup.filters"));
        expandItemFilters.setControl((Control)cFilterArea);
        expandFilters.addListener(11, new Listener(){

            public void handleEvent(Event event2) {
                expandItemFilters.setHeight(cFilterArea.computeSize((int)expandFilters.getSize().x, (int)-1).y + 3);
            }
        });
        expandFilters.addListener(17, new Listener(){

            public void handleEvent(Event event2) {
                Utils.execSWTThreadLater(Constants.isLinux ? 250 : 0, new AERunnable(){

                    public void runSupport() {
                        TableColumnSetupWindow.this.shell.layout(true, true);
                    }
                });
            }
        });
        expandFilters.addListener(18, new Listener(){

            public void handleEvent(Event event2) {
                Utils.execSWTThreadLater(Constants.isLinux ? 250 : 0, new AERunnable(){

                    public void runSupport() {
                        TableColumnSetupWindow.this.shell.layout(true, true);
                    }
                });
            }
        });
        ImageLoader imageLoader = ImageLoader.getInstance();
        Button btnLeft = new Button(cResultButtonArea, 8);
        imageLoader.setButtonImage(btnLeft, "alignleft");
        btnLeft.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TableColumnSetupWindow.this.alignChosen(1);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button btnCentre = new Button(cResultButtonArea, 8);
        imageLoader.setButtonImage(btnCentre, "aligncentre");
        btnCentre.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TableColumnSetupWindow.this.alignChosen(3);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button btnRight = new Button(cResultButtonArea, 8);
        imageLoader.setButtonImage(btnRight, "alignright");
        btnRight.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TableColumnSetupWindow.this.alignChosen(2);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button btnUp = new Button(cResultButtonArea, 8);
        imageLoader.setButtonImage(btnUp, "up");
        btnUp.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TableColumnSetupWindow.this.moveChosenUp();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button btnDown = new Button(cResultButtonArea, 8);
        imageLoader.setButtonImage(btnDown, "down");
        btnDown.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TableColumnSetupWindow.this.moveChosenDown();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button btnDel = new Button(cResultButtonArea, 8);
        imageLoader.setButtonImage(btnDel, "delete2");
        btnDel.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TableColumnSetupWindow.this.removeSelectedChosen();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.tvChosen = this.createTVChosen();
        this.cTableChosen = new Composite((Composite)cResultArea, 0);
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.cTableChosen.setLayout((Layout)gridLayout);
        this.tvChosen.initialize(this.cTableChosen);
        this.columnsChosen = tcm.getAllTableColumnCoreAsArray(forDataSourceType, this.forTableID);
        Arrays.sort(this.columnsChosen, TableColumnManager.getTableColumnOrderComparator());
        this.columnsOriginalOrder = new TableColumnCore[this.columnsChosen.length];
        System.arraycopy(this.columnsChosen, 0, this.columnsOriginalOrder, 0, this.columnsChosen.length);
        int pos = 0;
        for (int i = 0; i < this.columnsChosen.length; ++i) {
            boolean visible = this.columnsChosen[i].isVisible();
            this.mapNewVisibility.put(this.columnsChosen[i], new Boolean(visible));
            if (!visible) continue;
            this.columnsChosen[i].setPositionNoShift(pos++);
            this.tvChosen.addDataSource(this.columnsChosen[i]);
        }
        this.tvChosen.processDataSourceQueue();
        Button btnReset = null;
        String[] defaultColumnNames = tcm.getDefaultColumnNames(this.forTableID);
        if (defaultColumnNames != null) {
            btnReset = new Button(cResultButtonArea, 8);
            Messages.setLanguageText((Widget)btnReset, "Button.reset");
            btnReset.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String[] defaultColumnNames = tcm.getDefaultColumnNames(TableColumnSetupWindow.this.forTableID);
                    if (defaultColumnNames != null) {
                        ArrayList<TableColumnCore> defaultColumns = new ArrayList<TableColumnCore>();
                        for (String name : defaultColumnNames) {
                            TableColumnCore column = tcm.getTableColumnCore(TableColumnSetupWindow.this.forTableID, name);
                            if (column == null) continue;
                            defaultColumns.add(column);
                        }
                        if (defaultColumns.size() > 0) {
                            for (TableColumnCore tc : TableColumnSetupWindow.this.mapNewVisibility.keySet()) {
                                TableColumnSetupWindow.this.mapNewVisibility.put(tc, Boolean.FALSE);
                            }
                            TableColumnSetupWindow.this.tvChosen.removeAllTableRows();
                            TableColumnSetupWindow.access$602(TableColumnSetupWindow.this, defaultColumns.toArray(new TableColumnCore[0]));
                            for (int i = 0; i < TableColumnSetupWindow.this.columnsChosen.length; ++i) {
                                TableColumnSetupWindow.this.mapNewVisibility.put(TableColumnSetupWindow.this.columnsChosen[i], Boolean.TRUE);
                                TableColumnSetupWindow.this.columnsChosen[i].setPositionNoShift(i);
                                TableColumnSetupWindow.this.tvChosen.addDataSource(TableColumnSetupWindow.this.columnsChosen[i]);
                            }
                            TableColumnSetupWindow.this.doReset = true;
                        }
                    }
                }
            });
        }
        final Button btnCancel = new Button((Composite)this.shell, 8);
        Messages.setLanguageText((Widget)btnCancel, "Button.cancel");
        btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableColumnSetupWindow.this.shell.dispose();
            }
        });
        Button btnApply = new Button(cResultButtonArea, 8);
        Messages.setLanguageText((Widget)btnApply, "Button.apply");
        btnApply.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableColumnSetupWindow.this.apply();
                btnCancel.setEnabled(false);
            }
        });
        fd = new FormData();
        fd.left = new FormAttachment(0, 5);
        fd.right = new FormAttachment(100, -5);
        fd = new FormData();
        fd.top = new FormAttachment((Control)topInfo, 5);
        fd.right = new FormAttachment(100, -3);
        fd.bottom = new FormAttachment((Control)btnOk, -5);
        fd.width = 210;
        cResultArea.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment(0, 3);
        fd.left = new FormAttachment(0, 3);
        fd.right = new FormAttachment(100, -3);
        fd.bottom = new FormAttachment((Control)cResultButtonArea, -3);
        this.cTableChosen.setLayoutData((Object)fd);
        fd = new FormData();
        fd.bottom = new FormAttachment(100, 0);
        fd.left = new FormAttachment((Control)this.cTableChosen, 0, 0x1000000);
        cResultButtonArea.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment(0, 3);
        fd.left = new FormAttachment(0, 3);
        btnLeft.setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment((Control)btnLeft, 3);
        fd.top = new FormAttachment((Control)btnLeft, 0, 128);
        fd.bottom = new FormAttachment((Control)btnLeft, 0, 1024);
        btnCentre.setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment((Control)btnCentre, 3);
        fd.top = new FormAttachment((Control)btnLeft, 0, 128);
        fd.bottom = new FormAttachment((Control)btnLeft, 0, 1024);
        btnRight.setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 3);
        fd.top = new FormAttachment((Control)btnLeft, 2);
        btnUp.setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment((Control)btnUp, 3);
        fd.top = new FormAttachment((Control)btnUp, 0, 128);
        btnDown.setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment((Control)btnDown, 3);
        fd.top = new FormAttachment((Control)btnUp, 0, 128);
        btnDel.setLayoutData((Object)fd);
        if (btnReset != null) {
            fd = new FormData();
            fd.right = new FormAttachment((Control)btnApply, -3);
            fd.bottom = new FormAttachment((Control)btnApply, 0, 1024);
            btnReset.setLayoutData((Object)fd);
        }
        fd = new FormData();
        fd.right = new FormAttachment(100, -3);
        fd.top = new FormAttachment((Control)btnUp, 3, 1024);
        btnApply.setLayoutData((Object)fd);
        fd = new FormData();
        fd.right = new FormAttachment(100, -8);
        fd.bottom = new FormAttachment(100, -3);
        btnCancel.setLayoutData((Object)fd);
        fd = new FormData();
        fd.right = new FormAttachment((Control)btnCancel, -3);
        fd.bottom = new FormAttachment((Control)btnCancel, 0, 1024);
        btnOk.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment((Control)topInfo, 5);
        fd.left = new FormAttachment(0, 3);
        fd.right = new FormAttachment((Control)cResultArea, -3);
        fd.bottom = new FormAttachment(100, -3);
        this.cPickArea.setLayoutData((Object)fd);
        fd = new FormData();
        fd.bottom = new FormAttachment(100, 0);
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        expandFilters.setLayoutData((Object)fd);
        fd = new FormData();
        fd.bottom = new FormAttachment((Control)this.cCategories, 0, 0x1000000);
        fd.left = new FormAttachment(0, 5);
        lblCat.setLayoutData((Object)fd);
        fd = new FormData();
        fd.bottom = new FormAttachment((Control)this.radProficiency[0], 0, 0x1000000);
        fd.left = new FormAttachment(0, 0);
        lblProficiency.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment((Control)cProficiency, 5);
        fd.left = new FormAttachment((Control)lblCat, 5);
        fd.right = new FormAttachment(100, 0);
        this.cCategories.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment(0, 5);
        fd.left = new FormAttachment(0, 5);
        cProficiency.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment(0, 3);
        fd.left = new FormAttachment(0, 3);
        fd.right = new FormAttachment(100, -3);
        fd.bottom = new FormAttachment((Control)expandFilters, -3);
        this.cTableAvail.setLayoutData((Object)fd);
        this.shell.setTabList(new Control[]{this.cPickArea, cResultArea, btnOk, btnCancel});
        this.cPickArea.setTabList(new Control[]{this.cTableAvail});
        this.fillAvail();
        UIUpdaterSWT.getInstance().addUpdater(this);
    }

    protected void fillAvail() {
        int i;
        String selectedCat = null;
        Control[] children = this.cCategories.getChildren();
        for (i = 0; i < children.length; ++i) {
            Button btn;
            Control child = children[i];
            if (!(child instanceof Button) || !(btn = (Button)child).getSelection()) continue;
            selectedCat = (String)btn.getData("cat");
            break;
        }
        if (selectedCat != null && selectedCat.equals("all")) {
            selectedCat = null;
        }
        int selectedProf = 0;
        for (i = 0; i < this.radProficiency.length; i = (int)((byte)(i + 1))) {
            Button btn = this.radProficiency[i];
            if (!btn.getSelection()) continue;
            selectedProf = i;
            break;
        }
        String s = selectedCat != null ? MessageText.getString("ColumnSetup.availcolumns.filteredby", new String[]{this.radProficiency[selectedProf].getText(), selectedCat}) : MessageText.getString("ColumnSetup.availcolumns", new String[]{this.radProficiency[selectedProf].getText()});
        this.cPickArea.setText(s);
        this.tvAvail.removeAllTableRows();
        TableColumnManager tcm = TableColumnManager.getInstance();
        TableColumnCore[] datasources = tcm.getAllTableColumnCoreAsArray(this.forDataSourceType, this.forTableID);
        if (selectedCat == "uncat") {
            datasources = this.listColumnsNoCat.toArray(new TableColumnCore[this.listColumnsNoCat.size()]);
        }
        block2: for (int i2 = 0; i2 < datasources.length; ++i2) {
            String[] cats;
            TableColumnCore column = datasources[i2];
            TableColumnInfo info = tcm.getColumnInfo(this.forDataSourceType, this.forTableID, column.getName());
            String[] stringArray = cats = info == null ? null : info.getCategories();
            if (cats == null) {
                if (selectedCat != null && !selectedCat.equals("uncat")) continue;
                this.tvAvail.addDataSource(column);
                continue;
            }
            for (int j = 0; j < cats.length; ++j) {
                String cat = cats[j];
                if (selectedCat != null && !selectedCat.equalsIgnoreCase(cat) || info.getProficiency() > selectedProf) continue;
                this.tvAvail.addDataSource(column);
                continue block2;
            }
        }
        this.tvAvail.processDataSourceQueue();
    }

    protected void removeSelectedChosen() {
        int i;
        Object[] datasources = this.tvChosen.getSelectedDataSources().toArray();
        for (i = 0; i < datasources.length; ++i) {
            TableColumnCore column = (TableColumnCore)datasources[i];
            this.mapNewVisibility.put(column, Boolean.FALSE);
        }
        this.tvChosen.removeDataSources(datasources);
        this.tvChosen.processDataSourceQueue();
        for (i = 0; i < datasources.length; ++i) {
            TableRowSWT row = (TableRowSWT)this.tvAvail.getRow(datasources[i]);
            if (row == null) continue;
            row.redraw();
        }
    }

    protected void moveChosenDown() {
        TableRowCore[] selectedRows = this.tvChosen.getSelectedRows();
        TableRowCore[] rows = this.tvChosen.getRows();
        for (int i = selectedRows.length - 1; i >= 0; --i) {
            TableRowCore row = selectedRows[i];
            TableColumnCore column = (TableColumnCore)row.getDataSource();
            if (column == null) continue;
            int oldColumnPos = column.getPosition();
            int oldRowPos = row.getIndex();
            if (oldRowPos >= rows.length - 1) continue;
            TableRowCore displacedRow = rows[oldRowPos + 1];
            ((TableColumnCore)displacedRow.getDataSource()).setPositionNoShift(oldColumnPos);
            rows[oldRowPos + 1] = rows[oldRowPos];
            rows[oldRowPos] = displacedRow;
            column.setPositionNoShift(oldColumnPos + 1);
        }
        this.tvChosen.tableInvalidate();
        this.tvChosen.refreshTable(true);
    }

    protected void moveChosenUp() {
        TableRowCore[] selectedRows = this.tvChosen.getSelectedRows();
        TableRowCore[] rows = this.tvChosen.getRows();
        for (int i = 0; i < selectedRows.length; ++i) {
            TableRowCore row = selectedRows[i];
            TableColumnCore column = (TableColumnCore)row.getDataSource();
            if (column == null) continue;
            int oldColumnPos = column.getPosition();
            int oldRowPos = row.getIndex();
            if (oldRowPos <= 0) continue;
            TableRowCore displacedRow = rows[oldRowPos - 1];
            ((TableColumnCore)displacedRow.getDataSource()).setPositionNoShift(oldColumnPos);
            rows[oldRowPos - 1] = rows[oldRowPos];
            rows[oldRowPos] = displacedRow;
            column.setPositionNoShift(oldColumnPos - 1);
            column.setAlignment(3);
        }
        this.tvChosen.tableInvalidate();
        this.tvChosen.refreshTable(true);
    }

    protected void alignChosen(int align) {
        TableRowCore[] selectedRows = this.tvChosen.getSelectedRows();
        for (int i = 0; i < selectedRows.length; ++i) {
            TableRowCore row = selectedRows[i];
            TableColumnCore column = (TableColumnCore)row.getDataSource();
            if (column == null) continue;
            column.setAlignment(align);
        }
        this.tvChosen.tableInvalidate();
        this.tvChosen.refreshTable(true);
    }

    protected void apply() {
        for (TableColumnCore tc : this.mapNewVisibility.keySet()) {
            boolean visible = this.mapNewVisibility.get(tc);
            tc.setVisible(visible);
            if (!this.doReset) continue;
            tc.reset();
        }
        TableColumnManager.getInstance().saveTableColumns(this.forDataSourceType, this.forTableID);
        this.listener.tableStructureChanged(true, this.forDataSourceType);
    }

    private TableViewSWT<?> createTVChosen() {
        TableColumnManager tcm = TableColumnManager.getInstance();
        TableColumnCore[] columnTVChosen = tcm.getAllTableColumnCoreAsArray(TableColumn.class, TABLEID_CHOSEN);
        for (int i = 0; i < columnTVChosen.length; ++i) {
            TableColumnCore column = columnTVChosen[i];
            if (column.getName().equals("TableColumnChosenColumn")) {
                column.setVisible(true);
                column.setWidth(175);
                column.setSortAscending(true);
                continue;
            }
            column.setVisible(false);
        }
        final TableViewSWT tvChosen = TableViewFactory.createTableViewSWT(TableColumn.class, TABLEID_CHOSEN, TABLEID_CHOSEN, columnTVChosen, "TableColumnChosenColumn", 0x10010002);
        this.tvAvail.setParentDataSource(this);
        tvChosen.setMenuEnabled(false);
        tvChosen.setHeaderVisible(false);
        tvChosen.addLifeCycleListener(new TableLifeCycleListener(){
            private DragSource dragSource;
            private DropTarget dropTarget;

            public void tableViewInitialized() {
                this.dragSource = tvChosen.createDragSource(7);
                this.dragSource.setTransfer(new Transfer[]{TextTransfer.getInstance()});
                this.dragSource.setData("tv", (Object)tvChosen);
                this.dragSource.addDragListener(TableColumnSetupWindow.this.dragSourceListener);
                this.dropTarget = tvChosen.createDropTarget(31);
                this.dropTarget.setTransfer(new Transfer[]{TextTransfer.getInstance()});
                this.dropTarget.addDropListener(new DropTargetListener(){

                    public void dropAccept(DropTargetEvent event2) {
                    }

                    public void drop(DropTargetEvent event2) {
                        String id = (String)event2.data;
                        TableRowCore destRow = tvChosen.getRow(event2);
                        TableViewSWT tv = id.equals("c") ? tvChosen : TableColumnSetupWindow.this.tvAvail;
                        Object[] dataSources = tv.getSelectedDataSources().toArray();
                        for (int i = 0; i < dataSources.length; ++i) {
                            TableColumnCore column = (TableColumnCore)dataSources[i];
                            if (column == null) continue;
                            TableColumnSetupWindow.this.chooseColumn(column, destRow, true);
                            TableRowCore row = TableColumnSetupWindow.this.tvAvail.getRow(column);
                            if (row == null) continue;
                            row.redraw();
                        }
                    }

                    public void dragOver(DropTargetEvent event2) {
                    }

                    public void dragOperationChanged(DropTargetEvent event2) {
                    }

                    public void dragLeave(DropTargetEvent event2) {
                    }

                    public void dragEnter(DropTargetEvent event2) {
                    }
                });
            }

            public void tableViewDestroyed() {
                if (this.dragSource != null && !this.dragSource.isDisposed()) {
                    this.dragSource.dispose();
                }
                if (this.dropTarget != null && !this.dropTarget.isDisposed()) {
                    this.dropTarget.dispose();
                }
            }
        });
        tvChosen.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.stateMask == 0 && (e.keyCode == 0x1000003 || e.keyCode == 127)) {
                    TableColumnSetupWindow.this.removeSelectedChosen();
                    e.doit = false;
                }
                if (e.stateMask == 262144) {
                    if (e.keyCode == 0x1000001) {
                        TableColumnSetupWindow.this.moveChosenUp();
                        e.doit = false;
                    } else if (e.keyCode == 0x1000002) {
                        TableColumnSetupWindow.this.moveChosenDown();
                        e.doit = false;
                    }
                }
            }
        });
        return tvChosen;
    }

    private TableViewSWT<?> createTVAvail() {
        TableColumnCore[] columns;
        TableColumnManager tcm = TableColumnManager.getInstance();
        Map<String, TableColumnCore> mapColumns = tcm.getTableColumnsAsMap(TableColumn.class, TABLEID_AVAIL);
        int[] widths = new int[]{405, 105};
        if (this.sampleRow == null) {
            columns = new TableColumnCore[]{mapColumns.get("TableColumnNameInfo")};
            widths = new int[]{510};
        } else {
            columns = new TableColumnCore[]{mapColumns.get("TableColumnNameInfo"), mapColumns.get("TableColumnSample")};
        }
        for (int i = 0; i < columns.length; ++i) {
            TableColumnCore column = columns[i];
            if (column == null) continue;
            column.setVisible(true);
            column.setPositionNoShift(i);
            column.setWidth(widths[i]);
        }
        final TableViewSWT tvAvail = TableViewFactory.createTableViewSWT(TableColumn.class, TABLEID_AVAIL, TABLEID_AVAIL, columns, "TableColumnNameInfo", 0x10010004);
        tvAvail.setParentDataSource(this);
        tvAvail.setMenuEnabled(false);
        tvAvail.setRowDefaultHeight(65);
        tvAvail.addLifeCycleListener(new TableLifeCycleListener(){
            private DragSource dragSource;
            private DropTarget dropTarget;

            public void tableViewInitialized() {
                this.dragSource = tvAvail.createDragSource(7);
                this.dragSource.setTransfer(new Transfer[]{TextTransfer.getInstance()});
                this.dragSource.setData("tv", (Object)tvAvail);
                this.dragSource.addDragListener(TableColumnSetupWindow.this.dragSourceListener);
                this.dropTarget = tvAvail.createDropTarget(31);
                this.dropTarget.setTransfer(new Transfer[]{TextTransfer.getInstance()});
                this.dropTarget.addDropListener((DropTargetListener)new DropTargetAdapter(){

                    public void drop(DropTargetEvent event2) {
                        String id = (String)event2.data;
                        if (!id.equals("c")) {
                            return;
                        }
                        TableColumnSetupWindow.this.removeSelectedChosen();
                    }
                });
            }

            public void tableViewDestroyed() {
                if (this.dragSource != null && !this.dragSource.isDisposed()) {
                    this.dragSource.dispose();
                }
                if (this.dropTarget != null && !this.dropTarget.isDisposed()) {
                    this.dropTarget.dispose();
                }
            }
        });
        tvAvail.addSelectionListener(new TableSelectionAdapter(){

            public void defaultSelected(TableRowCore[] rows, int stateMask) {
                for (int i = 0; i < rows.length; ++i) {
                    TableRowCore row = rows[i];
                    TableColumnCore column = (TableColumnCore)row.getDataSource();
                    TableColumnSetupWindow.this.chooseColumn(column, null, false);
                }
            }
        }, false);
        tvAvail.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.stateMask == 0) {
                    if (e.keyCode == 0x1000004) {
                        TableRowCore[] selectedRows = tvAvail.getSelectedRows();
                        for (int i = 0; i < selectedRows.length; ++i) {
                            TableRowCore row = selectedRows[i];
                            TableColumnCore column = (TableColumnCore)row.getDataSource();
                            TableColumnSetupWindow.this.chooseColumn(column, null, false);
                            TableColumnSetupWindow.this.tvChosen.processDataSourceQueue();
                            row.redraw();
                        }
                        e.doit = false;
                    } else if (e.keyCode == 0x1000003) {
                        TableRowCore[] selectedRows = tvAvail.getSelectedRows();
                        for (int i = 0; i < selectedRows.length; ++i) {
                            TableRowCore row = selectedRows[i];
                            TableColumnCore column = (TableColumnCore)row.getDataSource();
                            TableColumnSetupWindow.this.mapNewVisibility.put(column, Boolean.FALSE);
                            TableColumnSetupWindow.this.tvChosen.removeDataSource(column);
                            TableColumnSetupWindow.this.tvChosen.processDataSourceQueue();
                            row.redraw();
                        }
                        e.doit = false;
                    }
                }
            }
        });
        return tvAvail;
    }

    public void open() {
        this.shell.open();
    }

    @Override
    public String getUpdateUIName() {
        return null;
    }

    @Override
    public void updateUI() {
        if (this.shell.isDisposed()) {
            UIUpdaterSWT.getInstance().removeUpdater(this);
            return;
        }
        if (this.tvAvail != null && !this.tvAvail.isDisposed()) {
            this.tvAvail.refreshTable(false);
        }
        if (this.tvChosen != null && !this.tvChosen.isDisposed()) {
            this.tvChosen.refreshTable(false);
        }
    }

    public TableRow getSampleRow() {
        return this.sampleRow;
    }

    public void chooseColumn(TableColumnCore column) {
        this.chooseColumn(column, null, false);
        TableRowCore row = this.tvAvail.getRow(column);
        if (row != null) {
            row.redraw();
        }
    }

    public boolean isColumnAdded(TableColumnCore column) {
        if (this.tvChosen == null) {
            return false;
        }
        TableRowCore row = this.tvChosen.getRow(column);
        return row != null;
    }

    public void chooseColumn(final TableColumnCore column, TableRowCore placeAboveRow, boolean ignoreExisting) {
        TableRowCore row = this.tvChosen.getRow(column);
        if (row == null || ignoreExisting) {
            int oldPosition;
            int newPosition = 0;
            TableRowCore tableRowCore = row = placeAboveRow == null && !ignoreExisting ? this.tvChosen.getFocusedRow() : placeAboveRow;
            if (row == null || row.getDataSource() == null) {
                if (this.columnsChosen.length > 0) {
                    newPosition = this.columnsChosen.length;
                }
            } else {
                newPosition = ((TableColumn)row.getDataSource()).getPosition();
            }
            final boolean shiftDir = (oldPosition = column.getPosition()) > newPosition || this.mapNewVisibility.get(column) == false;
            column.setPositionNoShift(newPosition);
            this.mapNewVisibility.put(column, Boolean.TRUE);
            for (int i = 0; i < 10; ++i) {
                try {
                    Arrays.sort(this.columnsChosen, new Comparator(){

                        public int compare(Object arg0, Object arg1) {
                            if (arg1 instanceof TableColumn && arg0 instanceof TableColumn) {
                                int i;
                                int iPositionB;
                                int iPositionA = ((TableColumn)arg0).getPosition();
                                if (iPositionA < 0) {
                                    iPositionA = 65535 + iPositionA;
                                }
                                if ((iPositionB = ((TableColumn)arg1).getPosition()) < 0) {
                                    iPositionB = 65535 + iPositionB;
                                }
                                if ((i = iPositionA - iPositionB) == 0) {
                                    if (column == arg0) {
                                        return shiftDir ? -1 : 1;
                                    }
                                    return shiftDir ? 1 : -1;
                                }
                                return i;
                            }
                            return 0;
                        }
                    });
                    break;
                }
                catch (Throwable e) {
                    continue;
                }
            }
            int pos = 0;
            for (int i = 0; i < this.columnsChosen.length; ++i) {
                if (!this.mapNewVisibility.get(this.columnsChosen[i]).booleanValue()) continue;
                this.columnsChosen[i].setPositionNoShift(pos++);
            }
            TableRowCore existingRow = this.tvChosen.getRow(column);
            if (existingRow == null) {
                this.tvChosen.addDataSource(column);
                this.tvChosen.processDataSourceQueue();
                this.tvChosen.addCountChangeListener(new TableCountChangeListener(){

                    public void rowRemoved(TableRowCore row) {
                    }

                    public void rowAdded(final TableRowCore row) {
                        Utils.execSWTThreadLater(500, new AERunnable(){

                            public void runSupport() {
                                TableColumnSetupWindow.this.tvChosen.setSelectedRows(new TableRowCore[]{row});
                                TableColumnSetupWindow.this.tvChosen.showRow(row);
                            }
                        });
                        TableColumnSetupWindow.this.tvChosen.removeCountChangeListener(this);
                    }
                });
            }
            Arrays.sort(this.columnsChosen, TableColumnManager.getTableColumnOrderComparator());
            this.tvChosen.tableInvalidate();
            this.tvChosen.refreshTable(true);
        } else {
            row.setSelected(true);
        }
    }

    private void close() {
        if (this.apply) {
            this.apply();
        } else {
            for (int i = 0; i < this.columnsOriginalOrder.length; ++i) {
                TableColumnCore column = this.columnsOriginalOrder[i];
                if (column == null) continue;
                column.setPositionNoShift(i);
            }
        }
    }

    static /* synthetic */ TableColumnCore[] access$602(TableColumnSetupWindow x0, TableColumnCore[] x1) {
        x0.columnsChosen = x1;
        return x1;
    }
}

