/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.configsections;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.LocaleUtil;
import org.gudy.azureus2.core3.internat.LocaleUtilDecoder;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.config.BooleanParameter;
import org.gudy.azureus2.ui.swt.config.StringListParameter;
import org.gudy.azureus2.ui.swt.plugins.UISWTConfigSection;

public class ConfigSectionFileTorrentsDecoding
implements UISWTConfigSection {
    private static final int REQUIRED_MODE = 2;

    public String configSectionGetParentSection() {
        return "torrents";
    }

    public int maxUserMode() {
        return 2;
    }

    public String configSectionGetName() {
        return "torrent.decoding";
    }

    public void configSectionSave() {
    }

    public void configSectionDelete() {
    }

    public Composite configSectionCreate(Composite parent) {
        Composite cSection = new Composite(parent, 0);
        GridData gridData = new GridData(272);
        cSection.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        cSection.setLayout((Layout)layout);
        int userMode = COConfigurationManager.getIntParameter("User Mode");
        if (userMode < 2) {
            Label label = new Label(cSection, 64);
            gridData = new GridData();
            label.setLayoutData((Object)gridData);
            String[] modeKeys = new String[]{"ConfigView.section.mode.beginner", "ConfigView.section.mode.intermediate", "ConfigView.section.mode.advanced"};
            String param1 = 2 < modeKeys.length ? MessageText.getString(modeKeys[2]) : String.valueOf(2);
            String param2 = userMode < modeKeys.length ? MessageText.getString(modeKeys[userMode]) : String.valueOf(userMode);
            label.setText(MessageText.getString("ConfigView.notAvailableForMode", new String[]{param1, param2}));
            return cSection;
        }
        Label label = new Label(cSection, 0);
        Messages.setLanguageText((Widget)label, "ConfigView.section.file.decoder.label");
        LocaleUtilDecoder[] decoders = LocaleUtil.getSingleton().getDecoders();
        String[] decoderLabels = new String[decoders.length + 1];
        String[] decoderValues = new String[decoders.length + 1];
        decoderLabels[0] = MessageText.getString("ConfigView.section.file.decoder.nodecoder");
        decoderValues[0] = "";
        for (int i = 1; i <= decoders.length; ++i) {
            decoderLabels[i] = decoderValues[i] = decoders[i - 1].getName();
        }
        new StringListParameter(cSection, "File.Decoder.Default", "", decoderLabels, decoderValues);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        new BooleanParameter(cSection, "File.Decoder.Prompt", "ConfigView.section.file.decoder.prompt").setLayoutData(gridData);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        new BooleanParameter(cSection, "File.Decoder.ShowLax", "ConfigView.section.file.decoder.showlax").setLayoutData(gridData);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        new BooleanParameter(cSection, "File.Decoder.ShowAll", "ConfigView.section.file.decoder.showall").setLayoutData(gridData);
        return cSection;
    }
}

