/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.configsections;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AEJavaManagement;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.platform.PlatformManager;
import org.gudy.azureus2.platform.PlatformManagerCapabilities;
import org.gudy.azureus2.platform.PlatformManagerFactory;
import org.gudy.azureus2.plugins.platform.PlatformManagerException;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.components.LinkLabel;
import org.gudy.azureus2.ui.swt.config.BooleanParameter;
import org.gudy.azureus2.ui.swt.config.FileParameter;
import org.gudy.azureus2.ui.swt.config.Parameter;
import org.gudy.azureus2.ui.swt.config.ParameterChangeAdapter;
import org.gudy.azureus2.ui.swt.config.StringListParameter;
import org.gudy.azureus2.ui.swt.config.StringParameter;
import org.gudy.azureus2.ui.swt.plugins.UISWTConfigSection;
import org.gudy.azureus2.ui.swt.shells.MessageBoxShell;
import org.gudy.azureus2.ui.swt.views.utils.ManagerUtils;

public class ConfigSectionStartShutdown
implements UISWTConfigSection {
    private static final String LBLKEY_PREFIX = "ConfigView.label.";

    public String configSectionGetParentSection() {
        return "root";
    }

    public String configSectionGetName() {
        return "startstop";
    }

    public void configSectionSave() {
    }

    public void configSectionDelete() {
    }

    public int maxUserMode() {
        return 1;
    }

    public Composite configSectionCreate(Composite parent) {
        Label label;
        final Composite cDisplay = new Composite(parent, 0);
        GridData gridData = new GridData(272);
        cDisplay.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        cDisplay.setLayout((Layout)layout);
        final PlatformManager platform = PlatformManagerFactory.getPlatformManager();
        int userMode = COConfigurationManager.getIntParameter("User Mode");
        boolean can_ral = platform.hasCapability(PlatformManagerCapabilities.RunAtLogin);
        if (can_ral || userMode > 0) {
            Group gStartStop = new Group(cDisplay, 0);
            Messages.setLanguageText((Widget)gStartStop, "ConfigView.label.start");
            layout = new GridLayout(2, false);
            gStartStop.setLayout((Layout)layout);
            gStartStop.setLayoutData((Object)new GridData(768));
            if (can_ral) {
                gridData = new GridData();
                gridData.horizontalSpan = 2;
                BooleanParameter start_on_login = new BooleanParameter((Composite)gStartStop, "Start On Login", "ConfigView.label.start.onlogin");
                try {
                    start_on_login.setSelected(platform.getRunAtLogin());
                    start_on_login.addChangeListener(new ParameterChangeAdapter(){

                        public void booleanParameterChanging(Parameter p, boolean toValue) {
                            try {
                                platform.setRunAtLogin(toValue);
                            }
                            catch (Throwable e) {
                                Debug.out(e);
                            }
                        }
                    });
                }
                catch (Throwable e) {
                    start_on_login.setEnabled(false);
                    Debug.out(e);
                }
                start_on_login.setLayoutData(gridData);
            }
            if (userMode > 0) {
                gridData = new GridData();
                gridData.horizontalSpan = 2;
                BooleanParameter start_in_lr_mode = new BooleanParameter((Composite)gStartStop, "Start In Low Resource Mode", "ConfigView.label.start.inlrm");
                start_in_lr_mode.setLayoutData(gridData);
            }
        }
        if (platform.hasCapability(PlatformManagerCapabilities.PreventComputerSleep)) {
            Group gSleep = new Group(cDisplay, 0);
            Messages.setLanguageText((Widget)gSleep, "ConfigView.label.sleep");
            layout = new GridLayout(2, false);
            gSleep.setLayout((Layout)layout);
            gSleep.setLayoutData((Object)new GridData(768));
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            label = new Label((Composite)gSleep, 0);
            Messages.setLanguageText((Widget)label, "ConfigView.label.sleep.info");
            label.setLayoutData((Object)gridData);
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            BooleanParameter no_sleep_dl = new BooleanParameter((Composite)gSleep, "Prevent Sleep Downloading", "ConfigView.label.sleep.download");
            no_sleep_dl.setLayoutData(gridData);
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            BooleanParameter no_sleep_se = new BooleanParameter((Composite)gSleep, "Prevent Sleep FP Seeding", "ConfigView.label.sleep.fpseed");
            no_sleep_se.setLayoutData(gridData);
        }
        if (userMode > 0) {
            Group gPR = new Group(cDisplay, 0);
            Messages.setLanguageText((Widget)gPR, "ConfigView.label.pauseresume");
            layout = new GridLayout(2, false);
            gPR.setLayout((Layout)layout);
            gPR.setLayoutData((Object)new GridData(768));
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            BooleanParameter pauseOnExit = new BooleanParameter((Composite)gPR, "Pause Downloads On Exit", "ConfigView.label.pause.downloads.on.exit");
            pauseOnExit.setLayoutData(gridData);
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            BooleanParameter resumeOnStart = new BooleanParameter((Composite)gPR, "Resume Downloads On Start", "ConfigView.label.resume.downloads.on.start");
            resumeOnStart.setLayoutData(gridData);
        }
        if (userMode >= 0) {
            String[] action_values;
            Group gStop = new Group(cDisplay, 0);
            Messages.setLanguageText((Widget)gStop, "ConfigView.label.stop");
            layout = new GridLayout(5, false);
            gStop.setLayout((Layout)layout);
            gStop.setLayoutData((Object)new GridData(768));
            gridData = new GridData();
            label = new Label((Composite)gStop, 0);
            Messages.setLanguageText((Widget)label, "ConfigView.label.stop.downcomp");
            label.setLayoutData((Object)gridData);
            int shutdown_types = platform.getShutdownTypes();
            ArrayList<String> l_action_values = new ArrayList<String>();
            ArrayList<String> l_action_descs = new ArrayList<String>();
            l_action_values.add("Nothing");
            l_action_values.add("QuitVuze");
            if ((shutdown_types & 4) != 0) {
                l_action_values.add("Sleep");
            }
            if ((shutdown_types & 2) != 0) {
                l_action_values.add("Hibernate");
            }
            if ((shutdown_types & 1) != 0) {
                l_action_values.add("Shutdown");
            }
            l_action_values.add("RunScript");
            l_action_values.add("RunScriptAndClose");
            for (String s : action_values = l_action_values.toArray(new String[l_action_values.size()])) {
                l_action_descs.add(MessageText.getString("ConfigView.label.stop." + s));
            }
            String[] action_descs = l_action_descs.toArray(new String[l_action_descs.size()]);
            final StringListParameter dc = new StringListParameter((Composite)gStop, "On Downloading Complete Do", "Nothing", action_descs, action_values);
            final Label dc_label = new Label((Composite)gStop, 0);
            Messages.setLanguageText((Widget)dc_label, "label.script.to.run");
            dc_label.setLayoutData((Object)new GridData());
            gridData = new GridData(768);
            final FileParameter dc_script = new FileParameter((Composite)gStop, "On Downloading Complete Script", "", new String[0]);
            dc_script.setLayoutData(gridData);
            boolean is_script = dc.getValue().startsWith("RunScript");
            dc_label.setEnabled(is_script);
            dc_script.setEnabled(is_script);
            dc.addChangeListener(new ParameterChangeAdapter(){

                public void parameterChanged(Parameter p, boolean caused_internally) {
                    boolean is_script = dc.getValue().startsWith("RunScript");
                    dc_label.setEnabled(is_script);
                    dc_script.setEnabled(is_script);
                }
            });
            gridData = new GridData();
            label = new Label((Composite)gStop, 0);
            Messages.setLanguageText((Widget)label, "ConfigView.label.stop.seedcomp");
            label.setLayoutData((Object)gridData);
            final StringListParameter sc = new StringListParameter((Composite)gStop, "On Seeding Complete Do", "Nothing", action_descs, action_values);
            final Label sc_label = new Label((Composite)gStop, 0);
            Messages.setLanguageText((Widget)sc_label, "label.script.to.run");
            sc_label.setLayoutData((Object)new GridData());
            gridData = new GridData(768);
            final FileParameter sc_script = new FileParameter((Composite)gStop, "On Seeding Complete Script", "", new String[0]);
            sc_script.setLayoutData(gridData);
            is_script = sc.getValue().startsWith("RunScript");
            sc_label.setEnabled(is_script);
            sc_script.setEnabled(is_script);
            sc.addChangeListener(new ParameterChangeAdapter(){

                public void parameterChanged(Parameter p, boolean caused_internally) {
                    boolean is_script = sc.getValue().startsWith("RunScript");
                    sc_label.setEnabled(is_script);
                    sc_script.setEnabled(is_script);
                }
            });
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            BooleanParameter resetOnTrigger = new BooleanParameter((Composite)gStop, "Stop Triggers Auto Reset", "!" + MessageText.getString("ConfigView.label.stop.autoreset", new String[]{MessageText.getString("ConfigView.label.stop.Nothing")}) + "!");
            resetOnTrigger.setLayoutData(gridData);
        }
        if (userMode > 0 && platform.hasCapability(PlatformManagerCapabilities.AccessExplicitVMOptions)) {
            Group gJVM = new Group(cDisplay, 0);
            Messages.setLanguageText((Widget)gJVM, "ConfigView.label.jvm");
            layout = new GridLayout(2, false);
            gJVM.setLayout((Layout)layout);
            gJVM.setLayoutData((Object)new GridData(768));
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            LinkLabel link = new LinkLabel((Composite)gJVM, gridData, "ConfigView.label.please.visit.here", "http://wiki.vuze.com/w/Java_VM_memory_usage");
            label = new Label((Composite)gJVM, 0);
            Messages.setLanguageText((Widget)label, "jvm.info");
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            label.setLayoutData((Object)gridData);
            try {
                final File option_file = platform.getVMOptionFile();
                final Group gJVMOptions = new Group((Composite)gJVM, 0);
                layout = new GridLayout(3, false);
                gJVMOptions.setLayout((Layout)layout);
                gridData = new GridData(768);
                gridData.horizontalSpan = 2;
                gJVMOptions.setLayoutData((Object)gridData);
                this.buildOptions(cDisplay, platform, (Composite)gJVMOptions, false);
                label = new Label((Composite)gJVM, 0);
                Messages.setLanguageText((Widget)label, "jvm.show.file", new String[]{option_file.getAbsolutePath()});
                Button show_folder_button = new Button((Composite)gJVM, 8);
                Messages.setLanguageText((Widget)show_folder_button, "MyTorrentsView.menu.explore");
                show_folder_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ManagerUtils.open(option_file);
                    }
                });
                label = new Label((Composite)gJVM, 0);
                Messages.setLanguageText((Widget)label, "jvm.reset");
                Button reset_button = new Button((Composite)gJVM, 8);
                Messages.setLanguageText((Widget)reset_button, "Button.reset");
                reset_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event2) {
                        try {
                            platform.setExplicitVMOptions(new String[0]);
                            ConfigSectionStartShutdown.this.buildOptions(cDisplay, platform, (Composite)gJVMOptions, true);
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                });
            }
            catch (Throwable e) {
                Debug.out(e);
                label = new Label((Composite)gJVM, 0);
                Messages.setLanguageText((Widget)label, "jvm.error", new String[]{Debug.getNestedExceptionMessage(e)});
                gridData = new GridData();
                gridData.horizontalSpan = 2;
                label.setLayoutData((Object)gridData);
            }
        }
        return cDisplay;
    }

    private void buildOptions(final Composite parent, final PlatformManager platform, final Composite area, boolean rebuild) throws PlatformManagerException {
        if (rebuild) {
            Control[] kids;
            for (Control k : kids = area.getChildren()) {
                k.dispose();
            }
        }
        String[] options = platform.getExplicitVMOptions();
        long max_mem = AEJavaManagement.getJVMLongOption(options, "-Xmx");
        int MIN_MAX_JVM = 0x2000000;
        GridData gridData = new GridData();
        Label label = new Label(area, 0);
        label.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)label, "jvm.max.mem", new String[]{ConfigSectionStartShutdown.encodeDisplayLong(0x2000000L)});
        gridData = new GridData();
        gridData.widthHint = 125;
        final StringParameter max_vm = new StringParameter(area, "jvm.max.mem", "", false);
        max_vm.setLayoutData(gridData);
        max_vm.setValue(max_mem == -1L ? "" : ConfigSectionStartShutdown.encodeDisplayLong(max_mem));
        max_vm.addChangeListener(new ParameterChangeAdapter(){
            private String last_value;

            public void parameterChanged(Parameter p, boolean caused_internally) {
                if (max_vm.isDisposed()) {
                    max_vm.removeChangeListener(this);
                    return;
                }
                String val = max_vm.getValue();
                if (this.last_value != null && this.last_value.equals(val)) {
                    return;
                }
                this.last_value = val;
                try {
                    long max_mem = ConfigSectionStartShutdown.decodeDisplayLong(val);
                    if (max_mem < 0x2000000L) {
                        throw new Exception("Min=" + ConfigSectionStartShutdown.encodeDisplayLong(0x2000000L));
                    }
                    String[] options = platform.getExplicitVMOptions();
                    long min_mem = AEJavaManagement.getJVMLongOption(options = AEJavaManagement.setJVMLongOption(options, "-Xmx", max_mem), "-Xms");
                    if (min_mem == -1L || min_mem > max_mem) {
                        options = AEJavaManagement.setJVMLongOption(options, "-Xms", max_mem);
                    }
                    platform.setExplicitVMOptions(options);
                    ConfigSectionStartShutdown.this.buildOptions(parent, platform, area, true);
                }
                catch (Throwable e) {
                    String param_name = MessageText.getString("jvm.max.mem");
                    int pos = param_name.indexOf(91);
                    if (pos != -1) {
                        param_name = param_name.substring(0, pos).trim();
                    }
                    MessageBoxShell mb = new MessageBoxShell(33, MessageText.getString("ConfigView.section.invalid.value.title"), MessageText.getString("ConfigView.section.invalid.value", new String[]{val, param_name, Debug.getNestedExceptionMessage(e)}));
                    mb.setParent(parent.getShell());
                    mb.open(null);
                }
            }
        });
        label = new Label(area, 0);
        gridData = new GridData(768);
        label.setLayoutData((Object)gridData);
        Long max_heap_mb = AEJavaManagement.getMaxHeapMB();
        if (max_heap_mb > 0L) {
            Messages.setLanguageText((Widget)label, "jvm.max.mem.current", new String[]{DisplayFormatters.formatByteCountToKiBEtc(max_heap_mb * 1024L * 1024L, true)});
        }
        int MIN_MIN_JVM = 0x800000;
        long min_mem = AEJavaManagement.getJVMLongOption(options, "-Xms");
        gridData = new GridData();
        label = new Label(area, 0);
        label.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)label, "jvm.min.mem", new String[]{ConfigSectionStartShutdown.encodeDisplayLong(0x800000L)});
        gridData = new GridData();
        gridData.widthHint = 125;
        final StringParameter min_vm = new StringParameter(area, "jvm.min.mem", "", false);
        min_vm.setLayoutData(gridData);
        min_vm.setValue(min_mem == -1L ? "" : ConfigSectionStartShutdown.encodeDisplayLong(min_mem));
        min_vm.addChangeListener(new ParameterChangeAdapter(){
            private String last_value;

            public void parameterChanged(Parameter p, boolean caused_internally) {
                if (min_vm.isDisposed()) {
                    min_vm.removeChangeListener(this);
                    return;
                }
                String val = min_vm.getValue();
                if (this.last_value != null && this.last_value.equals(val)) {
                    return;
                }
                this.last_value = val;
                try {
                    long min_mem = ConfigSectionStartShutdown.decodeDisplayLong(val);
                    if (min_mem < 0x800000L) {
                        throw new Exception("Min=" + ConfigSectionStartShutdown.encodeDisplayLong(0x800000L));
                    }
                    String[] options = platform.getExplicitVMOptions();
                    long max_mem = AEJavaManagement.getJVMLongOption(options = AEJavaManagement.setJVMLongOption(options, "-Xms", min_mem), "-Xmx");
                    if (max_mem == -1L || max_mem < min_mem) {
                        options = AEJavaManagement.setJVMLongOption(options, "-Xmx", min_mem);
                    }
                    platform.setExplicitVMOptions(options);
                    ConfigSectionStartShutdown.this.buildOptions(parent, platform, area, true);
                }
                catch (Throwable e) {
                    String param_name = MessageText.getString("jvm.min.mem");
                    int pos = param_name.indexOf(91);
                    if (pos != -1) {
                        param_name = param_name.substring(0, pos).trim();
                    }
                    MessageBoxShell mb = new MessageBoxShell(33, MessageText.getString("ConfigView.section.invalid.value.title"), MessageText.getString("ConfigView.section.invalid.value", new String[]{val, param_name, Debug.getNestedExceptionMessage(e)}));
                    mb.setParent(parent.getShell());
                    mb.open(null);
                }
            }
        });
        label = new Label(area, 0);
        gridData = new GridData(768);
        label.setLayoutData((Object)gridData);
        int MIN_DIRECT_JVM = 0x2000000;
        String OPTION_KEY = "-XX:MaxDirectMemorySize=";
        long max_direct = AEJavaManagement.getJVMLongOption(options, "-XX:MaxDirectMemorySize=");
        GridData gridData2 = new GridData();
        Label label2 = new Label(area, 0);
        label2.setLayoutData((Object)gridData2);
        Messages.setLanguageText((Widget)label2, "jvm.max.direct.mem", new String[]{ConfigSectionStartShutdown.encodeDisplayLong(0x2000000L)});
        gridData2 = new GridData();
        gridData2.widthHint = 125;
        final StringParameter max_direct_vm = new StringParameter(area, "jvm.max.direct.mem", "", false);
        max_direct_vm.setLayoutData(gridData2);
        max_direct_vm.setValue(max_direct == -1L ? "" : ConfigSectionStartShutdown.encodeDisplayLong(max_direct));
        max_direct_vm.addChangeListener(new ParameterChangeAdapter(){
            private String last_value;

            public void parameterChanged(Parameter p, boolean caused_internally) {
                if (max_direct_vm.isDisposed()) {
                    max_direct_vm.removeChangeListener(this);
                    return;
                }
                String val = max_direct_vm.getValue();
                if (this.last_value != null && this.last_value.equals(val)) {
                    return;
                }
                this.last_value = val;
                try {
                    long max_direct = ConfigSectionStartShutdown.decodeDisplayLong(val);
                    if (max_direct < 0x2000000L) {
                        throw new Exception("Min=" + ConfigSectionStartShutdown.encodeDisplayLong(0x2000000L));
                    }
                    String[] options = platform.getExplicitVMOptions();
                    options = AEJavaManagement.setJVMLongOption(options, "-XX:MaxDirectMemorySize=", max_direct);
                    platform.setExplicitVMOptions(options);
                    ConfigSectionStartShutdown.this.buildOptions(parent, platform, area, true);
                }
                catch (Throwable e) {
                    String param_name = MessageText.getString("jvm.max.direct.mem");
                    int pos = param_name.indexOf(91);
                    if (pos != -1) {
                        param_name = param_name.substring(0, pos).trim();
                    }
                    MessageBoxShell mb = new MessageBoxShell(33, MessageText.getString("ConfigView.section.invalid.value.title"), MessageText.getString("ConfigView.section.invalid.value", new String[]{val, param_name, Debug.getNestedExceptionMessage(e)}));
                    mb.setParent(parent.getShell());
                    mb.open(null);
                }
            }
        });
        label2 = new Label(area, 0);
        gridData2 = new GridData(768);
        label2.setLayoutData((Object)gridData2);
        Messages.setLanguageText((Widget)label2, "jvm.max.direct.mem.info");
        Label label3 = new Label(area, 0);
        GridData gridData3 = new GridData(768);
        gridData3.horizontalSpan = 3;
        label3.setLayoutData((Object)gridData3);
        Messages.setLanguageText((Widget)label3, "jvm.options.summary");
        for (String option : options) {
            label3 = new Label(area, 0);
            label3.setText(option);
            gridData3 = new GridData();
            gridData3.horizontalSpan = 3;
            gridData3.horizontalIndent = 20;
            label3.setLayoutData((Object)gridData3);
        }
        if (rebuild) {
            parent.layout(true, true);
        }
    }

    private static String encodeDisplayLong(long val) {
        if (val < 1024L) {
            return String.valueOf(val);
        }
        if ((val /= 1024L) < 1024L) {
            return String.valueOf(val) + " KB";
        }
        if ((val /= 1024L) < 1024L) {
            return String.valueOf(val) + " MB";
        }
        return String.valueOf(val /= 1024L) + " GB";
    }

    private static long decodeDisplayLong(String val) throws Exception {
        char[] chars = val.trim().toCharArray();
        String digits = "";
        String units = "";
        for (char c : chars) {
            if (Character.isDigit(c)) {
                if (units.length() > 0) {
                    throw new Exception("Invalid unit");
                }
                digits = digits + c;
                continue;
            }
            if (digits.length() == 0) {
                throw new Exception("Missing digits");
            }
            if (units.length() == 0 && Character.isWhitespace(c)) continue;
            units = units + c;
        }
        long value = Long.parseLong(digits);
        if (units.length() == 0) {
            units = "m";
        }
        if (units.length() > 0) {
            char c = Character.toLowerCase(units.charAt(0));
            if (c == 'k') {
                value *= 1024L;
            } else if (c == 'm') {
                value = value * 1024L * 1024L;
            } else if (c == 'g') {
                value = value * 1024L * 1024L * 1024L;
            } else {
                throw new Exception("Invalid size unit '" + units + "'");
            }
        }
        return value;
    }
}

