/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.stats;

import com.aelitis.azureus.core.networkmanager.admin.NetworkAdmin;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import java.util.ArrayList;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.plugins.UISWTInstance;
import org.gudy.azureus2.ui.swt.plugins.UISWTView;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEvent;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEventListener;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewCore;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewCoreEventListener;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewImpl;
import org.gudy.azureus2.ui.swt.views.IViewAlwaysInitialize;
import org.gudy.azureus2.ui.swt.views.stats.ActivityView;
import org.gudy.azureus2.ui.swt.views.stats.CacheView;
import org.gudy.azureus2.ui.swt.views.stats.DHTOpsView;
import org.gudy.azureus2.ui.swt.views.stats.DHTView;
import org.gudy.azureus2.ui.swt.views.stats.TagStatsView;
import org.gudy.azureus2.ui.swt.views.stats.TransferStatsView;
import org.gudy.azureus2.ui.swt.views.stats.VivaldiView;

public class StatsView
implements IViewAlwaysInitialize,
UISWTViewCoreEventListener {
    public static String VIEW_ID = "StatsView";
    public static final int EVENT_PERIODIC_UPDATE = 256;
    private CTabFolder folder;
    private ArrayList<UISWTViewCore> tabViews = new ArrayList();
    private UpdateThread updateThread;
    private Object dataSource;
    private UISWTViewCore activeView;
    private UISWTView swtView;
    private Composite parent;
    private static boolean registeredCoreSubViews;

    private void initialize(Composite composite) {
        this.parent = composite;
        this.folder = new CTabFolder(composite, 16384);
        this.folder.setBorderVisible(true);
        Label lblClose = new Label((Composite)this.folder, 64);
        lblClose.setText("x");
        lblClose.addListener(4, new Listener(){

            public void handleEvent(Event event2) {
                StatsView.this.delete();
            }
        });
        this.folder.setTopRight((Control)lblClose);
        this.folder.setTabHeight(20);
        UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
        if (uiFunctions != null) {
            UISWTInstance pluginUI = uiFunctions.getUISWTInstance();
            if (pluginUI != null && !registeredCoreSubViews) {
                pluginUI.addView("StatsView", "SpeedView", ActivityView.class, null);
                pluginUI.addView("StatsView", "TransferStatsView", TransferStatsView.class, null);
                pluginUI.addView("StatsView", "CacheView", CacheView.class, null);
                pluginUI.addView("StatsView", "DHTView", DHTView.class, 0);
                pluginUI.addView("StatsView", "DHTOpsView", DHTOpsView.class, 0);
                pluginUI.addView("StatsView", "VivaldiView", VivaldiView.class, 0);
                if (NetworkAdmin.getSingleton().hasDHTIPV6()) {
                    pluginUI.addView("StatsView", "DHTView.6", DHTView.class, 3);
                    pluginUI.addView("StatsView", "VivaldiView.6", VivaldiView.class, 3);
                }
                if (Constants.isCVSVersion()) {
                    pluginUI.addView("StatsView", "DHTView.cvs", DHTView.class, 1);
                    pluginUI.addView("StatsView", "VivaldiView.cvs", VivaldiView.class, 1);
                }
                pluginUI.addView("StatsView", "TagStatsView", TagStatsView.class, null);
                registeredCoreSubViews = true;
            }
            if (pluginUI != null) {
                UISWTInstance.UISWTViewEventListenerWrapper[] pluginViews = pluginUI.getViewListeners("StatsView");
                for (int i = 0; i < pluginViews.length; ++i) {
                    UISWTInstance.UISWTViewEventListenerWrapper l = pluginViews[i];
                    String name = l.getViewID();
                    try {
                        UISWTViewImpl view = new UISWTViewImpl("StatsView", name, l, null);
                        this.addSection(view, name);
                        continue;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        }
        this.folder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CTabItem item = (CTabItem)e.item;
                StatsView.this.selectView(item);
            }
        });
        Utils.execSWTThreadLater(0, new AERunnable(){

            public void runSupport() {
                if (StatsView.this.folder == null || StatsView.this.folder.isDisposed() || StatsView.this.folder.getItemCount() == 0) {
                    return;
                }
                if (StatsView.this.dataSource != null) {
                    for (CTabItem item : StatsView.this.folder.getItems()) {
                        String ds = (String)item.getData("ds");
                        if (!StatsView.this.dataSource.equals(ds)) continue;
                        StatsView.this.selectView(item);
                        return;
                    }
                }
                StatsView.this.selectView(StatsView.this.folder.getItem(0));
            }
        });
        this.updateThread = new UpdateThread();
        this.updateThread.setDaemon(true);
        this.updateThread.start();
        this.dataSourceChanged(this.dataSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void selectView(CTabItem item) {
        if (item == null) {
            return;
        }
        if (this.folder.getSelection() != item) {
            this.folder.setSelection(item);
        }
        this.folder.getShell().setCursor(this.folder.getDisplay().getSystemCursor(1));
        try {
            try {
                this.refresh();
                Object ds = item.getData("ds");
                if (ds == null) {
                    ds = this.dataSource;
                } else {
                    this.dataSource = ds;
                }
                UISWTViewCore view = (UISWTViewCore)item.getData("IView");
                if (view == null) {
                    Class cla = (Class)item.getData("claEventListener");
                    UISWTViewEventListener l = (UISWTViewEventListener)cla.newInstance();
                    view = new UISWTViewImpl("Main", cla.getSimpleName(), l, ds);
                    item.setData("IView", (Object)view);
                }
                this.activeView = view;
                if (item.getControl() == null) {
                    view.triggerEvent(1, ds);
                    view.initialize((Composite)this.folder);
                    item.setControl((Control)view.getComposite());
                }
                item.getControl().setFocus();
                UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
                if (uiFunctions != null) {
                    uiFunctions.getMDI().getEntry(VIEW_ID).setDatasource(this.dataSource);
                    uiFunctions.refreshIconBar();
                }
                this.refresh();
            }
            catch (Exception e) {
                Debug.out(e);
                Object var7_8 = null;
                this.folder.getShell().setCursor(null);
                return;
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.folder.getShell().setCursor(null);
            throw throwable;
        }
        this.folder.getShell().setCursor(null);
    }

    private UISWTViewCore getActiveView() {
        return this.activeView;
    }

    private void refresh() {
        if (this.folder == null || this.folder.isDisposed()) {
            return;
        }
        try {
            UISWTViewCore view = this.getActiveView();
            if (view != null) {
                view.triggerEvent(5, null);
            }
            CTabItem[] items = this.folder.getItems();
            for (int i = 0; i < items.length; ++i) {
                CTabItem item = items[i];
                view = (UISWTViewCore)item.getData("IView");
                try {
                    if (item.isDisposed() || view == null) continue;
                    String lastTitle = item.getText();
                    String newTitle = view.getFullTitle();
                    if (lastTitle == null || !lastTitle.equals(newTitle)) {
                        item.setText(StatsView.escapeAccelerators(newTitle));
                    }
                    String lastToolTip = item.getToolTipText();
                    String newToolTip = view.getFullTitle();
                    if (lastToolTip != null && lastToolTip.equals(newToolTip)) continue;
                    item.setToolTipText(newToolTip);
                    continue;
                }
                catch (Exception e) {
                    Debug.printStackTrace(e);
                }
            }
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
        }
    }

    private void focusGained() {
        if (this.folder == null || this.folder.isDisposed()) {
            return;
        }
        try {
            CTabItem[] items = this.folder.getItems();
            for (int i = 0; i < items.length; ++i) {
                CTabItem item = items[i];
                UISWTViewCore view = (UISWTViewCore)item.getData("IView");
                try {
                    if (item.isDisposed() || view == null) continue;
                    view.triggerEvent(3, null);
                    continue;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    private static String escapeAccelerators(String str) {
        if (str == null) {
            return str;
        }
        return str.replaceAll("&", "&&");
    }

    private String getFullTitle() {
        return MessageText.getString("Stats.title.full");
    }

    private void delete() {
        if (this.updateThread != null) {
            this.updateThread.stopIt();
        }
        if (this.folder != null && !this.folder.isDisposed()) {
            this.folder.setSelection(0);
        }
        if (Utils.isCarbon && this.folder != null && !this.folder.isDisposed()) {
            CTabItem[] items = this.folder.getItems();
            for (int i = 0; i < items.length; ++i) {
                if (items[i].isDisposed()) continue;
                items[i].dispose();
            }
        }
        for (int i = 0; i < this.tabViews.size(); ++i) {
            UISWTViewCore view = this.tabViews.get(i);
            if (view == null) continue;
            view.triggerEvent(7, null);
        }
        this.tabViews.clear();
        Utils.disposeSWTObjects(new Object[]{this.folder, this.parent});
    }

    private void dataSourceChanged(Object newDataSource) {
        if (this.dataSource == newDataSource) {
            return;
        }
        if (this.dataSource != null && newDataSource != null && this.dataSource.equals(newDataSource)) {
            return;
        }
        this.dataSource = newDataSource;
        if (this.folder == null) {
            return;
        }
        if (newDataSource instanceof String) {
            for (CTabItem item : this.folder.getItems()) {
                String ds = (String)item.getData("ds");
                if (!newDataSource.equals(ds)) continue;
                this.selectView(item);
            }
        }
    }

    private void addSection(UISWTViewCore view, Object dataSource) {
        if (view == null) {
            return;
        }
        view.triggerEvent(1, dataSource);
        CTabItem item = new CTabItem(this.folder, 0);
        Messages.setLanguageText((Widget)item, view.getTitleID());
        item.setData("IView", (Object)view);
        if (dataSource != null) {
            item.setData("ds", dataSource);
        }
        this.tabViews.add(view);
    }

    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 0: {
                this.swtView = (UISWTView)event2.getData();
                this.swtView.setTitle(this.getFullTitle());
                break;
            }
            case 7: {
                this.delete();
                break;
            }
            case 2: {
                this.initialize((Composite)event2.getData());
                break;
            }
            case 6: {
                this.swtView.setTitle(this.getFullTitle());
                Messages.updateLanguageForControl((Widget)this.folder);
                break;
            }
            case 1: {
                this.dataSourceChanged(event2.getData());
                break;
            }
            case 3: {
                this.focusGained();
                break;
            }
            case 5: {
                this.refresh();
            }
        }
        return true;
    }

    private class UpdateThread
    extends Thread {
        boolean bContinue;

        public UpdateThread() {
            super("StatsView Update Thread");
        }

        public void run() {
            this.bContinue = true;
            while (this.bContinue) {
                for (UISWTViewCore iview : StatsView.this.tabViews) {
                    try {
                        iview.triggerEvent(256, null);
                    }
                    catch (Exception e) {
                        Debug.printStackTrace(e);
                    }
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (Throwable e) {
                    Debug.out(e);
                    break;
                }
            }
        }

        public void stopIt() {
            this.bContinue = false;
        }
    }
}

