/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.table.impl;

import com.aelitis.azureus.ui.common.table.TableCellCore;
import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.common.table.TableRowCore;
import com.aelitis.azureus.ui.common.table.TableView;
import com.aelitis.azureus.ui.common.table.impl.TableViewImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.LightHashMap;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.plugins.ui.tables.TableRowMouseEvent;
import org.gudy.azureus2.plugins.ui.tables.TableRowMouseListener;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.BufferedTableRow;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;
import org.gudy.azureus2.ui.swt.views.table.TableItemOrTreeItem;
import org.gudy.azureus2.ui.swt.views.table.TableOrTreeSWT;
import org.gudy.azureus2.ui.swt.views.table.TableRowSWT;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWT;
import org.gudy.azureus2.ui.swt.views.table.impl.TableCellImpl;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewSWTImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableRowImpl<COREDATASOURCE>
extends BufferedTableRow
implements TableRowSWT {
    private Map<String, TableCellCore> mTableCells;
    private Object coreDataSource;
    private Object pluginDataSource;
    private boolean bDisposed;
    private boolean bSetNotUpToDateLastRefresh = false;
    private TableView<COREDATASOURCE> tableView;
    private static AEMonitor this_mon = new AEMonitor("TableRowImpl");
    private ArrayList<TableRowMouseListener> mouseListeners;
    private boolean wasShown = false;
    private Map<String, Object> dataList;
    private int lastIndex = -1;
    private int fontStyle;
    private int alpha = 255;
    private TableRowCore parentRow;
    private TableRowImpl<Object>[] subRows;
    private AEMonitor mon_SubRows = new AEMonitor("subRows");
    private TableColumnCore[] columnsSorted;
    private boolean bSkipFirstColumn;
    private static final boolean DEBUG_SET_FOREGROUND = System.getProperty("debug.setforeground") != null;
    private Object[] subDataSources;

    public TableRowImpl(TableRowCore parentRow, TableView<COREDATASOURCE> tv, TableOrTreeSWT table, TableColumnCore[] columnsSorted, String sTableID, Object dataSource, int index, boolean bSkipFirstColumn) {
        super(table);
        this.parentRow = parentRow;
        this.tableView = tv;
        this.coreDataSource = dataSource;
        this.bDisposed = false;
        this.lastIndex = index;
        this.mTableCells = new LightHashMap<String, TableCellCore>(columnsSorted.length, 1.0f);
        for (int i = 0; i < columnsSorted.length; ++i) {
            if (columnsSorted[i] == null) continue;
            if (!columnsSorted[i].handlesDataSourceType(this.getDataSource(false).getClass())) {
                this.mTableCells.put(columnsSorted[i].getName(), null);
                continue;
            }
            TableCellImpl cell = new TableCellImpl(this, columnsSorted[i], bSkipFirstColumn ? i + 1 : i);
            this.mTableCells.put(columnsSorted[i].getName(), cell);
        }
    }

    public TableRowImpl(TableView<COREDATASOURCE> tv, TableOrTreeSWT table, TableColumnCore[] columnsSorted, Object dataSource, boolean bSkipFirstColumn) {
        super(table);
        this.tableView = tv;
        this.columnsSorted = columnsSorted;
        this.coreDataSource = dataSource;
        this.bSkipFirstColumn = bSkipFirstColumn;
        this.bDisposed = false;
        this.mTableCells = new LightHashMap<String, TableCellCore>(columnsSorted.length, 1.0f);
        for (int i = 0; i < columnsSorted.length; ++i) {
            if (columnsSorted[i] == null) continue;
            TableCellImpl cell = new TableCellImpl(this, columnsSorted[i], bSkipFirstColumn ? i + 1 : i);
            this.mTableCells.put(columnsSorted[i].getName(), cell);
        }
    }

    @Override
    public boolean isValid() {
        if (this.bDisposed || this.mTableCells == null) {
            return true;
        }
        boolean valid = true;
        for (TableCell tableCell : this.mTableCells.values()) {
            if (tableCell == null || !tableCell.isValid()) continue;
            return false;
        }
        return valid;
    }

    @Override
    public Object getDataSource() {
        return this.getDataSource(false);
    }

    @Override
    public String getTableID() {
        return this.tableView.getTableID();
    }

    @Override
    public TableCell getTableCell(String field) {
        if (this.bDisposed || this.mTableCells == null) {
            return null;
        }
        return this.mTableCells.get(field);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMouseListener(TableRowMouseListener listener) {
        try {
            this_mon.enter();
            if (this.mouseListeners == null) {
                this.mouseListeners = new ArrayList(1);
            }
            this.mouseListeners.add(listener);
            Object var3_2 = null;
            this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMouseListener(TableRowMouseListener listener) {
        try {
            this_mon.enter();
            if (this.mouseListeners == null) {
                Object var3_2 = null;
                this_mon.exit();
                return;
            }
            this.mouseListeners.remove(listener);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this_mon.exit();
            throw throwable;
        }
        Object var3_3 = null;
        this_mon.exit();
    }

    @Override
    public void invokeMouseListeners(TableRowMouseEvent event2) {
        ArrayList<TableRowMouseListener> listeners = this.mouseListeners;
        if (listeners == null) {
            return;
        }
        for (int i = 0; i < listeners.size(); ++i) {
            try {
                TableRowMouseListener l = listeners.get(i);
                l.rowMouseTrigger(event2);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete() {
        this_mon.enter();
        try {
            if (this.bDisposed) {
                Object var5_1 = null;
                this_mon.exit();
                return;
            }
            if (TableViewImpl.DEBUGADDREMOVE) {
                System.out.println((this.table.isDisposed() ? "" : this.table.getData("Name")) + " row delete; index=" + this.getIndex());
            }
            for (TableCellCore cell : this.mTableCells.values()) {
                try {
                    if (cell == null) continue;
                    cell.dispose();
                }
                catch (Exception e) {
                    Debug.out(e);
                }
            }
            this.bDisposed = true;
        }
        catch (Throwable throwable) {
            Object var5_3 = null;
            this_mon.exit();
            throw throwable;
        }
        Object var5_2 = null;
        this_mon.exit();
    }

    @Override
    public List<TableCellCore> refresh(boolean bDoGraphics) {
        if (this.bDisposed) {
            return Collections.EMPTY_LIST;
        }
        boolean bVisible = this.isVisible();
        return this.refresh(bDoGraphics, bVisible);
    }

    @Override
    public List<TableCellCore> refresh(boolean bDoGraphics, boolean bVisible) {
        ArrayList<TableCellCore> list = Collections.EMPTY_LIST;
        if (this.bDisposed) {
            return list;
        }
        if (!bVisible) {
            if (!this.bSetNotUpToDateLastRefresh) {
                this.setUpToDate(false);
                this.bSetNotUpToDateLastRefresh = true;
            }
            return list;
        }
        this.bSetNotUpToDateLastRefresh = false;
        ((TableViewSWTImpl)this.tableView).invokeRefreshListeners(this);
        for (TableCellCore cell : this.mTableCells.values()) {
            boolean changed;
            TableColumn column;
            if (cell == null || cell.isDisposed() || (column = cell.getTableColumn()) != this.tableView.getSortColumn() && !this.tableView.isColumnVisible(column) || !(changed = cell.refresh(bDoGraphics, bVisible))) continue;
            if (list == Collections.EMPTY_LIST) {
                list = new ArrayList<TableCellCore>(this.mTableCells.size());
            }
            list.add(cell);
        }
        return list;
    }

    @Override
    public void locationChanged(int iStartColumn) {
        if (this.bDisposed || !this.isVisible()) {
            return;
        }
        for (TableCellCore cell : this.mTableCells.values()) {
            if (cell == null || cell.getTableColumn().getPosition() <= iStartColumn) continue;
            cell.locationChanged();
        }
    }

    @Override
    public TableCellCore getTableCellCore(String name) {
        if (this.bDisposed || this.mTableCells == null) {
            return null;
        }
        return this.mTableCells.get(name);
    }

    @Override
    public TableCellSWT getTableCellSWT(String name) {
        if (this.bDisposed || this.mTableCells == null) {
            return null;
        }
        TableCellCore cell = this.mTableCells.get(name);
        if (cell instanceof TableCellSWT) {
            return (TableCellSWT)cell;
        }
        return null;
    }

    @Override
    public Object getDataSource(boolean bCoreObject) {
        if (this.bDisposed) {
            return null;
        }
        if (bCoreObject) {
            return this.coreDataSource;
        }
        if (this.pluginDataSource != null) {
            return this.pluginDataSource;
        }
        this.pluginDataSource = PluginCoreUtils.convert(this.coreDataSource, bCoreObject);
        return this.pluginDataSource;
    }

    @Override
    public boolean isRowDisposed() {
        return this.bDisposed;
    }

    @Override
    public int getIndex() {
        if (this.bDisposed) {
            return -1;
        }
        if (this.lastIndex >= 0) {
            if (this.parentRow != null) {
                return this.lastIndex;
            }
            TableRowCore row = ((TableViewSWTImpl)this.tableView).getRowQuick(this.lastIndex);
            if (row == this) {
                return this.lastIndex;
            }
        }
        return this.tableView.indexOf(this);
    }

    public int getRealIndex() {
        return super.getIndex();
    }

    @Override
    public boolean setTableItem(int newIndex, boolean isVisible) {
        boolean changedSWTRow;
        if (this.bDisposed) {
            System.out.println("XXX setTI: bDisposed from " + Debug.getCompressedStackTrace());
            return false;
        }
        int maxItemShown = this.tableView.getMaxItemShown();
        if (newIndex > maxItemShown) {
            this.tableView.setMaxItemShown(newIndex);
            if (!isVisible) {
                return false;
            }
        }
        boolean changedIndex = this.lastIndex != newIndex || this.item == null;
        boolean bl = changedSWTRow = !changedIndex ? false : super.setTableItem(newIndex, isVisible);
        if (changedIndex) {
            this.lastIndex = newIndex;
        }
        this.setShown(isVisible, changedSWTRow);
        if (changedSWTRow && isVisible) {
            this.redraw();
            this.setUpToDate(false);
        }
        return changedSWTRow;
    }

    @Override
    public boolean setTableItem(int newIndex) {
        if (!Utils.isThisThreadSWT()) {
            return false;
        }
        return this.setTableItem(newIndex, true);
    }

    private static void setForegroundDebug(String method_sig, Color c) {
        if (DEBUG_SET_FOREGROUND && c != null) {
            Debug.out("BufferedTableRow " + method_sig + " -> " + c);
        }
    }

    private static void setForegroundDebug(String method_sig, int r, int g, int b) {
        if (DEBUG_SET_FOREGROUND && (r != 0 || g != 0 || b != 0)) {
            Debug.out("BufferedTableRow " + method_sig + " -> " + r + "," + g + "," + b);
        }
    }

    @Override
    public void setForeground(int r, int g, int b) {
        TableRowImpl.setForegroundDebug("setForeground(r, g, b)", r, g, b);
        if (!this.isVisible()) {
            return;
        }
        super.setForeground(r, g, b);
    }

    @Override
    public boolean setForeground(final Color c) {
        TableRowImpl.setForegroundDebug("setForeground(Color)", c);
        if (!this.isVisible()) {
            return true;
        }
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                TableRowImpl.this.setForegroundInSWTThread(c);
            }
        });
        return true;
    }

    private void setForegroundInSWTThread(Color c) {
        TableRowImpl.setForegroundDebug("setForegroundInSWTThread(Color)", c);
        if (!this.isVisible()) {
            return;
        }
        super.setForeground(c);
    }

    @Override
    public void setForeground(int[] rgb) {
        if (rgb == null || rgb.length < 3) {
            this.setForeground((Color)null);
            return;
        }
        this.setForeground(rgb[0], rgb[1], rgb[2]);
    }

    @Override
    public void setForegroundToErrorColor() {
        this.setForeground(Colors.colorError);
    }

    @Override
    public void invalidate() {
        this.invalidate(false);
    }

    @Override
    public void invalidate(boolean mustRefresh) {
        super.invalidate();
        if (this.bDisposed) {
            return;
        }
        for (TableCellCore cell : this.mTableCells.values()) {
            if (cell == null) continue;
            cell.invalidate(mustRefresh);
        }
    }

    @Override
    public void setUpToDate(boolean upToDate) {
        if (this.bDisposed) {
            return;
        }
        for (TableCellCore cell : this.mTableCells.values()) {
            if (cell == null) continue;
            cell.setUpToDate(upToDate);
        }
    }

    @Override
    public void redraw() {
        this.redraw(false);
    }

    @Override
    public void redraw(boolean doChildren) {
        Rectangle bounds = this.getBounds();
        this.table.redraw(bounds.x, bounds.y, bounds.width, bounds.height, false);
    }

    public String toString() {
        String result = "TableRowImpl@" + Integer.toHexString(this.hashCode()) + "/#" + this.lastIndex;
        return result;
    }

    @Override
    public TableView<COREDATASOURCE> getView() {
        return this.tableView;
    }

    @Override
    public boolean isShown() {
        return this.wasShown;
    }

    @Override
    public boolean setShown(boolean b, boolean force) {
        if (this.bDisposed) {
            return false;
        }
        if (b == this.wasShown && !force) {
            return false;
        }
        this.wasShown = b;
        for (TableCellCore cell : this.mTableCells.values()) {
            if (cell == null) continue;
            cell.invokeVisibilityListeners(b ? 0 : 1, true);
        }
        return true;
    }

    @Override
    public boolean isMouseOver() {
        return this.tableView.getTableRowWithCursor() == this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setData(String id, Object data) {
        TableRowImpl tableRowImpl = this;
        synchronized (tableRowImpl) {
            if (this.dataList == null) {
                this.dataList = new HashMap<String, Object>(1);
            }
            if (data == null) {
                this.dataList.remove(id);
            } else {
                this.dataList.put(id, data);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getData(String id) {
        TableRowImpl tableRowImpl = this;
        synchronized (tableRowImpl) {
            return this.dataList == null ? null : this.dataList.get(id);
        }
    }

    @Override
    public Rectangle getBounds() {
        Rectangle bounds = this.getBounds(1);
        if (bounds == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        Rectangle tableBounds = this.table.getClientArea();
        bounds.x = tableBounds.x;
        bounds.width = tableBounds.width;
        return bounds;
    }

    @Override
    public boolean setFontStyle(int style) {
        if (this.fontStyle == style) {
            return false;
        }
        this.fontStyle = style;
        this.invalidate();
        return true;
    }

    @Override
    public boolean setAlpha(int alpha) {
        if (this.alpha == alpha) {
            return false;
        }
        this.alpha = alpha;
        this.invalidate();
        return true;
    }

    @Override
    public int getAlpha() {
        return this.alpha;
    }

    @Override
    public int getFontStyle() {
        return this.fontStyle;
    }

    @Override
    public boolean isVisible() {
        return this.tableView.isRowVisible(this);
    }

    @Override
    public boolean isVisibleNoSWT() {
        return this.tableView.isRowVisible(this);
    }

    @Override
    public void setSelected(boolean selected) {
        if (this.tableView instanceof TableViewSWT) {
            ((TableViewSWT)this.tableView).setRowSelected(this, selected, true);
        }
    }

    @Override
    public void setWidgetSelected(boolean selected) {
        super.setSelected(selected);
    }

    @Override
    public boolean isSelected() {
        return this.tableView.isSelected(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSubItemCount(int count) {
        super.setSubItemCount(count);
        if (count == this.getSubItemCount() && (count == 0 || this.subRows != null && this.subRows[0] == null)) {
            return;
        }
        this.mon_SubRows.enter();
        try {
            this.subRows = new TableRowImpl[count];
            for (int i = 0; i < count; ++i) {
                this.subRows[i] = null;
            }
            Object var4_3 = null;
            this.mon_SubRows.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.mon_SubRows.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSubItems(Object[] datasources) {
        this.subDataSources = datasources;
        super.setSubItemCount(datasources.length);
        this.mon_SubRows.enter();
        try {
            this.subRows = new TableRowImpl[datasources.length];
            for (int i = 0; i < datasources.length; ++i) {
                this.subRows[i] = null;
            }
            Object var4_3 = null;
            this.mon_SubRows.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.mon_SubRows.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TableRowCore linkSubItem(int indexOf) {
        block4: {
            this.mon_SubRows.enter();
            try {
                if (indexOf < this.subRows.length) break block4;
                TableRowCore tableRowCore = null;
                Object var6_4 = null;
                this.mon_SubRows.exit();
                return tableRowCore;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.mon_SubRows.exit();
                throw throwable;
            }
        }
        TableRowImpl<Object> subRow = this.subRows[indexOf];
        if (subRow == null) {
            this.subRows[indexOf] = subRow = new TableRowImpl<COREDATASOURCE>(this, this.tableView, this.table, this.columnsSorted, this.getTableID(), this.subDataSources[indexOf], indexOf, this.bSkipFirstColumn);
        }
        TableItemOrTreeItem subItem = this.item.getItem(indexOf);
        subRow.setTableItem(subItem, true);
        TableRowImpl<Object> tableRowImpl = subRow;
        Object var6_5 = null;
        this.mon_SubRows.exit();
        return tableRowImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TableRowCore[] getSubRowsWithNull() {
        this.mon_SubRows.enter();
        try {
            TableRowCore[] copyOf = new TableRowCore[this.subRows.length];
            System.arraycopy(this.subRows, 0, copyOf, 0, this.subRows.length);
            TableRowCore[] tableRowCoreArray = copyOf;
            Object var4_3 = null;
            this.mon_SubRows.exit();
            return tableRowCoreArray;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.mon_SubRows.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public TableRowCore getSubRow(int pos) {
        TableRowImpl<Object>[] tableRowImplArray;
        this.mon_SubRows.enter();
        try {
            int i = -1;
            for (TableRowImpl<Object> row : this.subRows) {
                if (row == null || ++i != pos) continue;
                TableRowImpl<Object> tableRowImpl = row;
                Object var9_8 = null;
                this.mon_SubRows.exit();
                return tableRowImpl;
            }
            tableRowImplArray = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.mon_SubRows.exit();
            throw throwable;
        }
        Object var9_9 = null;
        this.mon_SubRows.exit();
        return tableRowImplArray;
    }

    @Override
    public void removeSubRow(final Object datasource) {
        Utils.execSWTThreadLater(0, new AERunnable(){

            public void runSupport() {
                TableRowImpl.this.swt_removeSubRow(datasource);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void swt_removeSubRow(Object datasource) {
        if (datasource instanceof TableRowImpl) {
            this.removeSubRow(((TableRowImpl)datasource).getDataSource());
        }
        this.mon_SubRows.enter();
        try {
            block8: {
                block7: {
                    if (this.subDataSources == null || this.subDataSources.length == 0) break block7;
                    if (this.subDataSources.length == this.subRows.length) break block8;
                }
                Object var8_2 = null;
                this.mon_SubRows.exit();
                return;
            }
            for (int i = 0; i < this.subDataSources.length; ++i) {
                Object ds = this.subDataSources[i];
                if (ds != datasource) continue;
                TableRowImpl<Object> rowToDel = this.subRows[i];
                TableRowImpl[] newSubRows = new TableRowImpl[this.subRows.length - 1];
                System.arraycopy(this.subRows, 0, newSubRows, 0, i);
                System.arraycopy(this.subRows, i + 1, newSubRows, i, this.subRows.length - i - 1);
                this.subRows = newSubRows;
                Object[] newDatasources = new Object[this.subRows.length];
                System.arraycopy(this.subDataSources, 0, newDatasources, 0, i);
                System.arraycopy(this.subDataSources, i + 1, newDatasources, i, this.subDataSources.length - i - 1);
                this.subDataSources = newDatasources;
                rowToDel.dispose();
                rowToDel.delete();
                super.setSubItemCount(this.subRows.length);
                break;
            }
        }
        catch (Throwable throwable) {
            Object var8_4 = null;
            this.mon_SubRows.exit();
            throw throwable;
        }
        Object var8_3 = null;
        this.mon_SubRows.exit();
    }

    @Override
    public boolean isInPaintItem() {
        return super.inPaintItem();
    }

    @Override
    public TableRowCore getParentRowCore() {
        return this.parentRow;
    }

    @Override
    public TableItemOrTreeItem getItem() {
        return this.item;
    }

    @Override
    public int getFullHeight() {
        return this.getBounds((int)1).height;
    }

    @Override
    public void setSortColumn(String columnID) {
    }

    @Override
    public TableCellCore getSortColumnCell(String hint) {
        if (this.bDisposed || this.mTableCells == null) {
            return null;
        }
        return this.mTableCells.get(hint);
    }
}

