/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.table.impl;

import com.aelitis.azureus.ui.swt.utils.ColorCache;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.mainwindow.HSLColor;
import org.gudy.azureus2.ui.swt.views.table.TableColumnOrTreeColumn;
import org.gudy.azureus2.ui.swt.views.table.TableItemOrTreeItem;
import org.gudy.azureus2.ui.swt.views.table.TableOrTreeSWT;
import org.gudy.azureus2.ui.swt.views.table.impl.TableOrTreeUtils;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewSWTImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableViewSWT_EraseItem
implements Listener {
    public static final Color[] alternatingColors = new Color[]{null, Colors.colorAltRow};
    private final TableOrTreeSWT table;
    private TableViewSWTImpl<?> tv;
    private boolean drawExtended;
    private boolean first = true;
    private static Color colorLine;

    public TableViewSWT_EraseItem(TableViewSWTImpl<?> _tv, TableOrTreeSWT table) {
        this.table = table;
        this.tv = _tv;
        COConfigurationManager.addAndFireParameterListener("Table.extendedErase", new ParameterListener(){

            public void parameterChanged(String parameterName) {
                Utils.execSWTThread(new AERunnable(){

                    public void runSupport() {
                        TableViewSWT_EraseItem.this.drawExtended = COConfigurationManager.getBooleanParameter("Table.extendedErase");
                        if (!TableViewSWT_EraseItem.this.first) {
                            Rectangle bounds = TableViewSWT_EraseItem.this.tv.getTableOrTreeSWT().getBounds();
                            TableViewSWT_EraseItem.this.tv.getTableOrTreeSWT().redraw(bounds.x, bounds.y, bounds.width, bounds.height, true);
                        }
                        TableViewSWT_EraseItem.this.first = false;
                    }
                });
            }
        });
        if (colorLine == null) {
            colorLine = this.tv.getComposite().getDisplay().getSystemColor(25);
            HSLColor hslColor = new HSLColor();
            hslColor.initHSLbyRGB(colorLine.getRed(), colorLine.getGreen(), colorLine.getBlue());
            int lum = hslColor.getLuminence();
            lum = lum > 127 ? (lum -= 25) : (lum += 40);
            hslColor.setLuminence(lum);
            colorLine = new Color((Device)this.tv.getComposite().getDisplay(), hslColor.getRed(), hslColor.getGreen(), hslColor.getBlue());
        }
    }

    public void handleEvent(Event event2) {
        if (event2.type == 40) {
            TableItemOrTreeItem item = TableOrTreeUtils.getEventItem(event2.item);
            TableViewSWT_EraseItem.eraseItem(event2, event2.gc, item, event2.index, this.drawExtended, item.getBounds(event2.index), this.tv, false);
        } else if (this.drawExtended) {
            this.paint(event2);
        }
    }

    private void paint(Event event2) {
        int numItems = this.table.getItemCount();
        int rowAreaHeight = this.tv.clientArea.height + this.tv.clientArea.y;
        int rowHeight = this.table.getItemHeight();
        int height = rowHeight * numItems;
        int blankHeight = rowAreaHeight - height;
        if (blankHeight > 0) {
            int startY;
            if (numItems > 0) {
                TableItemOrTreeItem lastItem = this.table.getItem(numItems - 1);
                if (lastItem != null) {
                    TableItemOrTreeItem[] subItems;
                    Rectangle lastItemBounds = lastItem.getExpanded() ? ((subItems = lastItem.getItems()) == null || subItems.length == 0 ? lastItem.getBounds() : subItems[subItems.length - 1].getBounds()) : lastItem.getBounds();
                    startY = lastItemBounds.y + lastItemBounds.height;
                } else {
                    startY = 0;
                }
            } else {
                startY = 0;
            }
            GC gc = event2.gc;
            gc.setClipping((Rectangle)null);
            for (int i = 0; i < blankHeight / rowHeight; ++i) {
                Color color;
                int curY = startY + i * rowHeight;
                int pos = (i + numItems) % 2;
                Color color2 = color = i <= -1 ? ColorCache.getRandomColor() : alternatingColors[pos];
                if (color == null) continue;
                gc.setBackground(color);
                gc.fillRectangle(this.tv.clientArea.x, startY + i * rowHeight, this.tv.clientArea.width, rowHeight);
            }
            if (TableViewSWTImpl.DRAW_VERTICAL_LINES) {
                TableColumnOrTreeColumn[] columns = this.table.getColumns();
                int pos = 0;
                gc.setForeground(Colors.black);
                gc.setAdvanced(true);
                gc.setAlpha(10);
                for (TableColumnOrTreeColumn tc : columns) {
                    gc.drawLine(pos - 1, startY, pos - 1, startY + blankHeight);
                    pos += tc.getWidth();
                }
                gc.drawLine(pos - 1, startY, pos - 1, startY + blankHeight);
            }
        }
    }

    public static void eraseItem(Event event2, GC gc, TableItemOrTreeItem item, int columnNo, boolean drawExtended, Rectangle bounds, TableViewSWTImpl<?> tv, boolean alwaysDrawBG) {
        TableOrTreeSWT table = tv.getTableOrTreeSWT();
        if (event2 == null || (event2.detail & 0x26) == 0) {
            TableItemOrTreeItem parentItem = item.getParentItem();
            int pos = parentItem != null ? parentItem.indexOf(item) + (table.indexOf(parentItem) + 1) % 2 : table.indexOf(item);
            Color color = alternatingColors[pos % 2];
            if (color != null) {
                gc.setBackground(color);
                if (parentItem != null) {
                    gc.setAlpha(128);
                }
            }
            Rectangle drawBounds = bounds;
            if (TableViewSWTImpl.DRAW_FULL_ROW && drawExtended && columnNo == table.getColumnCount() - 1) {
                tv.swt_calculateClientArea();
                drawBounds = new Rectangle(bounds.x, bounds.y, tv.clientArea.x + tv.clientArea.width - bounds.x, bounds.height);
                gc.setClipping(drawBounds);
            }
            if (alwaysDrawBG || color != null) {
                if (color == null) {
                    gc.setBackground(gc.getDevice().getSystemColor(25));
                }
                gc.fillRectangle(drawBounds);
                if (event2 != null) {
                    event2.detail &= 0xFFFFFFF7;
                }
            }
        }
        if (event2 != null && (event2.detail & 2) > 0 && !table.isFocusControl()) {
            gc.setBackground(Colors.blues[3]);
            gc.fillRectangle(bounds);
            if (event2 != null) {
                event2.detail &= 0xFFFFFFF7;
            }
        }
        if (TableViewSWTImpl.DRAW_VERTICAL_LINES && drawExtended && colorLine != null && item != null && bounds.width == item.getParent().getColumn(columnNo).getWidth() && bounds.width > 0) {
            Color fg = gc.getForeground();
            gc.setForeground(colorLine);
            gc.setClipping((Rectangle)null);
            gc.drawLine(bounds.x + bounds.width - 1, bounds.y - 1, bounds.x + bounds.width - 1, bounds.y + bounds.height);
            gc.setForeground(fg);
        }
    }

    static {
        Colors.getInstance().addColorsChangedListener(new ParameterListener(){

            public void parameterChanged(String parameterName) {
                TableViewSWT_EraseItem.alternatingColors[1] = Colors.colorAltRow;
            }
        });
    }
}

