/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.table.impl;

import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.swt.utils.FontUtils;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.BufferedGraphicTableItem;
import org.gudy.azureus2.ui.swt.components.BufferedTableItem;
import org.gudy.azureus2.ui.swt.components.InPaintInfo;
import org.gudy.azureus2.ui.swt.shells.GCStringPrinter;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;
import org.gudy.azureus2.ui.swt.views.table.TableItemOrTreeItem;
import org.gudy.azureus2.ui.swt.views.table.TableOrTreeSWT;
import org.gudy.azureus2.ui.swt.views.table.TableRowSWT;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWT;
import org.gudy.azureus2.ui.swt.views.table.impl.TableCellImpl;
import org.gudy.azureus2.ui.swt.views.table.impl.TableCellSWTBase;
import org.gudy.azureus2.ui.swt.views.table.impl.TableOrTreeUtils;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewSWTImpl;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewSWT_EraseItem;
import org.gudy.azureus2.ui.swt.views.table.utils.TableColumnSWTUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableViewSWT_PaintItem
implements Listener {
    Widget lastItem;
    int lastRowIndex = -1;
    private final TableOrTreeSWT table;
    private TableViewSWTImpl<?> tv;
    private boolean bSkipFirstColumn;

    public TableViewSWT_PaintItem(TableViewSWTImpl<?> tv, TableOrTreeSWT table) {
        this.table = table;
        this.tv = tv;
    }

    private int[] getColumnRange(TableItemOrTreeItem ti, int iMouseX, int width) {
        int i;
        int[] columnRange = new int[]{-1, -1};
        int numColumns = this.table.getColumnCount();
        if (numColumns <= 0) {
            return columnRange;
        }
        int n = i = this.bSkipFirstColumn ? 1 : 0;
        while (i < numColumns) {
            Rectangle cellBounds = ti.getBounds(i);
            if (iMouseX >= cellBounds.x && iMouseX < cellBounds.x + cellBounds.width && cellBounds.width > 0) {
                columnRange[0] = i;
                break;
            }
            ++i;
        }
        if (columnRange[0] == -1) {
            return columnRange;
        }
        if (columnRange[0] + 1 == numColumns) {
            columnRange[1] = columnRange[0];
        } else {
            int end = iMouseX + width;
            for (int i2 = columnRange[0] + 1; i2 < numColumns; ++i2) {
                Rectangle cellBounds = ti.getBounds(i2);
                if (cellBounds.x <= end || cellBounds.width <= 0) continue;
                columnRange[1] = i2 - 1;
                break;
            }
            if (columnRange[1] == -1) {
                columnRange[1] = numColumns - 1;
            }
        }
        return columnRange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleEvent(Event event2) {
        if (event2.gc.getClipping().isEmpty()) {
            return;
        }
        if (!this.table.isEnabled()) {
            event2.gc.setAlpha(100);
        }
        if (event2.type == 9) {
            Region r;
            block17: {
                block16: {
                    block15: {
                        r = new Region();
                        try {
                            event2.gc.getClipping(r);
                            TableItemOrTreeItem item = this.table.getItem(new Point(5, event2.y));
                            if (item == null) {
                                Object var11_6 = null;
                                break block15;
                            }
                            event2.item = item.getItem();
                            int[] columnRange = this.getColumnRange(item, event2.x, event2.width);
                            if (columnRange[0] == -1) {
                                break block16;
                            }
                            for (int i = columnRange[0]; i <= columnRange[1]; ++i) {
                                event2.index = i;
                                for (int y = event2.y; y < event2.y + event2.height && (item = this.table.getItem(new Point(5, y))) != null; y += item.getBounds().height) {
                                    Rectangle bounds = item.getBounds(i);
                                    if (!r.intersects(bounds)) continue;
                                    event2.item = item.getItem();
                                    this.table.setData("inPaintInfo", new InPaintInfo(item.getItem(), event2.index, bounds));
                                    if (event2.item != this.lastItem) {
                                        this.table.setData("lastIndex", null);
                                        this.lastRowIndex = this.table.indexOf(event2.item);
                                        this.table.setData("lastIndex", this.lastRowIndex);
                                    }
                                    boolean doErase = true;
                                    if (Constants.isWindows7OrHigher) {
                                        Point location = this.table.toControl(event2.display.getCursorLocation());
                                        if (location.y >= bounds.y && location.y < bounds.y + bounds.height) {
                                            doErase = false;
                                        }
                                    }
                                    Font f = event2.gc.getFont();
                                    if (doErase) {
                                        TableViewSWT_EraseItem.eraseItem(event2, event2.gc, item, event2.index, true, bounds, this.tv, true);
                                    }
                                    TableViewSWT_PaintItem.paintItem(event2.gc, (TableRowSWT)this.tv.getRow(item), event2.index, this.lastRowIndex, bounds, this.tv, false);
                                    event2.gc.setFont(f);
                                    event2.gc.setClipping(r);
                                    this.lastItem = event2.item;
                                }
                            }
                            break block17;
                        }
                        catch (Throwable throwable) {
                            Object var11_9 = null;
                            r.dispose();
                            throw throwable;
                        }
                    }
                    r.dispose();
                    return;
                }
                Object var11_7 = null;
                r.dispose();
                return;
            }
            Object var11_8 = null;
            r.dispose();
        } else {
            TableItemOrTreeItem item = TableOrTreeUtils.getEventItem(event2.item);
            Rectangle bounds = item.getBounds(event2.index);
            this.table.setData("inPaintInfo", new InPaintInfo((Item)event2.item, event2.index, bounds));
            if (event2.item != this.lastItem) {
                this.table.setData("lastIndex", null);
                this.lastRowIndex = this.table.indexOf(event2.item);
                this.table.setData("lastIndex", this.lastRowIndex);
            }
            TableViewSWT_PaintItem.paintItem(event2.gc, (TableRowSWT)this.tv.getRow(item), event2.index, this.lastRowIndex, bounds, this.tv, false);
            this.lastItem = event2.item;
        }
        this.table.setData("inPaintInfo", null);
        this.table.setData("lastIndex", null);
    }

    public static void paintItem(GC gc, TableRowSWT row, int columnIndex, int rowIndex, Rectangle _cellBounds, TableViewSWT<?> tv, boolean skipClipCalc) {
        try {
            TableColumnCore[] columnsOrdered;
            if (row == null || row.isRowDisposed()) {
                return;
            }
            int iColumnNo = columnIndex;
            if (tv instanceof TableViewSWTImpl && ((TableViewSWTImpl)tv).bSkipFirstColumn) {
                if (iColumnNo == 0) {
                    return;
                }
                --iColumnNo;
            }
            if (iColumnNo >= (columnsOrdered = tv.getVisibleColumns()).length) {
                System.out.println("Col #" + iColumnNo + " >= " + columnsOrdered.length + " count");
                return;
            }
            if (!tv.isColumnVisible(columnsOrdered[iColumnNo])) {
                System.out.println("col not visible " + iColumnNo);
                return;
            }
            Rectangle cellBounds = new Rectangle(_cellBounds.x, _cellBounds.y, _cellBounds.width, _cellBounds.height);
            Rectangle origClipping = gc.getClipping();
            TableOrTreeSWT table = tv.getTableOrTreeSWT();
            if (table != null) {
                if (origClipping.isEmpty() || origClipping.width >= cellBounds.width && origClipping.height >= cellBounds.height) {
                    table.setData("fullPaint", Boolean.TRUE);
                } else {
                    table.setData("fullPaint", Boolean.FALSE);
                }
            }
            if (!tv.isRowVisible(row)) {
                tv.visibleRowsChanged();
            }
            tv.invokePaintListeners(gc, row, columnsOrdered[iColumnNo], cellBounds);
            int rowAlpha = row.getAlpha();
            int fontStyle = row.getFontStyle();
            if (fontStyle == 1) {
                gc.setFont(FontUtils.getAnyFontBold(gc));
            }
            if (cellBounds.width <= 0 || cellBounds.height <= 0) {
                return;
            }
            TableCellSWT cell = row.getTableCellSWT(columnsOrdered[iColumnNo].getName());
            if (cell == null) {
                return;
            }
            if (!cell.isUpToDate()) {
                cell.refresh(true, true);
            }
            String text = cell.getText();
            if (!skipClipCalc) {
                Rectangle clipping = new Rectangle(cellBounds.x, cellBounds.y, cellBounds.width, cellBounds.height);
                if (!Utils.isCocoa && tv instanceof TableViewSWTImpl) {
                    int iMaxY;
                    int iMinY = ((TableViewSWTImpl)tv).headerHeight + ((TableViewSWTImpl)tv).clientArea.y;
                    if (clipping.y < iMinY) {
                        clipping.height -= iMinY - clipping.y;
                        clipping.y = iMinY;
                    }
                    if (clipping.y + clipping.height > (iMaxY = ((TableViewSWTImpl)tv).clientArea.height + ((TableViewSWTImpl)tv).clientArea.y)) {
                        clipping.height = iMaxY - clipping.y + 1;
                    }
                }
                if (clipping.width <= 0 || clipping.height <= 0) {
                    return;
                }
                if (!origClipping.contains(clipping.x, clipping.y) || !origClipping.contains(clipping.x + clipping.width - 1, clipping.y + clipping.height - 1)) {
                    gc.setClipping(clipping);
                }
            }
            if (rowAlpha < 255) {
                gc.setAlpha(rowAlpha);
            }
            if (cell.needsPainting()) {
                Image graphicSWT = cell.getGraphicSWT();
                if (graphicSWT != null && !graphicSWT.isDisposed()) {
                    int marginWidth = cell.getMarginWidth();
                    int marginHeight = cell.getMarginHeight();
                    Rectangle graphicBounds = new Rectangle(cellBounds.x + marginWidth, cellBounds.y + marginHeight, cellBounds.width - marginWidth * 2, cellBounds.height - marginHeight * 2);
                    Rectangle imageBounds = graphicSWT.getBounds();
                    BufferedTableItem bufferedTableItem = null;
                    if (cell instanceof TableCellImpl) {
                        bufferedTableItem = ((TableCellImpl)cell).getBufferedTableItem();
                    }
                    if (bufferedTableItem instanceof BufferedGraphicTableItem) {
                        BufferedGraphicTableItem ti = (BufferedGraphicTableItem)((Object)bufferedTableItem);
                        int orientation = ti.getOrientation();
                        if (orientation == 4) {
                            if (!graphicBounds.isEmpty()) {
                                gc.setAdvanced(true);
                                gc.drawImage(graphicSWT, 0, 0, imageBounds.width, imageBounds.height, graphicBounds.x, graphicBounds.y, graphicBounds.width, graphicBounds.height);
                            }
                        } else {
                            if (imageBounds.width < graphicBounds.width) {
                                if (orientation == 0x1000000) {
                                    graphicBounds.x += (graphicBounds.width - imageBounds.width) / 2;
                                } else if (orientation == 131072) {
                                    graphicBounds.x = graphicBounds.x + graphicBounds.width - imageBounds.width;
                                }
                            }
                            if (imageBounds.height < graphicBounds.height) {
                                graphicBounds.y += (graphicBounds.height - imageBounds.height) / 2;
                            }
                            gc.drawImage(graphicSWT, graphicBounds.x, graphicBounds.y);
                        }
                    } else {
                        gc.drawImage(graphicSWT, graphicBounds.x, graphicBounds.y);
                    }
                }
                cell.doPaint(gc);
            }
            if (text.length() > 0) {
                int textOpacity;
                int ofsx = 0;
                Image image = cell.getIcon();
                Rectangle imageBounds = null;
                if (image != null && !image.isDisposed()) {
                    imageBounds = image.getBounds();
                    int ofs = imageBounds.width;
                    ofsx += ofs;
                    cellBounds.x += ofs;
                    cellBounds.width -= ofs;
                }
                int style = TableColumnSWTUtils.convertColumnAlignmentToSWT(columnsOrdered[iColumnNo].getAlignment());
                if (cellBounds.height > 20) {
                    style |= 0x40;
                }
                if ((textOpacity = cell.getTextAlpha()) < 255) {
                    gc.setTextAntialias(1);
                    gc.setAlpha(textOpacity);
                } else if (textOpacity > 255) {
                    gc.setFont(FontUtils.getAnyFontBold(gc));
                    gc.setTextAntialias(1);
                    gc.setAlpha(textOpacity & 0xFF);
                }
                ofsx += 6;
                cellBounds.x += 3;
                cellBounds.width -= 6;
                cellBounds.y += 2;
                cellBounds.height -= 4;
                if (!cellBounds.isEmpty()) {
                    GCStringPrinter sp = new GCStringPrinter(gc, text, cellBounds, true, cellBounds.height > 20, style);
                    boolean fit = sp.printString();
                    if (fit) {
                        cell.setDefaultToolTip(null);
                    } else {
                        cell.setDefaultToolTip(text);
                    }
                    Point size = sp.getCalculatedSize();
                    size.x += ofsx;
                    TableColumn tableColumn = cell.getTableColumn();
                    if (tableColumn != null && tableColumn.getPreferredWidth() < size.x) {
                        tableColumn.setPreferredWidth(size.x);
                    }
                    if (imageBounds != null) {
                        boolean hack_adv;
                        int drawToY = cellBounds.y + cellBounds.height / 2 - imageBounds.height / 2;
                        boolean bl = hack_adv = Constants.isWindows8OrHigher && gc.getAdvanced();
                        if (hack_adv) {
                            gc.setAdvanced(false);
                        }
                        if ((style & 0x20000) != 0) {
                            int drawToX = cellBounds.x + cellBounds.width - size.x;
                            gc.drawImage(image, drawToX, drawToY);
                        } else {
                            gc.drawImage(image, cellBounds.x - imageBounds.width - 3, drawToY);
                        }
                        if (hack_adv) {
                            gc.setAdvanced(true);
                        }
                    }
                } else {
                    cell.setDefaultToolTip(null);
                }
            }
            if (cell instanceof TableCellSWTBase) {
                ((TableCellSWTBase)cell).clearVisuallyChangedSinceRefresh();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

