/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.table.impl;

import com.aelitis.azureus.ui.common.ToolBarItem;
import java.util.Map;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.plugins.ui.UIPluginViewToolBarListener;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.plugins.UISWTView;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEvent;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewCoreEventListener;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWT;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewSWTImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TableViewTab<DATASOURCETYPE>
implements UISWTViewCoreEventListener,
UIPluginViewToolBarListener,
AEDiagnosticsEvidenceGenerator {
    private TableViewSWT<DATASOURCETYPE> tv;
    private Object parentDataSource;
    private final String propertiesPrefix;
    private Composite composite;
    private UISWTView swtView;

    public TableViewTab(String propertiesPrefix) {
        this.propertiesPrefix = propertiesPrefix;
    }

    public TableViewSWT<DATASOURCETYPE> getTableView() {
        return this.tv;
    }

    public final void initialize(Composite composite) {
        this.tv = this.initYourTableView();
        if (this.parentDataSource != null) {
            this.tv.setParentDataSource(this.parentDataSource);
        }
        Composite parent = this.initComposite(composite);
        this.tv.initialize(this.swtView, parent);
        this.composite = parent != composite ? composite : this.tv.getComposite();
        this.tableViewTabInitComplete();
    }

    public void tableViewTabInitComplete() {
    }

    public Composite initComposite(Composite composite) {
        return composite;
    }

    public abstract TableViewSWT<DATASOURCETYPE> initYourTableView();

    public final void dataSourceChanged(Object newDataSource) {
        this.parentDataSource = newDataSource;
        if (this.tv != null) {
            this.tv.setParentDataSource(newDataSource);
        }
    }

    public final void refresh() {
        if (this.tv != null) {
            this.tv.refreshTable(false);
        }
    }

    private final void delete() {
        if (this.tv != null) {
            this.tv.delete();
        }
    }

    public String getFullTitle() {
        return MessageText.getString(this.getPropertiesPrefix() + ".title.full");
    }

    @Override
    public void generate(IndentWriter writer) {
        if (this.tv != null) {
            this.tv.generate(writer);
        }
    }

    public Composite getComposite() {
        return this.composite;
    }

    @Override
    public boolean toolBarItemActivated(ToolBarItem item, long activationType, Object datasource) {
        if (item.getID().equals("editcolumns") && this.tv instanceof TableViewSWTImpl) {
            this.tv.showColumnEditor();
            return true;
        }
        return false;
    }

    @Override
    public void refreshToolBarItems(Map<String, Long> list) {
        list.put("editcolumns", 1L);
    }

    public String getPropertiesPrefix() {
        return this.propertiesPrefix;
    }

    public Menu getPrivateMenu() {
        return null;
    }

    public void viewActivated() {
        if (this.tv instanceof TableViewSWTImpl) {
            ((TableViewSWTImpl)this.tv).isVisible();
        }
    }

    private void viewDeactivated() {
        if (this.tv instanceof TableViewSWTImpl) {
            ((TableViewSWTImpl)this.tv).isVisible();
        }
    }

    @Override
    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 0: {
                this.swtView = (UISWTView)event2.getData();
                this.swtView.setToolBarListener(this);
                this.swtView.setTitle(this.getFullTitle());
                break;
            }
            case 7: {
                this.delete();
                break;
            }
            case 2: {
                this.initialize((Composite)event2.getData());
                break;
            }
            case 6: {
                this.swtView.setTitle(this.getFullTitle());
                this.updateLanguage();
                Messages.updateLanguageForControl((Widget)this.composite);
                break;
            }
            case 1: {
                this.dataSourceChanged(event2.getData());
                break;
            }
            case 3: {
                this.viewActivated();
                break;
            }
            case 4: {
                this.viewDeactivated();
                break;
            }
            case 5: {
                this.refresh();
            }
        }
        return true;
    }

    public void updateLanguage() {
    }

    public UISWTView getSWTView() {
        return this.swtView;
    }
}

