/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.table.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.ui.tables.TableContextMenuItem;

public class TableContextMenuManager {
    private static TableContextMenuManager instance;
    private static AEMonitor class_mon;
    private Map items;
    private AEMonitor items_mon = new AEMonitor("TableContextMenuManager:items");

    private TableContextMenuManager() {
        this.items = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TableContextMenuManager getInstance() {
        try {
            class_mon.enter();
            if (instance == null) {
                instance = new TableContextMenuManager();
            }
            TableContextMenuManager tableContextMenuManager = instance;
            Object var2_1 = null;
            class_mon.exit();
            return tableContextMenuManager;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addContextMenuItem(TableContextMenuItem item) {
        try {
            String name = item.getResourceKey();
            String sTableID = item.getTableID();
            try {
                this.items_mon.enter();
                LinkedHashMap<String, TableContextMenuItem> mTypes = (LinkedHashMap<String, TableContextMenuItem>)this.items.get(sTableID);
                if (mTypes == null) {
                    mTypes = new LinkedHashMap<String, TableContextMenuItem>();
                    this.items.put(sTableID, mTypes);
                }
                mTypes.put(name, item);
                Object var6_6 = null;
                this.items_mon.exit();
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                this.items_mon.exit();
                throw throwable;
            }
        }
        catch (Exception e) {
            System.out.println("Error while adding Context Table Menu Item");
            Debug.printStackTrace(e);
        }
    }

    public void removeContextMenuItem(TableContextMenuItem item) {
        Map menu_item_map = (Map)this.items.get(item.getTableID());
        if (menu_item_map != null) {
            menu_item_map.remove(item.getResourceKey());
        }
    }

    public TableContextMenuItem[] getAllAsArray(String sMenuID) {
        Map local_menu_item_map = (Map)this.items.get(sMenuID);
        Map global_menu_item_map = (Map)this.items.get(null);
        if (local_menu_item_map == null && global_menu_item_map == null) {
            return new TableContextMenuItem[0];
        }
        ArrayList l = new ArrayList();
        if (local_menu_item_map != null) {
            l.addAll(local_menu_item_map.values());
        }
        if (global_menu_item_map != null) {
            l.addAll(global_menu_item_map.values());
        }
        return l.toArray(new TableContextMenuItem[l.size()]);
    }

    static {
        class_mon = new AEMonitor("TableContextMenuManager");
    }
}

