/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.files;

import com.aelitis.azureus.ui.common.table.TableCellCore;
import java.io.File;
import java.io.FileInputStream;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.CRC32;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.plugins.ui.menus.MenuItem;
import org.gudy.azureus2.plugins.ui.menus.MenuItemListener;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseEvent;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.plugins.ui.tables.TableContextMenuItem;
import org.gudy.azureus2.ui.swt.views.table.CoreTableColumnSWT;

public class FileHashItemBase
extends CoreTableColumnSWT
implements TableCellRefreshListener,
TableCellMouseListener {
    protected static final String HT_CRC32 = "crc32";
    protected static final String HT_MD5 = "md5";
    protected static final String HT_SHA1 = "sha1";
    final String hash_type;
    final TableContextMenuItem menuItem;
    private static AsyncDispatcher dispatcher = new AsyncDispatcher();
    private static Map<DiskManagerFileInfo, Set<String>> pending = new HashMap<DiskManagerFileInfo, Set<String>>();
    private static volatile DiskManagerFileInfo active;
    private static volatile String active_hash;
    private static volatile int active_percent;

    public FileHashItemBase(String _hash_type, int width) {
        super(_hash_type, 1, -1, width, "Files");
        this.hash_type = _hash_type;
        this.setType(1);
        this.setRefreshInterval(-2);
        this.menuItem = this.addContextMenuItem("FilesView." + this.hash_type + ".calculate");
        this.menuItem.setStyle(1);
        this.menuItem.addMultiListener(new MenuItemListener(){

            public void selected(MenuItem menu, Object target) {
                Object[] files;
                for (Object _file : files = (Object[])target) {
                    DiskManagerFileInfo file = (DiskManagerFileInfo)_file;
                    FileHashItemBase.updateHash(FileHashItemBase.this.hash_type, file);
                }
            }
        });
    }

    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"content"});
        info.setProficiency((byte)2);
    }

    public void cellMouseTrigger(TableCellMouseEvent event2) {
        DiskManagerFileInfo file = (DiskManagerFileInfo)event2.cell.getDataSource();
        if (file == null) {
            return;
        }
        TableCellCore core_cell = (TableCellCore)event2.cell;
        if (!event2.cell.getText().startsWith("<")) {
            core_cell.setCursorID(0);
            core_cell.setToolTip(null);
            return;
        }
        if (event2.eventType == 4) {
            core_cell.setCursorID(21);
            core_cell.setToolTip(MessageText.getString("FilesView.click.info"));
        } else if (event2.eventType == 5) {
            core_cell.setCursorID(0);
            core_cell.setToolTip(null);
        }
        if (event2.eventType != 1) {
            return;
        }
        if (event2.button != 1) {
            return;
        }
        event2.skipCoreFunctionality = true;
        FileHashItemBase.updateHash(this.hash_type, file);
    }

    public void refresh(TableCell cell) {
        DiskManagerFileInfo file = (DiskManagerFileInfo)cell.getDataSource();
        if (file == null) {
            return;
        }
        cell.setText(FileHashItemBase.getHash(this.hash_type, file));
    }

    private static boolean isFileReady(DiskManagerFileInfo file) {
        if (file == null || file.getLength() != file.getDownloaded() || file.getAccessMode() != 1) {
            return false;
        }
        File f = file.getFile(true);
        return f.length() == file.getLength() && f.canRead();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateHash(final String hash_type, final DiskManagerFileInfo file) {
        if (!FileHashItemBase.isFileReady(file)) {
            return;
        }
        Map<DiskManagerFileInfo, Set<String>> map = pending;
        synchronized (map) {
            Set<String> hashes = pending.get(file);
            if (hashes != null && hashes.contains(hash_type)) {
                return;
            }
            if (hashes == null) {
                hashes = new HashSet<String>();
                pending.put(file, hashes);
            }
            hashes.add(hash_type);
        }
        dispatcher.dispatch(new AERunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void runSupport() {
                block32: {
                    block30: {
                        block29: {
                            try {
                                try {
                                    DownloadManager dm = file.getDownloadManager();
                                    if (dm == null) {
                                        Object var17_3 = null;
                                        break block29;
                                    }
                                    if (!FileHashItemBase.isFileReady(file)) {
                                        break block30;
                                    }
                                    active_percent = 0;
                                    active_hash = hash_type;
                                    active = file;
                                    File f = file.getFile(true);
                                    CRC32 crc32 = null;
                                    MessageDigest md = null;
                                    if (hash_type == FileHashItemBase.HT_CRC32) {
                                        crc32 = new CRC32();
                                    } else {
                                        md = hash_type == FileHashItemBase.HT_MD5 ? MessageDigest.getInstance(FileHashItemBase.HT_MD5) : MessageDigest.getInstance("SHA1");
                                    }
                                    FileInputStream fis = new FileInputStream(f);
                                    long size = f.length();
                                    long done = 0L;
                                    if (size == 0L) {
                                        size = 1L;
                                    }
                                    try {
                                        byte[] hash;
                                        block33: {
                                            block31: {
                                                byte[] buffer = new byte[524288];
                                                while (true) {
                                                    int len;
                                                    if ((len = fis.read(buffer)) <= 0) {
                                                        if (crc32 != null) {
                                                            break;
                                                        }
                                                        break block31;
                                                    }
                                                    if (crc32 != null) {
                                                        crc32.update(buffer, 0, len);
                                                    }
                                                    if (md != null) {
                                                        md.update(buffer, 0, len);
                                                    }
                                                    active_percent = (int)(1000L * (done += (long)len) / size);
                                                }
                                                long val = crc32.getValue();
                                                hash = ByteFormatter.intToByteArray(val);
                                                break block33;
                                            }
                                            hash = md.digest();
                                        }
                                        Map<String, HashMap<String, Object>> other_hashes = dm.getDownloadState().getMapAttribute("fileotherhashes");
                                        other_hashes = other_hashes == null ? new HashMap<String, HashMap<String, byte[]>>() : BEncoder.cloneMap(other_hashes);
                                        HashMap<String, byte[]> file_hashes = (HashMap<String, byte[]>)other_hashes.get(String.valueOf(file.getIndex()));
                                        if (file_hashes == null) {
                                            file_hashes = new HashMap<String, byte[]>();
                                            other_hashes.put(String.valueOf(file.getIndex()), file_hashes);
                                        }
                                        file_hashes.put(hash_type, hash);
                                        dm.getDownloadState().setMapAttribute("fileotherhashes", other_hashes);
                                        Object var15_30 = null;
                                    }
                                    catch (Throwable throwable) {
                                        Object var15_31 = null;
                                        fis.close();
                                        throw throwable;
                                    }
                                    fis.close();
                                    break block32;
                                }
                                catch (Throwable e) {
                                    Debug.out(e);
                                    Object var17_6 = null;
                                    Map map = pending;
                                    synchronized (map) {
                                        Set hashes = (Set)pending.get(file);
                                        hashes.remove(hash_type);
                                        if (hashes.size() == 0) {
                                            pending.remove(file);
                                        }
                                        active = null;
                                        return;
                                    }
                                }
                            }
                            catch (Throwable throwable) {
                                Object var17_7 = null;
                                Map map = pending;
                                synchronized (map) {
                                    Set hashes = (Set)pending.get(file);
                                    hashes.remove(hash_type);
                                    if (hashes.size() == 0) {
                                        pending.remove(file);
                                    }
                                    active = null;
                                    throw throwable;
                                }
                            }
                        }
                        Map map = pending;
                        synchronized (map) {
                            Set hashes = (Set)pending.get(file);
                            hashes.remove(hash_type);
                            if (hashes.size() == 0) {
                                pending.remove(file);
                            }
                            active = null;
                            return;
                        }
                    }
                    Object var17_4 = null;
                    Map map = pending;
                    synchronized (map) {
                        Set hashes = (Set)pending.get(file);
                        hashes.remove(hash_type);
                        if (hashes.size() == 0) {
                            pending.remove(file);
                        }
                        active = null;
                        return;
                    }
                }
                Object var17_5 = null;
                Map map = pending;
                synchronized (map) {
                    Set hashes = (Set)pending.get(file);
                    hashes.remove(hash_type);
                    if (hashes.size() == 0) {
                        pending.remove(file);
                    }
                    active = null;
                    return;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getHash(String hash_type, DiskManagerFileInfo file) {
        byte[] hash;
        Map file_hashes;
        if (file == null) {
            return "";
        }
        DownloadManager dm = file.getDownloadManager();
        if (dm == null) {
            return "";
        }
        Map<DiskManagerFileInfo, Set<String>> map = pending;
        synchronized (map) {
            Set<String> hashes = pending.get(file);
            if (hashes != null && hashes.contains(hash_type)) {
                if (active == file && active_hash == hash_type) {
                    return DisplayFormatters.formatPercentFromThousands(active_percent);
                }
                return "...";
            }
        }
        Map other_hashes = dm.getDownloadState().getMapAttribute("fileotherhashes");
        if (other_hashes != null && (file_hashes = (Map)other_hashes.get(String.valueOf(file.getIndex()))) != null && (hash = (byte[])file_hashes.get(hash_type)) != null) {
            return ByteFormatter.encodeString(hash).toLowerCase();
        }
        if (!FileHashItemBase.isFileReady(file)) {
            return "";
        }
        return "<" + MessageText.getString("FilesView.click") + ">";
    }
}

