/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.files;

import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.views.table.CoreTableColumnSWT;

public class PercentItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public PercentItem() {
        super("%", 2, -2, 60, "Files");
        this.setRefreshInterval(-2);
        this.setMinWidthAuto(true);
    }

    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"progress"});
        info.setProficiency((byte)0);
    }

    public void refresh(TableCell cell) {
        long length;
        long bytesDownloaded;
        DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)cell.getDataSource();
        long percent = 0L;
        percent = fileInfo2 != null ? ((bytesDownloaded = fileInfo2.getDownloaded()) < 0L ? -1L : ((length = fileInfo2.getLength()) != 0L ? 1000L * bytesDownloaded / length : 1000L)) : -1L;
        if (!cell.setSortValue(percent) && cell.isValid()) {
            return;
        }
        cell.setText(percent < 0L ? "" : DisplayFormatters.formatPercentFromThousands((int)percent));
    }
}

