/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.mytorrents;

import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.views.table.CoreTableColumnSWT;

public class DoneFakeItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public static final String COLUMN_ID = "donefake";
    public static final Class DATASOURCE_TYPE = Download.class;

    public DoneFakeItem(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, 2, 55, sTableID);
        this.setRefreshInterval(-2);
        if (sTableID.equals("MyTorrents")) {
            this.setPosition(-2);
        } else {
            this.setPosition(-1);
        }
        this.setMinWidthAuto(true);
    }

    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"bytes", "progress"});
    }

    public void refresh(TableCell cell) {
        try {
            int value;
            DownloadManager dm = (DownloadManager)cell.getDataSource();
            int n = value = dm != null ? dm.getStats().getCompletedFake() : 0;
            if (!cell.setSortValue(value) && cell.isValid()) {
                return;
            }
            cell.setText(DisplayFormatters.formatPercentFromThousands(value));
            return;
        }
        catch (NullPointerException nullPointerException) {
            return;
        }
    }
}

