/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.mytorrents;

import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.views.table.CoreTableColumnSWT;

public class DownFakeItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public static final String COLUMN_ID = "downfake";
    public static final Class DATASOURCE_TYPE = Download.class;

    public DownFakeItem(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, 2, 70, sTableID);
        this.setRefreshInterval(-2);
        this.setMinWidthAuto(true);
    }

    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"content", "progress", "bytes"});
    }

    public void refresh(TableCell cell) {
        long value;
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        boolean downloadReduc = false;
        boolean ratioTool = false;
        if (dm != null) {
            downloadReduc = dm.getFakeOption(2);
            ratioTool = dm.getFakeOption(31);
        }
        long l = value = dm != null && (downloadReduc || ratioTool) ? dm.getStats().getTotalDataBytesReceivedFake() : 0L;
        if (!cell.setSortValue(value) && cell.isValid()) {
            return;
        }
        cell.setText(DisplayFormatters.formatByteCountToKiBEtc(value));
    }
}

