/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.mytorrents;

import com.aelitis.azureus.plugins.startstoprules.defaultplugin.DefaultRankCalculator;
import com.aelitis.azureus.plugins.startstoprules.defaultplugin.StartStopRulesDefaultPlugin;
import org.eclipse.swt.graphics.Color;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadTypeComplete;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellAddedListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadImpl;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.views.table.CoreTableColumnSWT;

public class DownSpeedFakeItem
extends CoreTableColumnSWT
implements TableCellAddedListener {
    public static final String COLUMN_ID = "downspeedfake";
    public static final Class DATASOURCE_TYPE = Download.class;

    public DownSpeedFakeItem(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, 2, 70, sTableID);
        this.setType(1);
        this.setRefreshInterval(-2);
        this.setUseCoreDataSource(false);
        this.setMinWidthAuto(true);
    }

    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"sharing", "bytes"});
        Class dsType = info.getColumn().getForDataSourceType();
        if (DownloadTypeComplete.class == dsType) {
            info.addCategories(new String[]{"essential"});
        }
    }

    public void cellAdded(TableCell cell) {
        cell.addRefreshListener(new RefreshListener());
    }

    public class RefreshListener
    implements TableCellRefreshListener {
        private int iLastState;

        public void refresh(TableCell cell) {
            long value;
            int iState;
            Download dl = (Download)cell.getDataSource();
            DownloadManager dm = ((DownloadImpl)dl).getDownload();
            if (dm == null) {
                iState = -1;
                value = 0L;
            } else {
                iState = dm.getState();
                value = dm.getStats().getDataReceivedRateFake();
            }
            if (!cell.setSortValue(value) && cell.isValid() && iState == this.iLastState) {
                return;
            }
            if (cell.setText(DisplayFormatters.formatByteCountToKiBEtcPerSec(value)) || iState != this.iLastState || !cell.isValid()) {
                this.changeColor(cell, dl, iState);
            }
        }

        private void changeColor(TableCell cell, Download dl, int iState) {
            try {
                DefaultRankCalculator calc = StartStopRulesDefaultPlugin.getRankCalculator(dl);
                Color newFG = null;
                if (calc != null && dl.getState() == 5 && !calc.getActivelySeeding()) {
                    newFG = Colors.colorWarning;
                }
                cell.setForeground(Utils.colorToIntArray(newFG));
                this.iLastState = iState;
            }
            catch (Exception e) {
                Debug.printStackTrace(e);
            }
        }
    }
}

