/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.mytorrents;

import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.menus.MenuItem;
import org.gudy.azureus2.plugins.ui.menus.MenuItemFillListener;
import org.gudy.azureus2.plugins.ui.menus.MenuItemListener;
import org.gudy.azureus2.plugins.ui.menus.MenuManager;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.plugins.ui.tables.TableContextMenuItem;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.ui.swt.views.table.CoreTableColumnSWT;

public class MaxUploadsItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public static final Class DATASOURCE_TYPE = Download.class;
    public static final String COLUMN_ID = "maxuploads";

    public MaxUploadsItem(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, 2, 30, sTableID);
        this.setRefreshInterval(-2);
        this.setMinWidthAuto(true);
        TableContextMenuItem menuItem = this.addContextMenuItem("TableColumn.menu.maxuploads");
        menuItem.setStyle(5);
        menuItem.addFillListener(new MenuItemFillListener(){

            public void menuWillBeShown(MenuItem menu, Object data) {
                menu.removeAllChildItems();
                PluginInterface pi = PluginInitializer.getDefaultInterface();
                UIManager uim = pi.getUIManager();
                MenuManager menuManager = uim.getMenuManager();
                int iStart = COConfigurationManager.getIntParameter("Max Uploads") - 2;
                if (iStart < 2) {
                    iStart = 2;
                }
                for (int i = iStart; i < iStart + 6; ++i) {
                    MenuItem item = menuManager.addMenuItem(menu, "MaxUploads." + i);
                    item.setText(String.valueOf(i));
                    item.setData(new Long(i));
                    item.addMultiListener(new MenuItemListener(){

                        public void selected(MenuItem item, Object target) {
                            if (target instanceof Object[]) {
                                Object[] targets;
                                for (Object object : targets = (Object[])target) {
                                    DownloadManager dm = (DownloadManager)object;
                                    int value = ((Long)item.getData()).intValue();
                                    dm.setMaxUploads(value);
                                }
                            }
                        }
                    });
                }
            }
        });
    }

    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"settings"});
        info.setProficiency((byte)2);
    }

    public void refresh(TableCell cell) {
        long value;
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        long l = value = dm == null ? 0L : (long)dm.getEffectiveMaxUploads();
        if (!cell.setSortValue(value) && cell.isValid()) {
            return;
        }
        cell.setText(String.valueOf(value));
    }
}

