/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.mytorrents;

import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.ui.menus.MenuItem;
import org.gudy.azureus2.plugins.ui.menus.MenuItemListener;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.plugins.ui.tables.TableContextMenuItem;
import org.gudy.azureus2.ui.swt.SimpleTextEntryWindow;
import org.gudy.azureus2.ui.swt.views.table.CoreTableColumnSWT;

public class MinSRItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public static final Class DATASOURCE_TYPE = Download.class;
    public static final String COLUMN_ID = "min_sr";

    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"sharing"});
        info.setProficiency((byte)1);
    }

    public MinSRItem(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, 2, 70, sTableID);
        this.setRefreshInterval(-2);
        TableContextMenuItem menuItem = this.addContextMenuItem("menu.min.share.ratio2");
        menuItem.addMultiListener(new MenuItemListener(){

            public void selected(MenuItem menu, Object target) {
                block12: {
                    if (target == null) {
                        return;
                    }
                    Object[] o = (Object[])target;
                    int existing = -1;
                    for (Object object : o) {
                        if (!(object instanceof DownloadManager)) continue;
                        int x = ((DownloadManager)object).getDownloadState().getIntParameter("sr.min");
                        if (existing == -1) {
                            existing = x;
                            continue;
                        }
                        if (existing == x) continue;
                        existing = -1;
                        break;
                    }
                    String existing_text = existing == -1 ? "" : String.valueOf((float)existing / 1000.0f);
                    SimpleTextEntryWindow entryWindow = new SimpleTextEntryWindow("min.sr.window.title", "min.sr.window.message");
                    entryWindow.setPreenteredText(existing_text, false);
                    entryWindow.selectPreenteredText(true);
                    entryWindow.prompt();
                    if (entryWindow.hasSubmittedInput()) {
                        try {
                            String text = entryWindow.getSubmittedInput().trim();
                            int sr = 0;
                            if (text.length() <= 0) break block12;
                            try {
                                float f = Float.parseFloat(text);
                                sr = (int)(f * 1000.0f);
                                if (sr < 0) {
                                    sr = 0;
                                } else if (sr == 0 && f > 0.0f) {
                                    sr = 1;
                                }
                            }
                            catch (Throwable e) {
                                Debug.out(e);
                            }
                            for (Object object : o) {
                                if (!(object instanceof DownloadManager)) continue;
                                ((DownloadManager)object).getDownloadState().setIntParameter("sr.min", sr);
                            }
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                }
            }
        });
    }

    public void refresh(TableCell cell) {
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        int value = 0;
        if (dm != null) {
            value = dm.getDownloadState().getIntParameter("sr.min");
        }
        if (!cell.setSortValue(value) && cell.isValid()) {
            return;
        }
        cell.setText(value == 0 ? "" : String.valueOf((float)value / 1000.0f));
    }
}

