/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.mytorrents;

import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.views.table.CoreTableColumnSWT;

public class SeedToPeerRatioItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public static final Class DATASOURCE_TYPE = Download.class;
    public static final String COLUMN_ID = "seed_to_peer_ratio";

    public SeedToPeerRatioItem(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, 2, 70, sTableID);
        this.setRefreshInterval(-2);
        this.setMinWidthAuto(true);
    }

    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"swarm"});
        info.setProficiency((byte)2);
    }

    public void refresh(TableCell cell) {
        float ratio = -1.0f;
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        if (dm != null) {
            int peers;
            int seeds;
            TRTrackerScraperResponse response = dm.getTrackerScrapeResponse();
            if (response != null && response.isValid()) {
                seeds = Math.max(dm.getNbSeeds(), response.getSeeds());
                int trackerPeerCount = response.getPeers();
                peers = dm.getNbPeers();
                if (peers == 0 || trackerPeerCount > peers) {
                    peers = trackerPeerCount <= 0 ? dm.getActivationCount() : trackerPeerCount;
                }
            } else {
                seeds = dm.getNbSeeds();
                peers = dm.getNbPeers();
            }
            ratio = peers < 0 || seeds < 0 ? 0.0f : (peers == 0 ? (seeds == 0 ? 0.0f : Float.POSITIVE_INFINITY) : (float)seeds / (float)peers);
        }
        if (!cell.setSortValue(ratio) && cell.isValid()) {
            return;
        }
        if (ratio == -1.0f) {
            cell.setText("");
        } else if (ratio == 0.0f) {
            cell.setText("??");
        } else {
            cell.setText(DisplayFormatters.formatDecimal(ratio, 3));
        }
    }
}

