/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.mytorrents;

import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.views.table.CoreTableColumnSWT;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;

public class ShareRatioFakeItem
extends CoreTableColumnSWT
implements TableCellRefreshListener,
ParameterListener {
    private static final String CONFIG_ID = "StartStopManager_iFirstPriority_ShareRatio";
    public static final String COLUMN_ID = "shareRatioFake";
    public static final Class DATASOURCE_TYPE = Download.class;
    private int iMinShareRatio;

    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"sharing", "swarm"});
    }

    public ShareRatioFakeItem(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, 2, 70, sTableID);
        this.setType(1);
        this.setRefreshInterval(-2);
        this.setMinWidthAuto(true);
        this.setPosition(-2);
        this.iMinShareRatio = COConfigurationManager.getIntParameter(CONFIG_ID);
        COConfigurationManager.addParameterListener(CONFIG_ID, (ParameterListener)this);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        COConfigurationManager.removeParameterListener(CONFIG_ID, this);
    }

    public void refresh(TableCell cell) {
        int sr;
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        int n = sr = dm != null ? dm.getStats().getShareRatioFake() : 0;
        if (sr == -1) {
            sr = 31536000;
        }
        if (!cell.setSortValue(sr) && cell.isValid()) {
            return;
        }
        String shareRatio = "";
        if (sr == 31536000) {
            shareRatio = "\u221e";
        } else {
            String partial = String.valueOf(sr % 1000);
            while (partial.length() < 3) {
                partial = "0" + partial;
            }
            shareRatio = DisplayFormatters.formatDecimal((double)sr / 1000.0, 3);
        }
        if (cell.setText(shareRatio)) {
            ((TableCellSWT)cell).setForeground(sr >= this.iMinShareRatio ? null : Colors.colorWarning);
        }
    }

    public void parameterChanged(String parameterName) {
        this.iMinShareRatio = COConfigurationManager.getIntParameter(CONFIG_ID);
        this.invalidateCells();
    }
}

