/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.mytorrents;

import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseEvent;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.plugins.ui.tables.TableRow;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.views.table.CoreTableColumnSWT;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;

public class StatusItem
extends CoreTableColumnSWT
implements TableCellRefreshListener,
TableCellMouseListener {
    public static final Class DATASOURCE_TYPE = Download.class;
    public static final String COLUMN_ID = "status";
    private static final Object CLICK_KEY = new Object();
    private static final int[] BLUE = Utils.colorToIntArray(Colors.blue);
    private boolean changeRowFG;
    private boolean changeCellFG = true;
    private boolean showTrackerErrors;

    public StatusItem(String sTableID, boolean changeRowFG) {
        super(DATASOURCE_TYPE, COLUMN_ID, 1, 80, sTableID);
        this.changeRowFG = changeRowFG;
        this.setRefreshInterval(-2);
    }

    public StatusItem(String sTableID) {
        this(sTableID, true);
    }

    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"essential"});
        info.setProficiency((byte)0);
    }

    public void refresh(TableCell cell) {
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        if (dm == null) {
            return;
        }
        int state = dm.getState();
        String text = this.showTrackerErrors && dm.isUnauthorisedOnTracker() && state != 100 ? dm.getTrackerStatus() : DisplayFormatters.formatDownloadStatus(dm);
        if (cell.setText(text) || !cell.isValid()) {
            boolean clickable = false;
            if (cell instanceof TableCellSWT) {
                int cursor_id;
                if (text.indexOf("http://") == -1) {
                    dm.setUserData(CLICK_KEY, null);
                    cursor_id = 0;
                } else {
                    dm.setUserData(CLICK_KEY, text);
                    cursor_id = 21;
                    clickable = true;
                }
                ((TableCellSWT)cell).setCursorID(cursor_id);
            }
            if (!this.changeCellFG && !this.changeRowFG) {
                cell.setForeground((int[])(clickable ? BLUE : null));
                return;
            }
            TableRow row = cell.getTableRow();
            if (row != null) {
                Object color = null;
                color = state == 60 ? Colors.blues[7] : (state == 100 ? Colors.colorError : null);
                if (this.changeRowFG) {
                    row.setForeground(Utils.colorToIntArray(color));
                } else if (this.changeCellFG) {
                    cell.setForeground(Utils.colorToIntArray(color));
                }
                if (clickable) {
                    cell.setForeground(Utils.colorToIntArray(Colors.blue));
                }
            }
        }
    }

    public boolean isChangeRowFG() {
        return this.changeRowFG;
    }

    public void setChangeRowFG(boolean changeRowFG) {
        this.changeRowFG = changeRowFG;
    }

    public boolean isChangeCellFG() {
        return this.changeCellFG;
    }

    public void setChangeCellFG(boolean changeCellFG) {
        this.changeCellFG = changeCellFG;
    }

    public void setShowTrackerErrors(boolean s) {
        this.showTrackerErrors = s;
    }

    public void cellMouseTrigger(TableCellMouseEvent event2) {
        String url;
        DownloadManager dm = (DownloadManager)event2.cell.getDataSource();
        if (dm == null) {
            return;
        }
        String clickable = (String)dm.getUserData(CLICK_KEY);
        if (clickable == null) {
            return;
        }
        event2.skipCoreFunctionality = true;
        if (event2.eventType == 1 && (url = UrlUtils.getURL(clickable)) != null) {
            Utils.launch(url);
        }
    }
}

