/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.mytorrents;

import com.aelitis.azureus.core.tag.Tag;
import com.aelitis.azureus.core.tag.TagManager;
import com.aelitis.azureus.core.tag.TagManagerFactory;
import com.aelitis.azureus.ui.swt.utils.ColorCache;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.views.table.CoreTableColumnSWT;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWTPaintListener;

public class TagColorsItem
extends CoreTableColumnSWT
implements TableCellRefreshListener,
TableCellSWTPaintListener {
    private static TagManager tag_manager = TagManagerFactory.getTagManager();
    public static final Class DATASOURCE_TYPE = Download.class;
    public static final String COLUMN_ID = "tag_colors";

    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"content"});
    }

    public TagColorsItem(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, 1, 70, sTableID);
        this.setRefreshInterval(-2);
    }

    public void refresh(TableCell cell) {
        List<Tag> tags;
        String sTags = null;
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        if (dm != null && (tags = tag_manager.getTagsForTaggable(3, dm)).size() > 0) {
            for (Tag t : tags) {
                String str = t.getTagName(true);
                if (sTags == null) {
                    sTags = str;
                    continue;
                }
                sTags = sTags + ", " + str;
            }
        }
        cell.setSortValue((Comparable)((Object)sTags));
        cell.setToolTip(sTags == null ? "" : sTags);
    }

    public void cellPaint(GC gc, TableCellSWT cell) {
        int num_colors;
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        ArrayList<Color> colors = new ArrayList<Color>();
        if (dm != null) {
            List<Tag> tags = tag_manager.getTagsForTaggable(3, dm);
            for (Tag tag : tags) {
                int[] rgb = tag.getColor();
                if (rgb == null || rgb.length != 3) continue;
                colors.add(ColorCache.getColor(gc.getDevice(), rgb));
            }
        }
        if ((num_colors = colors.size()) > 0) {
            Rectangle bounds = cell.getBounds();
            ++bounds.x;
            ++bounds.y;
            --bounds.width;
            --bounds.height;
            if (num_colors == 1) {
                gc.setBackground((Color)colors.get(0));
                gc.fillRectangle(bounds);
            } else {
                int width = bounds.width;
                int chunk = width / num_colors;
                if (chunk == 0) {
                    chunk = 1;
                }
                bounds.width = chunk;
                for (int i = 0; i < num_colors; ++i) {
                    int rem;
                    if (i == num_colors - 1 && (rem = width - chunk * (num_colors - 1)) > 0) {
                        bounds.width = rem;
                    }
                    gc.setBackground((Color)colors.get(i));
                    gc.fillRectangle(bounds);
                    bounds.x += chunk;
                }
            }
        }
    }
}

