/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.mytorrents;

import org.eclipse.swt.graphics.Color;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.core3.tracker.client.impl.bt.TRTrackerBTScraperResponseImpl;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;

public class TrackerCellUtils {
    public static final Class DATASOURCE_TYPE = Download.class;

    public static void updateColor(TableCell cell, DownloadManager dm, boolean show_errors) {
        if (dm == null || cell == null) {
            return;
        }
        if (show_errors && dm.isTrackerError()) {
            cell.setForegroundToErrorColor();
            return;
        }
        TRTrackerScraperResponse response = dm.getTrackerScrapeResponse();
        if (response instanceof TRTrackerBTScraperResponseImpl) {
            boolean bMultiHashScrapes = ((TRTrackerBTScraperResponseImpl)response).getTrackerStatus().getSupportsMultipeHashScrapes();
            Color color = bMultiHashScrapes ? null : Colors.grey;
            cell.setForeground(Utils.colorToIntArray(color));
        } else {
            cell.setForeground(Utils.colorToIntArray(null));
        }
    }

    public static String getTooltipText(TableCell cell, DownloadManager dm, boolean show_errors) {
        if (dm == null || cell == null) {
            return null;
        }
        if (show_errors && dm.isTrackerError()) {
            return null;
        }
        String sToolTip = null;
        TRTrackerScraperResponse response = dm.getTrackerScrapeResponse();
        if (response instanceof TRTrackerBTScraperResponseImpl) {
            String sPrefix = ((TRTrackerBTScraperResponseImpl)response).getTrackerStatus().getSupportsMultipeHashScrapes() ? "" : "No";
            sToolTip = MessageText.getString("Tracker.tooltip." + sPrefix + "MultiSupport");
        }
        return sToolTip;
    }
}

