/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.peers;

import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.views.table.CoreTableColumnSWT;

public class DownSpeedItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public static final String COLUMN_ID = "downloadspeed";

    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"bytes"});
    }

    public DownSpeedItem(String table_id) {
        super(COLUMN_ID, 2, -2, 65, table_id);
        this.setRefreshInterval(-2);
    }

    public void refresh(TableCell cell) {
        long sort_value;
        PEPeer peer = (PEPeer)cell.getDataSource();
        long data_value = 0L;
        long prot_value = 0L;
        if (peer != null) {
            data_value = peer.getStats().getDataReceiveRate();
            prot_value = peer.getStats().getProtocolReceiveRate();
        }
        if (!cell.setSortValue(sort_value = (data_value << 32) + prot_value) && cell.isValid()) {
            return;
        }
        cell.setText(DisplayFormatters.formatDataProtByteCountToKiBEtcPerSec(data_value, prot_value));
    }
}

