/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.peers;

import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.views.table.CoreTableColumnSWT;

public class MessagingItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public static final String COLUMN_ID = "Messaging";

    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"protocol"});
    }

    public MessagingItem(String table_id) {
        super(COLUMN_ID, 3, -1, 40, table_id);
        this.setRefreshInterval(-2);
    }

    public void refresh(TableCell cell) {
        String text;
        int value;
        PEPeer peer = (PEPeer)cell.getDataSource();
        int n = value = peer == null ? -1 : peer.getMessagingMode();
        if (!cell.setSortValue(value) && cell.isValid()) {
            return;
        }
        switch (value) {
            case 1: {
                text = "";
                break;
            }
            case 3: {
                text = "LT";
                break;
            }
            case 2: {
                text = "AZ";
                break;
            }
            case 4: {
                text = "Plugin";
                break;
            }
            default: {
                text = "";
            }
        }
        cell.setText(text);
    }
}

