/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.pieces;

import com.aelitis.azureus.core.diskmanager.cache.CacheFileManagerFactory;
import com.aelitis.azureus.core.diskmanager.cache.CacheFileManagerStats;
import java.util.Arrays;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.gudy.azureus2.core3.peer.PEPiece;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.plugins.ui.Graphic;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellAddedListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellDisposeListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThread;
import org.gudy.azureus2.ui.swt.plugins.UISWTGraphic;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTGraphicImpl;
import org.gudy.azureus2.ui.swt.views.table.CoreTableColumnSWT;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;

public class BlocksItem
extends CoreTableColumnSWT
implements TableCellAddedListener,
TableCellRefreshListener,
TableCellDisposeListener {
    private static final int COLOR_REQUESTED = 0;
    private static final int COLOR_WRITTEN = 1;
    private static final int COLOR_DOWNLOADED = 2;
    private static final int COLOR_INCACHE = 3;
    public static final Color[] colors = new Color[]{Colors.blues[2], Colors.blues[9], Colors.red, Colors.grey};
    private static CacheFileManagerStats cacheStats = null;

    public BlocksItem() {
        super("blocks", "Pieces");
        this.initializeAsGraphic(-2, 200);
    }

    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"progress"});
    }

    public void cellAdded(TableCell cell) {
        if (cacheStats == null) {
            try {
                cacheStats = CacheFileManagerFactory.getSingleton().getStats();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        cell.setFillCell(true);
    }

    public void dispose(final TableCell cell) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                Image img = ((TableCellSWT)cell).getGraphicSWT();
                if (img != null && !img.isDisposed()) {
                    img.dispose();
                }
            }
        });
    }

    public void refresh(final TableCell cell) {
        final PEPiece pePiece = (PEPiece)cell.getDataSource();
        if (pePiece == null) {
            cell.setSortValue(0L);
            this.dispose(cell);
            cell.setGraphic(null);
            return;
        }
        cell.setSortValue(pePiece.getNbWritten());
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                long addBlocks;
                long lNumBlocks = pePiece.getNbBlocks();
                int newWidth = cell.getWidth();
                if (newWidth <= 0) {
                    BlocksItem.this.dispose(cell);
                    cell.setGraphic(null);
                    return;
                }
                int newHeight = cell.getHeight();
                int x1 = newWidth - 2;
                int y1 = newHeight - 3;
                if (x1 < 10 || y1 < 3) {
                    BlocksItem.this.dispose(cell);
                    cell.setGraphic(null);
                    return;
                }
                Image image = new Image((Device)SWTThread.getInstance().getDisplay(), newWidth, newHeight);
                GC gcImage = new GC((Drawable)image);
                gcImage.setForeground(Colors.grey);
                gcImage.drawRectangle(0, 0, x1 + 1, y1 + 1);
                int blocksPerPixel = 0;
                int iPixelsPerBlock = 0;
                int pxRes = 0;
                long pxBlockStep = 0L;
                int factor = 4;
                while (iPixelsPerBlock <= 0) {
                    iPixelsPerBlock = (int)((long)(x1 + 1) / (lNumBlocks / (long)(++blocksPerPixel)));
                }
                pxRes = (int)((long)x1 - lNumBlocks / (long)blocksPerPixel * (long)iPixelsPerBlock);
                if (pxRes <= 0) {
                    pxRes = 1;
                }
                if ((addBlocks = lNumBlocks * (long)factor / (pxBlockStep = lNumBlocks * (long)factor / (long)pxRes)) * (long)iPixelsPerBlock > (long)pxRes) {
                    ++pxBlockStep;
                }
                TOTorrent torrent = pePiece.getManager().getDiskManager().getTorrent();
                boolean[] written = pePiece.getDMPiece().getWritten();
                boolean piece_written = pePiece.isWritten();
                int drawnWidth = 0;
                int blockStep = 0;
                int pieceNumber = pePiece.getPieceNumber();
                long[] offsets = new long[(int)lNumBlocks];
                long[] lengths = (long[])offsets.clone();
                Arrays.fill(offsets, (long)pePiece.getManager().getDiskManager().getPieceLength() * (long)pieceNumber);
                int i = 0;
                while ((long)i < lNumBlocks) {
                    lengths[i] = pePiece.getBlockSize(i);
                    int n = i;
                    offsets[n] = offsets[n] + (long)(16384 * i);
                    ++i;
                }
                boolean[] isCached = cacheStats == null ? new boolean[(int)lNumBlocks] : cacheStats.getBytesInCache(torrent, offsets, lengths);
                int i2 = 0;
                while ((long)i2 < lNumBlocks) {
                    int nextWidth = iPixelsPerBlock;
                    if ((long)(blockStep += blocksPerPixel * factor) >= pxBlockStep) {
                        nextWidth += (int)((long)blockStep / pxBlockStep);
                        blockStep = (int)((long)blockStep - pxBlockStep);
                    }
                    if ((long)i2 >= lNumBlocks - (long)blocksPerPixel) {
                        nextWidth = x1 - drawnWidth;
                    }
                    Color color = Colors.white;
                    if (written == null && piece_written || written != null && written[i2]) {
                        color = colors[1];
                    } else if (pePiece.isDownloaded(i2)) {
                        color = colors[2];
                    } else if (pePiece.isRequested(i2)) {
                        color = colors[0];
                    }
                    gcImage.setBackground(color);
                    gcImage.fillRectangle(drawnWidth + 1, 1, nextWidth, y1);
                    if (isCached[i2]) {
                        gcImage.setBackground(colors[3]);
                        gcImage.fillRectangle(drawnWidth + 1, 1, nextWidth, 3);
                    }
                    drawnWidth += nextWidth;
                    i2 += blocksPerPixel;
                }
                gcImage.dispose();
                Image oldImage = null;
                Graphic graphic = cell.getGraphic();
                if (graphic instanceof UISWTGraphic) {
                    oldImage = ((UISWTGraphic)graphic).getImage();
                }
                if (cell instanceof TableCellSWT) {
                    ((TableCellSWT)cell).setGraphic(image);
                } else {
                    cell.setGraphic(new UISWTGraphicImpl(image));
                }
                if (oldImage != null && !oldImage.isDisposed()) {
                    oldImage.dispose();
                }
                gcImage.dispose();
            }
        });
    }
}

