/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.tracker;

import com.aelitis.azureus.core.tracker.TrackerPeerSource;
import org.gudy.azureus2.core3.util.TimeFormatter;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.views.table.CoreTableColumnSWT;

public class IntervalItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public IntervalItem(String tableID) {
        super("interval", 3, -2, 75, tableID);
        this.setRefreshInterval(-1);
    }

    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"essential"});
    }

    public void refresh(TableCell cell) {
        long sort;
        TrackerPeerSource ps = (TrackerPeerSource)cell.getDataSource();
        long interval = 0L;
        long min_interval = 0L;
        if (ps != null) {
            interval = ps.getInterval();
            min_interval = ps.getMinInterval();
        }
        if (!cell.setSortValue(sort = interval << 31 | min_interval & 0xFFFFFFFFL) && cell.isValid()) {
            return;
        }
        String str = interval <= 0L && min_interval <= 0L ? "" : (interval <= 0L ? "(" + this.format(min_interval) + ")" : (min_interval <= 0L ? this.format(interval) : this.format(interval) + " (" + this.format(min_interval) + ")"));
        cell.setText(str);
    }

    private String format(long secs) {
        return TimeFormatter.format2(secs, secs < 300L && secs % 60L != 0L);
    }
}

