/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.webplugin;

import com.aelitis.azureus.core.pairing.PairedService;
import com.aelitis.azureus.core.pairing.PairedServiceRequestHandler;
import com.aelitis.azureus.core.pairing.PairingConnectionData;
import com.aelitis.azureus.core.pairing.PairingManager;
import com.aelitis.azureus.core.pairing.PairingManagerFactory;
import com.aelitis.azureus.core.pairing.PairingManagerListener;
import com.aelitis.azureus.core.proxy.AEProxyFactory;
import com.aelitis.azureus.plugins.upnp.UPnPMapping;
import com.aelitis.azureus.plugins.upnp.UPnPPlugin;
import com.aelitis.azureus.util.JSONUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.GZIPOutputStream;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.core3.util.SHA1Hasher;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimeFormatter;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginConfig;
import org.gudy.azureus2.plugins.PluginException;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginListener;
import org.gudy.azureus2.plugins.ipfilter.IPRange;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.logging.LoggerChannelListener;
import org.gudy.azureus2.plugins.tracker.Tracker;
import org.gudy.azureus2.plugins.tracker.TrackerException;
import org.gudy.azureus2.plugins.tracker.TrackerTorrent;
import org.gudy.azureus2.plugins.tracker.web.TrackerAuthenticationAdapter;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebContext;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebPageGenerator;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebPageRequest;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebPageResponse;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.config.BooleanParameter;
import org.gudy.azureus2.plugins.ui.config.HyperlinkParameter;
import org.gudy.azureus2.plugins.ui.config.InfoParameter;
import org.gudy.azureus2.plugins.ui.config.IntParameter;
import org.gudy.azureus2.plugins.ui.config.LabelParameter;
import org.gudy.azureus2.plugins.ui.config.Parameter;
import org.gudy.azureus2.plugins.ui.config.ParameterListener;
import org.gudy.azureus2.plugins.ui.config.PasswordParameter;
import org.gudy.azureus2.plugins.ui.config.StringListParameter;
import org.gudy.azureus2.plugins.ui.config.StringParameter;
import org.gudy.azureus2.plugins.ui.model.BasicPluginConfigModel;
import org.gudy.azureus2.plugins.ui.model.BasicPluginViewModel;
import org.json.simple.JSONObject;

public class WebPlugin
implements Plugin,
TrackerWebPageGenerator {
    public static final String PR_ENABLE = "Enable";
    public static final String PR_DISABLABLE = "Disablable";
    public static final String PR_PORT = "Port";
    public static final String PR_BIND_IP = "Bind IP";
    public static final String PR_ROOT_RESOURCE = "Root Resource";
    public static final String PR_ROOT_DIR = "Root Dir";
    public static final String PR_ACCESS = "Access";
    public static final String PR_LOG = "DefaultLoggerChannel";
    public static final String PR_CONFIG_MODEL_PARAMS = "DefaultConfigModelParams";
    public static final String PR_CONFIG_MODEL = "DefaultConfigModel";
    public static final String PR_VIEW_MODEL = "DefaultViewModel";
    public static final String PR_HIDE_RESOURCE_CONFIG = "DefaultHideResourceConfig";
    public static final String PR_ENABLE_KEEP_ALIVE = "DefaultEnableKeepAlive";
    public static final String PR_PAIRING_SID = "PairingSID";
    public static final String PROPERTIES_MIGRATED = "Properties Migrated";
    public static final String CONFIG_MIGRATED = "Config Migrated";
    public static final String PAIRING_MIGRATED = "Pairing Migrated";
    public static final String PAIRING_SESSION_KEY = "Pairing Session Key";
    public static final String CONFIG_PASSWORD_ENABLE = "Password Enable";
    public static final boolean CONFIG_PASSWORD_ENABLE_DEFAULT = false;
    public static final String CONFIG_PAIRING_ENABLE = "Pairing Enable";
    public static final boolean CONFIG_PAIRING_ENABLE_DEFAULT = true;
    public static final String CONFIG_PORT_OVERRIDE = "Port Override";
    public static final String CONFIG_PAIRING_AUTO_AUTH = "Pairing Auto Auth";
    public static final boolean CONFIG_PAIRING_AUTO_AUTH_DEFAULT = true;
    public static final String CONFIG_ENABLE = "Enable";
    public boolean CONFIG_ENABLE_DEFAULT = true;
    public static final String CONFIG_USER = "User";
    public static final String CONFIG_USER_DEFAULT = "";
    public static final String CONFIG_PASSWORD = "Password";
    public static final byte[] CONFIG_PASSWORD_DEFAULT = new byte[0];
    public static final String CONFIG_PORT = "Port";
    public int CONFIG_PORT_DEFAULT = 8089;
    public static final String CONFIG_BIND_IP = "Bind IP";
    public String CONFIG_BIND_IP_DEFAULT = "";
    public static final String CONFIG_PROTOCOL = "Protocol";
    public static final String CONFIG_PROTOCOL_DEFAULT = "HTTP";
    public static final String CONFIG_UPNP_ENABLE = "UPnP Enable";
    public static final boolean CONFIG_UPNP_ENABLE_DEFAULT = true;
    public static final String CONFIG_HOME_PAGE = "Home Page";
    public static final String CONFIG_HOME_PAGE_DEFAULT = "index.html";
    public static final String CONFIG_ROOT_DIR = "Root Dir";
    public String CONFIG_ROOT_DIR_DEFAULT = "";
    public static final String CONFIG_ROOT_RESOURCE = "Root Resource";
    public String CONFIG_ROOT_RESOURCE_DEFAULT = "";
    public static final String CONFIG_MODE = "Mode";
    public static final String CONFIG_MODE_FULL = "full";
    public static final String CONFIG_MODE_DEFAULT = "full";
    public static final String CONFIG_ACCESS = "Access";
    public String CONFIG_ACCESS_DEFAULT = "all";
    protected static final String NL = "\r\n";
    protected static final String[] welcome_pages = new String[]{"index.html", "index.htm", "index.php", "index.tmpl"};
    protected static File[] welcome_files;
    private static final AsyncDispatcher network_dispatcher;
    protected PluginInterface plugin_interface;
    private LoggerChannel log;
    private PluginConfig plugin_config;
    private BasicPluginViewModel view_model;
    private BasicPluginConfigModel config_model;
    private String p_sid;
    private StringParameter param_home;
    private StringParameter param_rootdir;
    private StringParameter param_rootres;
    private IntParameter param_port;
    private StringListParameter param_protocol;
    private StringParameter param_bind;
    private StringParameter param_access;
    private InfoParameter param_i2p_dest;
    private BooleanParameter p_upnp_enable;
    private BooleanParameter pw_enable;
    private StringParameter p_user_name;
    private PasswordParameter p_password;
    private BooleanParameter param_auto_auth;
    private IntParameter param_port_or;
    private boolean setting_auto_auth;
    private String pairing_access_code;
    private String pairing_session_code;
    private boolean plugin_enabled;
    private String home_page;
    private String file_root;
    private String resource_root;
    private String root_dir;
    private boolean ip_range_all = false;
    private List<IPRange> ip_ranges;
    private TrackerWebContext tracker_context;
    private UPnPMapping upnp_mapping;
    private PairingManagerListener pairing_listener;
    private Properties properties;
    private static ThreadLocal<String> tls;
    private static final int LOGOUT_GRACE_MILLIS = 5000;
    private static final String GRACE_PERIOD_MARKER = "<grace_period>";
    private Map<String, Long> logout_timer = new HashMap<String, Long>();

    public WebPlugin() {
        this.properties = new Properties();
    }

    public WebPlugin(Properties defaults) {
        this.properties = defaults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(PluginInterface _plugin_interface) throws PluginException {
        HyperlinkParameter pairing_test;
        HyperlinkParameter connection_test;
        BooleanParameter pairing_enable;
        LabelParameter pairing_info;
        BooleanParameter param_enable;
        Boolean disablable;
        String pr_access;
        String pr_root_dir;
        String pr_root_resource;
        String pr_bind_ip;
        Integer pr_port;
        Boolean pr_enable;
        Object o;
        this.plugin_interface = _plugin_interface;
        this.plugin_config = this.plugin_interface.getPluginconfig();
        Properties plugin_properties = this.plugin_interface.getPluginProperties();
        if (plugin_properties != null && (o = plugin_properties.get("plugin." + "Root Dir".replaceAll(" ", "_"))) instanceof String) {
            this.properties.put("Root Dir", o);
        }
        if ((pr_enable = (Boolean)this.properties.get("Enable")) != null) {
            this.CONFIG_ENABLE_DEFAULT = pr_enable;
        }
        if ((pr_port = (Integer)this.properties.get("Port")) != null) {
            this.CONFIG_PORT_DEFAULT = pr_port;
        }
        if ((pr_bind_ip = (String)this.properties.get("Bind IP")) != null) {
            this.CONFIG_BIND_IP_DEFAULT = pr_bind_ip.trim();
        }
        if ((pr_root_resource = (String)this.properties.get("Root Resource")) != null) {
            this.CONFIG_ROOT_RESOURCE_DEFAULT = pr_root_resource;
        }
        if ((pr_root_dir = (String)this.properties.get("Root Dir")) != null) {
            this.CONFIG_ROOT_DIR_DEFAULT = pr_root_dir;
        }
        if ((pr_access = (String)this.properties.get("Access")) != null) {
            this.CONFIG_ACCESS_DEFAULT = pr_access;
        }
        Boolean pr_hide_resource_config = (Boolean)this.properties.get(PR_HIDE_RESOURCE_CONFIG);
        this.log = (LoggerChannel)this.properties.get(PR_LOG);
        if (this.log == null) {
            this.log = this.plugin_interface.getLogger().getChannel("WebPlugin");
        }
        this.p_sid = (String)this.properties.get(PR_PAIRING_SID);
        UIManager ui_manager = this.plugin_interface.getUIManager();
        this.view_model = (BasicPluginViewModel)this.properties.get(PR_VIEW_MODEL);
        if (this.view_model == null) {
            this.view_model = ui_manager.createBasicPluginViewModel(this.plugin_interface.getPluginName());
        }
        String plugin_id = this.plugin_interface.getPluginID();
        String sConfigSectionID = "plugins." + plugin_id;
        this.view_model.setConfigSectionID(sConfigSectionID);
        this.view_model.getStatus().setText("Running");
        this.view_model.getActivity().setVisible(false);
        this.view_model.getProgress().setVisible(false);
        this.log.addListener(new LoggerChannelListener(){

            public void messageLogged(int type, String message) {
                WebPlugin.this.view_model.getLogArea().appendText(message + "\n");
            }

            public void messageLogged(String str, Throwable error) {
                WebPlugin.this.view_model.getLogArea().appendText(str + "\n");
                WebPlugin.this.view_model.getLogArea().appendText(error.toString() + "\n");
            }
        });
        this.config_model = (BasicPluginConfigModel)this.properties.get(PR_CONFIG_MODEL);
        if (this.config_model == null) {
            String[] cm_params = (String[])this.properties.get(PR_CONFIG_MODEL_PARAMS);
            this.config_model = cm_params == null || cm_params.length == 0 ? ui_manager.createBasicPluginConfigModel("plugins", sConfigSectionID) : (cm_params.length == 1 ? ui_manager.createBasicPluginConfigModel(cm_params[0]) : ui_manager.createBasicPluginConfigModel(cm_params[0], cm_params[1]));
        }
        boolean save_needed = false;
        if (!this.plugin_config.getPluginBooleanParameter(CONFIG_MIGRATED, false)) {
            this.plugin_config.setPluginParameter(CONFIG_MIGRATED, true);
            save_needed = true;
            this.plugin_config.setPluginParameter(CONFIG_PASSWORD_ENABLE, this.plugin_config.getBooleanParameter("Tracker Password Enable Web", false));
            this.plugin_config.setPluginParameter(CONFIG_USER, this.plugin_config.getStringParameter("Tracker Username", CONFIG_USER_DEFAULT));
            this.plugin_config.setPluginParameter(CONFIG_PASSWORD, this.plugin_config.getByteParameter("Tracker Password", CONFIG_PASSWORD_DEFAULT));
        }
        if (!this.plugin_config.getPluginBooleanParameter(PROPERTIES_MIGRATED, false)) {
            this.plugin_config.setPluginParameter(PROPERTIES_MIGRATED, true);
            Properties props = this.plugin_interface.getPluginProperties();
            if (props.getProperty("port", CONFIG_USER_DEFAULT).length() > 0) {
                save_needed = true;
                String prop_port = props.getProperty("port", CONFIG_USER_DEFAULT + this.CONFIG_PORT_DEFAULT);
                String prop_protocol = props.getProperty("protocol", CONFIG_PROTOCOL_DEFAULT);
                String prop_home = props.getProperty("homepage", CONFIG_HOME_PAGE_DEFAULT);
                String prop_rootdir = props.getProperty("rootdir", this.CONFIG_ROOT_DIR_DEFAULT);
                String prop_rootres = props.getProperty("rootresource", this.CONFIG_ROOT_RESOURCE_DEFAULT);
                String prop_mode = props.getProperty("mode", "full");
                String prop_access = props.getProperty("access", this.CONFIG_ACCESS_DEFAULT);
                int prop_port_int = this.CONFIG_PORT_DEFAULT;
                try {
                    prop_port_int = Integer.parseInt(prop_port);
                }
                catch (Throwable e) {
                    // empty catch block
                }
                this.plugin_config.setPluginParameter("Port", prop_port_int);
                this.plugin_config.setPluginParameter(CONFIG_PROTOCOL, prop_protocol);
                this.plugin_config.setPluginParameter(CONFIG_HOME_PAGE, prop_home);
                this.plugin_config.setPluginParameter("Root Dir", prop_rootdir);
                this.plugin_config.setPluginParameter("Root Resource", prop_rootres);
                this.plugin_config.setPluginParameter(CONFIG_MODE, prop_mode);
                this.plugin_config.setPluginParameter("Access", prop_access);
                File props_file = new File(this.plugin_interface.getPluginDirectoryName(), "plugin.properties");
                PrintWriter pw = null;
                try {
                    Parameter[] parameterArray;
                    try {
                        File backup = new File(this.plugin_interface.getPluginDirectoryName(), "plugin.properties.bak");
                        props_file.renameTo(backup);
                        pw = new PrintWriter(new FileWriter(props_file));
                        pw.println("plugin.class=" + props.getProperty("plugin.class"));
                        pw.println("plugin.name=" + props.getProperty("plugin.name"));
                        pw.println("plugin.version=" + props.getProperty("plugin.version"));
                        pw.println("plugin.id=" + props.getProperty("plugin.id"));
                        pw.println(CONFIG_USER_DEFAULT);
                        pw.println("# configuration has been migrated to plugin config - see view->config->plugins");
                        pw.println("# in the SWT user interface");
                        this.log.logAlert(1, this.plugin_interface.getPluginName() + " - plugin.properties settings migrated to plugin configuration.");
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                        this.log.logAlert(3, this.plugin_interface.getPluginName() + " - plugin.properties settings migration failed.");
                        parameterArray = null;
                        if (pw != null) {
                            pw.close();
                        }
                    }
                    parameterArray = null;
                    if (pw != null) {
                        pw.close();
                    }
                }
                catch (Throwable throwable) {
                    Object var27_32 = null;
                    if (pw != null) {
                        pw.close();
                    }
                    throw throwable;
                }
            }
        }
        if (save_needed) {
            this.plugin_config.save();
        }
        if ((disablable = (Boolean)this.properties.get(PR_DISABLABLE)) != null && disablable.booleanValue()) {
            param_enable = this.config_model.addBooleanParameter2("Enable", "webui.enable", this.CONFIG_ENABLE_DEFAULT);
            this.plugin_enabled = param_enable.getValue();
        } else {
            param_enable = null;
            this.plugin_enabled = true;
        }
        this.initStage(1);
        this.param_port = this.config_model.addIntParameter2("Port", "webui.port", this.CONFIG_PORT_DEFAULT);
        this.param_bind = this.config_model.addStringParameter2("Bind IP", "webui.bindip", this.CONFIG_BIND_IP_DEFAULT);
        this.param_protocol = this.config_model.addStringListParameter2(CONFIG_PROTOCOL, "webui.protocol", new String[]{"http", "https"}, CONFIG_PROTOCOL_DEFAULT);
        ParameterListener update_server_listener = new ParameterListener(){

            public void parameterChanged(Parameter param) {
                WebPlugin.this.setupServer();
            }
        };
        this.param_port.addListener(update_server_listener);
        this.param_bind.addListener(update_server_listener);
        this.param_protocol.addListener(update_server_listener);
        this.param_i2p_dest = this.config_model.addInfoParameter2("webui.i2p_dest", CONFIG_USER_DEFAULT);
        this.param_i2p_dest.setVisible(false);
        if (param_enable != null) {
            COConfigurationManager.registerExportedParameter(plugin_id + ".enable", param_enable.getConfigKeyName());
        }
        COConfigurationManager.registerExportedParameter(plugin_id + ".port", this.param_port.getConfigKeyName());
        COConfigurationManager.registerExportedParameter(plugin_id + ".protocol", this.param_protocol.getConfigKeyName());
        this.p_upnp_enable = this.config_model.addBooleanParameter2(CONFIG_UPNP_ENABLE, "webui.upnpenable", true);
        this.p_upnp_enable.addListener(new ParameterListener(){

            public void parameterChanged(Parameter param) {
                WebPlugin.this.setupUPnP();
            }
        });
        this.plugin_interface.addListener(new PluginListener(){

            public void initializationComplete() {
                WebPlugin.this.setupUPnP();
            }

            public void closedownInitiated() {
            }

            public void closedownComplete() {
            }
        });
        if (this.p_sid != null) {
            final PairingManager pm = PairingManagerFactory.getSingleton();
            pairing_info = this.config_model.addLabelParameter2("webui.pairing.info." + (pm.isEnabled() ? "y" : "n"));
            pairing_enable = this.config_model.addBooleanParameter2(CONFIG_PAIRING_ENABLE, "webui.pairingenable", true);
            if (!this.plugin_config.getPluginBooleanParameter(PAIRING_MIGRATED, false)) {
                boolean has_pw_enabled = this.plugin_config.getPluginBooleanParameter(CONFIG_PASSWORD_ENABLE, false);
                if (has_pw_enabled) {
                    this.plugin_config.setPluginParameter(CONFIG_PAIRING_AUTO_AUTH, false);
                }
                this.plugin_config.setPluginParameter(PAIRING_MIGRATED, true);
            }
            this.param_port_or = this.config_model.addIntParameter2(CONFIG_PORT_OVERRIDE, "webui.port.override", 0);
            this.param_auto_auth = this.config_model.addBooleanParameter2(CONFIG_PAIRING_AUTO_AUTH, "webui.pairing.autoauth", true);
            this.param_auto_auth.addListener(new ParameterListener(){

                public void parameterChanged(Parameter param) {
                    if (pairing_enable.getValue() && pm.isEnabled()) {
                        WebPlugin.this.setupAutoAuth();
                    } else {
                        WebPlugin.this.setupSessionCode(null);
                    }
                }
            });
            connection_test = this.config_model.addHyperlinkParameter2("webui.connectiontest", this.getConnectionTestURL(this.p_sid));
            pairing_test = this.config_model.addHyperlinkParameter2("webui.pairingtest", "http://remote.vuze.com/?sid=" + this.p_sid);
            String sid_key = "Plugin." + plugin_id + ".pairing.sid";
            COConfigurationManager.setStringDefault(sid_key, this.p_sid);
            COConfigurationManager.registerExportedParameter(plugin_id + ".pairing.sid", sid_key);
            COConfigurationManager.registerExportedParameter(plugin_id + ".pairing.enable", pairing_enable.getConfigKeyName());
            COConfigurationManager.registerExportedParameter(plugin_id + ".pairing.auto_auth", this.param_auto_auth.getConfigKeyName());
        } else {
            pairing_info = null;
            pairing_enable = null;
            this.param_auto_auth = null;
            this.param_port_or = null;
            pairing_test = null;
            connection_test = null;
        }
        this.config_model.createGroup("ConfigView.section.Pairing", new Parameter[]{pairing_info, pairing_enable, this.param_port_or, this.param_auto_auth, connection_test, pairing_test});
        this.config_model.createGroup("ConfigView.section.server", new Parameter[]{this.param_port, this.param_bind, this.param_protocol, this.param_i2p_dest, this.p_upnp_enable});
        this.param_home = this.config_model.addStringParameter2(CONFIG_HOME_PAGE, "webui.homepage", CONFIG_HOME_PAGE_DEFAULT);
        this.param_rootdir = this.config_model.addStringParameter2("Root Dir", "webui.rootdir", this.CONFIG_ROOT_DIR_DEFAULT);
        this.param_rootres = this.config_model.addStringParameter2("Root Resource", "webui.rootres", this.CONFIG_ROOT_RESOURCE_DEFAULT);
        if (pr_hide_resource_config != null && pr_hide_resource_config.booleanValue()) {
            this.param_home.setVisible(false);
            this.param_rootdir.setVisible(false);
            this.param_rootres.setVisible(false);
        } else {
            ParameterListener update_resources_listener = new ParameterListener(){

                public void parameterChanged(Parameter param) {
                    WebPlugin.this.setupResources();
                }
            };
            this.param_home.addListener(update_resources_listener);
            this.param_rootdir.addListener(update_resources_listener);
            this.param_rootres.addListener(update_resources_listener);
        }
        LabelParameter a_label1 = this.config_model.addLabelParameter2("webui.mode.info");
        StringListParameter param_mode = this.config_model.addStringListParameter2(CONFIG_MODE, "webui.mode", new String[]{"full", "view"}, "full");
        LabelParameter a_label2 = this.config_model.addLabelParameter2("webui.access.info");
        this.param_access = this.config_model.addStringParameter2("Access", "webui.access", this.CONFIG_ACCESS_DEFAULT);
        this.param_access.addListener(new ParameterListener(){

            public void parameterChanged(Parameter param) {
                WebPlugin.this.setupAccess();
            }
        });
        this.pw_enable = this.config_model.addBooleanParameter2(CONFIG_PASSWORD_ENABLE, "webui.passwordenable", false);
        this.p_user_name = this.config_model.addStringParameter2(CONFIG_USER, "webui.user", CONFIG_USER_DEFAULT);
        this.p_password = this.config_model.addPasswordParameter2(CONFIG_PASSWORD, "webui.password", 2, CONFIG_PASSWORD_DEFAULT);
        this.pw_enable.addEnabledOnSelection(this.p_user_name);
        this.pw_enable.addEnabledOnSelection(this.p_password);
        ParameterListener auth_change_listener = new ParameterListener(){

            public void parameterChanged(Parameter param) {
                if (WebPlugin.this.param_auto_auth != null && !WebPlugin.this.setting_auto_auth) {
                    WebPlugin.this.log("Disabling pairing auto-authentication as overridden by user");
                    WebPlugin.this.param_auto_auth.setValue(false);
                }
                if (param == WebPlugin.this.p_user_name || param == WebPlugin.this.p_password) {
                    WebPlugin.this.setupSessionCode(null);
                }
            }
        };
        this.p_user_name.addListener(auth_change_listener);
        this.p_password.addListener(auth_change_listener);
        this.pw_enable.addListener(auth_change_listener);
        this.config_model.createGroup("webui.group.access", new Parameter[]{a_label1, param_mode, a_label2, this.param_access, this.pw_enable, this.p_user_name, this.p_password});
        if (this.p_sid != null) {
            final PairingManager pm = PairingManagerFactory.getSingleton();
            pairing_enable.addListener(new ParameterListener(){

                public void parameterChanged(Parameter param) {
                    boolean enabled = pairing_enable.getValue();
                    WebPlugin.this.param_auto_auth.setEnabled(pm.isEnabled() && enabled);
                    WebPlugin.this.param_port_or.setEnabled(pm.isEnabled() && enabled);
                    boolean test_ok = pm.isEnabled() && pairing_enable.getValue() && pm.peekAccessCode() != null && !pm.hasActionOutstanding();
                    pairing_test.setEnabled(test_ok);
                    connection_test.setEnabled(test_ok);
                    WebPlugin.this.setupPairing(WebPlugin.this.p_sid, enabled);
                }
            });
            this.pairing_listener = new PairingManagerListener(){

                public void somethingChanged(PairingManager pm) {
                    pairing_info.setLabelKey("webui.pairing.info." + (pm.isEnabled() ? "y" : "n"));
                    if (WebPlugin.this.plugin_enabled) {
                        pairing_enable.setEnabled(pm.isEnabled());
                        WebPlugin.this.param_auto_auth.setEnabled(pm.isEnabled() && pairing_enable.getValue());
                        WebPlugin.this.param_port_or.setEnabled(pm.isEnabled() && pairing_enable.getValue());
                        boolean test_ok = pm.isEnabled() && pairing_enable.getValue() && pm.peekAccessCode() != null && !pm.hasActionOutstanding();
                        pairing_test.setEnabled(test_ok);
                        connection_test.setEnabled(test_ok);
                    }
                    connection_test.setHyperlink(WebPlugin.this.getConnectionTestURL(WebPlugin.this.p_sid));
                    WebPlugin.this.setupPairing(WebPlugin.this.p_sid, pairing_enable.getValue());
                }
            };
            this.pairing_listener.somethingChanged(pm);
            pm.addListener(this.pairing_listener);
            this.setupPairing(this.p_sid, pairing_enable.getValue());
            ParameterListener update_pairing_listener = new ParameterListener(){

                public void parameterChanged(Parameter param) {
                    WebPlugin.this.updatePairing(WebPlugin.this.p_sid);
                    WebPlugin.this.setupUPnP();
                }
            };
            this.param_port.addListener(update_pairing_listener);
            this.param_port_or.addListener(update_pairing_listener);
            this.param_protocol.addListener(update_pairing_listener);
        }
        if (param_enable != null) {
            final ArrayList<Parameter> changed_params = new ArrayList<Parameter>();
            if (!this.plugin_enabled) {
                Parameter[] params;
                for (Parameter param : params = this.config_model.getParameters()) {
                    if (param == param_enable || !param.isEnabled()) continue;
                    changed_params.add(param);
                    param.setEnabled(false);
                }
            }
            param_enable.addListener(new ParameterListener(){

                public void parameterChanged(Parameter e_p) {
                    WebPlugin.this.plugin_enabled = ((BooleanParameter)e_p).getValue();
                    if (WebPlugin.this.plugin_enabled) {
                        for (Parameter p : changed_params) {
                            p.setEnabled(true);
                        }
                    } else {
                        Parameter[] params;
                        changed_params.clear();
                        for (Parameter param : params = WebPlugin.this.config_model.getParameters()) {
                            if (param == e_p || !param.isEnabled()) continue;
                            changed_params.add(param);
                            param.setEnabled(false);
                        }
                    }
                    WebPlugin.this.setupServer();
                    WebPlugin.this.setupUPnP();
                    if (WebPlugin.this.p_sid != null) {
                        WebPlugin.this.setupPairing(WebPlugin.this.p_sid, pairing_enable.getValue());
                    }
                }
            });
        }
        this.setupResources();
        this.setupAccess();
        this.setupServer();
    }

    protected void initStage(int num) {
    }

    private String getConnectionTestURL(String sid) {
        String ac;
        String res = "http://pair.vuze.com/pairing/web/test?sid=" + sid;
        PairingManager pm = PairingManagerFactory.getSingleton();
        if (pm.isEnabled() && (ac = pm.peekAccessCode()) != null) {
            res = res + "&ac=" + ac;
        }
        return res;
    }

    protected boolean isPluginEnabled() {
        return this.plugin_enabled;
    }

    protected void unloadPlugin() {
        if (this.view_model != null) {
            this.view_model.destroy();
            this.view_model = null;
        }
        if (this.config_model != null) {
            this.config_model.destroy();
            this.config_model = null;
        }
        if (this.tracker_context != null) {
            this.tracker_context.destroy();
            this.tracker_context = null;
        }
        if (this.upnp_mapping != null) {
            this.upnp_mapping.destroy();
            this.upnp_mapping = null;
        }
        if (this.pairing_listener != null) {
            PairingManager pm = PairingManagerFactory.getSingleton();
            pm.removeListener(this.pairing_listener);
            this.pairing_listener = null;
        }
    }

    private void setupResources() {
        String error;
        File f_root;
        this.home_page = this.param_home.getValue().trim();
        if (this.home_page.length() == 0) {
            this.home_page = null;
        } else if (!this.home_page.startsWith("/")) {
            this.home_page = "/" + this.home_page;
        }
        this.resource_root = this.param_rootres.getValue().trim();
        if (this.resource_root.length() == 0) {
            this.resource_root = null;
        } else if (this.resource_root.startsWith("/")) {
            this.resource_root = this.resource_root.substring(1);
        }
        this.root_dir = this.param_rootdir.getValue().trim();
        if (this.root_dir.length() == 0) {
            this.file_root = this.plugin_interface.getPluginDirectoryName();
            if (this.file_root == null) {
                this.file_root = SystemProperties.getUserPath() + "web";
            }
        } else if (this.root_dir.startsWith(File.separator) || this.root_dir.indexOf(":") != -1) {
            this.file_root = this.root_dir;
        } else {
            if (File.separatorChar != '/' && this.root_dir.contains("/")) {
                this.root_dir = this.root_dir.replace('/', File.separatorChar);
            }
            this.file_root = this.plugin_interface.getPluginDirectoryName();
            if (this.file_root != null) {
                this.file_root = this.file_root + File.separator + this.root_dir;
                if (!new File(this.file_root).exists()) {
                    this.file_root = null;
                }
            }
            if (this.file_root == null) {
                this.file_root = SystemProperties.getUserPath() + "web" + File.separator + this.root_dir;
            }
        }
        if (!(f_root = new File(this.file_root)).exists()) {
            error = "WebPlugin: root dir '" + this.file_root + "' doesn't exist";
            this.log.log(3, error);
        } else if (!f_root.isDirectory()) {
            error = "WebPlugin: root dir '" + this.file_root + "' isn't a directory";
            this.log.log(3, error);
        }
        welcome_files = new File[welcome_pages.length];
        for (int i = 0; i < welcome_pages.length; ++i) {
            WebPlugin.welcome_files[i] = new File(this.file_root + File.separator + welcome_pages[i]);
        }
    }

    private void setupAccess() {
        String access_str = this.param_access.getValue().trim();
        String ip_ranges_str = CONFIG_USER_DEFAULT;
        this.ip_ranges = null;
        this.ip_range_all = false;
        if (access_str.length() > 7 && Character.isDigit(access_str.charAt(0))) {
            String[] ranges = access_str.replace(';', ',').split(",");
            this.ip_ranges = new ArrayList<IPRange>();
            for (String range : ranges) {
                if ((range = range.trim()).length() <= 7) continue;
                IPRange ip_range = this.plugin_interface.getIPFilter().createRange(true);
                int sep = range.indexOf("-");
                if (sep == -1) {
                    ip_range.setStartIP(range);
                    ip_range.setEndIP(range);
                } else {
                    ip_range.setStartIP(range.substring(0, sep).trim());
                    ip_range.setEndIP(range.substring(sep + 1).trim());
                }
                ip_range.checkValid();
                if (!ip_range.isValid()) {
                    this.log.log(3, "Access parameter '" + range + "' is invalid");
                    continue;
                }
                this.ip_ranges.add(ip_range);
                ip_ranges_str = ip_ranges_str + (ip_ranges_str.length() == 0 ? CONFIG_USER_DEFAULT : ", ") + ip_range.getStartIP() + " - " + ip_range.getEndIP();
            }
            if (this.ip_ranges.size() == 0) {
                this.ip_ranges = null;
            }
        } else if (access_str.equalsIgnoreCase("all") || access_str.length() == 0) {
            this.ip_range_all = true;
        }
        this.log.log(1, "Acceptable IP range = " + (this.ip_ranges == null ? (this.ip_range_all ? "all" : "local") : ip_ranges_str));
    }

    protected void setupServer() {
        try {
            if (!this.plugin_enabled) {
                if (this.tracker_context != null) {
                    this.tracker_context.destroy();
                    this.tracker_context = null;
                }
                return;
            }
            final int port = this.param_port.getValue();
            String protocol_str = this.param_protocol.getValue().trim();
            String bind_ip_str = this.param_bind.getValue().trim();
            InetAddress bind_ip = null;
            if (bind_ip_str.length() > 0) {
                try {
                    bind_ip = InetAddress.getByName(bind_ip_str);
                }
                catch (Throwable e) {
                    this.log.log(3, "Bind IP parameter '" + bind_ip_str + "' is invalid");
                }
            }
            if (this.tracker_context != null) {
                URL url = this.tracker_context.getURLs()[0];
                String existing_protocol = url.getProtocol();
                int existing_port = url.getPort() == -1 ? url.getDefaultPort() : url.getPort();
                InetAddress existing_bind_ip = this.tracker_context.getBindIP();
                if (existing_port == port && existing_protocol.equalsIgnoreCase(protocol_str) && this.sameAddress(bind_ip, existing_bind_ip)) {
                    return;
                }
                this.tracker_context.destroy();
                this.tracker_context = null;
            }
            int protocol = protocol_str.equalsIgnoreCase(CONFIG_PROTOCOL_DEFAULT) ? 1 : 2;
            this.log.log(1, "Server initialisation: port = " + port + (bind_ip == null ? CONFIG_USER_DEFAULT : ", bind = " + bind_ip_str + ")") + ", protocol = " + protocol_str + (this.root_dir.length() == 0 ? CONFIG_USER_DEFAULT : ", root = " + this.root_dir));
            this.tracker_context = this.plugin_interface.getTracker().createWebContext(Constants.APP_NAME + " - " + this.plugin_interface.getPluginName(), port, protocol, bind_ip);
            network_dispatcher.dispatch(new AERunnable(){

                public void runSupport() {
                    HashMap<String, Object> options = new HashMap<String, Object>();
                    options.put("port", port);
                    Map<String, Object> reply = AEProxyFactory.getPluginServerProxy(WebPlugin.this.plugin_interface.getPluginName(), "I2P", WebPlugin.this.plugin_interface.getPluginID(), options);
                    if (reply != null) {
                        WebPlugin.this.param_i2p_dest.setVisible(true);
                        String host = (String)reply.get("host");
                        if (!WebPlugin.this.param_i2p_dest.getValue().equals(host)) {
                            WebPlugin.this.param_i2p_dest.setValue(host);
                            if (WebPlugin.this.p_sid != null) {
                                WebPlugin.this.updatePairing(WebPlugin.this.p_sid);
                            }
                        }
                    }
                }
            });
            Boolean pr_enable_keep_alive = (Boolean)this.properties.get(PR_ENABLE_KEEP_ALIVE);
            if (pr_enable_keep_alive != null && pr_enable_keep_alive.booleanValue()) {
                this.tracker_context.setEnableKeepAlive(true);
            }
            this.tracker_context.addPageGenerator(this);
            this.tracker_context.addAuthenticationListener(new TrackerAuthenticationAdapter(){
                private String last_pw = "";
                private byte[] last_hash = new byte[0];
                private final int DELAY = 10000;
                private Map<String, Object[]> fail_map = new HashMap<String, Object[]>();

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public boolean authenticate(String headers, URL resource, String user, String pw) {
                    Object waiter;
                    long now = SystemTime.getMonotonousTime();
                    String client_address = this.getHeaderField(headers, "X-Real-IP");
                    if (client_address == null) {
                        client_address = "<unknown>";
                    }
                    Map map = WebPlugin.this.logout_timer;
                    synchronized (map) {
                        Long logout_time = (Long)WebPlugin.this.logout_timer.get(client_address);
                        if (logout_time != null && now - logout_time <= 5000L) {
                            tls.set(WebPlugin.GRACE_PERIOD_MARKER);
                            return true;
                        }
                    }
                    boolean result = this.authenticateSupport(headers, resource, user, pw);
                    if (!result) {
                        if (!pw.equals(WebPlugin.CONFIG_USER_DEFAULT)) {
                            waiter = null;
                            Map<String, Object[]> map2 = this.fail_map;
                            synchronized (map2) {
                                Object[] x = this.fail_map.get(client_address);
                                if (x == null) {
                                    x = new Object[]{new AESemaphore("af:waiter"), new Long(-1L), new Long(-1L), now};
                                    this.fail_map.put(client_address, x);
                                } else {
                                    x[1] = x[2];
                                    x[2] = x[3];
                                    x[3] = now;
                                    long t = (Long)x[1];
                                    if (now - t < 10000L) {
                                        WebPlugin.this.log("Too many recent authentication failures from '" + client_address + "' - rate limiting");
                                        x[2] = now + 10000L;
                                        this.last_pw = WebPlugin.CONFIG_USER_DEFAULT;
                                        waiter = (AESemaphore)x[0];
                                    }
                                }
                            }
                            if (waiter != null) {
                                ((AESemaphore)waiter).reserve(10000L);
                            }
                        }
                    } else {
                        waiter = this.fail_map;
                        synchronized (waiter) {
                            this.fail_map.remove(client_address);
                        }
                        String cookies = this.getHeaderField(headers, "Cookie");
                        if (!(WebPlugin.this.pairing_session_code == null || cookies != null && cookies.contains(WebPlugin.this.pairing_session_code))) {
                            tls.set(WebPlugin.this.pairing_session_code);
                        }
                    }
                    WebPlugin.this.recordAuthRequest(client_address, result);
                    if (!result) {
                        // empty if block
                    }
                    return result;
                }

                private boolean authenticateSupport(String headers, URL resource, String user, String pw) {
                    boolean result;
                    boolean auto_auth;
                    boolean bl = auto_auth = WebPlugin.this.param_auto_auth != null && WebPlugin.this.param_auto_auth.getValue();
                    if (!WebPlugin.this.pw_enable.getValue()) {
                        result = true;
                    } else {
                        if (auto_auth) {
                            user = user.trim().toLowerCase();
                            pw = pw.toUpperCase();
                        }
                        if (!user.equals(WebPlugin.this.p_user_name.getValue())) {
                            result = false;
                        } else {
                            byte[] hash = this.last_hash;
                            if (!this.last_pw.equals(pw)) {
                                hash = WebPlugin.this.plugin_interface.getUtilities().getSecurityManager().calculateSHA1(auto_auth ? pw.toUpperCase().getBytes() : pw.getBytes());
                                this.last_pw = pw;
                                this.last_hash = hash;
                            }
                            result = Arrays.equals(hash, WebPlugin.this.p_password.getValue());
                        }
                    }
                    if (result) {
                        this.checkCookieSet(headers, resource);
                    } else if (auto_auth) {
                        int x = this.checkCookieSet(headers, resource);
                        if (x == 1) {
                            result = true;
                        } else if (x == 0) {
                            result = WebPlugin.this.hasOurCookie(this.getHeaderField(headers, "Cookie"));
                        }
                    } else {
                        result = WebPlugin.this.hasOurCookie(this.getHeaderField(headers, "Cookie"));
                    }
                    return result;
                }

                private int checkCookieSet(String headers, URL resource) {
                    String[] locations;
                    if (WebPlugin.this.pairing_access_code == null) {
                        return 2;
                    }
                    for (String location : locations = new String[]{resource.getQuery(), this.getHeaderField(headers, "Referer")}) {
                        if (location == null) continue;
                        boolean skip_fail = false;
                        int param_len = 0;
                        int p1 = location.indexOf("vuze_pairing_ac=");
                        if (p1 == -1) {
                            p1 = location.indexOf("ac=");
                            if (p1 != -1) {
                                param_len = 3;
                                skip_fail = true;
                            }
                        } else {
                            param_len = 16;
                        }
                        if (p1 == -1) continue;
                        int p2 = location.indexOf(38, p1);
                        String ac = location.substring(p1 + param_len, p2 == -1 ? location.length() : p2).trim();
                        p2 = ac.indexOf(35);
                        if (p2 != -1) {
                            ac = ac.substring(0, p2);
                        }
                        if (ac.equalsIgnoreCase(WebPlugin.this.pairing_access_code)) {
                            tls.set(WebPlugin.this.pairing_session_code);
                            return 1;
                        }
                        if (skip_fail) continue;
                        return 2;
                    }
                    return 0;
                }

                private String getHeaderField(String headers, String field) {
                    int p2;
                    String lc_headers = headers.toLowerCase();
                    int p1 = lc_headers.indexOf(field.toLowerCase() + ":");
                    if (p1 != -1 && (p2 = lc_headers.indexOf(10, p1)) != -1) {
                        return headers.substring(p1 + field.length() + 1, p2).trim();
                    }
                    return null;
                }
            });
        }
        catch (TrackerException e) {
            this.log.log("Server initialisation failed", e);
        }
    }

    private boolean hasOurCookie(String cookies) {
        String[] cookie_list;
        if (cookies == null) {
            return false;
        }
        for (String cookie : cookie_list = cookies.split(";")) {
            String[] bits = cookie.split("=");
            if (bits.length != 2 || !bits[0].trim().equals("vuze_pairing_sc") || !bits[1].trim().equals(this.pairing_session_code)) continue;
            return true;
        }
        return false;
    }

    private boolean sameAddress(InetAddress a1, InetAddress a2) {
        if (a1 == null && a2 == null) {
            return true;
        }
        if (a1 == null || a2 == null) {
            return false;
        }
        return a1.equals(a2);
    }

    protected void setupUPnP() {
        if (!this.plugin_enabled || !this.p_upnp_enable.getValue()) {
            if (this.upnp_mapping != null) {
                this.log("Removing UPnP mapping");
                this.upnp_mapping.destroy();
                this.upnp_mapping = null;
            }
            return;
        }
        PluginInterface pi_upnp = this.plugin_interface.getPluginManager().getPluginInterfaceByClass(UPnPPlugin.class);
        if (pi_upnp == null) {
            this.log.log("No UPnP plugin available, not attempting port mapping");
        } else {
            int port = this.param_port.getValue();
            if (this.upnp_mapping != null) {
                if (this.upnp_mapping.getPort() == port) {
                    return;
                }
                this.log("Updating UPnP mapping");
                this.upnp_mapping.destroy();
            } else {
                this.log("Creating UPnP mapping");
            }
            this.upnp_mapping = ((UPnPPlugin)pi_upnp.getPlugin()).addMapping(this.plugin_interface.getPluginName(), true, port, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setupPairing(String sid, boolean pairing_enabled) {
        PairingManager pm = PairingManagerFactory.getSingleton();
        PairedService service = pm.getService(sid);
        if (this.plugin_enabled && pairing_enabled && pm.isEnabled()) {
            this.setupAutoAuth();
            if (service == null) {
                this.log("Adding pairing service");
                service = pm.addService(sid, new PairedServiceRequestHandler(){

                    public byte[] handleRequest(InetAddress originator, String endpoint_url, byte[] request2) throws IOException {
                        return WebPlugin.this.handleTunnelRequest(originator, endpoint_url, request2);
                    }
                });
                PairingConnectionData cd = service.getConnectionData();
                try {
                    this.updatePairing(cd);
                    Object var7_6 = null;
                    cd.sync();
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    cd.sync();
                    throw throwable;
                }
            }
        } else {
            this.pairing_access_code = null;
            this.setupSessionCode(null);
            if (service != null) {
                this.log("Removing pairing service");
                service.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupSessionCode(String key) {
        if (key == null) {
            key = Base32.encode(this.p_user_name.getValue().getBytes()) + Base32.encode(this.p_password.getValue());
        }
        WebPlugin webPlugin = this;
        synchronized (webPlugin) {
            String existing_key = this.plugin_config.getPluginStringParameter(PAIRING_SESSION_KEY, CONFIG_USER_DEFAULT);
            String[] bits = existing_key.split("=");
            if (bits.length == 2 && bits[0].equals(key)) {
                this.pairing_session_code = bits[1];
            } else {
                this.pairing_session_code = Base32.encode(RandomUtils.nextSecureHash());
                this.plugin_config.setPluginParameter(PAIRING_SESSION_KEY, key + "=" + this.pairing_session_code);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setupAutoAuth() {
        String ac;
        PairingManager pm = PairingManagerFactory.getSingleton();
        this.pairing_access_code = ac = pm.peekAccessCode();
        if (this.pairing_access_code != null && this.param_auto_auth.getValue()) {
            this.setupSessionCode(ac);
            try {
                this.setting_auto_auth = true;
                if (!this.p_user_name.getValue().equals("vuze")) {
                    this.p_user_name.setValue("vuze");
                }
                SHA1Hasher hasher = new SHA1Hasher();
                byte[] encoded = hasher.calculateHash(this.pairing_access_code.getBytes());
                if (!Arrays.equals(this.p_password.getValue(), encoded)) {
                    this.p_password.setValue(this.pairing_access_code);
                }
                if (!this.pw_enable.getValue()) {
                    this.pw_enable.setValue(true);
                }
                Object var6_5 = null;
                this.setting_auto_auth = false;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.setting_auto_auth = false;
                throw throwable;
            }
        } else {
            this.setupSessionCode(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updatePairing(String sid) {
        PairingManager pm = PairingManagerFactory.getSingleton();
        PairedService service = pm.getService(sid);
        if (service != null) {
            PairingConnectionData cd = service.getConnectionData();
            this.log("Updating pairing information");
            try {
                this.updatePairing(cd);
                Object var6_5 = null;
                cd.sync();
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                cd.sync();
                throw throwable;
            }
        }
    }

    protected void updatePairing(PairingConnectionData cd) {
        String host;
        int override;
        cd.setAttribute("port", String.valueOf(this.param_port.getValue()));
        int n = override = this.param_port_or == null ? 0 : this.param_port_or.getValue();
        if (override > 0) {
            cd.setAttribute("port_or", String.valueOf(override));
        } else {
            cd.setAttribute("port_or", null);
        }
        cd.setAttribute("protocol", this.param_protocol.getValue());
        if (this.param_i2p_dest.isVisible() && (host = this.param_i2p_dest.getValue()).length() > 0) {
            cd.setAttribute("I2P", host);
        }
    }

    public int getPort() {
        return this.param_port.getValue();
    }

    public String getProtocol() {
        return this.param_protocol.getValue();
    }

    public void setUserAndPassword(String user, String password) {
        this.p_user_name.setValue(user);
        this.p_password.setValue(password);
        this.pw_enable.setValue(true);
    }

    public void unsetUserAndPassword() {
        this.pw_enable.setValue(false);
    }

    private void recordAuthRequest(String client_ip, boolean good) {
        PairingManager pm = PairingManagerFactory.getSingleton();
        pm.recordRequest(this.plugin_interface.getPluginName(), client_ip, good);
    }

    private void recordRequest(TrackerWebPageRequest request2, boolean good, boolean is_tunnel) {
        PairingManager pm = PairingManagerFactory.getSingleton();
        String str = request2.getClientAddress();
        if (is_tunnel) {
            str = "Tunnel (" + str + ")";
        }
        pm.recordRequest(this.plugin_interface.getPluginName(), str, good);
    }

    public boolean generateSupport(TrackerWebPageRequest request2, TrackerWebPageResponse response) throws IOException {
        return false;
    }

    private byte[] handleTunnelRequest(final InetAddress originator, String endpoint_url, final byte[] request_bytes) throws IOException {
        int data_start;
        int q_pos = endpoint_url.indexOf(63);
        boolean raw = true;
        if (q_pos != -1) {
            String params = endpoint_url.substring(q_pos + 1);
            String[] args = params.split("&");
            String new_endpoint = endpoint_url.substring(0, q_pos);
            String sep = "?";
            for (String arg : args) {
                if (arg.startsWith("tunnel_format=")) {
                    String temp = arg.substring(14);
                    if (!temp.startsWith("h")) continue;
                    raw = false;
                    continue;
                }
                new_endpoint = new_endpoint + sep + arg;
                sep = "&";
            }
            endpoint_url = new_endpoint;
        }
        final String f_endpoint_url = endpoint_url;
        final JSONObject request_headers = new JSONObject();
        if (raw) {
            data_start = 0;
        } else {
            int request_header_len = request_bytes[0] << 8 & 0xFF00 | request_bytes[1] & 0xFF;
            String reply_json_str = new String(request_bytes, 2, request_header_len, "UTF-8");
            request_headers.putAll(JSONUtils.decodeJSON(reply_json_str));
            data_start = request_header_len + 2;
        }
        TrackerWebPageRequest request2 = new TrackerWebPageRequest(){

            public Tracker getTracker() {
                return null;
            }

            public String getClientAddress() {
                return originator.getHostAddress();
            }

            public InetSocketAddress getClientAddress2() {
                return new InetSocketAddress(originator, 0);
            }

            public InetSocketAddress getLocalAddress() {
                return new InetSocketAddress("127.0.0.1", 0);
            }

            public String getUser() {
                return null;
            }

            public String getURL() {
                String url = (String)request_headers.get("HTTP-URL");
                if (url != null) {
                    return url;
                }
                return f_endpoint_url;
            }

            public String getHeader() {
                return WebPlugin.CONFIG_USER_DEFAULT;
            }

            public Map getHeaders() {
                return request_headers;
            }

            public InputStream getInputStream() {
                return new ByteArrayInputStream(request_bytes, data_start, request_bytes.length - data_start);
            }

            public URL getAbsoluteURL() {
                try {
                    return new URL("http://127.0.0.1" + this.getURL());
                }
                catch (Throwable e) {
                    return null;
                }
            }

            public TrackerWebContext getContext() {
                return null;
            }
        };
        final ByteArrayOutputStream baos = new ByteArrayOutputStream();
        final HashMap<String, String> reply_headers = new HashMap<String, String>();
        TrackerWebPageResponse response = new TrackerWebPageResponse(){

            public OutputStream getOutputStream() {
                return baos;
            }

            public void setReplyStatus(int status) {
                reply_headers.put("HTTP-Status", String.valueOf(status));
            }

            public void setContentType(String type) {
                reply_headers.put("Content-Type", type);
            }

            public void setLastModified(long time) {
            }

            public void setExpires(long time) {
            }

            public void setHeader(String name, String value) {
                reply_headers.put(name, value);
            }

            public void setGZIP(boolean gzip) {
            }

            public boolean useFile(String root_dir, String relative_url) throws IOException {
                Debug.out("Not supported");
                return false;
            }

            public void useStream(String file_type, InputStream stream) throws IOException {
                Debug.out("Not supported");
            }

            public void writeTorrent(TrackerTorrent torrent) throws IOException {
                Debug.out("Not supported");
            }

            public void setAsynchronous(boolean async) throws IOException {
                Debug.out("Not supported");
            }

            public boolean getAsynchronous() {
                return false;
            }

            public OutputStream getRawOutputStream() throws IOException {
                Debug.out("Not supported");
                throw new IOException("Not supported");
            }
        };
        try {
            byte[] bytes;
            if (this.generate2(request2, response, true)) {
                bytes = baos.toByteArray();
            } else {
                Debug.out("Tunnelled request not handled: " + request2.getURL());
                response.setReplyStatus(404);
                bytes = new byte[]{};
            }
            if (raw) {
                return bytes;
            }
            String accept_encoding = (String)request_headers.get("Accept-Encoding");
            if (accept_encoding != null && accept_encoding.contains("gzip")) {
                reply_headers.put("Content-Encoding", "gzip");
                ByteArrayOutputStream temp = new ByteArrayOutputStream(bytes.length + 512);
                GZIPOutputStream gos = new GZIPOutputStream(temp);
                gos.write(bytes);
                gos.close();
                bytes = temp.toByteArray();
            }
            ByteArrayOutputStream baos2 = new ByteArrayOutputStream(bytes.length + 512);
            String header_json = JSONUtils.encodeToJSON(reply_headers);
            byte[] header_bytes = header_json.getBytes("UTF-8");
            int header_len = header_bytes.length;
            byte[] header_len_bytes = new byte[]{(byte)(header_len >> 8), (byte)header_len};
            baos2.write(header_len_bytes);
            baos2.write(header_bytes);
            baos2.write(bytes);
            return baos2.toByteArray();
        }
        catch (Throwable e) {
            Debug.out(e);
            return new byte[0];
        }
    }

    public boolean generate(TrackerWebPageRequest request2, TrackerWebPageResponse response) throws IOException {
        String url = request2.getURL();
        if (url.startsWith("/pairing/tunnel/")) {
            long error_code = 1L;
            try {
                PairingManager pm = PairingManagerFactory.getSingleton();
                if (pm.isEnabled()) {
                    if (pm.isSRPEnabled()) {
                        return pm.handleLocalTunnel(request2, response);
                    }
                    error_code = 5L;
                    throw new IOException("Secure pairing is not enabled");
                }
                error_code = 5L;
                throw new IOException("Pairing is not enabled");
            }
            catch (Throwable e) {
                JSONObject json = new JSONObject();
                JSONObject error = new JSONObject();
                json.put("error", error);
                error.put("msg", Debug.getNestedExceptionMessage(e));
                error.put("code", (Object)error_code);
                return this.returnJSON(response, JSONUtils.encodeToJSON(json));
            }
        }
        return this.generate2(request2, response, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean generate2(TrackerWebPageRequest request2, TrackerWebPageResponse response, boolean is_tunnel) throws IOException {
        int pos;
        String redirect;
        URL full_url;
        String full_url_path;
        String cookie_to_set;
        String client = request2.getClientAddress();
        if (!this.ip_range_all) {
            try {
                boolean valid_ip = true;
                InetAddress ia = InetAddress.getByName(client);
                if (this.ip_ranges == null) {
                    if (!ia.isLoopbackAddress()) {
                        this.log.log(3, "Client '" + client + "' is not local, rejecting");
                        valid_ip = false;
                    }
                } else {
                    boolean ok = false;
                    for (IPRange range : this.ip_ranges) {
                        if (!range.isInRange(ia.getHostAddress())) continue;
                        ok = true;
                    }
                    if (!ok) {
                        this.log.log(3, "Client '" + client + "' (" + ia.getHostAddress() + ") is not in range, rejecting");
                        valid_ip = false;
                    }
                }
                if (!valid_ip) {
                    response.setReplyStatus(403);
                    this.recordRequest(request2, false, is_tunnel);
                    return this.returnTextPlain(response, "Cannot access resource from this IP address.");
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
                this.recordRequest(request2, false, is_tunnel);
                return false;
            }
        }
        this.recordRequest(request2, true, is_tunnel);
        String url = request2.getURL();
        if (url.toString().endsWith(".class")) {
            System.out.println("WebPlugin::generate:" + url);
        }
        if ((cookie_to_set = tls.get()) == GRACE_PERIOD_MARKER) {
            return this.returnTextPlain(response, "Logout in progress, please try again later.");
        }
        if (cookie_to_set != null) {
            response.setHeader("Set-Cookie", "vuze_pairing_sc=" + cookie_to_set + "; path=/; HttpOnly");
            tls.set(null);
        }
        if ((full_url_path = (full_url = request2.getAbsoluteURL()).getPath()).equals("/isPairedServiceAvailable")) {
            redirect = this.getArgumentFromURL(full_url, "redirect_to");
            if (redirect != null) {
                try {
                    URL target = new URL(redirect);
                    String host = target.getHost();
                    if (!Constants.isAzureusDomain(host) && !InetAddress.getByName(host).isLoopbackAddress()) {
                        this.log("Invalid redirect host: " + host);
                        redirect = null;
                    }
                }
                catch (Throwable e) {
                    Debug.out(e);
                    redirect = null;
                }
            }
            if (redirect != null) {
                response.setReplyStatus(302);
                response.setHeader("Location", redirect);
                return true;
            }
            String callback = this.getArgumentFromURL(full_url, "jsoncallback");
            if (callback != null) {
                return this.returnTextPlain(response, callback + "( {'pairedserviceavailable':true} )");
            }
        } else {
            if (full_url_path.equals("/isServicePaired")) {
                boolean paired = cookie_to_set != null || this.hasOurCookie((String)request2.getHeaders().get("cookie"));
                return this.returnTextPlain(response, "{ 'servicepaired': " + (paired ? "true" : "false") + " }");
            }
            if (full_url_path.equals("/pairedServiceLogout")) {
                Map<String, Long> paired = this.logout_timer;
                synchronized (paired) {
                    this.logout_timer.put(client, SystemTime.getMonotonousTime());
                }
                response.setHeader("Set-Cookie", "vuze_pairing_sc=<deleted>, expires=" + TimeFormatter.getCookieDate(0L));
                redirect = this.getArgumentFromURL(full_url, "redirect_to");
                if (redirect != null) {
                    try {
                        URL target = new URL(redirect);
                        String host = target.getHost();
                        if (!Constants.isAzureusDomain(host) && !InetAddress.getByName(host).isLoopbackAddress()) {
                            this.log("Invalid redirect host: " + host);
                            redirect = null;
                        }
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                        redirect = null;
                    }
                }
                if (redirect == null) {
                    return this.returnTextPlain(response, CONFIG_USER_DEFAULT);
                }
                response.setReplyStatus(302);
                response.setHeader("Location", redirect);
                return true;
            }
        }
        request2.getHeaders().put("x-vuze-is-tunnel", is_tunnel ? "true" : "false");
        if (this.generateSupport(request2, response)) {
            return true;
        }
        if (is_tunnel) {
            return false;
        }
        if (url.equals("/") || url.startsWith("/?")) {
            url = "/";
            if (this.home_page != null) {
                url = this.home_page;
            } else {
                for (int i = 0; i < welcome_files.length; ++i) {
                    if (!welcome_files[i].exists()) continue;
                    url = "/" + welcome_pages[i];
                    break;
                }
            }
        }
        if (response.useFile(this.file_root, url)) {
            return true;
        }
        String resource_name = url;
        if (resource_name.startsWith("/")) {
            resource_name = resource_name.substring(1);
        }
        if ((pos = resource_name.lastIndexOf(".")) != -1) {
            String type = resource_name.substring(pos + 1);
            ClassLoader cl = this.plugin_interface.getPluginClassLoader();
            InputStream is = cl.getResourceAsStream(resource_name);
            if (is == null && this.resource_root != null) {
                resource_name = this.resource_root + "/" + resource_name;
                is = cl.getResourceAsStream(resource_name);
            }
            if (is != null) {
                try {
                    response.useStream(type, is);
                    Object var15_26 = null;
                }
                catch (Throwable throwable) {
                    Object var15_27 = null;
                    is.close();
                    throw throwable;
                }
                is.close();
                return true;
            }
        }
        return false;
    }

    private String getArgumentFromURL(URL url, String argument) {
        String query = url.getQuery();
        if (query != null) {
            String[] args;
            for (String arg : args = query.split("&")) {
                String[] x = arg.split("=");
                if (x.length != 2 || !x[0].equals(argument)) continue;
                return UrlUtils.decode(x[1]);
            }
        }
        return null;
    }

    private boolean returnTextPlain(TrackerWebPageResponse response, String str) {
        return this.returnStuff(response, "text/plain", str);
    }

    private boolean returnJSON(TrackerWebPageResponse response, String str) throws IOException {
        response.setContentType("application/json; charset=UTF-8");
        OutputStream os = response.getOutputStream();
        os.write(str.getBytes("UTF-8"));
        return true;
    }

    private boolean returnStuff(TrackerWebPageResponse response, String content_type, String str) {
        response.setContentType(content_type);
        PrintWriter pw = new PrintWriter(response.getOutputStream());
        pw.println(str);
        pw.flush();
        pw.close();
        return true;
    }

    protected BasicPluginConfigModel getConfigModel() {
        return this.config_model;
    }

    protected BasicPluginViewModel getViewModel() {
        return this.view_model;
    }

    protected void log(String str) {
        this.log.log(str);
    }

    protected void log(String str, Throwable e) {
        this.log.log(str, e);
    }

    static {
        network_dispatcher = new AsyncDispatcher("webplugin:netdispatch", 5000);
        tls = new ThreadLocal<String>(){

            @Override
            public String initialValue() {
                return null;
            }
        };
    }
}

