/*
 * Decompiled with CFR 0.152.
 */
package ghostfucker.utils.sun.misc;

import ghostfucker.utils.sun.misc.CEStreamExhausted;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.nio.ByteBuffer;

public abstract class CharacterDecoder {
    protected abstract int bytesPerAtom();

    protected abstract int bytesPerLine();

    protected void decodeBufferPrefix(PushbackInputStream pushbackInputStream, OutputStream outputStream) throws IOException {
    }

    protected void decodeBufferSuffix(PushbackInputStream pushbackInputStream, OutputStream outputStream) throws IOException {
    }

    protected int decodeLinePrefix(PushbackInputStream pushbackInputStream, OutputStream outputStream) throws IOException {
        return this.bytesPerLine();
    }

    protected void decodeLineSuffix(PushbackInputStream pushbackInputStream, OutputStream outputStream) throws IOException {
    }

    protected void decodeAtom(PushbackInputStream pushbackInputStream, OutputStream outputStream, int n) throws IOException {
        throw new CEStreamExhausted();
    }

    protected int readFully(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        for (int i = 0; i < n2; ++i) {
            int n3 = inputStream.read();
            if (n3 == -1) {
                return i == 0 ? -1 : i;
            }
            byArray[i + n] = (byte)n3;
        }
        return n2;
    }

    public void decodeBuffer(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n = 0;
        PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream);
        this.decodeBufferPrefix(pushbackInputStream, outputStream);
        while (true) {
            try {
                int n2 = this.decodeLinePrefix(pushbackInputStream, outputStream);
                int n3 = 0;
                while (n3 + this.bytesPerAtom() < n2) {
                    this.decodeAtom(pushbackInputStream, outputStream, this.bytesPerAtom());
                    n += this.bytesPerAtom();
                    n3 += this.bytesPerAtom();
                }
                if (n3 + this.bytesPerAtom() == n2) {
                    this.decodeAtom(pushbackInputStream, outputStream, this.bytesPerAtom());
                    n += this.bytesPerAtom();
                } else {
                    this.decodeAtom(pushbackInputStream, outputStream, n2 - n3);
                    n += n2 - n3;
                }
                this.decodeLineSuffix(pushbackInputStream, outputStream);
            }
            catch (CEStreamExhausted cEStreamExhausted) {
                this.decodeBufferSuffix(pushbackInputStream, outputStream);
                return;
            }
        }
    }

    public byte[] decodeBuffer(String string) throws IOException {
        byte[] byArray = new byte[string.length()];
        string.getBytes(0, string.length(), byArray, 0);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.decodeBuffer(byteArrayInputStream, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] decodeBuffer(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.decodeBuffer(inputStream, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public ByteBuffer decodeBufferToByteBuffer(String string) throws IOException {
        return ByteBuffer.wrap(this.decodeBuffer(string));
    }

    public ByteBuffer decodeBufferToByteBuffer(InputStream inputStream) throws IOException {
        return ByteBuffer.wrap(this.decodeBuffer(inputStream));
    }
}

