/*
 * Decompiled with CFR 0.152.
 */
package ghostfucker.utils.sun.net.www;

import ghostfucker.utils.sun.net.ProgressSource;
import ghostfucker.utils.sun.net.www.http.ChunkedInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class MeteredStream
extends FilterInputStream {
    protected boolean closed = false;
    protected int expected;
    protected int count = 0;
    protected int markedCount = 0;
    protected int markLimit = -1;
    protected ProgressSource pi;

    public MeteredStream(InputStream inputStream, ProgressSource progressSource, int n) {
        super(inputStream);
        this.pi = progressSource;
        this.expected = n;
        if (progressSource != null) {
            progressSource.updateProgress(0, n);
        }
    }

    private final void justRead(int n) throws IOException {
        if (n == -1) {
            if (!this.isMarked()) {
                this.close();
            }
            return;
        }
        this.count += n;
        if (this.count - this.markedCount > this.markLimit) {
            this.markLimit = -1;
        }
        if (this.pi != null) {
            this.pi.updateProgress(this.count, this.expected);
        }
        if (this.isMarked()) {
            return;
        }
        if (this.expected > 0 && this.count >= this.expected) {
            this.close();
        }
    }

    private boolean isMarked() {
        if (this.markLimit < 0) {
            return false;
        }
        return this.count - this.markedCount <= this.markLimit;
    }

    public synchronized int read() throws IOException {
        if (this.closed) {
            return -1;
        }
        int n = this.in.read();
        if (n != -1) {
            this.justRead(1);
        } else {
            this.justRead(n);
        }
        return n;
    }

    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.closed) {
            return -1;
        }
        int n3 = this.in.read(byArray, n, n2);
        this.justRead(n3);
        return n3;
    }

    public synchronized long skip(long l) throws IOException {
        if (this.closed) {
            return 0L;
        }
        if (this.in instanceof ChunkedInputStream) {
            l = this.in.skip(l);
        } else {
            int n = l > (long)(this.expected - this.count) ? this.expected - this.count : (int)l;
            l = this.in.skip(n);
        }
        this.justRead((int)l);
        return l;
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        if (this.pi != null) {
            this.pi.finishTracking();
        }
        this.closed = true;
        this.in.close();
    }

    public synchronized int available() throws IOException {
        return this.closed ? 0 : this.in.available();
    }

    public synchronized void mark(int n) {
        if (this.closed) {
            return;
        }
        super.mark(n);
        this.markedCount = this.count;
        this.markLimit = n;
    }

    public synchronized void reset() throws IOException {
        if (this.closed) {
            return;
        }
        if (!this.isMarked()) {
            throw new IOException("Resetting to an invalid mark");
        }
        this.count = this.markedCount;
        super.reset();
    }

    public boolean markSupported() {
        if (this.closed) {
            return false;
        }
        return super.markSupported();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
            if (this.pi != null) {
                this.pi.close();
            }
        }
        finally {
            super.finalize();
        }
    }
}

