/*
 * Decompiled with CFR 0.152.
 */
package ghostfucker.utils.sun.security.ec;

import ghostfucker.utils.sun.security.ec.ECParameters;
import ghostfucker.utils.sun.security.pkcs.PKCS8Key;
import ghostfucker.utils.sun.security.util.DerInputStream;
import ghostfucker.utils.sun.security.util.DerOutputStream;
import ghostfucker.utils.sun.security.util.DerValue;
import ghostfucker.utils.sun.security.x509.AlgorithmId;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.interfaces.ECPrivateKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public final class ECPrivateKeyImpl
extends PKCS8Key
implements ECPrivateKey {
    private static final long serialVersionUID = 88695385615075129L;
    private BigInteger s;
    private ECParameterSpec params;

    public ECPrivateKeyImpl(byte[] byArray) throws InvalidKeyException {
        this.decode(byArray);
    }

    public ECPrivateKeyImpl(BigInteger bigInteger, ECParameterSpec eCParameterSpec) throws InvalidKeyException {
        this.s = bigInteger;
        this.params = eCParameterSpec;
        this.algid = new AlgorithmId(AlgorithmId.EC_oid, ECParameters.getAlgorithmParameters(eCParameterSpec));
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            derOutputStream.putInteger(1);
            byte[] byArray = ECParameters.trimZeroes(bigInteger.toByteArray());
            derOutputStream.putOctetString(byArray);
            DerValue derValue = new DerValue(48, derOutputStream.toByteArray());
            this.key = derValue.toByteArray();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(iOException);
        }
    }

    public String getAlgorithm() {
        return "EC";
    }

    public BigInteger getS() {
        return this.s;
    }

    public ECParameterSpec getParams() {
        return this.params;
    }

    protected void parseKeyBits() throws InvalidKeyException {
        try {
            Object object;
            DerInputStream derInputStream = new DerInputStream(this.key);
            DerValue derValue = derInputStream.getDerValue();
            if (derValue.tag != 48) {
                throw new IOException("Not a SEQUENCE");
            }
            DerInputStream derInputStream2 = derValue.data;
            int n = derInputStream2.getInteger();
            if (n != 1) {
                throw new IOException("Version must be 1");
            }
            byte[] byArray = derInputStream2.getOctetString();
            this.s = new BigInteger(1, byArray);
            while (derInputStream2.available() != 0) {
                object = derInputStream2.getDerValue();
                if (((DerValue)object).isContextSpecific((byte)0) || ((DerValue)object).isContextSpecific((byte)1)) continue;
                throw new InvalidKeyException("Unexpected value: " + object);
            }
            object = this.algid.getParameters();
            if (object == null) {
                throw new InvalidKeyException("EC domain parameters must be encoded in the algorithm identifier");
            }
            this.params = ((AlgorithmParameters)object).getParameterSpec(ECParameterSpec.class);
        }
        catch (IOException iOException) {
            throw new InvalidKeyException("Invalid EC private key", iOException);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new InvalidKeyException("Invalid EC private key", invalidParameterSpecException);
        }
    }

    public String toString() {
        return "Sun EC private key, " + this.params.getCurve().getField().getFieldSize() + " bits\n  private value:  " + this.s + "\n  parameters: " + this.params;
    }
}

