/*
 * Decompiled with CFR 0.152.
 */
package ghostfucker.utils.sun.security.jca;

import ghostfucker.utils.sun.security.jca.ProviderConfig;
import ghostfucker.utils.sun.security.jca.ServiceId;
import ghostfucker.utils.sun.security.util.Debug;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.Security;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProviderList {
    static final Debug debug = Debug.getInstance("jca", "ProviderList");
    private static final ProviderConfig[] PC0 = new ProviderConfig[0];
    private static final Provider[] P0 = new Provider[0];
    static final ProviderList EMPTY = new ProviderList(PC0, true);
    private static final Provider EMPTY_PROVIDER = new Provider("##Empty##", 1.0, "initialization in progress"){

        public Provider.Service getService(String string, String string2) {
            return null;
        }
    };
    private final ProviderConfig[] configs;
    private volatile boolean allLoaded;
    private final List<Provider> userList = new AbstractList<Provider>(){

        @Override
        public int size() {
            return ProviderList.this.configs.length;
        }

        @Override
        public Provider get(int n) {
            return ProviderList.this.getProvider(n);
        }
    };

    static ProviderList fromSecurityProperties() {
        return AccessController.doPrivileged(new PrivilegedAction<ProviderList>(){

            @Override
            public ProviderList run() {
                return new ProviderList();
            }
        });
    }

    public static ProviderList add(ProviderList providerList, Provider provider) {
        return ProviderList.insertAt(providerList, provider, -1);
    }

    public static ProviderList insertAt(ProviderList providerList, Provider provider, int n) {
        if (providerList.getProvider(provider.getName()) != null) {
            return providerList;
        }
        ArrayList<ProviderConfig> arrayList = new ArrayList<ProviderConfig>(Arrays.asList(providerList.configs));
        int n2 = arrayList.size();
        if (n < 0 || n > n2) {
            n = n2;
        }
        arrayList.add(n, new ProviderConfig(provider));
        return new ProviderList(arrayList.toArray(PC0), true);
    }

    public static ProviderList remove(ProviderList providerList, String string) {
        if (providerList.getProvider(string) == null) {
            return providerList;
        }
        ProviderConfig[] providerConfigArray = new ProviderConfig[providerList.size() - 1];
        int n = 0;
        for (ProviderConfig providerConfig : providerList.configs) {
            if (providerConfig.getProvider().getName().equals(string)) continue;
            providerConfigArray[n++] = providerConfig;
        }
        return new ProviderList(providerConfigArray, true);
    }

    public static ProviderList newList(Provider ... providerArray) {
        ProviderConfig[] providerConfigArray = new ProviderConfig[providerArray.length];
        for (int i = 0; i < providerArray.length; ++i) {
            providerConfigArray[i] = new ProviderConfig(providerArray[i]);
        }
        return new ProviderList(providerConfigArray, true);
    }

    private ProviderList(ProviderConfig[] providerConfigArray, boolean bl) {
        this.configs = providerConfigArray;
        this.allLoaded = bl;
    }

    private ProviderList() {
        String string;
        ArrayList<ProviderConfig> arrayList = new ArrayList<ProviderConfig>();
        int n = 1;
        while ((string = Security.getProperty("security.provider." + n)) != null) {
            ProviderConfig providerConfig;
            if ((string = string.trim()).length() == 0) {
                System.err.println("invalid entry for security.provider." + n);
                break;
            }
            int n2 = string.indexOf(32);
            if (n2 == -1) {
                providerConfig = new ProviderConfig(string);
            } else {
                String string2 = string.substring(0, n2);
                String string3 = string.substring(n2 + 1).trim();
                providerConfig = new ProviderConfig(string2, string3);
            }
            if (!arrayList.contains(providerConfig)) {
                arrayList.add(providerConfig);
            }
            ++n;
        }
        this.configs = arrayList.toArray(PC0);
        if (debug != null) {
            debug.println("provider configuration: " + arrayList);
        }
    }

    ProviderList getJarList(String[] stringArray) {
        ArrayList<ProviderConfig> arrayList = new ArrayList<ProviderConfig>();
        for (String string : stringArray) {
            ProviderConfig providerConfig = new ProviderConfig(string);
            for (ProviderConfig providerConfig2 : this.configs) {
                if (!providerConfig2.equals(providerConfig)) continue;
                providerConfig = providerConfig2;
                break;
            }
            arrayList.add(providerConfig);
        }
        Object[] objectArray = arrayList.toArray(PC0);
        return new ProviderList((ProviderConfig[])objectArray, false);
    }

    public int size() {
        return this.configs.length;
    }

    Provider getProvider(int n) {
        Provider provider = this.configs[n].getProvider();
        return provider != null ? provider : EMPTY_PROVIDER;
    }

    public List<Provider> providers() {
        return this.userList;
    }

    private ProviderConfig getProviderConfig(String string) {
        int n = this.getIndex(string);
        return n != -1 ? this.configs[n] : null;
    }

    public Provider getProvider(String string) {
        ProviderConfig providerConfig = this.getProviderConfig(string);
        return providerConfig == null ? null : providerConfig.getProvider();
    }

    public int getIndex(String string) {
        for (int i = 0; i < this.configs.length; ++i) {
            Provider provider = this.getProvider(i);
            if (!provider.getName().equals(string)) continue;
            return i;
        }
        return -1;
    }

    private int loadAll() {
        if (this.allLoaded) {
            return this.configs.length;
        }
        if (debug != null) {
            debug.println("Loading all providers");
            new Exception("Call trace").printStackTrace();
        }
        int n = 0;
        for (int i = 0; i < this.configs.length; ++i) {
            Provider provider = this.configs[i].getProvider();
            if (provider == null) continue;
            ++n;
        }
        if (n == this.configs.length) {
            this.allLoaded = true;
        }
        return n;
    }

    ProviderList removeInvalid() {
        int n = this.loadAll();
        if (n == this.configs.length) {
            return this;
        }
        ProviderConfig[] providerConfigArray = new ProviderConfig[n];
        int n2 = 0;
        for (int i = 0; i < this.configs.length; ++i) {
            ProviderConfig providerConfig = this.configs[i];
            if (!providerConfig.isLoaded()) continue;
            providerConfigArray[n2++] = providerConfig;
        }
        return new ProviderList(providerConfigArray, true);
    }

    public Provider[] toArray() {
        return this.providers().toArray(P0);
    }

    public String toString() {
        return Arrays.asList(this.configs).toString();
    }

    public Provider.Service getService(String string, String string2) {
        for (int i = 0; i < this.configs.length; ++i) {
            Provider provider = this.getProvider(i);
            Provider.Service service = provider.getService(string, string2);
            if (service == null) continue;
            return service;
        }
        return null;
    }

    public List<Provider.Service> getServices(String string, String string2) {
        return new ServiceList(string, string2);
    }

    @Deprecated
    public List<Provider.Service> getServices(String string, List<String> list) {
        ArrayList<ServiceId> arrayList = new ArrayList<ServiceId>();
        for (String string2 : list) {
            arrayList.add(new ServiceId(string, string2));
        }
        return this.getServices(arrayList);
    }

    public List<Provider.Service> getServices(List<ServiceId> list) {
        return new ServiceList(list);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ServiceList
    extends AbstractList<Provider.Service> {
        private final String type;
        private final String algorithm;
        private final List<ServiceId> ids;
        private Provider.Service firstService;
        private List<Provider.Service> services;
        private int providerIndex;

        ServiceList(String string, String string2) {
            this.type = string;
            this.algorithm = string2;
            this.ids = null;
        }

        ServiceList(List<ServiceId> list) {
            this.type = null;
            this.algorithm = null;
            this.ids = list;
        }

        private void addService(Provider.Service service) {
            if (this.firstService == null) {
                this.firstService = service;
            } else {
                if (this.services == null) {
                    this.services = new ArrayList<Provider.Service>(4);
                    this.services.add(this.firstService);
                }
                this.services.add(service);
            }
        }

        /*
         * Unable to fully structure code
         */
        private Provider.Service tryGet(int var1_1) {
            block0: while (true) {
                if (var1_1 == 0 && this.firstService != null) {
                    return this.firstService;
                }
                if (this.services != null && this.services.size() > var1_1) {
                    return this.services.get(var1_1);
                }
                if (this.providerIndex >= ProviderList.access$100(ProviderList.this).length) {
                    return null;
                }
                var2_2 = ProviderList.this.getProvider(this.providerIndex++);
                if (this.type != null) {
                    var3_3 = var2_2.getService(this.type, this.algorithm);
                    if (var3_3 == null) continue;
                    this.addService((Provider.Service)var3_3);
                    continue;
                }
                var3_3 = this.ids.iterator();
                while (true) {
                    if (var3_3.hasNext()) ** break;
                    continue block0;
                    var4_4 = (ServiceId)var3_3.next();
                    var5_5 = var2_2.getService(var4_4.type, var4_4.algorithm);
                    if (var5_5 == null) continue;
                    this.addService(var5_5);
                }
                break;
            }
        }

        @Override
        public Provider.Service get(int n) {
            Provider.Service service = this.tryGet(n);
            if (service == null) {
                throw new IndexOutOfBoundsException();
            }
            return service;
        }

        @Override
        public int size() {
            int n;
            if (this.services != null) {
                n = this.services.size();
            } else {
                int n2 = n = this.firstService != null ? 1 : 0;
            }
            while (this.tryGet(n) != null) {
                ++n;
            }
            return n;
        }

        @Override
        public boolean isEmpty() {
            return this.tryGet(0) == null;
        }

        @Override
        public Iterator<Provider.Service> iterator() {
            return new Iterator<Provider.Service>(){
                int index;

                @Override
                public boolean hasNext() {
                    return ServiceList.this.tryGet(this.index) != null;
                }

                @Override
                public Provider.Service next() {
                    Provider.Service service = ServiceList.this.tryGet(this.index);
                    if (service == null) {
                        throw new NoSuchElementException();
                    }
                    ++this.index;
                    return service;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }
}

