/*
 * Decompiled with CFR 0.152.
 */
package ghostfucker.utils.sun.security.jca;

import ghostfucker.utils.sun.security.jca.ProviderList;
import java.security.Provider;

public class Providers {
    private static final ThreadLocal<ProviderList> threadLists = new InheritableThreadLocal<ProviderList>();
    private static volatile int threadListsUsed;
    private static volatile ProviderList providerList;
    private static final String BACKUP_PROVIDER_CLASSNAME = "ghostfucker.utils.sun.security.provider.VerificationProvider";
    private static final String[] jarVerificationProviders;

    private Providers() {
    }

    public static Provider getSunProvider() {
        try {
            Class<?> clazz = Class.forName(jarVerificationProviders[0]);
            return (Provider)clazz.newInstance();
        }
        catch (Exception exception) {
            try {
                Class<?> clazz = Class.forName(BACKUP_PROVIDER_CLASSNAME);
                return (Provider)clazz.newInstance();
            }
            catch (Exception exception2) {
                throw new RuntimeException("Sun provider not found", exception);
            }
        }
    }

    public static Object startJarVerification() {
        ProviderList providerList = Providers.getProviderList();
        ProviderList providerList2 = providerList.getJarList(jarVerificationProviders);
        return Providers.beginThreadProviderList(providerList2);
    }

    public static void stopJarVerification(Object object) {
        Providers.endThreadProviderList((ProviderList)object);
    }

    public static ProviderList getProviderList() {
        ProviderList providerList = Providers.getThreadProviderList();
        if (providerList == null) {
            providerList = Providers.getSystemProviderList();
        }
        return providerList;
    }

    public static void setProviderList(ProviderList providerList) {
        if (Providers.getThreadProviderList() == null) {
            Providers.setSystemProviderList(providerList);
        } else {
            Providers.changeThreadProviderList(providerList);
        }
    }

    public static synchronized ProviderList getFullProviderList() {
        ProviderList providerList = Providers.getThreadProviderList();
        if (providerList != null) {
            ProviderList providerList2 = providerList.removeInvalid();
            if (providerList2 != providerList) {
                Providers.changeThreadProviderList(providerList2);
                providerList = providerList2;
            }
            return providerList;
        }
        providerList = Providers.getSystemProviderList();
        ProviderList providerList3 = providerList.removeInvalid();
        if (providerList3 != providerList) {
            Providers.setSystemProviderList(providerList3);
            providerList = providerList3;
        }
        return providerList;
    }

    private static ProviderList getSystemProviderList() {
        return providerList;
    }

    private static void setSystemProviderList(ProviderList providerList) {
        Providers.providerList = providerList;
    }

    public static ProviderList getThreadProviderList() {
        if (threadListsUsed == 0) {
            return null;
        }
        return threadLists.get();
    }

    private static void changeThreadProviderList(ProviderList providerList) {
        threadLists.set(providerList);
    }

    public static synchronized ProviderList beginThreadProviderList(ProviderList providerList) {
        if (ProviderList.debug != null) {
            ProviderList.debug.println("ThreadLocal providers: " + providerList);
        }
        ProviderList providerList2 = threadLists.get();
        ++threadListsUsed;
        threadLists.set(providerList);
        return providerList2;
    }

    public static synchronized void endThreadProviderList(ProviderList providerList) {
        if (providerList == null) {
            if (ProviderList.debug != null) {
                ProviderList.debug.println("Disabling ThreadLocal providers");
            }
            threadLists.remove();
        } else {
            if (ProviderList.debug != null) {
                ProviderList.debug.println("Restoring previous ThreadLocal providers: " + providerList);
            }
            threadLists.set(providerList);
        }
        --threadListsUsed;
    }

    static {
        providerList = ProviderList.EMPTY;
        providerList = ProviderList.fromSecurityProperties();
        jarVerificationProviders = new String[]{"ghostfucker.utils.sun.security.provider.Sun", "ghostfucker.utils.sun.security.rsa.SunRsaSign", BACKUP_PROVIDER_CLASSNAME};
    }
}

