/*
 * Decompiled with CFR 0.152.
 */
package ghostfucker.utils.sun.security.jgss;

import ghostfucker.utils.sun.security.jgss.GSSExceptionImpl;
import ghostfucker.utils.sun.security.jgss.GSSManagerImpl;
import ghostfucker.utils.sun.security.jgss.GSSNameImpl;
import ghostfucker.utils.sun.security.jgss.GSSUtil;
import ghostfucker.utils.sun.security.jgss.ProviderList;
import ghostfucker.utils.sun.security.jgss.spi.GSSCredentialSpi;
import ghostfucker.utils.sun.security.jgss.spi.GSSNameSpi;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GSSCredentialImpl
implements GSSCredential {
    private GSSManagerImpl gssManager = null;
    private boolean destroyed = false;
    private Hashtable<SearchKey, GSSCredentialSpi> hashtable = null;
    private GSSCredentialSpi tempCred = null;

    GSSCredentialImpl(GSSManagerImpl gSSManagerImpl, int n) throws GSSException {
        this(gSSManagerImpl, null, 0, (Oid[])null, n);
    }

    GSSCredentialImpl(GSSManagerImpl gSSManagerImpl, GSSName gSSName, int n, Oid oid, int n2) throws GSSException {
        if (oid == null) {
            oid = ProviderList.DEFAULT_MECH_OID;
        }
        this.init(gSSManagerImpl);
        this.add(gSSName, n, n, oid, n2);
    }

    GSSCredentialImpl(GSSManagerImpl gSSManagerImpl, GSSName gSSName, int n, Oid[] oidArray, int n2) throws GSSException {
        this.init(gSSManagerImpl);
        boolean bl = false;
        if (oidArray == null) {
            oidArray = gSSManagerImpl.getMechs();
            bl = true;
        }
        for (int i = 0; i < oidArray.length; ++i) {
            try {
                this.add(gSSName, n, n, oidArray[i], n2);
                continue;
            }
            catch (GSSException gSSException) {
                if (bl) {
                    GSSUtil.debug("Ignore " + gSSException + " while acquring cred for " + oidArray[i]);
                    continue;
                }
                throw gSSException;
            }
        }
        if (this.hashtable.size() == 0 || n2 != this.getUsage()) {
            throw new GSSException(13);
        }
    }

    public GSSCredentialImpl(GSSManagerImpl gSSManagerImpl, GSSCredentialSpi gSSCredentialSpi) throws GSSException {
        this.init(gSSManagerImpl);
        int n = 2;
        if (gSSCredentialSpi.isInitiatorCredential()) {
            n = gSSCredentialSpi.isAcceptorCredential() ? 0 : 1;
        }
        SearchKey searchKey = new SearchKey(gSSCredentialSpi.getMechanism(), n);
        this.tempCred = gSSCredentialSpi;
        this.hashtable.put(searchKey, this.tempCred);
    }

    void init(GSSManagerImpl gSSManagerImpl) {
        this.gssManager = gSSManagerImpl;
        this.hashtable = new Hashtable(gSSManagerImpl.getMechs().length);
    }

    @Override
    public void dispose() throws GSSException {
        if (!this.destroyed) {
            Enumeration<GSSCredentialSpi> enumeration = this.hashtable.elements();
            while (enumeration.hasMoreElements()) {
                GSSCredentialSpi gSSCredentialSpi = enumeration.nextElement();
                gSSCredentialSpi.dispose();
            }
            this.destroyed = true;
        }
    }

    @Override
    public GSSName getName() throws GSSException {
        if (this.destroyed) {
            throw new IllegalStateException("This credential is no longer valid");
        }
        return GSSNameImpl.wrapElement(this.gssManager, this.tempCred.getName());
    }

    @Override
    public GSSName getName(Oid oid) throws GSSException {
        if (this.destroyed) {
            throw new IllegalStateException("This credential is no longer valid");
        }
        SearchKey searchKey = null;
        GSSCredentialSpi gSSCredentialSpi = null;
        if (oid == null) {
            oid = ProviderList.DEFAULT_MECH_OID;
        }
        if ((gSSCredentialSpi = this.hashtable.get(searchKey = new SearchKey(oid, 1))) == null) {
            searchKey = new SearchKey(oid, 2);
            gSSCredentialSpi = this.hashtable.get(searchKey);
        }
        if (gSSCredentialSpi == null) {
            searchKey = new SearchKey(oid, 0);
            gSSCredentialSpi = this.hashtable.get(searchKey);
        }
        if (gSSCredentialSpi == null) {
            throw new GSSExceptionImpl(2, oid);
        }
        return GSSNameImpl.wrapElement(this.gssManager, gSSCredentialSpi.getName());
    }

    @Override
    public int getRemainingLifetime() throws GSSException {
        if (this.destroyed) {
            throw new IllegalStateException("This credential is no longer valid");
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = Integer.MAX_VALUE;
        Enumeration<SearchKey> enumeration = this.hashtable.keys();
        while (enumeration.hasMoreElements()) {
            SearchKey searchKey = enumeration.nextElement();
            GSSCredentialSpi gSSCredentialSpi = this.hashtable.get(searchKey);
            if (searchKey.getUsage() == 1) {
                n = gSSCredentialSpi.getInitLifetime();
            } else if (searchKey.getUsage() == 2) {
                n = gSSCredentialSpi.getAcceptLifetime();
            } else {
                n2 = gSSCredentialSpi.getInitLifetime();
                int n5 = n = n2 < (n3 = gSSCredentialSpi.getAcceptLifetime()) ? n2 : n3;
            }
            if (n4 <= n) continue;
            n4 = n;
        }
        return n4;
    }

    @Override
    public int getRemainingInitLifetime(Oid oid) throws GSSException {
        if (this.destroyed) {
            throw new IllegalStateException("This credential is no longer valid");
        }
        GSSCredentialSpi gSSCredentialSpi = null;
        SearchKey searchKey = null;
        boolean bl = false;
        int n = 0;
        if (oid == null) {
            oid = ProviderList.DEFAULT_MECH_OID;
        }
        if ((gSSCredentialSpi = this.hashtable.get(searchKey = new SearchKey(oid, 1))) != null) {
            bl = true;
            if (n < gSSCredentialSpi.getInitLifetime()) {
                n = gSSCredentialSpi.getInitLifetime();
            }
        }
        if ((gSSCredentialSpi = this.hashtable.get(searchKey = new SearchKey(oid, 0))) != null) {
            bl = true;
            if (n < gSSCredentialSpi.getInitLifetime()) {
                n = gSSCredentialSpi.getInitLifetime();
            }
        }
        if (!bl) {
            throw new GSSExceptionImpl(2, oid);
        }
        return n;
    }

    @Override
    public int getRemainingAcceptLifetime(Oid oid) throws GSSException {
        if (this.destroyed) {
            throw new IllegalStateException("This credential is no longer valid");
        }
        GSSCredentialSpi gSSCredentialSpi = null;
        SearchKey searchKey = null;
        boolean bl = false;
        int n = 0;
        if (oid == null) {
            oid = ProviderList.DEFAULT_MECH_OID;
        }
        if ((gSSCredentialSpi = this.hashtable.get(searchKey = new SearchKey(oid, 2))) != null) {
            bl = true;
            if (n < gSSCredentialSpi.getAcceptLifetime()) {
                n = gSSCredentialSpi.getAcceptLifetime();
            }
        }
        if ((gSSCredentialSpi = this.hashtable.get(searchKey = new SearchKey(oid, 0))) != null) {
            bl = true;
            if (n < gSSCredentialSpi.getAcceptLifetime()) {
                n = gSSCredentialSpi.getAcceptLifetime();
            }
        }
        if (!bl) {
            throw new GSSExceptionImpl(2, oid);
        }
        return n;
    }

    @Override
    public int getUsage() throws GSSException {
        if (this.destroyed) {
            throw new IllegalStateException("This credential is no longer valid");
        }
        boolean bl = false;
        boolean bl2 = false;
        Enumeration<SearchKey> enumeration = this.hashtable.keys();
        while (enumeration.hasMoreElements()) {
            SearchKey searchKey = enumeration.nextElement();
            if (searchKey.getUsage() == 1) {
                bl = true;
                continue;
            }
            if (searchKey.getUsage() == 2) {
                bl2 = true;
                continue;
            }
            return 0;
        }
        if (bl) {
            if (bl2) {
                return 0;
            }
            return 1;
        }
        return 2;
    }

    @Override
    public int getUsage(Oid oid) throws GSSException {
        if (this.destroyed) {
            throw new IllegalStateException("This credential is no longer valid");
        }
        GSSCredentialSpi gSSCredentialSpi = null;
        SearchKey searchKey = null;
        boolean bl = false;
        boolean bl2 = false;
        if (oid == null) {
            oid = ProviderList.DEFAULT_MECH_OID;
        }
        if ((gSSCredentialSpi = this.hashtable.get(searchKey = new SearchKey(oid, 1))) != null) {
            bl = true;
        }
        if ((gSSCredentialSpi = this.hashtable.get(searchKey = new SearchKey(oid, 2))) != null) {
            bl2 = true;
        }
        if ((gSSCredentialSpi = this.hashtable.get(searchKey = new SearchKey(oid, 0))) != null) {
            bl = true;
            bl2 = true;
        }
        if (bl && bl2) {
            return 0;
        }
        if (bl) {
            return 1;
        }
        if (bl2) {
            return 2;
        }
        throw new GSSExceptionImpl(2, oid);
    }

    @Override
    public Oid[] getMechs() throws GSSException {
        if (this.destroyed) {
            throw new IllegalStateException("This credential is no longer valid");
        }
        Vector<Oid> vector = new Vector<Oid>(this.hashtable.size());
        Enumeration<SearchKey> enumeration = this.hashtable.keys();
        while (enumeration.hasMoreElements()) {
            SearchKey searchKey = enumeration.nextElement();
            vector.addElement(searchKey.getMech());
        }
        return vector.toArray(new Oid[0]);
    }

    @Override
    public void add(GSSName gSSName, int n, int n2, Oid oid, int n3) throws GSSException {
        SearchKey searchKey;
        if (this.destroyed) {
            throw new IllegalStateException("This credential is no longer valid");
        }
        if (oid == null) {
            oid = ProviderList.DEFAULT_MECH_OID;
        }
        if (this.hashtable.containsKey(searchKey = new SearchKey(oid, n3))) {
            throw new GSSExceptionImpl(17, "Duplicate element found: " + GSSCredentialImpl.getElementStr(oid, n3));
        }
        GSSNameSpi gSSNameSpi = gSSName == null ? null : ((GSSNameImpl)gSSName).getElement(oid);
        this.tempCred = this.gssManager.getCredentialElement(gSSNameSpi, n, n2, oid, n3);
        if (this.tempCred != null) {
            if (!(n3 != 0 || this.tempCred.isAcceptorCredential() && this.tempCred.isInitiatorCredential())) {
                int n4;
                int n5;
                if (!this.tempCred.isInitiatorCredential()) {
                    n5 = 2;
                    n4 = 1;
                } else {
                    n5 = 1;
                    n4 = 2;
                }
                searchKey = new SearchKey(oid, n5);
                this.hashtable.put(searchKey, this.tempCred);
                this.tempCred = this.gssManager.getCredentialElement(gSSNameSpi, n, n2, oid, n4);
                searchKey = new SearchKey(oid, n4);
                this.hashtable.put(searchKey, this.tempCred);
            } else {
                this.hashtable.put(searchKey, this.tempCred);
            }
        }
    }

    @Override
    public boolean equals(Object object) {
        if (this.destroyed) {
            throw new IllegalStateException("This credential is no longer valid");
        }
        if (this == object) {
            return true;
        }
        if (!(object instanceof GSSCredentialImpl)) {
            return false;
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (this.destroyed) {
            throw new IllegalStateException("This credential is no longer valid");
        }
        return 1;
    }

    public GSSCredentialSpi getElement(Oid oid, boolean bl) throws GSSException {
        GSSCredentialSpi gSSCredentialSpi;
        if (this.destroyed) {
            throw new IllegalStateException("This credential is no longer valid");
        }
        if (oid == null) {
            oid = ProviderList.DEFAULT_MECH_OID;
            SearchKey searchKey = new SearchKey(oid, bl ? 1 : 2);
            gSSCredentialSpi = this.hashtable.get(searchKey);
            if (gSSCredentialSpi == null && (gSSCredentialSpi = this.hashtable.get(searchKey = new SearchKey(oid, 0))) == null) {
                Object[] objectArray = this.hashtable.entrySet().toArray();
                for (int i = 0; i < objectArray.length && (gSSCredentialSpi = (GSSCredentialSpi)((Map.Entry)objectArray[i]).getValue()).isInitiatorCredential() != bl; ++i) {
                }
            }
        } else {
            SearchKey searchKey = bl ? new SearchKey(oid, 1) : new SearchKey(oid, 2);
            gSSCredentialSpi = this.hashtable.get(searchKey);
            if (gSSCredentialSpi == null) {
                searchKey = new SearchKey(oid, 0);
                gSSCredentialSpi = this.hashtable.get(searchKey);
            }
        }
        if (gSSCredentialSpi == null) {
            throw new GSSExceptionImpl(13, "No credential found for: " + oid + GSSCredentialImpl.getElementStr(oid, bl ? 1 : 2));
        }
        return gSSCredentialSpi;
    }

    Set<GSSCredentialSpi> getElements() {
        HashSet<GSSCredentialSpi> hashSet = new HashSet<GSSCredentialSpi>(this.hashtable.size());
        Enumeration<GSSCredentialSpi> enumeration = this.hashtable.elements();
        while (enumeration.hasMoreElements()) {
            GSSCredentialSpi gSSCredentialSpi = enumeration.nextElement();
            hashSet.add(gSSCredentialSpi);
        }
        return hashSet;
    }

    private static String getElementStr(Oid oid, int n) {
        String string = oid.toString();
        string = n == 1 ? string.concat(" usage: Initiate") : (n == 2 ? string.concat(" usage: Accept") : string.concat(" usage: Initiate and Accept"));
        return string;
    }

    public String toString() {
        if (this.destroyed) {
            throw new IllegalStateException("This credential is no longer valid");
        }
        GSSCredentialSpi gSSCredentialSpi = null;
        StringBuffer stringBuffer = new StringBuffer("[GSSCredential: ");
        Object[] objectArray = this.hashtable.entrySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            try {
                stringBuffer.append('\n');
                gSSCredentialSpi = (GSSCredentialSpi)((Map.Entry)objectArray[i]).getValue();
                stringBuffer.append(gSSCredentialSpi.getName());
                stringBuffer.append(' ');
                stringBuffer.append(gSSCredentialSpi.getMechanism());
                stringBuffer.append(gSSCredentialSpi.isInitiatorCredential() ? " Initiate" : "");
                stringBuffer.append(gSSCredentialSpi.isAcceptorCredential() ? " Accept" : "");
                stringBuffer.append(" [");
                stringBuffer.append(gSSCredentialSpi.toString());
                stringBuffer.append(']');
                continue;
            }
            catch (GSSException gSSException) {
                // empty catch block
            }
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    static class SearchKey {
        private Oid mechOid = null;
        private int usage = 0;

        public SearchKey(Oid oid, int n) {
            this.mechOid = oid;
            this.usage = n;
        }

        public Oid getMech() {
            return this.mechOid;
        }

        public int getUsage() {
            return this.usage;
        }

        public boolean equals(Object object) {
            if (!(object instanceof SearchKey)) {
                return false;
            }
            SearchKey searchKey = (SearchKey)object;
            return this.mechOid.equals(searchKey.mechOid) && this.usage == searchKey.usage;
        }

        public int hashCode() {
            return this.mechOid.hashCode();
        }
    }
}

