/*
 * Decompiled with CFR 0.152.
 */
package ghostfucker.utils.sun.security.jgss;

import ghostfucker.utils.sun.security.util.DerOutputStream;
import ghostfucker.utils.sun.security.util.DerValue;
import ghostfucker.utils.sun.security.util.ObjectIdentifier;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.ietf.jgss.GSSException;

public class GSSHeader {
    private ObjectIdentifier mechOid = null;
    private byte[] mechOidBytes = null;
    private int mechTokenLength = 0;
    public static final int TOKEN_ID = 96;

    public GSSHeader(ObjectIdentifier objectIdentifier, int n) throws IOException {
        this.mechOid = objectIdentifier;
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putOID(objectIdentifier);
        this.mechOidBytes = derOutputStream.toByteArray();
        this.mechTokenLength = n;
    }

    public GSSHeader(InputStream inputStream) throws IOException, GSSException {
        int n = inputStream.read();
        if (n != 96) {
            throw new GSSException(10, -1, "GSSHeader did not find the right tag");
        }
        int n2 = this.getLength(inputStream);
        DerValue derValue = new DerValue(inputStream);
        this.mechOidBytes = derValue.toByteArray();
        this.mechOid = derValue.getOID();
        this.mechTokenLength = n2 - this.mechOidBytes.length;
    }

    public ObjectIdentifier getOid() {
        return this.mechOid;
    }

    public int getMechTokenLength() {
        return this.mechTokenLength;
    }

    public int getLength() {
        int n = this.mechOidBytes.length + this.mechTokenLength;
        return 1 + this.getLenFieldSize(n) + this.mechOidBytes.length;
    }

    public static int getMaxMechTokenSize(ObjectIdentifier objectIdentifier, int n) {
        int n2 = 0;
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            derOutputStream.putOID(objectIdentifier);
            n2 = derOutputStream.toByteArray().length;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        n -= 1 + n2;
        return n -= 5;
    }

    private int getLenFieldSize(int n) {
        int n2 = 1;
        n2 = n < 128 ? 1 : (n < 256 ? 2 : (n < 65536 ? 3 : (n < 0x1000000 ? 4 : 5)));
        return n2;
    }

    public int encode(OutputStream outputStream) throws IOException {
        int n = 1 + this.mechOidBytes.length;
        outputStream.write(96);
        int n2 = this.mechOidBytes.length + this.mechTokenLength;
        outputStream.write(this.mechOidBytes);
        return n += this.putLength(n2, outputStream);
    }

    private int getLength(InputStream inputStream) throws IOException {
        return this.getLength(inputStream.read(), inputStream);
    }

    private int getLength(int n, InputStream inputStream) throws IOException {
        int n2;
        int n3 = n;
        if ((n3 & 0x80) == 0) {
            n2 = n3;
        } else {
            if ((n3 &= 0x7F) == 0) {
                return -1;
            }
            if (n3 < 0 || n3 > 4) {
                throw new IOException("DerInputStream.getLength(): lengthTag=" + n3 + ", " + (n3 < 0 ? "incorrect DER encoding." : "too big."));
            }
            n2 = 0;
            while (n3 > 0) {
                n2 <<= 8;
                n2 += 0xFF & inputStream.read();
                --n3;
            }
        }
        return n2;
    }

    private int putLength(int n, OutputStream outputStream) throws IOException {
        int n2 = 0;
        if (n < 128) {
            outputStream.write((byte)n);
            n2 = 1;
        } else if (n < 256) {
            outputStream.write(-127);
            outputStream.write((byte)n);
            n2 = 2;
        } else if (n < 65536) {
            outputStream.write(-126);
            outputStream.write((byte)(n >> 8));
            outputStream.write((byte)n);
            n2 = 3;
        } else if (n < 0x1000000) {
            outputStream.write(-125);
            outputStream.write((byte)(n >> 16));
            outputStream.write((byte)(n >> 8));
            outputStream.write((byte)n);
            n2 = 4;
        } else {
            outputStream.write(-124);
            outputStream.write((byte)(n >> 24));
            outputStream.write((byte)(n >> 16));
            outputStream.write((byte)(n >> 8));
            outputStream.write((byte)n);
            n2 = 5;
        }
        return n2;
    }

    private void debug(String string) {
        System.err.print(string);
    }

    private String getHexBytes(byte[] byArray, int n) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            int n2 = byArray[i] >> 4 & 0xF;
            int n3 = byArray[i] & 0xF;
            stringBuffer.append(Integer.toHexString(n2));
            stringBuffer.append(Integer.toHexString(n3));
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }
}

