/*
 * Decompiled with CFR 0.152.
 */
package ghostfucker.utils.sun.security.jgss;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class GSSToken {
    public static final void writeLittleEndian(int n, byte[] byArray) {
        GSSToken.writeLittleEndian(n, byArray, 0);
    }

    public static final void writeLittleEndian(int n, byte[] byArray, int n2) {
        byArray[n2++] = (byte)n;
        byArray[n2++] = (byte)(n >>> 8);
        byArray[n2++] = (byte)(n >>> 16);
        byArray[n2++] = (byte)(n >>> 24);
    }

    public static final void writeBigEndian(int n, byte[] byArray) {
        GSSToken.writeBigEndian(n, byArray, 0);
    }

    public static final void writeBigEndian(int n, byte[] byArray, int n2) {
        byArray[n2++] = (byte)(n >>> 24);
        byArray[n2++] = (byte)(n >>> 16);
        byArray[n2++] = (byte)(n >>> 8);
        byArray[n2++] = (byte)n;
    }

    public static final int readLittleEndian(byte[] byArray, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        while (n2 > 0) {
            n3 += (byArray[n] & 0xFF) << n4;
            n4 += 8;
            ++n;
            --n2;
        }
        return n3;
    }

    public static final int readBigEndian(byte[] byArray, int n, int n2) {
        int n3 = 0;
        int n4 = (n2 - 1) * 8;
        while (n2 > 0) {
            n3 += (byArray[n] & 0xFF) << n4;
            n4 -= 8;
            ++n;
            --n2;
        }
        return n3;
    }

    public static final void writeInt(int n, OutputStream outputStream) throws IOException {
        outputStream.write(n >>> 8);
        outputStream.write(n);
    }

    public static final int writeInt(int n, byte[] byArray, int n2) {
        byArray[n2++] = (byte)(n >>> 8);
        byArray[n2++] = (byte)n;
        return n2;
    }

    public static final int readInt(InputStream inputStream) throws IOException {
        return (0xFF & inputStream.read()) << 8 | 0xFF & inputStream.read();
    }

    public static final int readInt(byte[] byArray, int n) {
        return (0xFF & byArray[n]) << 8 | 0xFF & byArray[n + 1];
    }

    public static final void readFully(InputStream inputStream, byte[] byArray) throws IOException {
        GSSToken.readFully(inputStream, byArray, 0, byArray.length);
    }

    public static final void readFully(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        while (n2 > 0) {
            int n3 = inputStream.read(byArray, n, n2);
            if (n3 == -1) {
                throw new EOFException("Cannot read all " + n2 + " bytes needed to form this token!");
            }
            n += n3;
            n2 -= n3;
        }
    }

    public static final void debug(String string) {
        System.err.print(string);
    }

    public static final String getHexBytes(byte[] byArray) {
        return GSSToken.getHexBytes(byArray, 0, byArray.length);
    }

    public static final String getHexBytes(byte[] byArray, int n) {
        return GSSToken.getHexBytes(byArray, 0, n);
    }

    public static final String getHexBytes(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = n; i < n + n2; ++i) {
            int n3 = byArray[i] >> 4 & 0xF;
            int n4 = byArray[i] & 0xF;
            stringBuffer.append(Integer.toHexString(n3));
            stringBuffer.append(Integer.toHexString(n4));
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }
}

