/*
 * Decompiled with CFR 0.152.
 */
package ghostfucker.utils.sun.security.jgss;

import ghostfucker.utils.com.sun.security.auth.callback.TextCallbackHandler;
import ghostfucker.utils.sun.net.www.protocol.http.NegotiateCallbackHandler;
import ghostfucker.utils.sun.security.action.GetBooleanAction;
import ghostfucker.utils.sun.security.action.GetPropertyAction;
import ghostfucker.utils.sun.security.jgss.GSSCredentialImpl;
import ghostfucker.utils.sun.security.jgss.GSSNameImpl;
import ghostfucker.utils.sun.security.jgss.LoginConfigImpl;
import ghostfucker.utils.sun.security.jgss.krb5.Krb5NameElement;
import ghostfucker.utils.sun.security.jgss.spi.GSSCredentialSpi;
import ghostfucker.utils.sun.security.jgss.spi.GSSNameSpi;
import ghostfucker.utils.sun.security.jgss.spnego.SpNegoCredElement;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Security;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import javax.security.auth.Destroyable;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.kerberos.KerberosKey;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GSSUtil {
    public static final Oid GSS_KRB5_MECH_OID = GSSUtil.createOid("1.2.840.113554.1.2.2");
    public static final Oid GSS_KRB5_MECH_OID2 = GSSUtil.createOid("1.3.5.1.5.2");
    public static final Oid GSS_SPNEGO_MECH_OID = GSSUtil.createOid("1.3.6.1.5.5.2");
    public static final Oid NT_GSS_KRB5_PRINCIPAL = GSSUtil.createOid("1.2.840.113554.1.2.2.1");
    public static final Oid NT_HOSTBASED_SERVICE2 = GSSUtil.createOid("1.2.840.113554.1.2.1.4");
    private static final String DEFAULT_HANDLER = "auth.login.defaultCallbackHandler";
    public static final int CALLER_UNKNOWN = -1;
    public static final int CALLER_INITIATE = 1;
    public static final int CALLER_ACCEPT = 2;
    public static final int CALLER_SSL_CLIENT = 3;
    public static final int CALLER_SSL_SERVER = 4;
    public static final int CALLER_HTTP_NEGOTIATE = 5;
    static final boolean DEBUG = AccessController.doPrivileged(new GetBooleanAction("ghostfucker.utils.sun.security.jgss.debug"));

    static void debug(String string) {
        if (DEBUG) {
            assert (string != null);
            System.out.println(string);
        }
    }

    public static Oid createOid(String string) {
        try {
            return new Oid(string);
        }
        catch (GSSException gSSException) {
            GSSUtil.debug("Ignored invalid OID: " + string);
            return null;
        }
    }

    public static boolean isSpNegoMech(Oid oid) {
        return GSS_SPNEGO_MECH_OID.equals(oid);
    }

    public static boolean isKerberosMech(Oid oid) {
        return GSS_KRB5_MECH_OID.equals(oid) || GSS_KRB5_MECH_OID2.equals(oid);
    }

    public static String getMechStr(Oid oid) {
        if (GSSUtil.isSpNegoMech(oid)) {
            return "SPNEGO";
        }
        if (GSSUtil.isKerberosMech(oid)) {
            return "Kerberos V5";
        }
        return oid.toString();
    }

    public static Subject getSubject(GSSName gSSName, GSSCredential gSSCredential) {
        HashSet<Object> hashSet = null;
        HashSet hashSet2 = new HashSet();
        Set<GSSCredentialSpi> set = null;
        HashSet<KerberosPrincipal> hashSet3 = new HashSet<KerberosPrincipal>();
        if (gSSName instanceof GSSNameImpl) {
            try {
                GSSNameSpi gSSNameSpi = ((GSSNameImpl)gSSName).getElement(GSS_KRB5_MECH_OID);
                String string = ((Object)gSSNameSpi).toString();
                if (gSSNameSpi instanceof Krb5NameElement) {
                    string = ((Krb5NameElement)gSSNameSpi).getKrb5PrincipalName().getName();
                }
                KerberosPrincipal kerberosPrincipal = new KerberosPrincipal(string);
                hashSet3.add(kerberosPrincipal);
            }
            catch (GSSException gSSException) {
                GSSUtil.debug("Skipped name " + gSSName + " due to " + gSSException);
            }
        }
        if (gSSCredential instanceof GSSCredentialImpl) {
            set = ((GSSCredentialImpl)gSSCredential).getElements();
            hashSet = new HashSet(set.size());
            GSSUtil.populateCredentials(hashSet, set);
        } else {
            hashSet = new HashSet<Object>();
        }
        GSSUtil.debug("Created Subject with the following");
        GSSUtil.debug("principals=" + hashSet3);
        GSSUtil.debug("public creds=" + hashSet2);
        GSSUtil.debug("private creds=" + hashSet);
        return new Subject(false, hashSet3, hashSet2, hashSet);
    }

    private static void populateCredentials(Set<Object> set, Set<?> set2) {
        for (Object object : set2) {
            Destroyable destroyable;
            if (object instanceof SpNegoCredElement) {
                object = ((SpNegoCredElement)object).getInternalCred();
            }
            if (object instanceof KerberosTicket) {
                if (!object.getClass().getName().equals("javax.security.auth.kerberos.KerberosTicket")) {
                    destroyable = (KerberosTicket)object;
                    object = new KerberosTicket(((KerberosTicket)destroyable).getEncoded(), ((KerberosTicket)destroyable).getClient(), ((KerberosTicket)destroyable).getServer(), ((KerberosTicket)destroyable).getSessionKey().getEncoded(), ((KerberosTicket)destroyable).getSessionKeyType(), ((KerberosTicket)destroyable).getFlags(), ((KerberosTicket)destroyable).getAuthTime(), ((KerberosTicket)destroyable).getStartTime(), ((KerberosTicket)destroyable).getEndTime(), ((KerberosTicket)destroyable).getRenewTill(), ((KerberosTicket)destroyable).getClientAddresses());
                }
                set.add(object);
                continue;
            }
            if (object instanceof KerberosKey) {
                if (!object.getClass().getName().equals("javax.security.auth.kerberos.KerberosKey")) {
                    destroyable = (KerberosKey)object;
                    object = new KerberosKey(((KerberosKey)destroyable).getPrincipal(), ((KerberosKey)destroyable).getEncoded(), ((KerberosKey)destroyable).getKeyType(), ((KerberosKey)destroyable).getVersionNumber());
                }
                set.add(object);
                continue;
            }
            GSSUtil.debug("Skipped cred element: " + object);
        }
    }

    public static Subject login(int n, Oid oid) throws LoginException {
        Object object;
        Object object2 = null;
        object2 = n == 5 ? new NegotiateCallbackHandler() : ((object = Security.getProperty(DEFAULT_HANDLER)) != null && ((String)object).length() != 0 ? null : new TextCallbackHandler());
        object = new LoginContext("", null, (CallbackHandler)object2, new LoginConfigImpl(n, oid));
        ((LoginContext)object).login();
        return ((LoginContext)object).getSubject();
    }

    public static boolean useSubjectCredsOnly(int n) {
        if (n == 5) {
            return false;
        }
        String string = AccessController.doPrivileged(new GetPropertyAction("javax.security.auth.useSubjectCredsOnly", "true"));
        return !string.equalsIgnoreCase("false");
    }

    public static boolean useMSInterop() {
        String string = AccessController.doPrivileged(new GetPropertyAction("ghostfucker.utils.sun.security.spnego.msinterop", "true"));
        return !string.equalsIgnoreCase("false");
    }

    public static Vector searchSubject(final GSSNameSpi gSSNameSpi, final Oid oid, final boolean bl, final Class clazz) {
        GSSUtil.debug("Search Subject for " + GSSUtil.getMechStr(oid) + (bl ? " INIT" : " ACCEPT") + " cred (" + (gSSNameSpi == null ? "<<DEF>>" : ((Object)gSSNameSpi).toString()) + ", " + clazz.getName() + ")");
        final AccessControlContext accessControlContext = AccessController.getContext();
        try {
            Vector vector = AccessController.doPrivileged(new PrivilegedExceptionAction<Vector>(){

                @Override
                public Vector run() throws Exception {
                    Subject subject = Subject.getSubject(accessControlContext);
                    Vector<GSSCredentialSpi> vector = null;
                    if (subject != null) {
                        vector = new Vector<GSSCredentialSpi>();
                        for (GSSCredentialImpl gSSCredentialImpl : subject.getPrivateCredentials(GSSCredentialImpl.class)) {
                            GSSUtil.debug("...Found cred" + gSSCredentialImpl);
                            try {
                                GSSCredentialSpi gSSCredentialSpi = gSSCredentialImpl.getElement(oid, bl);
                                GSSUtil.debug("......Found element: " + gSSCredentialSpi);
                                if (gSSCredentialSpi.getClass().equals(clazz) && (gSSNameSpi == null || ((Object)gSSNameSpi).equals(gSSCredentialSpi.getName()))) {
                                    vector.add(gSSCredentialSpi);
                                    continue;
                                }
                                GSSUtil.debug("......Discard element");
                            }
                            catch (GSSException gSSException) {
                                GSSUtil.debug("...Discard cred (" + gSSException + ")");
                            }
                        }
                    } else {
                        GSSUtil.debug("No Subject");
                    }
                    return vector;
                }
            });
            return vector;
        }
        catch (PrivilegedActionException privilegedActionException) {
            GSSUtil.debug("Unexpected exception when searching Subject:");
            if (DEBUG) {
                privilegedActionException.printStackTrace();
            }
            return null;
        }
    }
}

