/*
 * Decompiled with CFR 0.152.
 */
package ghostfucker.utils.sun.security.jgss;

import ghostfucker.utils.sun.security.jgss.GSSUtil;
import ghostfucker.utils.sun.security.util.Debug;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.ietf.jgss.Oid;

public class LoginConfigImpl
extends Configuration {
    private final Configuration config;
    private final int caller;
    private final String mechName;
    private static final Debug debug = Debug.getInstance("gssloginconfig", "\t[GSS LoginConfigImpl]");

    public LoginConfigImpl(int n, Oid oid) {
        this.caller = n;
        if (!oid.equals(GSSUtil.GSS_KRB5_MECH_OID)) {
            throw new IllegalArgumentException(oid.toString() + " not supported");
        }
        this.mechName = "krb5";
        this.config = AccessController.doPrivileged(new PrivilegedAction<Configuration>(){

            @Override
            public Configuration run() {
                return Configuration.getConfiguration();
            }
        });
    }

    public AppConfigurationEntry[] getAppConfigurationEntry(String string) {
        String[] stringArray;
        AppConfigurationEntry[] appConfigurationEntryArray;
        block14: {
            block13: {
                appConfigurationEntryArray = null;
                if ("OTHER".equalsIgnoreCase(string)) {
                    return null;
                }
                stringArray = null;
                if (!"krb5".equals(this.mechName)) break block13;
                switch (this.caller) {
                    case 1: {
                        stringArray = new String[]{"com.sun.security.jgss.krb5.initiate", "com.sun.security.jgss.initiate"};
                        break block14;
                    }
                    case 2: {
                        stringArray = new String[]{"com.sun.security.jgss.krb5.accept", "com.sun.security.jgss.accept"};
                        break block14;
                    }
                    case 3: {
                        stringArray = new String[]{"com.sun.security.jgss.krb5.initiate", "com.sun.net.ssl.client"};
                        break block14;
                    }
                    case 4: {
                        stringArray = new String[]{"com.sun.security.jgss.krb5.accept", "com.sun.net.ssl.server"};
                        break block14;
                    }
                    case 5: {
                        stringArray = new String[]{"com.sun.security.jgss.krb5.initiate"};
                        break block14;
                    }
                    case -1: {
                        throw new AssertionError((Object)"caller cannot be unknown");
                    }
                    default: {
                        throw new AssertionError((Object)"caller not defined");
                    }
                }
            }
            throw new IllegalArgumentException(this.mechName + " not supported");
        }
        for (String string2 : stringArray) {
            appConfigurationEntryArray = this.config.getAppConfigurationEntry(string2);
            if (debug != null) {
                debug.println("Trying " + string2 + (appConfigurationEntryArray == null ? ": does not exist." : ": Found!"));
            }
            if (appConfigurationEntryArray != null) break;
        }
        if (appConfigurationEntryArray == null) {
            if (debug != null) {
                debug.println("Cannot read JGSS entry, use default values instead.");
            }
            appConfigurationEntryArray = this.getDefaultConfigurationEntry();
        }
        return appConfigurationEntryArray;
    }

    private AppConfigurationEntry[] getDefaultConfigurationEntry() {
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        if (this.mechName == null || this.mechName.equals("krb5")) {
            if (LoginConfigImpl.isServerSide(this.caller)) {
                hashMap.put("useKeyTab", "true");
                hashMap.put("storeKey", "true");
                hashMap.put("doNotPrompt", "true");
                hashMap.put("isInitiator", "false");
            } else {
                hashMap.put("useTicketCache", "true");
                hashMap.put("doNotPrompt", "false");
            }
            return new AppConfigurationEntry[]{new AppConfigurationEntry("com.sun.security.auth.module.Krb5LoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, hashMap)};
        }
        return null;
    }

    private static boolean isServerSide(int n) {
        return 2 == n || 4 == n;
    }
}

