/*
 * Decompiled with CFR 0.152.
 */
package ghostfucker.utils.sun.security.jgss.krb5;

import ghostfucker.utils.sun.security.jgss.krb5.InitialToken;
import ghostfucker.utils.sun.security.jgss.krb5.Krb5Context;
import ghostfucker.utils.sun.security.jgss.krb5.Krb5CredElement;
import ghostfucker.utils.sun.security.jgss.krb5.Krb5InitCredential;
import ghostfucker.utils.sun.security.jgss.krb5.Krb5NameElement;
import ghostfucker.utils.sun.security.krb5.Checksum;
import ghostfucker.utils.sun.security.krb5.Credentials;
import ghostfucker.utils.sun.security.krb5.EncryptionKey;
import ghostfucker.utils.sun.security.krb5.KrbApReq;
import ghostfucker.utils.sun.security.krb5.KrbException;
import ghostfucker.utils.sun.security.util.DerValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.InetAddress;
import org.ietf.jgss.GSSException;

class InitSecContextToken
extends InitialToken {
    private KrbApReq apReq = null;

    InitSecContextToken(Krb5Context krb5Context, Credentials credentials, Credentials credentials2) throws KrbException, IOException, GSSException {
        boolean bl = krb5Context.getMutualAuthState();
        boolean bl2 = true;
        boolean bl3 = true;
        InitialToken.OverloadedChecksum overloadedChecksum = new InitialToken.OverloadedChecksum((InitialToken)this, krb5Context, credentials, credentials2);
        Checksum checksum = overloadedChecksum.getChecksum();
        this.apReq = new KrbApReq(credentials2, bl, bl2, bl3, checksum);
        krb5Context.resetMySequenceNumber(this.apReq.getSeqNumber());
        EncryptionKey encryptionKey = this.apReq.getSubKey();
        if (encryptionKey != null) {
            krb5Context.setKey(encryptionKey);
        } else {
            krb5Context.setKey(credentials2.getSessionKey());
        }
        if (!bl) {
            krb5Context.resetPeerSequenceNumber(0);
        }
    }

    InitSecContextToken(Krb5Context krb5Context, EncryptionKey[] encryptionKeyArray, InputStream inputStream) throws IOException, GSSException, KrbException {
        Serializable serializable;
        int n = inputStream.read() << 8 | inputStream.read();
        if (n != 256) {
            throw new GSSException(10, -1, "AP_REQ token id does not match!");
        }
        byte[] byArray = new DerValue(inputStream).toByteArray();
        InetAddress inetAddress = null;
        if (krb5Context.getChannelBinding() != null) {
            inetAddress = krb5Context.getChannelBinding().getInitiatorAddress();
        }
        this.apReq = new KrbApReq(byArray, encryptionKeyArray, inetAddress);
        EncryptionKey encryptionKey = this.apReq.getCreds().getSessionKey();
        EncryptionKey encryptionKey2 = this.apReq.getSubKey();
        if (encryptionKey2 != null) {
            krb5Context.setKey(encryptionKey2);
        } else {
            krb5Context.setKey(encryptionKey);
        }
        InitialToken.OverloadedChecksum overloadedChecksum = new InitialToken.OverloadedChecksum((InitialToken)this, krb5Context, this.apReq.getChecksum(), encryptionKey);
        overloadedChecksum.setContextFlags(krb5Context);
        Credentials credentials = overloadedChecksum.getDelegatedCreds();
        if (credentials != null) {
            serializable = Krb5InitCredential.getInstance((Krb5NameElement)krb5Context.getSrcName(), credentials);
            krb5Context.setDelegCred((Krb5CredElement)((Object)serializable));
        }
        int n2 = (serializable = this.apReq.getSeqNumber()) != null ? (Integer)serializable : 0;
        krb5Context.resetPeerSequenceNumber(n2);
        if (!krb5Context.getMutualAuthState()) {
            krb5Context.resetMySequenceNumber(n2);
        }
    }

    public final KrbApReq getKrbApReq() {
        return this.apReq;
    }

    public final byte[] encode() throws IOException {
        byte[] byArray = this.apReq.getMessage();
        byte[] byArray2 = new byte[2 + byArray.length];
        InitSecContextToken.writeInt(256, byArray2, 0);
        System.arraycopy(byArray, 0, byArray2, 2, byArray.length);
        return byArray2;
    }
}

