/*
 * Decompiled with CFR 0.152.
 */
package ghostfucker.utils.sun.security.jgss.krb5;

import ghostfucker.utils.sun.security.action.GetBooleanAction;
import ghostfucker.utils.sun.security.jgss.GSSUtil;
import ghostfucker.utils.sun.security.jgss.krb5.SubjectComber;
import ghostfucker.utils.sun.security.krb5.Credentials;
import ghostfucker.utils.sun.security.krb5.EncryptionKey;
import ghostfucker.utils.sun.security.krb5.KrbException;
import java.io.IOException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.List;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosKey;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.LoginException;

public class Krb5Util {
    static final boolean DEBUG = AccessController.doPrivileged(new GetBooleanAction("ghostfucker.utils.sun.security.krb5.debug"));

    private Krb5Util() {
    }

    public static KerberosTicket getTicketFromSubjectAndTgs(int n, String string, String string2, String string3, AccessControlContext accessControlContext) throws LoginException, KrbException, IOException {
        Credentials credentials;
        Credentials credentials2;
        boolean bl;
        KerberosTicket kerberosTicket;
        Subject subject = Subject.getSubject(accessControlContext);
        KerberosTicket kerberosTicket2 = (KerberosTicket)SubjectComber.find(subject, string2, string, KerberosTicket.class);
        if (kerberosTicket2 != null) {
            return kerberosTicket2;
        }
        Subject subject2 = null;
        if (!GSSUtil.useSubjectCredsOnly(n)) {
            try {
                subject2 = GSSUtil.login(n, GSSUtil.GSS_KRB5_MECH_OID);
                kerberosTicket2 = (KerberosTicket)SubjectComber.find(subject2, string2, string, KerberosTicket.class);
                if (kerberosTicket2 != null) {
                    return kerberosTicket2;
                }
            }
            catch (LoginException loginException) {
                // empty catch block
            }
        }
        if ((kerberosTicket = (KerberosTicket)SubjectComber.find(subject, string3, string, KerberosTicket.class)) == null && subject2 != null) {
            kerberosTicket = (KerberosTicket)SubjectComber.find(subject2, string3, string, KerberosTicket.class);
            bl = false;
        } else {
            bl = true;
        }
        if (kerberosTicket != null && (credentials2 = Credentials.acquireServiceCreds(string2, credentials = Krb5Util.ticketToCreds(kerberosTicket))) != null) {
            kerberosTicket2 = Krb5Util.credsToTicket(credentials2);
            if (bl && subject != null && !subject.isReadOnly()) {
                subject.getPrivateCredentials().add(kerberosTicket2);
            }
        }
        return kerberosTicket2;
    }

    static KerberosTicket getTicket(int n, String string, String string2, AccessControlContext accessControlContext) throws LoginException {
        Subject subject = Subject.getSubject(accessControlContext);
        KerberosTicket kerberosTicket = (KerberosTicket)SubjectComber.find(subject, string2, string, KerberosTicket.class);
        if (kerberosTicket == null && !GSSUtil.useSubjectCredsOnly(n)) {
            Subject subject2 = GSSUtil.login(n, GSSUtil.GSS_KRB5_MECH_OID);
            kerberosTicket = (KerberosTicket)SubjectComber.find(subject2, string2, string, KerberosTicket.class);
        }
        return kerberosTicket;
    }

    public static Subject getSubject(int n, AccessControlContext accessControlContext) throws LoginException {
        Subject subject = Subject.getSubject(accessControlContext);
        if (subject == null && !GSSUtil.useSubjectCredsOnly(n)) {
            subject = GSSUtil.login(n, GSSUtil.GSS_KRB5_MECH_OID);
        }
        return subject;
    }

    public static KerberosKey[] getKeys(int n, String string, AccessControlContext accessControlContext) throws LoginException {
        int n2;
        Subject subject = Subject.getSubject(accessControlContext);
        List list = (List)SubjectComber.findMany(subject, string, null, KerberosKey.class);
        if (list == null && !GSSUtil.useSubjectCredsOnly(n)) {
            Subject subject2 = GSSUtil.login(n, GSSUtil.GSS_KRB5_MECH_OID);
            list = (List)SubjectComber.findMany(subject2, string, null, KerberosKey.class);
        }
        if (list != null && (n2 = list.size()) > 0) {
            KerberosKey[] kerberosKeyArray = new KerberosKey[n2];
            list.toArray(kerberosKeyArray);
            return kerberosKeyArray;
        }
        return null;
    }

    public static KerberosTicket credsToTicket(Credentials credentials) {
        EncryptionKey encryptionKey = credentials.getSessionKey();
        return new KerberosTicket(credentials.getEncoded(), new KerberosPrincipal(credentials.getClient().getName()), new KerberosPrincipal(credentials.getServer().getName(), 2), encryptionKey.getBytes(), encryptionKey.getEType(), credentials.getFlags(), credentials.getAuthTime(), credentials.getStartTime(), credentials.getEndTime(), credentials.getRenewTill(), credentials.getClientAddresses());
    }

    public static Credentials ticketToCreds(KerberosTicket kerberosTicket) throws KrbException, IOException {
        return new Credentials(kerberosTicket.getEncoded(), kerberosTicket.getClient().getName(), kerberosTicket.getServer().getName(), kerberosTicket.getSessionKey().getEncoded(), kerberosTicket.getSessionKeyType(), kerberosTicket.getFlags(), kerberosTicket.getAuthTime(), kerberosTicket.getStartTime(), kerberosTicket.getEndTime(), kerberosTicket.getRenewTill(), kerberosTicket.getClientAddresses());
    }
}

